"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Topic = exports.TopicProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const kafka_generated_1 = require("./kafka.generated");
Object.defineProperty(exports, "TopicProperty", { enumerable: true, get: function () { return kafka_generated_1.RosTopic; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::KAFKA::Topic`, which is used to create a topic.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosTopic`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-kafka-topic
 */
class Topic extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosTopic = new kafka_generated_1.RosTopic(this, id, {
            partitionNum: props.partitionNum,
            compactTopic: props.compactTopic,
            replicationFactor: props.replicationFactor,
            instanceId: props.instanceId,
            config: props.config,
            topic: props.topic,
            minInsyncReplicas: props.minInsyncReplicas,
            localTopic: props.localTopic,
            tags: props.tags,
            remark: props.remark,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTopic;
        this.attrInstanceId = rosTopic.attrInstanceId;
        this.attrTopic = rosTopic.attrTopic;
    }
}
exports.Topic = Topic;
//# sourceMappingURL=data:application/json;base64,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