"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SaslUser = exports.SaslUserProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const kafka_generated_1 = require("./kafka.generated");
Object.defineProperty(exports, "SaslUserProperty", { enumerable: true, get: function () { return kafka_generated_1.RosSaslUser; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::KAFKA::SaslUser`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosSaslUser`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-kafka-sasluser
 */
class SaslUser extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosSaslUser = new kafka_generated_1.RosSaslUser(this, id, {
            type: props.type,
            username: props.username,
            instanceId: props.instanceId,
            mechanism: props.mechanism,
            password: props.password,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSaslUser;
        this.attrInstanceId = rosSaslUser.attrInstanceId;
        this.attrUsername = rosSaslUser.attrUsername;
    }
}
exports.SaslUser = SaslUser;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2FzbHVzZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzYXNsdXNlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsdURBQWdEO0FBRXhCLGlHQUZmLDZCQUFXLE9BRW9CO0FBMEN4Qzs7OztHQUlHO0FBQ0gsTUFBYSxRQUFTLFNBQVEsR0FBRyxDQUFDLFFBQVE7SUFnQnRDOzs7O09BSUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQW9CLEVBQUUsbUNBQTJDLElBQUk7UUFDL0csS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUNuQixJQUFJLENBQUMsRUFBRSxHQUFHLEVBQUUsQ0FBQztRQUNiLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ25CLElBQUksQ0FBQyxnQ0FBZ0MsR0FBRyxnQ0FBZ0MsQ0FBQztRQUV6RSxNQUFNLFdBQVcsR0FBRyxJQUFJLDZCQUFXLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRztZQUMzQyxJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUk7WUFDaEIsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO1lBQ3hCLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtZQUM1QixTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7WUFDMUIsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO1NBQzNCLEVBQUUsZ0NBQWdDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQ3BGLElBQUksQ0FBQyxRQUFRLEdBQUcsV0FBVyxDQUFDO1FBQzVCLElBQUksQ0FBQyxjQUFjLEdBQUcsV0FBVyxDQUFDLGNBQWMsQ0FBQztRQUNqRCxJQUFJLENBQUMsWUFBWSxHQUFHLFdBQVcsQ0FBQyxZQUFZLENBQUM7SUFDakQsQ0FBQztDQUNKO0FBdkNELDRCQXVDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvcyBmcm9tICdAYWxpY2xvdWQvcm9zLWNkay1jb3JlJztcbmltcG9ydCB7IFJvc1Nhc2xVc2VyIH0gZnJvbSAnLi9rYWZrYS5nZW5lcmF0ZWQnO1xuLy8gR2VuZXJhdGVkIGZyb20gdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBTcGVjaWZpY2F0aW9uXG5leHBvcnQgeyBSb3NTYXNsVXNlciBhcyBTYXNsVXNlclByb3BlcnR5IH07XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgU2FzbFVzZXJgLlxuICogU2VlIGh0dHBzOi8vd3d3LmFsaWJhYmFjbG91ZC5jb20vaGVscC9yb3MvZGV2ZWxvcGVyLXJlZmVyZW5jZS9hbGl5dW4ta2Fma2Etc2FzbHVzZXJcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTYXNsVXNlclByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGluc3RhbmNlSWQ6IFRoZSBpbnN0YW5jZSBJRC5cbiAgICAgKi9cbiAgICByZWFkb25seSBpbnN0YW5jZUlkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwYXNzd29yZDogVGhlIHBhc3N3b3JkIG9mIHRoZSBTQVNMIHVzZXIuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcGFzc3dvcmQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHVzZXJuYW1lOiBUaGUgbmFtZSBvZiB0aGUgU0FTTCB1c2VyLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHVzZXJuYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBtZWNoYW5pc206IFRoZSBlbmNyeXB0aW9uIG1ldGhvZC4gVmFsaWQgdmFsdWVzOlxuICAgICAqIFNDUkFNLVNIQS01MTIgKGRlZmF1bHQpXG4gICAgICogU0NSQU0tU0hBLTI1NlxuICAgICAqIE5vdGVcbiAgICAgKiBUaGlzIHBhcmFtZXRlciBpcyBhdmFpbGFibGUgb25seSBmb3IgQXBzYXJhTVEgZm9yIEthZmthIFYzIHNlcnZlcmxlc3MgaW5zdGFuY2VzLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG1lY2hhbmlzbT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHR5cGU6IFRoZSB0eXBlIG9mIHRoZSBTaW1wbGUgQXV0aGVudGljYXRpb24gYW5kIFNlY3VyaXR5IExheWVyIChTQVNMKSB1c2VyLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogcGxhaW46IGEgc2ltcGxlIG1lY2hhbmlzbSB0aGF0IHVzZXMgdXNlcm5hbWVzIGFuZCBwYXNzd29yZHMgdG8gdmVyaWZ5IHVzZXIgaWRlbnRpdGllcy4gQXBzYXJhTVEgZm9yIEthZmthIHByb3ZpZGVzIGFuIGltcHJvdmVkIFBMQUlOIG1lY2hhbmlzbSB0aGF0IGFsbG93cyB5b3UgdG8gZHluYW1pY2FsbHkgYWRkIFNBU0wgdXNlcnMgd2l0aG91dCB0aGUgbmVlZCB0byByZXN0YXJ0IGFuIGluc3RhbmNlLlxuICAgICAqIFNDUkFNOiBhIG1lY2hhbmlzbSB0aGF0IHVzZXMgdXNlcm5hbWVzIGFuZCBwYXNzd29yZHMgdG8gdmVyaWZ5IHVzZXIgaWRlbnRpdGllcy4gQ29tcGFyZWQgd2l0aCB0aGUgUExBSU4gbWVjaGFuaXNtLCB0aGlzIG1lY2hhbmlzbSBwcm92aWRlcyBiZXR0ZXIgc2VjdXJpdHkgcHJvdGVjdGlvbi4gQXBzYXJhTVEgZm9yIEthZmthIHVzZXMgdGhlIFNDUkFNLVNIQS0yNTYgYWxnb3JpdGhtLlxuICAgICAqIExEQVA6IFRoaXMgdmFsdWUgaXMgYXZhaWxhYmxlIG9ubHkgZm9yIHRoZSBTQVNMIHVzZXJzIG9mIEFwc2FyYU1RIGZvciBDb25mbHVlbnQgaW5zdGFuY2VzLlxuICAgICAqIERlZmF1bHQgdmFsdWU6IHBsYWluLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHR5cGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogVGhpcyBjbGFzcyBlbmNhcHN1bGF0ZXMgYW5kIGV4dGVuZHMgdGhlIFJPUyByZXNvdXJjZSB0eXBlIGBBTElZVU46OktBRktBOjpTYXNsVXNlcmAuXG4gKiBATm90ZSBUaGlzIGNsYXNzIG1heSBoYXZlIHNvbWUgbmV3IGZ1bmN0aW9ucyB0byBmYWNpbGl0YXRlIGRldmVsb3BtZW50LCBzbyBpdCBpcyByZWNvbW1lbmRlZCB0byB1c2UgdGhpcyBjbGFzcyBpbnN0ZWFkIG9mIGBSb3NTYXNsVXNlcmBmb3IgYSBtb3JlIGNvbnZlbmllbnQgZGV2ZWxvcG1lbnQgZXhwZXJpZW5jZS5cbiAqIFNlZSBodHRwczovL3d3dy5hbGliYWJhY2xvdWQuY29tL2hlbHAvcm9zL2RldmVsb3Blci1yZWZlcmVuY2UvYWxpeXVuLWthZmthLXNhc2x1c2VyXG4gKi9cbmV4cG9ydCBjbGFzcyBTYXNsVXNlciBleHRlbmRzIHJvcy5SZXNvdXJjZSB7XG4gICAgcHJvdGVjdGVkIHNjb3BlOiByb3MuQ29uc3RydWN0O1xuICAgIHByb3RlY3RlZCBpZDogc3RyaW5nO1xuICAgIHByb3RlY3RlZCBwcm9wczogU2FzbFVzZXJQcm9wcztcbiAgICBwcm90ZWN0ZWQgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW47XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgSW5zdGFuY2VJZDogVGhlIGluc3RhbmNlIElELlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRySW5zdGFuY2VJZDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIFVzZXJuYW1lOiBUaGUgdXNlciBuYW1lIG9mIHRoZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0clVzZXJuYW1lOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIFBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIFBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogU2FzbFVzZXJQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICAgICAgdGhpcy5zY29wZSA9IHNjb3BlO1xuICAgICAgICB0aGlzLmlkID0gaWQ7XG4gICAgICAgIHRoaXMucHJvcHMgPSBwcm9wcztcbiAgICAgICAgdGhpcy5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCA9IGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50O1xuXG4gICAgICAgIGNvbnN0IHJvc1Nhc2xVc2VyID0gbmV3IFJvc1Nhc2xVc2VyKHRoaXMsIGlkLCAge1xuICAgICAgICAgICAgdHlwZTogcHJvcHMudHlwZSxcbiAgICAgICAgICAgIHVzZXJuYW1lOiBwcm9wcy51c2VybmFtZSxcbiAgICAgICAgICAgIGluc3RhbmNlSWQ6IHByb3BzLmluc3RhbmNlSWQsXG4gICAgICAgICAgICBtZWNoYW5pc206IHByb3BzLm1lY2hhbmlzbSxcbiAgICAgICAgICAgIHBhc3N3b3JkOiBwcm9wcy5wYXNzd29yZCxcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgICAgIHRoaXMucmVzb3VyY2UgPSByb3NTYXNsVXNlcjtcbiAgICAgICAgdGhpcy5hdHRySW5zdGFuY2VJZCA9IHJvc1Nhc2xVc2VyLmF0dHJJbnN0YW5jZUlkO1xuICAgICAgICB0aGlzLmF0dHJVc2VybmFtZSA9IHJvc1Nhc2xVc2VyLmF0dHJVc2VybmFtZTtcbiAgICB9XG59XG4iXX0=