"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const kafka_generated_1 = require("./kafka.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return kafka_generated_1.RosInstance; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::KAFKA::Instance`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosInstance`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-kafka-instance
 */
class Instance extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosInstance = new kafka_generated_1.RosInstance(this, id, {
            instanceId: props.instanceId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrAllConfig = rosInstance.attrAllConfig;
        this.attrAllowedList = rosInstance.attrAllowedList;
        this.attrCreateTime = rosInstance.attrCreateTime;
        this.attrDeployType = rosInstance.attrDeployType;
        this.attrDiskSize = rosInstance.attrDiskSize;
        this.attrDiskType = rosInstance.attrDiskType;
        this.attrDomainEndpoint = rosInstance.attrDomainEndpoint;
        this.attrEipMax = rosInstance.attrEipMax;
        this.attrEndPoint = rosInstance.attrEndPoint;
        this.attrExpiredTime = rosInstance.attrExpiredTime;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrInstanceName = rosInstance.attrInstanceName;
        this.attrIoMax = rosInstance.attrIoMax;
        this.attrIoMaxSpec = rosInstance.attrIoMaxSpec;
        this.attrMsgRetain = rosInstance.attrMsgRetain;
        this.attrPaymentType = rosInstance.attrPaymentType;
        this.attrResourceGroupId = rosInstance.attrResourceGroupId;
        this.attrSaslDomainEndpoint = rosInstance.attrSaslDomainEndpoint;
        this.attrServiceVersion = rosInstance.attrServiceVersion;
        this.attrSpecType = rosInstance.attrSpecType;
        this.attrSslDomainEndpoint = rosInstance.attrSslDomainEndpoint;
        this.attrSslEndPoint = rosInstance.attrSslEndPoint;
        this.attrTags = rosInstance.attrTags;
        this.attrTopicNumLimit = rosInstance.attrTopicNumLimit;
        this.attrVSwitchId = rosInstance.attrVSwitchId;
        this.attrVpcId = rosInstance.attrVpcId;
        this.attrZoneId = rosInstance.attrZoneId;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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