"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Acl = exports.AclProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const kafka_generated_1 = require("./kafka.generated");
Object.defineProperty(exports, "AclProperty", { enumerable: true, get: function () { return kafka_generated_1.RosAcl; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::KAFKA::Acl`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosAcl`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-kafka-acl
 */
class Acl extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosAcl = new kafka_generated_1.RosAcl(this, id, {
            aclResourceName: props.aclResourceName,
            aclOperationTypes: props.aclOperationTypes,
            username: props.username,
            instanceId: props.instanceId,
            aclResourceType: props.aclResourceType,
            aclPermissionType: props.aclPermissionType,
            aclResourcePatternType: props.aclResourcePatternType,
            host: props.host,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAcl;
        this.attrAclResourceType = rosAcl.attrAclResourceType;
        this.attrInstanceId = rosAcl.attrInstanceId;
        this.attrUsername = rosAcl.attrUsername;
    }
}
exports.Acl = Acl;
//# sourceMappingURL=data:application/json;base64,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