/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.common;

import java.io.Closeable;
import java.io.File;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.ContentHandlerAdapter;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.util.SafeClose;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DicomFiles {
    private static SAXParser saxParser;

    public static void scan(List<String> fnames, Callback scb) {
        DicomFiles.scan(fnames, true, scb);
    }

    public static void scan(List<String> fnames, boolean printout, Callback scb) {
        for (String fname : fnames) {
            DicomFiles.scan(new File(fname), printout, scb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void scan(File f, boolean printout, Callback scb) {
        DicomInputStream in;
        block12: {
            if (f.isDirectory()) {
                for (String s : f.list()) {
                    DicomFiles.scan(new File(f, s), printout, scb);
                }
                return;
            }
            if (f.getName().endsWith(".xml")) {
                try {
                    SAXParser p = saxParser;
                    if (p == null) {
                        saxParser = p = SAXParserFactory.newInstance().newSAXParser();
                    }
                    Attributes ds = new Attributes();
                    ContentHandlerAdapter ch = new ContentHandlerAdapter(ds);
                    p.parse(f, (DefaultHandler)ch);
                    Attributes fmi = ch.getFileMetaInformation();
                    if (fmi == null) {
                        fmi = ds.createFileMetaInformation("1.2.840.10008.1.2.1");
                    }
                    boolean b = scb.dicomFile(f, fmi, -1L, ds);
                    if (!printout) return;
                    System.out.print(b ? (char)'.' : 'I');
                    return;
                }
                catch (Exception e) {
                    System.out.println();
                    System.out.println("Failed to parse file " + f + ": " + e.getMessage());
                    e.printStackTrace(System.out);
                }
                return;
            }
            in = null;
            try {
                in = new DicomInputStream(f);
                in.setIncludeBulkData(DicomInputStream.IncludeBulkData.NO);
                Attributes fmi = in.readFileMetaInformation();
                long dsPos = in.getPosition();
                Attributes ds = in.readDatasetUntilPixelData();
                if (!(fmi != null && fmi.containsValue(131088) && fmi.containsValue(131074) && fmi.containsValue(131075))) {
                    fmi = ds.createFileMetaInformation(in.getTransferSyntax());
                }
                boolean b = scb.dicomFile(f, fmi, dsPos, ds);
                if (!printout) break block12;
                System.out.print(b ? (char)'.' : 'I');
            }
            catch (Exception e) {
                try {
                    System.out.println();
                    System.out.println("Failed to scan file " + f + ": " + e.getMessage());
                    e.printStackTrace(System.out);
                }
                catch (Throwable throwable) {
                    SafeClose.close(in);
                    throw throwable;
                }
                SafeClose.close((Closeable)in);
                return;
            }
        }
        SafeClose.close((Closeable)in);
        return;
    }

    public static interface Callback {
        public boolean dicomFile(File var1, Attributes var2, long var3, Attributes var5) throws Exception;
    }
}

