"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-9235
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.workflow_catalog_relationship import WorkflowCatalogRelationship
    from intersight.model.workflow_internal_properties import WorkflowInternalProperties
    from intersight.model.workflow_properties import WorkflowProperties
    from intersight.model.workflow_rollback_task import WorkflowRollbackTask
    from intersight.model.workflow_task_definition_relationship import WorkflowTaskDefinitionRelationship
    from intersight.model.workflow_task_metadata_relationship import WorkflowTaskMetadataRelationship
    globals()['WorkflowCatalogRelationship'] = WorkflowCatalogRelationship
    globals()['WorkflowInternalProperties'] = WorkflowInternalProperties
    globals()['WorkflowProperties'] = WorkflowProperties
    globals()['WorkflowRollbackTask'] = WorkflowRollbackTask
    globals()['WorkflowTaskDefinitionRelationship'] = WorkflowTaskDefinitionRelationship
    globals()['WorkflowTaskMetadataRelationship'] = WorkflowTaskMetadataRelationship


class WorkflowTaskDefinitionAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'WORKFLOW.TASKDEFINITION': "workflow.TaskDefinition",
        },
        ('object_type',): {
            'WORKFLOW.TASKDEFINITION': "workflow.TaskDefinition",
        },
        ('license_entitlement',): {
            'BASE': "Base",
            'ESSENTIAL': "Essential",
            'STANDARD': "Standard",
            'ADVANTAGE': "Advantage",
            'PREMIER': "Premier",
            'IWO-ESSENTIAL': "IWO-Essential",
            'IWO-ADVANTAGE': "IWO-Advantage",
            'IWO-PREMIER': "IWO-Premier",
            'IKS-ADVANTAGE': "IKS-Advantage",
        },
    }

    validations = {
        ('label',): {
            'regex': {
                'pattern': r'^[a-zA-Z0-9]+[\sa-zA-Z0-9_\'.\/:-]{1,92}$',  # noqa: E501
            },
        },
        ('name',): {
            'regex': {
                'pattern': r'^[a-zA-Z0-9_.:-]{1,64}$',  # noqa: E501
            },
        },
        ('version',): {
            'inclusive_minimum': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'default_version': (bool,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'internal_properties': (WorkflowInternalProperties,),  # noqa: E501
            'label': (str,),  # noqa: E501
            'license_entitlement': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'properties': (WorkflowProperties,),  # noqa: E501
            'rollback_tasks': ([WorkflowRollbackTask], none_type,),  # noqa: E501
            'secure_prop_access': (bool,),  # noqa: E501
            'version': (int,),  # noqa: E501
            'catalog': (WorkflowCatalogRelationship,),  # noqa: E501
            'cloned_from': (WorkflowTaskDefinitionRelationship,),  # noqa: E501
            'implemented_tasks': ([WorkflowTaskDefinitionRelationship], none_type,),  # noqa: E501
            'interface_task': (WorkflowTaskDefinitionRelationship,),  # noqa: E501
            'task_metadata': (WorkflowTaskMetadataRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'default_version': 'DefaultVersion',  # noqa: E501
        'description': 'Description',  # noqa: E501
        'internal_properties': 'InternalProperties',  # noqa: E501
        'label': 'Label',  # noqa: E501
        'license_entitlement': 'LicenseEntitlement',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'properties': 'Properties',  # noqa: E501
        'rollback_tasks': 'RollbackTasks',  # noqa: E501
        'secure_prop_access': 'SecurePropAccess',  # noqa: E501
        'version': 'Version',  # noqa: E501
        'catalog': 'Catalog',  # noqa: E501
        'cloned_from': 'ClonedFrom',  # noqa: E501
        'implemented_tasks': 'ImplementedTasks',  # noqa: E501
        'interface_task': 'InterfaceTask',  # noqa: E501
        'task_metadata': 'TaskMetadata',  # noqa: E501
    }

    read_only_vars = {
        'license_entitlement',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """WorkflowTaskDefinitionAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "workflow.TaskDefinition", must be one of ["workflow.TaskDefinition", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "workflow.TaskDefinition", must be one of ["workflow.TaskDefinition", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            default_version (bool): When true this will be the task version that is used when a specific task definition version is not specified. The very first task definition created with a name will be set as the default version, after that user can explicitly set any version of the task definition as the default version.. [optional]  # noqa: E501
            description (str): A user friendly description about task on what operations are done as part of the task execution and any other specific information about task input and output.. [optional]  # noqa: E501
            internal_properties (WorkflowInternalProperties): [optional]  # noqa: E501
            label (str): A user friendly short name to identify the task definition. Label can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.), colon (:), space ( ), single quote ('), forward slash (/), or an underscore (_) and must be at least 2 characters.. [optional]  # noqa: E501
            license_entitlement (str): License entitlement required to run this task. It is determined by license requirement of features. * `Base` - Base as a License type. It is default license type. * `Essential` - Essential as a License type. * `Standard` - Standard as a License type. * `Advantage` - Advantage as a License type. * `Premier` - Premier as a License type. * `IWO-Essential` - IWO-Essential as a License type. * `IWO-Advantage` - IWO-Advantage as a License type. * `IWO-Premier` - IWO-Premier as a License type. * `IKS-Advantage` - IKS-Advantage as a License type.. [optional] if omitted the server will use the default value of "Base"  # noqa: E501
            name (str): The name of the task definition. The name should follow this convention <Verb or Action><Category><Vendor><Product><Noun or object> Verb or Action is a required portion of the name and this must be part of the pre-approved verb list. Category is an optional field and this will refer to the broad category of the task referring to the type of resource or endpoint. If there is no specific category then use \"Generic\" if required. Vendor is an optional field and this will refer to the specific vendor this task applies to. If the task is generic and not tied to a vendor, then do not specify anything. Product is an optional field, this will contain the vendor product and model when desired. Noun or object is a required field and  this will contain the noun or object on which the action is being performed. Name can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.), colon (:), or an underscore (_). Examples SendEmail  - This is a task in Generic category for sending email. NewStorageVolume - This is a vendor agnostic task under Storage device category for creating a new volume.. [optional]  # noqa: E501
            properties (WorkflowProperties): [optional]  # noqa: E501
            rollback_tasks ([WorkflowRollbackTask], none_type): [optional]  # noqa: E501
            secure_prop_access (bool): If set to true, the task requires access to secure properties and uses an encryption token associated with a workflow moid to encrypt or decrypt the secure properties.. [optional]  # noqa: E501
            version (int): The version of the task definition so we can support multiple versions of a task definition.. [optional] if omitted the server will use the default value of 1  # noqa: E501
            catalog (WorkflowCatalogRelationship): [optional]  # noqa: E501
            cloned_from (WorkflowTaskDefinitionRelationship): [optional]  # noqa: E501
            implemented_tasks ([WorkflowTaskDefinitionRelationship], none_type): An array of relationships to workflowTaskDefinition resources.. [optional]  # noqa: E501
            interface_task (WorkflowTaskDefinitionRelationship): [optional]  # noqa: E501
            task_metadata (WorkflowTaskMetadataRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "workflow.TaskDefinition")
        object_type = kwargs.get('object_type', "workflow.TaskDefinition")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """WorkflowTaskDefinitionAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "workflow.TaskDefinition", must be one of ["workflow.TaskDefinition", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "workflow.TaskDefinition", must be one of ["workflow.TaskDefinition", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            default_version (bool): When true this will be the task version that is used when a specific task definition version is not specified. The very first task definition created with a name will be set as the default version, after that user can explicitly set any version of the task definition as the default version.. [optional]  # noqa: E501
            description (str): A user friendly description about task on what operations are done as part of the task execution and any other specific information about task input and output.. [optional]  # noqa: E501
            internal_properties (WorkflowInternalProperties): [optional]  # noqa: E501
            label (str): A user friendly short name to identify the task definition. Label can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.), colon (:), space ( ), single quote ('), forward slash (/), or an underscore (_) and must be at least 2 characters.. [optional]  # noqa: E501
            license_entitlement (str): License entitlement required to run this task. It is determined by license requirement of features. * `Base` - Base as a License type. It is default license type. * `Essential` - Essential as a License type. * `Standard` - Standard as a License type. * `Advantage` - Advantage as a License type. * `Premier` - Premier as a License type. * `IWO-Essential` - IWO-Essential as a License type. * `IWO-Advantage` - IWO-Advantage as a License type. * `IWO-Premier` - IWO-Premier as a License type. * `IKS-Advantage` - IKS-Advantage as a License type.. [optional] if omitted the server will use the default value of "Base"  # noqa: E501
            name (str): The name of the task definition. The name should follow this convention <Verb or Action><Category><Vendor><Product><Noun or object> Verb or Action is a required portion of the name and this must be part of the pre-approved verb list. Category is an optional field and this will refer to the broad category of the task referring to the type of resource or endpoint. If there is no specific category then use \"Generic\" if required. Vendor is an optional field and this will refer to the specific vendor this task applies to. If the task is generic and not tied to a vendor, then do not specify anything. Product is an optional field, this will contain the vendor product and model when desired. Noun or object is a required field and  this will contain the noun or object on which the action is being performed. Name can only contain letters (a-z, A-Z), numbers (0-9), hyphen (-), period (.), colon (:), or an underscore (_). Examples SendEmail  - This is a task in Generic category for sending email. NewStorageVolume - This is a vendor agnostic task under Storage device category for creating a new volume.. [optional]  # noqa: E501
            properties (WorkflowProperties): [optional]  # noqa: E501
            rollback_tasks ([WorkflowRollbackTask], none_type): [optional]  # noqa: E501
            secure_prop_access (bool): If set to true, the task requires access to secure properties and uses an encryption token associated with a workflow moid to encrypt or decrypt the secure properties.. [optional]  # noqa: E501
            version (int): The version of the task definition so we can support multiple versions of a task definition.. [optional] if omitted the server will use the default value of 1  # noqa: E501
            catalog (WorkflowCatalogRelationship): [optional]  # noqa: E501
            cloned_from (WorkflowTaskDefinitionRelationship): [optional]  # noqa: E501
            implemented_tasks ([WorkflowTaskDefinitionRelationship], none_type): An array of relationships to workflowTaskDefinition resources.. [optional]  # noqa: E501
            interface_task (WorkflowTaskDefinitionRelationship): [optional]  # noqa: E501
            task_metadata (WorkflowTaskMetadataRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "workflow.TaskDefinition")
        object_type = kwargs.get('object_type', "workflow.TaskDefinition")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
