"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-9235
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.virtualization_vmware_datastore_relationship import VirtualizationVmwareDatastoreRelationship
    from intersight.model.virtualization_vmware_shares_info import VirtualizationVmwareSharesInfo
    from intersight.model.virtualization_vmware_virtual_machine_relationship import VirtualizationVmwareVirtualMachineRelationship
    globals()['VirtualizationVmwareDatastoreRelationship'] = VirtualizationVmwareDatastoreRelationship
    globals()['VirtualizationVmwareSharesInfo'] = VirtualizationVmwareSharesInfo
    globals()['VirtualizationVmwareVirtualMachineRelationship'] = VirtualizationVmwareVirtualMachineRelationship


class VirtualizationVmwareVirtualDiskAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'VIRTUALIZATION.VMWAREVIRTUALDISK': "virtualization.VmwareVirtualDisk",
        },
        ('object_type',): {
            'VIRTUALIZATION.VMWAREVIRTUALDISK': "virtualization.VmwareVirtualDisk",
        },
        ('compatibility_mode',): {
            'NOTAPPLICABLE': "notApplicable",
            'PHYSICALMODE': "physicalMode",
            'VIRTUALMODE': "virtualMode",
        },
        ('disk_mode',): {
            'PERSISTENT': "persistent",
            'INDEPENDENT_PERSISTENT': "independent_persistent",
            'INDEPENDENT_NONPERSISTENT': "independent_nonpersistent",
            'NONPERSISTENT': "nonpersistent",
            'UNDOABLE': "undoable",
            'APPEND': "append",
        },
        ('disk_type',): {
            'FLATDISK': "flatDisk",
            'RDMDISK': "rdmDisk",
        },
        ('sharing',): {
            'SHARINGNONE': "sharingNone",
            'SHARINGMULTIWRITER': "sharingMultiWriter",
        },
        ('storage_allocation_type',): {
            'NOTAPPLICABLE': "notApplicable",
            'THIN': "thin",
            'LAZYZEROEDTHICK': "lazyZeroedThick",
            'EAGERZEROEDTHICK': "eagerZeroedThick",
        },
    }

    validations = {
        ('uuid',): {
            'regex': {
                'pattern': r'^$|^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$',  # noqa: E501
            },
        },
        ('vdisk_id',): {
            'regex': {
                'pattern': r'^$|^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$',  # noqa: E501
            },
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'compatibility_mode': (str,),  # noqa: E501
            'controller_key': (int,),  # noqa: E501
            'device_name': (str,),  # noqa: E501
            'disk_mode': (str,),  # noqa: E501
            'disk_type': (str,),  # noqa: E501
            'key': (int,),  # noqa: E501
            'limit': (int,),  # noqa: E501
            'lun_uuid': (str,),  # noqa: E501
            'serial': (str,),  # noqa: E501
            'shares': (VirtualizationVmwareSharesInfo,),  # noqa: E501
            'sharing': (str,),  # noqa: E501
            'storage_allocation_type': (str,),  # noqa: E501
            'unit_number': (int,),  # noqa: E501
            'uuid': (str,),  # noqa: E501
            'vdisk_id': (str,),  # noqa: E501
            'vendor': (str,),  # noqa: E501
            'virtual_disk_path': (str,),  # noqa: E501
            'vm_identity': (str,),  # noqa: E501
            'datastore': (VirtualizationVmwareDatastoreRelationship,),  # noqa: E501
            'virtual_machine': (VirtualizationVmwareVirtualMachineRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'compatibility_mode': 'CompatibilityMode',  # noqa: E501
        'controller_key': 'ControllerKey',  # noqa: E501
        'device_name': 'DeviceName',  # noqa: E501
        'disk_mode': 'DiskMode',  # noqa: E501
        'disk_type': 'DiskType',  # noqa: E501
        'key': 'Key',  # noqa: E501
        'limit': 'Limit',  # noqa: E501
        'lun_uuid': 'LunUuid',  # noqa: E501
        'serial': 'Serial',  # noqa: E501
        'shares': 'Shares',  # noqa: E501
        'sharing': 'Sharing',  # noqa: E501
        'storage_allocation_type': 'StorageAllocationType',  # noqa: E501
        'unit_number': 'UnitNumber',  # noqa: E501
        'uuid': 'Uuid',  # noqa: E501
        'vdisk_id': 'VdiskId',  # noqa: E501
        'vendor': 'Vendor',  # noqa: E501
        'virtual_disk_path': 'VirtualDiskPath',  # noqa: E501
        'vm_identity': 'VmIdentity',  # noqa: E501
        'datastore': 'Datastore',  # noqa: E501
        'virtual_machine': 'VirtualMachine',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """VirtualizationVmwareVirtualDiskAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "virtualization.VmwareVirtualDisk", must be one of ["virtualization.VmwareVirtualDisk", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "virtualization.VmwareVirtualDisk", must be one of ["virtualization.VmwareVirtualDisk", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            compatibility_mode (str): Compatibility mode of the raw disk mapping (RDM). * `notApplicable` - Value specified for any disk which is not of raw device mapping type. * `physicalMode` - A disk device backed by a physical compatibility mode raw disk mapping cannot use disk modes, and commands are passed straight through to the LUN indicated by the raw disk mapping. * `virtualMode` - A disk device backed by a virtual compatibility mode raw disk mapping can use disk modes.. [optional] if omitted the server will use the default value of "notApplicable"  # noqa: E501
            controller_key (int): Key of the controller on which the disk is created.. [optional]  # noqa: E501
            device_name (str): Host-specific device the LUN is being accessed through. If the target LUN is not available on the host then it is empty. For example, this could happen if it has accidentally been masked out.. [optional]  # noqa: E501
            disk_mode (str): Persistence mode of the virtual disk. For RDM disks, it is only supported when the raw disk mapping is using virtual compatibility mode. * `persistent` - Changes are immediately and permanently written to the virtual disk. * `independent_persistent` - Changes are immediately and permanently written to the virtual disk and not affected by snapshots. * `independent_nonpersistent` - Changes to virtual disk are made to a redo log and discarded at power off and not affected by snapshots. * `nonpersistent` - Changes to virtual disk are made to a redo log and discarded at power off. * `undoable` - Changes to virtual disk are made to a redo log and has the option to commit or undo. * `append` - Changes are appended to the redo log and can be revoked by removing the undo log.. [optional] if omitted the server will use the default value of "persistent"  # noqa: E501
            disk_type (str): Specifies whether the virtual disk is a RDM or a Hard disk. * `flatDisk` - Specifies that it is a flat disk. * `rdmDisk` - Specifies that it is a raw device mapping disk.. [optional] if omitted the server will use the default value of "flatDisk"  # noqa: E501
            key (int): The internally assigned key of this disk. This entity is not manipulated by users.. [optional]  # noqa: E501
            limit (int): The utilization of a virtual machine will not exceed this limit, even if there are available resources. Used to ensure a consistent performance of virtual machines independent of available resources. If set to -1, then there is no fixed limit on resource usage (only bounded by available resources and shares). The unit is number of I/O per second.. [optional]  # noqa: E501
            lun_uuid (str): Unique identifier of the LUN accessed by the raw disk mapping (RDM).. [optional]  # noqa: E501
            serial (str): Serial ID of the storage device.. [optional]  # noqa: E501
            shares (VirtualizationVmwareSharesInfo): [optional]  # noqa: E501
            sharing (str): Sharing mode of the virtual disk. * `sharingNone` - The virtual disk is not shared. * `sharingMultiWriter` - The virtual disk is shared between multiple virtual machines.. [optional] if omitted the server will use the default value of "sharingNone"  # noqa: E501
            storage_allocation_type (str): Allocation type for the virtual disk. * `notApplicable` - Value specified for a disk for which storage allocation type is not applicable. * `thin` - A thin provisioned disk consumes only the space that it needs for its initial operrations, and grows with time according to demand. It is the fastest method to create a virtual disk because it creates a disk with just the header information. * `lazyZeroedThick` - A lazy zeroed thick disk has all space allocated at the time of its creation. Data remaining on the physical device is not erased during creation, but is zeroed out on demand later on first write from the virtual machine. * `eagerZeroedThick` - An eager zeroed thick disk has all space allocated and wiped clean of any previous contents on the physical media at creation time. Such disks may take longer time during creation compared to other disk formats.. [optional] if omitted the server will use the default value of "notApplicable"  # noqa: E501
            unit_number (int): Unit number of the disk on its controller.. [optional]  # noqa: E501
            uuid (str): UUID assigned by vCenter to every disk.. [optional]  # noqa: E501
            vdisk_id (str): Identity of the virtual disk object as the first class entity.. [optional]  # noqa: E501
            vendor (str): Vendor of the storage device.. [optional]  # noqa: E501
            virtual_disk_path (str): Path of the virtual disk.. [optional]  # noqa: E501
            vm_identity (str): Identity of the virtual machine where the virtual disk is created.. [optional]  # noqa: E501
            datastore (VirtualizationVmwareDatastoreRelationship): [optional]  # noqa: E501
            virtual_machine (VirtualizationVmwareVirtualMachineRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "virtualization.VmwareVirtualDisk")
        object_type = kwargs.get('object_type', "virtualization.VmwareVirtualDisk")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """VirtualizationVmwareVirtualDiskAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "virtualization.VmwareVirtualDisk", must be one of ["virtualization.VmwareVirtualDisk", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "virtualization.VmwareVirtualDisk", must be one of ["virtualization.VmwareVirtualDisk", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            compatibility_mode (str): Compatibility mode of the raw disk mapping (RDM). * `notApplicable` - Value specified for any disk which is not of raw device mapping type. * `physicalMode` - A disk device backed by a physical compatibility mode raw disk mapping cannot use disk modes, and commands are passed straight through to the LUN indicated by the raw disk mapping. * `virtualMode` - A disk device backed by a virtual compatibility mode raw disk mapping can use disk modes.. [optional] if omitted the server will use the default value of "notApplicable"  # noqa: E501
            controller_key (int): Key of the controller on which the disk is created.. [optional]  # noqa: E501
            device_name (str): Host-specific device the LUN is being accessed through. If the target LUN is not available on the host then it is empty. For example, this could happen if it has accidentally been masked out.. [optional]  # noqa: E501
            disk_mode (str): Persistence mode of the virtual disk. For RDM disks, it is only supported when the raw disk mapping is using virtual compatibility mode. * `persistent` - Changes are immediately and permanently written to the virtual disk. * `independent_persistent` - Changes are immediately and permanently written to the virtual disk and not affected by snapshots. * `independent_nonpersistent` - Changes to virtual disk are made to a redo log and discarded at power off and not affected by snapshots. * `nonpersistent` - Changes to virtual disk are made to a redo log and discarded at power off. * `undoable` - Changes to virtual disk are made to a redo log and has the option to commit or undo. * `append` - Changes are appended to the redo log and can be revoked by removing the undo log.. [optional] if omitted the server will use the default value of "persistent"  # noqa: E501
            disk_type (str): Specifies whether the virtual disk is a RDM or a Hard disk. * `flatDisk` - Specifies that it is a flat disk. * `rdmDisk` - Specifies that it is a raw device mapping disk.. [optional] if omitted the server will use the default value of "flatDisk"  # noqa: E501
            key (int): The internally assigned key of this disk. This entity is not manipulated by users.. [optional]  # noqa: E501
            limit (int): The utilization of a virtual machine will not exceed this limit, even if there are available resources. Used to ensure a consistent performance of virtual machines independent of available resources. If set to -1, then there is no fixed limit on resource usage (only bounded by available resources and shares). The unit is number of I/O per second.. [optional]  # noqa: E501
            lun_uuid (str): Unique identifier of the LUN accessed by the raw disk mapping (RDM).. [optional]  # noqa: E501
            serial (str): Serial ID of the storage device.. [optional]  # noqa: E501
            shares (VirtualizationVmwareSharesInfo): [optional]  # noqa: E501
            sharing (str): Sharing mode of the virtual disk. * `sharingNone` - The virtual disk is not shared. * `sharingMultiWriter` - The virtual disk is shared between multiple virtual machines.. [optional] if omitted the server will use the default value of "sharingNone"  # noqa: E501
            storage_allocation_type (str): Allocation type for the virtual disk. * `notApplicable` - Value specified for a disk for which storage allocation type is not applicable. * `thin` - A thin provisioned disk consumes only the space that it needs for its initial operrations, and grows with time according to demand. It is the fastest method to create a virtual disk because it creates a disk with just the header information. * `lazyZeroedThick` - A lazy zeroed thick disk has all space allocated at the time of its creation. Data remaining on the physical device is not erased during creation, but is zeroed out on demand later on first write from the virtual machine. * `eagerZeroedThick` - An eager zeroed thick disk has all space allocated and wiped clean of any previous contents on the physical media at creation time. Such disks may take longer time during creation compared to other disk formats.. [optional] if omitted the server will use the default value of "notApplicable"  # noqa: E501
            unit_number (int): Unit number of the disk on its controller.. [optional]  # noqa: E501
            uuid (str): UUID assigned by vCenter to every disk.. [optional]  # noqa: E501
            vdisk_id (str): Identity of the virtual disk object as the first class entity.. [optional]  # noqa: E501
            vendor (str): Vendor of the storage device.. [optional]  # noqa: E501
            virtual_disk_path (str): Path of the virtual disk.. [optional]  # noqa: E501
            vm_identity (str): Identity of the virtual machine where the virtual disk is created.. [optional]  # noqa: E501
            datastore (VirtualizationVmwareDatastoreRelationship): [optional]  # noqa: E501
            virtual_machine (VirtualizationVmwareVirtualMachineRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "virtualization.VmwareVirtualDisk")
        object_type = kwargs.get('object_type', "virtualization.VmwareVirtualDisk")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
