"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-9235
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.asset_device_registration_relationship import AssetDeviceRegistrationRelationship
    from intersight.model.niatelemetry_deployment_status import NiatelemetryDeploymentStatus
    from intersight.model.niatelemetry_logical_link import NiatelemetryLogicalLink
    from intersight.model.niatelemetry_vpc_details import NiatelemetryVpcDetails
    globals()['AssetDeviceRegistrationRelationship'] = AssetDeviceRegistrationRelationship
    globals()['NiatelemetryDeploymentStatus'] = NiatelemetryDeploymentStatus
    globals()['NiatelemetryLogicalLink'] = NiatelemetryLogicalLink
    globals()['NiatelemetryVpcDetails'] = NiatelemetryVpcDetails


class NiatelemetryNiaInventoryFabricAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'NIATELEMETRY.NIAINVENTORYFABRIC': "niatelemetry.NiaInventoryFabric",
        },
        ('object_type',): {
            'NIATELEMETRY.NIAINVENTORYFABRIC': "niatelemetry.NiaInventoryFabric",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'anycast_gw_mac': (str,),  # noqa: E501
            'bgp_established_interface_count': (int,),  # noqa: E501
            'bgw_count': (int,),  # noqa: E501
            'bgw_interface_up_count': (int,),  # noqa: E501
            'border_gateway_spine_count': (int,),  # noqa: E501
            'border_leaf_count': (int,),  # noqa: E501
            'cloudsec_autoconfig': (bool,),  # noqa: E501
            'dci_subnet_range': (str,),  # noqa: E501
            'dci_subnet_target_mask': (str,),  # noqa: E501
            'dcnmtracker_enabled': (bool,),  # noqa: E501
            'ebgp_evpn_link_up_count': (int,),  # noqa: E501
            'fabric_id': (str,),  # noqa: E501
            'fabric_name': (str,),  # noqa: E501
            'fabric_parent': (str,),  # noqa: E501
            'fabric_technology': (str,),  # noqa: E501
            'fabric_type': (str,),  # noqa: E501
            'feature_ptp': (str,),  # noqa: E501
            'is_bgw_present': (bool,),  # noqa: E501
            'is_enable_nxapi_http': (bool,),  # noqa: E501
            'is_enable_real_time_backup': (bool,),  # noqa: E501
            'is_ngoam_enabled': (bool,),  # noqa: E501
            'is_scheduled_back_up_enabled': (bool,),  # noqa: E501
            'is_trm_enabled': (bool,),  # noqa: E501
            'leaf_count': (int,),  # noqa: E501
            'link_state_routing': (str,),  # noqa: E501
            'link_type': (str,),  # noqa: E501
            'logical_links': ([NiatelemetryLogicalLink], none_type,),  # noqa: E501
            'network_deployment_count': (int,),  # noqa: E501
            'network_deployment_status': ([NiatelemetryDeploymentStatus], none_type,),  # noqa: E501
            'ntp_server_ip_list': (str,),  # noqa: E501
            'nxos_vni_bw_sites_count': (int,),  # noqa: E501
            'nxos_vrf_bw_sites_count': (int,),  # noqa: E501
            'nxos_vrf_count': (int,),  # noqa: E501
            'oper_status': (str,),  # noqa: E501
            'record_type': (str,),  # noqa: E501
            'record_version': (str,),  # noqa: E501
            'replication_mode': (str,),  # noqa: E501
            'rp_mode': (str,),  # noqa: E501
            'serial': (str,),  # noqa: E501
            'site_name': (str,),  # noqa: E501
            'software_image': (str,),  # noqa: E501
            'spine_count': (int,),  # noqa: E501
            'syslog_server_ip_list': (str,),  # noqa: E501
            'syslog_sev': (str,),  # noqa: E501
            'template_name': (str,),  # noqa: E501
            'vlan_vni_mappings': (str,),  # noqa: E501
            'vni_ip_count': (int,),  # noqa: E501
            'vpc_details': ([NiatelemetryVpcDetails], none_type,),  # noqa: E501
            'vrf_deployment_count': (int,),  # noqa: E501
            'vrf_deployment_status': ([NiatelemetryDeploymentStatus], none_type,),  # noqa: E501
            'xsite_network_count': (int,),  # noqa: E501
            'xsite_vrf_count': (int,),  # noqa: E501
            'registered_device': (AssetDeviceRegistrationRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'anycast_gw_mac': 'AnycastGwMac',  # noqa: E501
        'bgp_established_interface_count': 'BgpEstablishedInterfaceCount',  # noqa: E501
        'bgw_count': 'BgwCount',  # noqa: E501
        'bgw_interface_up_count': 'BgwInterfaceUpCount',  # noqa: E501
        'border_gateway_spine_count': 'BorderGatewaySpineCount',  # noqa: E501
        'border_leaf_count': 'BorderLeafCount',  # noqa: E501
        'cloudsec_autoconfig': 'CloudsecAutoconfig',  # noqa: E501
        'dci_subnet_range': 'DciSubnetRange',  # noqa: E501
        'dci_subnet_target_mask': 'DciSubnetTargetMask',  # noqa: E501
        'dcnmtracker_enabled': 'DcnmtrackerEnabled',  # noqa: E501
        'ebgp_evpn_link_up_count': 'EbgpEvpnLinkUpCount',  # noqa: E501
        'fabric_id': 'FabricId',  # noqa: E501
        'fabric_name': 'FabricName',  # noqa: E501
        'fabric_parent': 'FabricParent',  # noqa: E501
        'fabric_technology': 'FabricTechnology',  # noqa: E501
        'fabric_type': 'FabricType',  # noqa: E501
        'feature_ptp': 'FeaturePtp',  # noqa: E501
        'is_bgw_present': 'IsBgwPresent',  # noqa: E501
        'is_enable_nxapi_http': 'IsEnableNxapiHttp',  # noqa: E501
        'is_enable_real_time_backup': 'IsEnableRealTimeBackup',  # noqa: E501
        'is_ngoam_enabled': 'IsNgoamEnabled',  # noqa: E501
        'is_scheduled_back_up_enabled': 'IsScheduledBackUpEnabled',  # noqa: E501
        'is_trm_enabled': 'IsTrmEnabled',  # noqa: E501
        'leaf_count': 'LeafCount',  # noqa: E501
        'link_state_routing': 'LinkStateRouting',  # noqa: E501
        'link_type': 'LinkType',  # noqa: E501
        'logical_links': 'LogicalLinks',  # noqa: E501
        'network_deployment_count': 'NetworkDeploymentCount',  # noqa: E501
        'network_deployment_status': 'NetworkDeploymentStatus',  # noqa: E501
        'ntp_server_ip_list': 'NtpServerIpList',  # noqa: E501
        'nxos_vni_bw_sites_count': 'NxosVniBwSitesCount',  # noqa: E501
        'nxos_vrf_bw_sites_count': 'NxosVrfBwSitesCount',  # noqa: E501
        'nxos_vrf_count': 'NxosVrfCount',  # noqa: E501
        'oper_status': 'OperStatus',  # noqa: E501
        'record_type': 'RecordType',  # noqa: E501
        'record_version': 'RecordVersion',  # noqa: E501
        'replication_mode': 'ReplicationMode',  # noqa: E501
        'rp_mode': 'RpMode',  # noqa: E501
        'serial': 'Serial',  # noqa: E501
        'site_name': 'SiteName',  # noqa: E501
        'software_image': 'SoftwareImage',  # noqa: E501
        'spine_count': 'SpineCount',  # noqa: E501
        'syslog_server_ip_list': 'SyslogServerIpList',  # noqa: E501
        'syslog_sev': 'SyslogSev',  # noqa: E501
        'template_name': 'TemplateName',  # noqa: E501
        'vlan_vni_mappings': 'VlanVniMappings',  # noqa: E501
        'vni_ip_count': 'VniIpCount',  # noqa: E501
        'vpc_details': 'VpcDetails',  # noqa: E501
        'vrf_deployment_count': 'VrfDeploymentCount',  # noqa: E501
        'vrf_deployment_status': 'VrfDeploymentStatus',  # noqa: E501
        'xsite_network_count': 'XsiteNetworkCount',  # noqa: E501
        'xsite_vrf_count': 'XsiteVrfCount',  # noqa: E501
        'registered_device': 'RegisteredDevice',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """NiatelemetryNiaInventoryFabricAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "niatelemetry.NiaInventoryFabric", must be one of ["niatelemetry.NiaInventoryFabric", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "niatelemetry.NiaInventoryFabric", must be one of ["niatelemetry.NiaInventoryFabric", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            anycast_gw_mac (str): Returns the aycast gateway mac.. [optional]  # noqa: E501
            bgp_established_interface_count (int): Counts the number of BGP interfaces that are in established state.. [optional]  # noqa: E501
            bgw_count (int): Returns number of bgw switches in the fabric.. [optional]  # noqa: E501
            bgw_interface_up_count (int): Count number of active interfaces on border gateways.. [optional]  # noqa: E501
            border_gateway_spine_count (int): Count number of border gateway spines in the fabric inventory.. [optional]  # noqa: E501
            border_leaf_count (int): Count number of border leafs in the fabric inventory.. [optional]  # noqa: E501
            cloudsec_autoconfig (bool): Cloudsec autoconfig details on the fabric.. [optional]  # noqa: E501
            dci_subnet_range (str): Returns the dci subnet range.. [optional]  # noqa: E501
            dci_subnet_target_mask (str): Returns the dci subnet target mask.. [optional]  # noqa: E501
            dcnmtracker_enabled (bool): Returns the value of the dcnmtrackerEnabled field.. [optional]  # noqa: E501
            ebgp_evpn_link_up_count (int): Count number of ebgp evpn active interfaces.. [optional]  # noqa: E501
            fabric_id (str): Uniquely identifies a fabric.. [optional]  # noqa: E501
            fabric_name (str): Returns the value of the Name of a fabric.. [optional]  # noqa: E501
            fabric_parent (str): Parent of the fabric on DCNM.. [optional]  # noqa: E501
            fabric_technology (str): Fabric Technology details on the fabric.. [optional]  # noqa: E501
            fabric_type (str): Fabric type information string.. [optional]  # noqa: E501
            feature_ptp (str): PTP feature details on the fabric.. [optional]  # noqa: E501
            is_bgw_present (bool): Checks if border gateway is present in the fabric inventory.. [optional]  # noqa: E501
            is_enable_nxapi_http (bool): Check if NXAPI HTTP is enabled or not on the fabric.. [optional]  # noqa: E501
            is_enable_real_time_backup (bool): Check if real time backup is enabled or not on the fabric.. [optional]  # noqa: E501
            is_ngoam_enabled (bool): Returns if ngoam is enabled.. [optional]  # noqa: E501
            is_scheduled_back_up_enabled (bool): Returns if the scheduled backup is enabled.. [optional]  # noqa: E501
            is_trm_enabled (bool): Is TRM enabled for the fabric.. [optional]  # noqa: E501
            leaf_count (int): Returns total number of leafs in the fabric.. [optional]  # noqa: E501
            link_state_routing (str): Link state routing details on the fabric.. [optional]  # noqa: E501
            link_type (str): Fabric oper status information.. [optional]  # noqa: E501
            logical_links ([NiatelemetryLogicalLink], none_type): [optional]  # noqa: E501
            network_deployment_count (int): No of networks deployed on a fabric.. [optional]  # noqa: E501
            network_deployment_status ([NiatelemetryDeploymentStatus], none_type): [optional]  # noqa: E501
            ntp_server_ip_list (str): NTP server IP List on the fabric.. [optional]  # noqa: E501
            nxos_vni_bw_sites_count (int): Returns the count of vnis between sites.. [optional]  # noqa: E501
            nxos_vrf_bw_sites_count (int): Returns the count of vrfs between sites.. [optional]  # noqa: E501
            nxos_vrf_count (int): Returns the value of the nxosVrfCount field.. [optional]  # noqa: E501
            oper_status (str): Fabric oper status information.. [optional]  # noqa: E501
            record_type (str): Type of record DCNM / APIC / SE. This determines the type of platform where inventory was collected.. [optional]  # noqa: E501
            record_version (str): Version of record being pushed. This determines what was the API version for data available from the device.. [optional]  # noqa: E501
            replication_mode (str): Replication mode details on the fabric.. [optional]  # noqa: E501
            rp_mode (str): RP Mode details on the fabric.. [optional]  # noqa: E501
            serial (str): Serial number of device being inventoried. The serial number is unique per device.. [optional]  # noqa: E501
            site_name (str): Name of fabric domain of the controller.. [optional]  # noqa: E501
            software_image (str): Software image details on the fabric.. [optional]  # noqa: E501
            spine_count (int): Returns total number of spines in the fabric.. [optional]  # noqa: E501
            syslog_server_ip_list (str): Syslog server IP list on DCNM.. [optional]  # noqa: E501
            syslog_sev (str): Syslog sev details on the fabric.. [optional]  # noqa: E501
            template_name (str): Template name of the fabric on DCNM.. [optional]  # noqa: E501
            vlan_vni_mappings (str): VLAN to VNI mappings configured in the DCNM.. [optional]  # noqa: E501
            vni_ip_count (int): Count number of IP addresses configured in the DCNM networks.. [optional]  # noqa: E501
            vpc_details ([NiatelemetryVpcDetails], none_type): [optional]  # noqa: E501
            vrf_deployment_count (int): No of vrfs deployed on a fabric.. [optional]  # noqa: E501
            vrf_deployment_status ([NiatelemetryDeploymentStatus], none_type): [optional]  # noqa: E501
            xsite_network_count (int): Returns deployed network count for bgw/bgws switches in the MSD fabric.. [optional]  # noqa: E501
            xsite_vrf_count (int): Returns deployed vrf count for bgw/bgws switches in the MSD fabric.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "niatelemetry.NiaInventoryFabric")
        object_type = kwargs.get('object_type', "niatelemetry.NiaInventoryFabric")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """NiatelemetryNiaInventoryFabricAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "niatelemetry.NiaInventoryFabric", must be one of ["niatelemetry.NiaInventoryFabric", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "niatelemetry.NiaInventoryFabric", must be one of ["niatelemetry.NiaInventoryFabric", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            anycast_gw_mac (str): Returns the aycast gateway mac.. [optional]  # noqa: E501
            bgp_established_interface_count (int): Counts the number of BGP interfaces that are in established state.. [optional]  # noqa: E501
            bgw_count (int): Returns number of bgw switches in the fabric.. [optional]  # noqa: E501
            bgw_interface_up_count (int): Count number of active interfaces on border gateways.. [optional]  # noqa: E501
            border_gateway_spine_count (int): Count number of border gateway spines in the fabric inventory.. [optional]  # noqa: E501
            border_leaf_count (int): Count number of border leafs in the fabric inventory.. [optional]  # noqa: E501
            cloudsec_autoconfig (bool): Cloudsec autoconfig details on the fabric.. [optional]  # noqa: E501
            dci_subnet_range (str): Returns the dci subnet range.. [optional]  # noqa: E501
            dci_subnet_target_mask (str): Returns the dci subnet target mask.. [optional]  # noqa: E501
            dcnmtracker_enabled (bool): Returns the value of the dcnmtrackerEnabled field.. [optional]  # noqa: E501
            ebgp_evpn_link_up_count (int): Count number of ebgp evpn active interfaces.. [optional]  # noqa: E501
            fabric_id (str): Uniquely identifies a fabric.. [optional]  # noqa: E501
            fabric_name (str): Returns the value of the Name of a fabric.. [optional]  # noqa: E501
            fabric_parent (str): Parent of the fabric on DCNM.. [optional]  # noqa: E501
            fabric_technology (str): Fabric Technology details on the fabric.. [optional]  # noqa: E501
            fabric_type (str): Fabric type information string.. [optional]  # noqa: E501
            feature_ptp (str): PTP feature details on the fabric.. [optional]  # noqa: E501
            is_bgw_present (bool): Checks if border gateway is present in the fabric inventory.. [optional]  # noqa: E501
            is_enable_nxapi_http (bool): Check if NXAPI HTTP is enabled or not on the fabric.. [optional]  # noqa: E501
            is_enable_real_time_backup (bool): Check if real time backup is enabled or not on the fabric.. [optional]  # noqa: E501
            is_ngoam_enabled (bool): Returns if ngoam is enabled.. [optional]  # noqa: E501
            is_scheduled_back_up_enabled (bool): Returns if the scheduled backup is enabled.. [optional]  # noqa: E501
            is_trm_enabled (bool): Is TRM enabled for the fabric.. [optional]  # noqa: E501
            leaf_count (int): Returns total number of leafs in the fabric.. [optional]  # noqa: E501
            link_state_routing (str): Link state routing details on the fabric.. [optional]  # noqa: E501
            link_type (str): Fabric oper status information.. [optional]  # noqa: E501
            logical_links ([NiatelemetryLogicalLink], none_type): [optional]  # noqa: E501
            network_deployment_count (int): No of networks deployed on a fabric.. [optional]  # noqa: E501
            network_deployment_status ([NiatelemetryDeploymentStatus], none_type): [optional]  # noqa: E501
            ntp_server_ip_list (str): NTP server IP List on the fabric.. [optional]  # noqa: E501
            nxos_vni_bw_sites_count (int): Returns the count of vnis between sites.. [optional]  # noqa: E501
            nxos_vrf_bw_sites_count (int): Returns the count of vrfs between sites.. [optional]  # noqa: E501
            nxos_vrf_count (int): Returns the value of the nxosVrfCount field.. [optional]  # noqa: E501
            oper_status (str): Fabric oper status information.. [optional]  # noqa: E501
            record_type (str): Type of record DCNM / APIC / SE. This determines the type of platform where inventory was collected.. [optional]  # noqa: E501
            record_version (str): Version of record being pushed. This determines what was the API version for data available from the device.. [optional]  # noqa: E501
            replication_mode (str): Replication mode details on the fabric.. [optional]  # noqa: E501
            rp_mode (str): RP Mode details on the fabric.. [optional]  # noqa: E501
            serial (str): Serial number of device being inventoried. The serial number is unique per device.. [optional]  # noqa: E501
            site_name (str): Name of fabric domain of the controller.. [optional]  # noqa: E501
            software_image (str): Software image details on the fabric.. [optional]  # noqa: E501
            spine_count (int): Returns total number of spines in the fabric.. [optional]  # noqa: E501
            syslog_server_ip_list (str): Syslog server IP list on DCNM.. [optional]  # noqa: E501
            syslog_sev (str): Syslog sev details on the fabric.. [optional]  # noqa: E501
            template_name (str): Template name of the fabric on DCNM.. [optional]  # noqa: E501
            vlan_vni_mappings (str): VLAN to VNI mappings configured in the DCNM.. [optional]  # noqa: E501
            vni_ip_count (int): Count number of IP addresses configured in the DCNM networks.. [optional]  # noqa: E501
            vpc_details ([NiatelemetryVpcDetails], none_type): [optional]  # noqa: E501
            vrf_deployment_count (int): No of vrfs deployed on a fabric.. [optional]  # noqa: E501
            vrf_deployment_status ([NiatelemetryDeploymentStatus], none_type): [optional]  # noqa: E501
            xsite_network_count (int): Returns deployed network count for bgw/bgws switches in the MSD fabric.. [optional]  # noqa: E501
            xsite_vrf_count (int): Returns deployed vrf count for bgw/bgws switches in the MSD fabric.. [optional]  # noqa: E501
            registered_device (AssetDeviceRegistrationRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "niatelemetry.NiaInventoryFabric")
        object_type = kwargs.get('object_type', "niatelemetry.NiaInventoryFabric")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
