"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.11-9235
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from intersight.exceptions import ApiAttributeError


def lazy_import():
    from intersight.model.meta_access_privilege import MetaAccessPrivilege
    from intersight.model.meta_display_name_definition import MetaDisplayNameDefinition
    from intersight.model.meta_identity_definition import MetaIdentityDefinition
    from intersight.model.meta_prop_definition import MetaPropDefinition
    from intersight.model.meta_relationship_definition import MetaRelationshipDefinition
    globals()['MetaAccessPrivilege'] = MetaAccessPrivilege
    globals()['MetaDisplayNameDefinition'] = MetaDisplayNameDefinition
    globals()['MetaIdentityDefinition'] = MetaIdentityDefinition
    globals()['MetaPropDefinition'] = MetaPropDefinition
    globals()['MetaRelationshipDefinition'] = MetaRelationshipDefinition


class MetaDefinitionAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'META.DEFINITION': "meta.Definition",
        },
        ('object_type',): {
            'META.DEFINITION': "meta.Definition",
        },
        ('meta_type',): {
            'MANAGEDOBJECT': "ManagedObject",
            'COMPLEXTYPE': "ComplexType",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'access_privileges': ([MetaAccessPrivilege], none_type,),  # noqa: E501
            'ancestor_classes': ([str], none_type,),  # noqa: E501
            'display_name_metas': ([MetaDisplayNameDefinition], none_type,),  # noqa: E501
            'identity_constraints': ([MetaIdentityDefinition], none_type,),  # noqa: E501
            'is_concrete': (bool,),  # noqa: E501
            'meta_type': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'namespace': (str,),  # noqa: E501
            'parent_class': (str,),  # noqa: E501
            'permission_supported': (bool,),  # noqa: E501
            'properties': ([MetaPropDefinition], none_type,),  # noqa: E501
            'rbac_resource': (bool,),  # noqa: E501
            'relationships': ([MetaRelationshipDefinition], none_type,),  # noqa: E501
            'resource_pool_types': ([str], none_type,),  # noqa: E501
            'rest_path': (str,),  # noqa: E501
            'version': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'access_privileges': 'AccessPrivileges',  # noqa: E501
        'ancestor_classes': 'AncestorClasses',  # noqa: E501
        'display_name_metas': 'DisplayNameMetas',  # noqa: E501
        'identity_constraints': 'IdentityConstraints',  # noqa: E501
        'is_concrete': 'IsConcrete',  # noqa: E501
        'meta_type': 'MetaType',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'namespace': 'Namespace',  # noqa: E501
        'parent_class': 'ParentClass',  # noqa: E501
        'permission_supported': 'PermissionSupported',  # noqa: E501
        'properties': 'Properties',  # noqa: E501
        'rbac_resource': 'RbacResource',  # noqa: E501
        'relationships': 'Relationships',  # noqa: E501
        'resource_pool_types': 'ResourcePoolTypes',  # noqa: E501
        'rest_path': 'RestPath',  # noqa: E501
        'version': 'Version',  # noqa: E501
    }

    read_only_vars = {
        'is_concrete',  # noqa: E501
        'meta_type',  # noqa: E501
        'name',  # noqa: E501
        'namespace',  # noqa: E501
        'parent_class',  # noqa: E501
        'permission_supported',  # noqa: E501
        'rbac_resource',  # noqa: E501
        'rest_path',  # noqa: E501
        'version',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """MetaDefinitionAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "meta.Definition", must be one of ["meta.Definition", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "meta.Definition", must be one of ["meta.Definition", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            access_privileges ([MetaAccessPrivilege], none_type): [optional]  # noqa: E501
            ancestor_classes ([str], none_type): [optional]  # noqa: E501
            display_name_metas ([MetaDisplayNameDefinition], none_type): [optional]  # noqa: E501
            identity_constraints ([MetaIdentityDefinition], none_type): [optional]  # noqa: E501
            is_concrete (bool): Boolean flag to specify whether the meta class is a concrete class or not.. [optional]  # noqa: E501
            meta_type (str): Indicates whether the meta class is a complex type or managed object. * `ManagedObject` - The meta.Definition object describes a managed object. * `ComplexType` - The meta.Definition object describes a nested complex type within a managed object.. [optional] if omitted the server will use the default value of "ManagedObject"  # noqa: E501
            name (str): The fully-qualified class name of the Managed Object or complex type. For example, \"compute:Blade\" where the Managed Object is \"Blade\" and the package is 'compute'.. [optional]  # noqa: E501
            namespace (str): The namespace of the meta.. [optional]  # noqa: E501
            parent_class (str): The fully-qualified name of the parent metaclass in the class inheritance hierarchy.. [optional]  # noqa: E501
            permission_supported (bool): Boolean flag to specify whether instances of this class type can be specified in permissions for instance based access control. Permissions can be created for entire Intersight account or to a subset of resources (instance based access control). In the first release, permissions are supported for entire account or for a subset of organizations.. [optional]  # noqa: E501
            properties ([MetaPropDefinition], none_type): [optional]  # noqa: E501
            rbac_resource (bool): Boolean flag to specify whether instances of this class type can be assigned to resource groups that are part of an organization for access control. Inventoried physical/logical objects which needs access control should have rbacResource=true. These objects are not part of any organization by default like device registrations and should be assigned to organizations for access control. Profiles, policies, workflow definitions which are created by specifying organization need not have this flag set.. [optional]  # noqa: E501
            relationships ([MetaRelationshipDefinition], none_type): [optional]  # noqa: E501
            resource_pool_types ([str], none_type): [optional]  # noqa: E501
            rest_path (str): Restful URL path for the meta.. [optional]  # noqa: E501
            version (str): The version of the service that defines the meta-data.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "meta.Definition")
        object_type = kwargs.get('object_type', "meta.Definition")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """MetaDefinitionAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "meta.Definition", must be one of ["meta.Definition", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "meta.Definition", must be one of ["meta.Definition", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            access_privileges ([MetaAccessPrivilege], none_type): [optional]  # noqa: E501
            ancestor_classes ([str], none_type): [optional]  # noqa: E501
            display_name_metas ([MetaDisplayNameDefinition], none_type): [optional]  # noqa: E501
            identity_constraints ([MetaIdentityDefinition], none_type): [optional]  # noqa: E501
            is_concrete (bool): Boolean flag to specify whether the meta class is a concrete class or not.. [optional]  # noqa: E501
            meta_type (str): Indicates whether the meta class is a complex type or managed object. * `ManagedObject` - The meta.Definition object describes a managed object. * `ComplexType` - The meta.Definition object describes a nested complex type within a managed object.. [optional] if omitted the server will use the default value of "ManagedObject"  # noqa: E501
            name (str): The fully-qualified class name of the Managed Object or complex type. For example, \"compute:Blade\" where the Managed Object is \"Blade\" and the package is 'compute'.. [optional]  # noqa: E501
            namespace (str): The namespace of the meta.. [optional]  # noqa: E501
            parent_class (str): The fully-qualified name of the parent metaclass in the class inheritance hierarchy.. [optional]  # noqa: E501
            permission_supported (bool): Boolean flag to specify whether instances of this class type can be specified in permissions for instance based access control. Permissions can be created for entire Intersight account or to a subset of resources (instance based access control). In the first release, permissions are supported for entire account or for a subset of organizations.. [optional]  # noqa: E501
            properties ([MetaPropDefinition], none_type): [optional]  # noqa: E501
            rbac_resource (bool): Boolean flag to specify whether instances of this class type can be assigned to resource groups that are part of an organization for access control. Inventoried physical/logical objects which needs access control should have rbacResource=true. These objects are not part of any organization by default like device registrations and should be assigned to organizations for access control. Profiles, policies, workflow definitions which are created by specifying organization need not have this flag set.. [optional]  # noqa: E501
            relationships ([MetaRelationshipDefinition], none_type): [optional]  # noqa: E501
            resource_pool_types ([str], none_type): [optional]  # noqa: E501
            rest_path (str): Restful URL path for the meta.. [optional]  # noqa: E501
            version (str): The version of the service that defines the meta-data.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "meta.Definition")
        object_type = kwargs.get('object_type', "meta.Definition")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
