# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiVersionInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'version': 'str',
        'snapshot': 'bool',
        'build_user': 'str',
        'build_timestamp': 'str',
        'git_hash': 'str'
    }

    attribute_map = {
        'version': 'version',
        'snapshot': 'snapshot',
        'build_user': 'buildUser',
        'build_timestamp': 'buildTimestamp',
        'git_hash': 'gitHash'
    }

    def __init__(self, version=None, snapshot=None, build_user=None, build_timestamp=None, git_hash=None):
        """
        ApiVersionInfo - a model defined in Swagger
        """

        self._version = None
        self._snapshot = None
        self._build_user = None
        self._build_timestamp = None
        self._git_hash = None

        if version is not None:
          self.version = version
        if snapshot is not None:
          self.snapshot = snapshot
        if build_user is not None:
          self.build_user = build_user
        if build_timestamp is not None:
          self.build_timestamp = build_timestamp
        if git_hash is not None:
          self.git_hash = git_hash

    @property
    def version(self):
        """
        Gets the version of this ApiVersionInfo.
        Version.

        :return: The version of this ApiVersionInfo.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ApiVersionInfo.
        Version.

        :param version: The version of this ApiVersionInfo.
        :type: str
        """

        self._version = version

    @property
    def snapshot(self):
        """
        Gets the snapshot of this ApiVersionInfo.
        Whether this build is a development snapshot.

        :return: The snapshot of this ApiVersionInfo.
        :rtype: bool
        """
        return self._snapshot

    @snapshot.setter
    def snapshot(self, snapshot):
        """
        Sets the snapshot of this ApiVersionInfo.
        Whether this build is a development snapshot.

        :param snapshot: The snapshot of this ApiVersionInfo.
        :type: bool
        """

        self._snapshot = snapshot

    @property
    def build_user(self):
        """
        Gets the build_user of this ApiVersionInfo.
        The user performing the build.

        :return: The build_user of this ApiVersionInfo.
        :rtype: str
        """
        return self._build_user

    @build_user.setter
    def build_user(self, build_user):
        """
        Sets the build_user of this ApiVersionInfo.
        The user performing the build.

        :param build_user: The build_user of this ApiVersionInfo.
        :type: str
        """

        self._build_user = build_user

    @property
    def build_timestamp(self):
        """
        Gets the build_timestamp of this ApiVersionInfo.
        Build timestamp.

        :return: The build_timestamp of this ApiVersionInfo.
        :rtype: str
        """
        return self._build_timestamp

    @build_timestamp.setter
    def build_timestamp(self, build_timestamp):
        """
        Sets the build_timestamp of this ApiVersionInfo.
        Build timestamp.

        :param build_timestamp: The build_timestamp of this ApiVersionInfo.
        :type: str
        """

        self._build_timestamp = build_timestamp

    @property
    def git_hash(self):
        """
        Gets the git_hash of this ApiVersionInfo.
        Source control management hash.

        :return: The git_hash of this ApiVersionInfo.
        :rtype: str
        """
        return self._git_hash

    @git_hash.setter
    def git_hash(self, git_hash):
        """
        Sets the git_hash of this ApiVersionInfo.
        Source control management hash.

        :param git_hash: The git_hash of this ApiVersionInfo.
        :type: str
        """

        self._git_hash = git_hash

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiVersionInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
