# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiUser2(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'password': 'str',
        'auth_roles': 'list[ApiAuthRoleRef]',
        'pw_hash': 'str',
        'pw_salt': 'int',
        'pw_login': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'password': 'password',
        'auth_roles': 'authRoles',
        'pw_hash': 'pwHash',
        'pw_salt': 'pwSalt',
        'pw_login': 'pwLogin'
    }

    def __init__(self, name=None, password=None, auth_roles=None, pw_hash=None, pw_salt=None, pw_login=None):
        """
        ApiUser2 - a model defined in Swagger
        """

        self._name = None
        self._password = None
        self._auth_roles = None
        self._pw_hash = None
        self._pw_salt = None
        self._pw_login = None

        if name is not None:
          self.name = name
        if password is not None:
          self.password = password
        if auth_roles is not None:
          self.auth_roles = auth_roles
        if pw_hash is not None:
          self.pw_hash = pw_hash
        if pw_salt is not None:
          self.pw_salt = pw_salt
        if pw_login is not None:
          self.pw_login = pw_login

    @property
    def name(self):
        """
        Gets the name of this ApiUser2.
        The username, which is unique within a Cloudera Manager installation.

        :return: The name of this ApiUser2.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiUser2.
        The username, which is unique within a Cloudera Manager installation.

        :param name: The name of this ApiUser2.
        :type: str
        """

        self._name = name

    @property
    def password(self):
        """
        Gets the password of this ApiUser2.
        Returns the user password. <p> Passwords are not returned when querying user information, so this property will always be empty when reading information from a server.

        :return: The password of this ApiUser2.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this ApiUser2.
        Returns the user password. <p> Passwords are not returned when querying user information, so this property will always be empty when reading information from a server.

        :param password: The password of this ApiUser2.
        :type: str
        """

        self._password = password

    @property
    def auth_roles(self):
        """
        Gets the auth_roles of this ApiUser2.
        A list of ApiAuthRole that this user possesses.

        :return: The auth_roles of this ApiUser2.
        :rtype: list[ApiAuthRoleRef]
        """
        return self._auth_roles

    @auth_roles.setter
    def auth_roles(self, auth_roles):
        """
        Sets the auth_roles of this ApiUser2.
        A list of ApiAuthRole that this user possesses.

        :param auth_roles: The auth_roles of this ApiUser2.
        :type: list[ApiAuthRoleRef]
        """

        self._auth_roles = auth_roles

    @property
    def pw_hash(self):
        """
        Gets the pw_hash of this ApiUser2.
        NOTE: Only available in the \"export\" view

        :return: The pw_hash of this ApiUser2.
        :rtype: str
        """
        return self._pw_hash

    @pw_hash.setter
    def pw_hash(self, pw_hash):
        """
        Sets the pw_hash of this ApiUser2.
        NOTE: Only available in the \"export\" view

        :param pw_hash: The pw_hash of this ApiUser2.
        :type: str
        """

        self._pw_hash = pw_hash

    @property
    def pw_salt(self):
        """
        Gets the pw_salt of this ApiUser2.
        NOTE: Only available in the \"export\" view

        :return: The pw_salt of this ApiUser2.
        :rtype: int
        """
        return self._pw_salt

    @pw_salt.setter
    def pw_salt(self, pw_salt):
        """
        Sets the pw_salt of this ApiUser2.
        NOTE: Only available in the \"export\" view

        :param pw_salt: The pw_salt of this ApiUser2.
        :type: int
        """

        self._pw_salt = pw_salt

    @property
    def pw_login(self):
        """
        Gets the pw_login of this ApiUser2.
        NOTE: Only available in the \"export\" view

        :return: The pw_login of this ApiUser2.
        :rtype: bool
        """
        return self._pw_login

    @pw_login.setter
    def pw_login(self, pw_login):
        """
        Sets the pw_login of this ApiUser2.
        NOTE: Only available in the \"export\" view

        :param pw_login: The pw_login of this ApiUser2.
        :type: bool
        """

        self._pw_login = pw_login

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiUser2):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
