# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiTimeSeriesRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'query': 'str',
        '_from': 'str',
        'to': 'str',
        'content_type': 'str',
        'desired_rollup': 'str',
        'must_use_desired_rollup': 'bool'
    }

    attribute_map = {
        'query': 'query',
        '_from': 'from',
        'to': 'to',
        'content_type': 'contentType',
        'desired_rollup': 'desiredRollup',
        'must_use_desired_rollup': 'mustUseDesiredRollup'
    }

    def __init__(self, query=None, _from=None, to=None, content_type=None, desired_rollup=None, must_use_desired_rollup=None):
        """
        ApiTimeSeriesRequest - a model defined in Swagger
        """

        self._query = None
        self.__from = None
        self._to = None
        self._content_type = None
        self._desired_rollup = None
        self._must_use_desired_rollup = None

        if query is not None:
          self.query = query
        if _from is not None:
          self._from = _from
        if to is not None:
          self.to = to
        if content_type is not None:
          self.content_type = content_type
        if desired_rollup is not None:
          self.desired_rollup = desired_rollup
        if must_use_desired_rollup is not None:
          self.must_use_desired_rollup = must_use_desired_rollup

    @property
    def query(self):
        """
        Gets the query of this ApiTimeSeriesRequest.
        tsquery to run against the CM time-series data store. Please see the <a href=\"http://tiny.cloudera.com/cm_tsquery\"> tsquery language documentation</a>.<p/>

        :return: The query of this ApiTimeSeriesRequest.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """
        Sets the query of this ApiTimeSeriesRequest.
        tsquery to run against the CM time-series data store. Please see the <a href=\"http://tiny.cloudera.com/cm_tsquery\"> tsquery language documentation</a>.<p/>

        :param query: The query of this ApiTimeSeriesRequest.
        :type: str
        """

        self._query = query

    @property
    def _from(self):
        """
        Gets the _from of this ApiTimeSeriesRequest.
        Start of the period to query in ISO 8601 format (defaults to 5 minutes before the end of the period).

        :return: The _from of this ApiTimeSeriesRequest.
        :rtype: str
        """
        return self.__from

    @_from.setter
    def _from(self, _from):
        """
        Sets the _from of this ApiTimeSeriesRequest.
        Start of the period to query in ISO 8601 format (defaults to 5 minutes before the end of the period).

        :param _from: The _from of this ApiTimeSeriesRequest.
        :type: str
        """

        self.__from = _from

    @property
    def to(self):
        """
        Gets the to of this ApiTimeSeriesRequest.
        End of the period to query in ISO 8601 format (defaults to current time).

        :return: The to of this ApiTimeSeriesRequest.
        :rtype: str
        """
        return self._to

    @to.setter
    def to(self, to):
        """
        Sets the to of this ApiTimeSeriesRequest.
        End of the period to query in ISO 8601 format (defaults to current time).

        :param to: The to of this ApiTimeSeriesRequest.
        :type: str
        """

        self._to = to

    @property
    def content_type(self):
        """
        Gets the content_type of this ApiTimeSeriesRequest.
        contentType to return the response in. The content types \"application/json\" and \"text/csv\" are supported. This defaults to \"application/json\". If \"text/csv\" is specified then we return one row per time series data point, and we don't return any of the metadata.

        :return: The content_type of this ApiTimeSeriesRequest.
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """
        Sets the content_type of this ApiTimeSeriesRequest.
        contentType to return the response in. The content types \"application/json\" and \"text/csv\" are supported. This defaults to \"application/json\". If \"text/csv\" is specified then we return one row per time series data point, and we don't return any of the metadata.

        :param content_type: The content_type of this ApiTimeSeriesRequest.
        :type: str
        """

        self._content_type = content_type

    @property
    def desired_rollup(self):
        """
        Gets the desired_rollup of this ApiTimeSeriesRequest.
        Aggregate rollup level desired for the response data. Valid values are RAW, TEN_MINUTELY, HOURLY, SIX_HOURLY, DAILY, and WEEKLY. Note that if the mustUseDesiredRollup parameter is not set, then the monitoring server can decide to return a different rollup level.

        :return: The desired_rollup of this ApiTimeSeriesRequest.
        :rtype: str
        """
        return self._desired_rollup

    @desired_rollup.setter
    def desired_rollup(self, desired_rollup):
        """
        Sets the desired_rollup of this ApiTimeSeriesRequest.
        Aggregate rollup level desired for the response data. Valid values are RAW, TEN_MINUTELY, HOURLY, SIX_HOURLY, DAILY, and WEEKLY. Note that if the mustUseDesiredRollup parameter is not set, then the monitoring server can decide to return a different rollup level.

        :param desired_rollup: The desired_rollup of this ApiTimeSeriesRequest.
        :type: str
        """

        self._desired_rollup = desired_rollup

    @property
    def must_use_desired_rollup(self):
        """
        Gets the must_use_desired_rollup of this ApiTimeSeriesRequest.
        If set to true, then the tsquery will return data with the desired aggregate rollup level.

        :return: The must_use_desired_rollup of this ApiTimeSeriesRequest.
        :rtype: bool
        """
        return self._must_use_desired_rollup

    @must_use_desired_rollup.setter
    def must_use_desired_rollup(self, must_use_desired_rollup):
        """
        Sets the must_use_desired_rollup of this ApiTimeSeriesRequest.
        If set to true, then the tsquery will return data with the desired aggregate rollup level.

        :param must_use_desired_rollup: The must_use_desired_rollup of this ApiTimeSeriesRequest.
        :type: bool
        """

        self._must_use_desired_rollup = must_use_desired_rollup

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiTimeSeriesRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
