# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiRestartClusterArgs(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'restart_only_stale_services': 'bool',
        'redeploy_client_configuration': 'bool',
        'restart_service_names': 'list[str]'
    }

    attribute_map = {
        'restart_only_stale_services': 'restartOnlyStaleServices',
        'redeploy_client_configuration': 'redeployClientConfiguration',
        'restart_service_names': 'restartServiceNames'
    }

    def __init__(self, restart_only_stale_services=None, redeploy_client_configuration=None, restart_service_names=None):
        """
        ApiRestartClusterArgs - a model defined in Swagger
        """

        self._restart_only_stale_services = None
        self._redeploy_client_configuration = None
        self._restart_service_names = None

        if restart_only_stale_services is not None:
          self.restart_only_stale_services = restart_only_stale_services
        if redeploy_client_configuration is not None:
          self.redeploy_client_configuration = redeploy_client_configuration
        if restart_service_names is not None:
          self.restart_service_names = restart_service_names

    @property
    def restart_only_stale_services(self):
        """
        Gets the restart_only_stale_services of this ApiRestartClusterArgs.
        Only restart services that have stale configuration and their dependent services.

        :return: The restart_only_stale_services of this ApiRestartClusterArgs.
        :rtype: bool
        """
        return self._restart_only_stale_services

    @restart_only_stale_services.setter
    def restart_only_stale_services(self, restart_only_stale_services):
        """
        Sets the restart_only_stale_services of this ApiRestartClusterArgs.
        Only restart services that have stale configuration and their dependent services.

        :param restart_only_stale_services: The restart_only_stale_services of this ApiRestartClusterArgs.
        :type: bool
        """

        self._restart_only_stale_services = restart_only_stale_services

    @property
    def redeploy_client_configuration(self):
        """
        Gets the redeploy_client_configuration of this ApiRestartClusterArgs.
        Re-deploy client configuration for all services in the cluster.

        :return: The redeploy_client_configuration of this ApiRestartClusterArgs.
        :rtype: bool
        """
        return self._redeploy_client_configuration

    @redeploy_client_configuration.setter
    def redeploy_client_configuration(self, redeploy_client_configuration):
        """
        Sets the redeploy_client_configuration of this ApiRestartClusterArgs.
        Re-deploy client configuration for all services in the cluster.

        :param redeploy_client_configuration: The redeploy_client_configuration of this ApiRestartClusterArgs.
        :type: bool
        """

        self._redeploy_client_configuration = redeploy_client_configuration

    @property
    def restart_service_names(self):
        """
        Gets the restart_service_names of this ApiRestartClusterArgs.
        Only restart services that are specified and their dependent services. Available since V11.

        :return: The restart_service_names of this ApiRestartClusterArgs.
        :rtype: list[str]
        """
        return self._restart_service_names

    @restart_service_names.setter
    def restart_service_names(self, restart_service_names):
        """
        Sets the restart_service_names of this ApiRestartClusterArgs.
        Only restart services that are specified and their dependent services. Available since V11.

        :param restart_service_names: The restart_service_names of this ApiRestartClusterArgs.
        :type: list[str]
        """

        self._restart_service_names = restart_service_names

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiRestartClusterArgs):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
