# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiMetricSchema(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'display_name': 'str',
        'description': 'str',
        'is_counter': 'bool',
        'unit_numerator': 'str',
        'unit_denominator': 'str',
        'aliases': 'list[str]',
        'sources': 'dict(str, list[str])'
    }

    attribute_map = {
        'name': 'name',
        'display_name': 'displayName',
        'description': 'description',
        'is_counter': 'isCounter',
        'unit_numerator': 'unitNumerator',
        'unit_denominator': 'unitDenominator',
        'aliases': 'aliases',
        'sources': 'sources'
    }

    def __init__(self, name=None, display_name=None, description=None, is_counter=None, unit_numerator=None, unit_denominator=None, aliases=None, sources=None):
        """
        ApiMetricSchema - a model defined in Swagger
        """

        self._name = None
        self._display_name = None
        self._description = None
        self._is_counter = None
        self._unit_numerator = None
        self._unit_denominator = None
        self._aliases = None
        self._sources = None

        if name is not None:
          self.name = name
        if display_name is not None:
          self.display_name = display_name
        if description is not None:
          self.description = description
        if is_counter is not None:
          self.is_counter = is_counter
        if unit_numerator is not None:
          self.unit_numerator = unit_numerator
        if unit_denominator is not None:
          self.unit_denominator = unit_denominator
        if aliases is not None:
          self.aliases = aliases
        if sources is not None:
          self.sources = sources

    @property
    def name(self):
        """
        Gets the name of this ApiMetricSchema.
        Name of the metric. This name is guaranteed to be unique among the metrics.

        :return: The name of this ApiMetricSchema.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiMetricSchema.
        Name of the metric. This name is guaranteed to be unique among the metrics.

        :param name: The name of this ApiMetricSchema.
        :type: str
        """

        self._name = name

    @property
    def display_name(self):
        """
        Gets the display_name of this ApiMetricSchema.
        Display name of the metric.

        :return: The display_name of this ApiMetricSchema.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ApiMetricSchema.
        Display name of the metric.

        :param display_name: The display_name of this ApiMetricSchema.
        :type: str
        """

        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this ApiMetricSchema.
        Description of the metric.

        :return: The description of this ApiMetricSchema.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ApiMetricSchema.
        Description of the metric.

        :param description: The description of this ApiMetricSchema.
        :type: str
        """

        self._description = description

    @property
    def is_counter(self):
        """
        Gets the is_counter of this ApiMetricSchema.
        Is the metric a counter. A counter tracks the total count since a process / host started. The rate of change of a counter may often be more interesting than the raw value of a counter.

        :return: The is_counter of this ApiMetricSchema.
        :rtype: bool
        """
        return self._is_counter

    @is_counter.setter
    def is_counter(self, is_counter):
        """
        Sets the is_counter of this ApiMetricSchema.
        Is the metric a counter. A counter tracks the total count since a process / host started. The rate of change of a counter may often be more interesting than the raw value of a counter.

        :param is_counter: The is_counter of this ApiMetricSchema.
        :type: bool
        """

        self._is_counter = is_counter

    @property
    def unit_numerator(self):
        """
        Gets the unit_numerator of this ApiMetricSchema.
        Numerator for the unit of the metric.

        :return: The unit_numerator of this ApiMetricSchema.
        :rtype: str
        """
        return self._unit_numerator

    @unit_numerator.setter
    def unit_numerator(self, unit_numerator):
        """
        Sets the unit_numerator of this ApiMetricSchema.
        Numerator for the unit of the metric.

        :param unit_numerator: The unit_numerator of this ApiMetricSchema.
        :type: str
        """

        self._unit_numerator = unit_numerator

    @property
    def unit_denominator(self):
        """
        Gets the unit_denominator of this ApiMetricSchema.
        Denominator for the unit of the metric.

        :return: The unit_denominator of this ApiMetricSchema.
        :rtype: str
        """
        return self._unit_denominator

    @unit_denominator.setter
    def unit_denominator(self, unit_denominator):
        """
        Sets the unit_denominator of this ApiMetricSchema.
        Denominator for the unit of the metric.

        :param unit_denominator: The unit_denominator of this ApiMetricSchema.
        :type: str
        """

        self._unit_denominator = unit_denominator

    @property
    def aliases(self):
        """
        Gets the aliases of this ApiMetricSchema.
        Aliases for the metric. An alias is unique per metric (per source and version) but is not globally unique. Aliases usually refer to previous names for the metric as metrics are renamed or replaced.

        :return: The aliases of this ApiMetricSchema.
        :rtype: list[str]
        """
        return self._aliases

    @aliases.setter
    def aliases(self, aliases):
        """
        Sets the aliases of this ApiMetricSchema.
        Aliases for the metric. An alias is unique per metric (per source and version) but is not globally unique. Aliases usually refer to previous names for the metric as metrics are renamed or replaced.

        :param aliases: The aliases of this ApiMetricSchema.
        :type: list[str]
        """

        self._aliases = aliases

    @property
    def sources(self):
        """
        Gets the sources of this ApiMetricSchema.
        Sources for the metric. Each source entry contains the name of the source and a list of versions for which this source is valid

        :return: The sources of this ApiMetricSchema.
        :rtype: dict(str, list[str])
        """
        return self._sources

    @sources.setter
    def sources(self, sources):
        """
        Sets the sources of this ApiMetricSchema.
        Sources for the metric. Each source entry contains the name of the source and a list of versions for which this source is valid

        :param sources: The sources of this ApiMetricSchema.
        :type: dict(str, list[str])
        """

        self._sources = sources

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiMetricSchema):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
