# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiInstallControlPlaneArgs(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'kubernetes_type': 'str',
        'remote_repo_url': 'str',
        'values_yaml': 'str',
        'kube_config': 'str',
        'namespace': 'str',
        'docker_registry': 'str',
        'is_override_allowed': 'bool'
    }

    attribute_map = {
        'kubernetes_type': 'kubernetesType',
        'remote_repo_url': 'remoteRepoUrl',
        'values_yaml': 'valuesYaml',
        'kube_config': 'kubeConfig',
        'namespace': 'namespace',
        'docker_registry': 'dockerRegistry',
        'is_override_allowed': 'isOverrideAllowed'
    }

    def __init__(self, kubernetes_type=None, remote_repo_url=None, values_yaml=None, kube_config=None, namespace=None, docker_registry=None, is_override_allowed=None):
        """
        ApiInstallControlPlaneArgs - a model defined in Swagger
        """

        self._kubernetes_type = None
        self._remote_repo_url = None
        self._values_yaml = None
        self._kube_config = None
        self._namespace = None
        self._docker_registry = None
        self._is_override_allowed = None

        if kubernetes_type is not None:
          self.kubernetes_type = kubernetes_type
        if remote_repo_url is not None:
          self.remote_repo_url = remote_repo_url
        if values_yaml is not None:
          self.values_yaml = values_yaml
        if kube_config is not None:
          self.kube_config = kube_config
        if namespace is not None:
          self.namespace = namespace
        if docker_registry is not None:
          self.docker_registry = docker_registry
        if is_override_allowed is not None:
          self.is_override_allowed = is_override_allowed

    @property
    def kubernetes_type(self):
        """
        Gets the kubernetes_type of this ApiInstallControlPlaneArgs.
        The kubernetes type (e.g. \"openshift\") that the control plane will run on

        :return: The kubernetes_type of this ApiInstallControlPlaneArgs.
        :rtype: str
        """
        return self._kubernetes_type

    @kubernetes_type.setter
    def kubernetes_type(self, kubernetes_type):
        """
        Sets the kubernetes_type of this ApiInstallControlPlaneArgs.
        The kubernetes type (e.g. \"openshift\") that the control plane will run on

        :param kubernetes_type: The kubernetes_type of this ApiInstallControlPlaneArgs.
        :type: str
        """

        self._kubernetes_type = kubernetes_type

    @property
    def remote_repo_url(self):
        """
        Gets the remote_repo_url of this ApiInstallControlPlaneArgs.
        The url of the remote repository where the private cloud artifacts to install are hosted

        :return: The remote_repo_url of this ApiInstallControlPlaneArgs.
        :rtype: str
        """
        return self._remote_repo_url

    @remote_repo_url.setter
    def remote_repo_url(self, remote_repo_url):
        """
        Sets the remote_repo_url of this ApiInstallControlPlaneArgs.
        The url of the remote repository where the private cloud artifacts to install are hosted

        :param remote_repo_url: The remote_repo_url of this ApiInstallControlPlaneArgs.
        :type: str
        """

        self._remote_repo_url = remote_repo_url

    @property
    def values_yaml(self):
        """
        Gets the values_yaml of this ApiInstallControlPlaneArgs.
        A yaml file containing configuration parameters for the installation. To see sample values.yaml files, read the documentation <a target=\"_blank\"  href=http://tiny.cloudera.com/cdp-pvc.install-values-yaml>here</a>.

        :return: The values_yaml of this ApiInstallControlPlaneArgs.
        :rtype: str
        """
        return self._values_yaml

    @values_yaml.setter
    def values_yaml(self, values_yaml):
        """
        Sets the values_yaml of this ApiInstallControlPlaneArgs.
        A yaml file containing configuration parameters for the installation. To see sample values.yaml files, read the documentation <a target=\"_blank\"  href=http://tiny.cloudera.com/cdp-pvc.install-values-yaml>here</a>.

        :param values_yaml: The values_yaml of this ApiInstallControlPlaneArgs.
        :type: str
        """

        self._values_yaml = values_yaml

    @property
    def kube_config(self):
        """
        Gets the kube_config of this ApiInstallControlPlaneArgs.
        The content of the kubeconfig file of the kubernetes environment on which the install will be performed Simplified example:<br> <br> apiVersion: v1<br> clusters:<br> - cluster:<br> &emsp;&emsp;certificate-authority-data: abc123<br> &emsp;&emsp;server: https://example-server.domain.com:6443<br> &emsp;name: example-cluster.domain.com:6443<br> contexts:<br> - context:<br> &emsp;&emsp;cluster: ocp-cluster1<br> &emsp;&emsp;user: admin<br> &emsp;name: admin<br> current-context: admin<br> kind: Config<br> preferences: {}<br> users:<br> - name: admin<br> &emsp;user:<br> &emsp;&emsp;client-certificate-data: abc123<br> &emsp;&emsp;client-key-data: xyz987<br> <br> For more information on the kubeconfig file, read the documentation <a target=\"_blank\" href=http://tiny.cloudera.com/cdp-pvc.kubernetes>here</a>.

        :return: The kube_config of this ApiInstallControlPlaneArgs.
        :rtype: str
        """
        return self._kube_config

    @kube_config.setter
    def kube_config(self, kube_config):
        """
        Sets the kube_config of this ApiInstallControlPlaneArgs.
        The content of the kubeconfig file of the kubernetes environment on which the install will be performed Simplified example:<br> <br> apiVersion: v1<br> clusters:<br> - cluster:<br> &emsp;&emsp;certificate-authority-data: abc123<br> &emsp;&emsp;server: https://example-server.domain.com:6443<br> &emsp;name: example-cluster.domain.com:6443<br> contexts:<br> - context:<br> &emsp;&emsp;cluster: ocp-cluster1<br> &emsp;&emsp;user: admin<br> &emsp;name: admin<br> current-context: admin<br> kind: Config<br> preferences: {}<br> users:<br> - name: admin<br> &emsp;user:<br> &emsp;&emsp;client-certificate-data: abc123<br> &emsp;&emsp;client-key-data: xyz987<br> <br> For more information on the kubeconfig file, read the documentation <a target=\"_blank\" href=http://tiny.cloudera.com/cdp-pvc.kubernetes>here</a>.

        :param kube_config: The kube_config of this ApiInstallControlPlaneArgs.
        :type: str
        """

        self._kube_config = kube_config

    @property
    def namespace(self):
        """
        Gets the namespace of this ApiInstallControlPlaneArgs.
        A unique namespace where the control plane will be installed

        :return: The namespace of this ApiInstallControlPlaneArgs.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this ApiInstallControlPlaneArgs.
        A unique namespace where the control plane will be installed

        :param namespace: The namespace of this ApiInstallControlPlaneArgs.
        :type: str
        """

        self._namespace = namespace

    @property
    def docker_registry(self):
        """
        Gets the docker_registry of this ApiInstallControlPlaneArgs.
        The url of the Docker Registry where images required for install are hosted. This fields is deprecated. The docker registry should be provided within the values.yaml configuration file.

        :return: The docker_registry of this ApiInstallControlPlaneArgs.
        :rtype: str
        """
        return self._docker_registry

    @docker_registry.setter
    def docker_registry(self, docker_registry):
        """
        Sets the docker_registry of this ApiInstallControlPlaneArgs.
        The url of the Docker Registry where images required for install are hosted. This fields is deprecated. The docker registry should be provided within the values.yaml configuration file.

        :param docker_registry: The docker_registry of this ApiInstallControlPlaneArgs.
        :type: str
        """

        self._docker_registry = docker_registry

    @property
    def is_override_allowed(self):
        """
        Gets the is_override_allowed of this ApiInstallControlPlaneArgs.
        

        :return: The is_override_allowed of this ApiInstallControlPlaneArgs.
        :rtype: bool
        """
        return self._is_override_allowed

    @is_override_allowed.setter
    def is_override_allowed(self, is_override_allowed):
        """
        Sets the is_override_allowed of this ApiInstallControlPlaneArgs.
        

        :param is_override_allowed: The is_override_allowed of this ApiInstallControlPlaneArgs.
        :type: bool
        """

        self._is_override_allowed = is_override_allowed

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiInstallControlPlaneArgs):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
