# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiHiveReplicationArguments(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'source_service': 'ApiServiceRef',
        'table_filters': 'list[ApiHiveTable]',
        'export_dir': 'str',
        'force': 'bool',
        'replicate_data': 'bool',
        'hdfs_arguments': 'ApiHdfsReplicationArguments',
        'replicate_impala_metadata': 'bool',
        'run_invalidate_metadata': 'bool',
        'dry_run': 'bool',
        'num_threads': 'int',
        'sentry_migration': 'bool',
        'skip_url_permissions': 'bool'
    }

    attribute_map = {
        'source_service': 'sourceService',
        'table_filters': 'tableFilters',
        'export_dir': 'exportDir',
        'force': 'force',
        'replicate_data': 'replicateData',
        'hdfs_arguments': 'hdfsArguments',
        'replicate_impala_metadata': 'replicateImpalaMetadata',
        'run_invalidate_metadata': 'runInvalidateMetadata',
        'dry_run': 'dryRun',
        'num_threads': 'numThreads',
        'sentry_migration': 'sentryMigration',
        'skip_url_permissions': 'skipUrlPermissions'
    }

    def __init__(self, source_service=None, table_filters=None, export_dir=None, force=None, replicate_data=None, hdfs_arguments=None, replicate_impala_metadata=None, run_invalidate_metadata=None, dry_run=None, num_threads=None, sentry_migration=None, skip_url_permissions=None):
        """
        ApiHiveReplicationArguments - a model defined in Swagger
        """

        self._source_service = None
        self._table_filters = None
        self._export_dir = None
        self._force = None
        self._replicate_data = None
        self._hdfs_arguments = None
        self._replicate_impala_metadata = None
        self._run_invalidate_metadata = None
        self._dry_run = None
        self._num_threads = None
        self._sentry_migration = None
        self._skip_url_permissions = None

        if source_service is not None:
          self.source_service = source_service
        if table_filters is not None:
          self.table_filters = table_filters
        if export_dir is not None:
          self.export_dir = export_dir
        if force is not None:
          self.force = force
        if replicate_data is not None:
          self.replicate_data = replicate_data
        if hdfs_arguments is not None:
          self.hdfs_arguments = hdfs_arguments
        if replicate_impala_metadata is not None:
          self.replicate_impala_metadata = replicate_impala_metadata
        if run_invalidate_metadata is not None:
          self.run_invalidate_metadata = run_invalidate_metadata
        if dry_run is not None:
          self.dry_run = dry_run
        if num_threads is not None:
          self.num_threads = num_threads
        self.sentry_migration = sentry_migration
        self.skip_url_permissions = skip_url_permissions

    @property
    def source_service(self):
        """
        Gets the source_service of this ApiHiveReplicationArguments.
        The service to replicate from.

        :return: The source_service of this ApiHiveReplicationArguments.
        :rtype: ApiServiceRef
        """
        return self._source_service

    @source_service.setter
    def source_service(self, source_service):
        """
        Sets the source_service of this ApiHiveReplicationArguments.
        The service to replicate from.

        :param source_service: The source_service of this ApiHiveReplicationArguments.
        :type: ApiServiceRef
        """

        self._source_service = source_service

    @property
    def table_filters(self):
        """
        Gets the table_filters of this ApiHiveReplicationArguments.
        Filters for tables to include in the replication. Optional. If not provided, include all tables in all databases.

        :return: The table_filters of this ApiHiveReplicationArguments.
        :rtype: list[ApiHiveTable]
        """
        return self._table_filters

    @table_filters.setter
    def table_filters(self, table_filters):
        """
        Sets the table_filters of this ApiHiveReplicationArguments.
        Filters for tables to include in the replication. Optional. If not provided, include all tables in all databases.

        :param table_filters: The table_filters of this ApiHiveReplicationArguments.
        :type: list[ApiHiveTable]
        """

        self._table_filters = table_filters

    @property
    def export_dir(self):
        """
        Gets the export_dir of this ApiHiveReplicationArguments.
        Directory, in the HDFS service where the target Hive service's data is stored, where the export file will be saved. Optional. If not provided, Cloudera Manager will pick a directory for storing the data.

        :return: The export_dir of this ApiHiveReplicationArguments.
        :rtype: str
        """
        return self._export_dir

    @export_dir.setter
    def export_dir(self, export_dir):
        """
        Sets the export_dir of this ApiHiveReplicationArguments.
        Directory, in the HDFS service where the target Hive service's data is stored, where the export file will be saved. Optional. If not provided, Cloudera Manager will pick a directory for storing the data.

        :param export_dir: The export_dir of this ApiHiveReplicationArguments.
        :type: str
        """

        self._export_dir = export_dir

    @property
    def force(self):
        """
        Gets the force of this ApiHiveReplicationArguments.
        Whether to force overwriting of mismatched tables. Defaults to false.

        :return: The force of this ApiHiveReplicationArguments.
        :rtype: bool
        """
        return self._force

    @force.setter
    def force(self, force):
        """
        Sets the force of this ApiHiveReplicationArguments.
        Whether to force overwriting of mismatched tables. Defaults to false.

        :param force: The force of this ApiHiveReplicationArguments.
        :type: bool
        """

        self._force = force

    @property
    def replicate_data(self):
        """
        Gets the replicate_data of this ApiHiveReplicationArguments.
        Whether to replicate table data stored in HDFS. Defaults to false. <p/> If set, the \"hdfsArguments\" property must be set to configure the HDFS replication job.

        :return: The replicate_data of this ApiHiveReplicationArguments.
        :rtype: bool
        """
        return self._replicate_data

    @replicate_data.setter
    def replicate_data(self, replicate_data):
        """
        Sets the replicate_data of this ApiHiveReplicationArguments.
        Whether to replicate table data stored in HDFS. Defaults to false. <p/> If set, the \"hdfsArguments\" property must be set to configure the HDFS replication job.

        :param replicate_data: The replicate_data of this ApiHiveReplicationArguments.
        :type: bool
        """

        self._replicate_data = replicate_data

    @property
    def hdfs_arguments(self):
        """
        Gets the hdfs_arguments of this ApiHiveReplicationArguments.
        Arguments for the HDFS replication job. <p/> This must be provided when choosing to replicate table data stored in HDFS. The \"sourceService\", \"sourcePath\" and \"dryRun\" properties of the HDFS arguments are ignored; their values are derived from the Hive replication's information. <p/> The \"destinationPath\" property is used slightly differently from the usual HDFS replication jobs. It is used to map the root path of the source service into the target service. It may be omitted, in which case the source and target paths will match. <p/> Example: if the destination path is set to \"/new_root\", a \"/foo/bar\" path in the source will be stored in \"/new_root/foo/bar\" in the target.

        :return: The hdfs_arguments of this ApiHiveReplicationArguments.
        :rtype: ApiHdfsReplicationArguments
        """
        return self._hdfs_arguments

    @hdfs_arguments.setter
    def hdfs_arguments(self, hdfs_arguments):
        """
        Sets the hdfs_arguments of this ApiHiveReplicationArguments.
        Arguments for the HDFS replication job. <p/> This must be provided when choosing to replicate table data stored in HDFS. The \"sourceService\", \"sourcePath\" and \"dryRun\" properties of the HDFS arguments are ignored; their values are derived from the Hive replication's information. <p/> The \"destinationPath\" property is used slightly differently from the usual HDFS replication jobs. It is used to map the root path of the source service into the target service. It may be omitted, in which case the source and target paths will match. <p/> Example: if the destination path is set to \"/new_root\", a \"/foo/bar\" path in the source will be stored in \"/new_root/foo/bar\" in the target.

        :param hdfs_arguments: The hdfs_arguments of this ApiHiveReplicationArguments.
        :type: ApiHdfsReplicationArguments
        """

        self._hdfs_arguments = hdfs_arguments

    @property
    def replicate_impala_metadata(self):
        """
        Gets the replicate_impala_metadata of this ApiHiveReplicationArguments.
        Whether to replicate the impala metadata. (i.e. the metadata for impala UDFs and their corresponding binaries in HDFS).

        :return: The replicate_impala_metadata of this ApiHiveReplicationArguments.
        :rtype: bool
        """
        return self._replicate_impala_metadata

    @replicate_impala_metadata.setter
    def replicate_impala_metadata(self, replicate_impala_metadata):
        """
        Sets the replicate_impala_metadata of this ApiHiveReplicationArguments.
        Whether to replicate the impala metadata. (i.e. the metadata for impala UDFs and their corresponding binaries in HDFS).

        :param replicate_impala_metadata: The replicate_impala_metadata of this ApiHiveReplicationArguments.
        :type: bool
        """

        self._replicate_impala_metadata = replicate_impala_metadata

    @property
    def run_invalidate_metadata(self):
        """
        Gets the run_invalidate_metadata of this ApiHiveReplicationArguments.
        Whether to run invalidate metadata query or not

        :return: The run_invalidate_metadata of this ApiHiveReplicationArguments.
        :rtype: bool
        """
        return self._run_invalidate_metadata

    @run_invalidate_metadata.setter
    def run_invalidate_metadata(self, run_invalidate_metadata):
        """
        Sets the run_invalidate_metadata of this ApiHiveReplicationArguments.
        Whether to run invalidate metadata query or not

        :param run_invalidate_metadata: The run_invalidate_metadata of this ApiHiveReplicationArguments.
        :type: bool
        """

        self._run_invalidate_metadata = run_invalidate_metadata

    @property
    def dry_run(self):
        """
        Gets the dry_run of this ApiHiveReplicationArguments.
        Whether to perform a dry run. Defaults to false

        :return: The dry_run of this ApiHiveReplicationArguments.
        :rtype: bool
        """
        return self._dry_run

    @dry_run.setter
    def dry_run(self, dry_run):
        """
        Sets the dry_run of this ApiHiveReplicationArguments.
        Whether to perform a dry run. Defaults to false

        :param dry_run: The dry_run of this ApiHiveReplicationArguments.
        :type: bool
        """

        self._dry_run = dry_run

    @property
    def num_threads(self):
        """
        Gets the num_threads of this ApiHiveReplicationArguments.
        Number of threads to use in multi-threaded export/import phase

        :return: The num_threads of this ApiHiveReplicationArguments.
        :rtype: int
        """
        return self._num_threads

    @num_threads.setter
    def num_threads(self, num_threads):
        """
        Sets the num_threads of this ApiHiveReplicationArguments.
        Number of threads to use in multi-threaded export/import phase

        :param num_threads: The num_threads of this ApiHiveReplicationArguments.
        :type: int
        """

        self._num_threads = num_threads

    @property
    def sentry_migration(self):
        """
        Gets the sentry_migration of this ApiHiveReplicationArguments.
        

        :return: The sentry_migration of this ApiHiveReplicationArguments.
        :rtype: bool
        """
        return self._sentry_migration

    @sentry_migration.setter
    def sentry_migration(self, sentry_migration):
        """
        Sets the sentry_migration of this ApiHiveReplicationArguments.
        

        :param sentry_migration: The sentry_migration of this ApiHiveReplicationArguments.
        :type: bool
        """
        if sentry_migration is None:
            raise ValueError("Invalid value for `sentry_migration`, must not be `None`")

        self._sentry_migration = sentry_migration

    @property
    def skip_url_permissions(self):
        """
        Gets the skip_url_permissions of this ApiHiveReplicationArguments.
        Is skipUrlPermissions on.

        :return: The skip_url_permissions of this ApiHiveReplicationArguments.
        :rtype: bool
        """
        return self._skip_url_permissions

    @skip_url_permissions.setter
    def skip_url_permissions(self, skip_url_permissions):
        """
        Sets the skip_url_permissions of this ApiHiveReplicationArguments.
        Is skipUrlPermissions on.

        :param skip_url_permissions: The skip_url_permissions of this ApiHiveReplicationArguments.
        :type: bool
        """
        if skip_url_permissions is None:
            raise ValueError("Invalid value for `skip_url_permissions`, must not be `None`")

        self._skip_url_permissions = skip_url_permissions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiHiveReplicationArguments):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
