# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiHdfsReplicationResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'progress': 'int',
        'throughput': 'float',
        'remaining_time': 'int',
        'estimated_completion_time': 'str',
        'counters': 'list[ApiHdfsReplicationCounter]',
        'num_files_dry_run': 'int',
        'num_bytes_dry_run': 'int',
        'num_files_expected': 'int',
        'num_bytes_expected': 'int',
        'num_files_copied': 'int',
        'num_bytes_copied': 'int',
        'num_files_skipped': 'int',
        'num_bytes_skipped': 'int',
        'num_files_deleted': 'int',
        'num_files_copy_failed': 'int',
        'num_bytes_copy_failed': 'int',
        'setup_error': 'str',
        'job_id': 'str',
        'job_details_uri': 'str',
        'dry_run': 'bool',
        'snapshotted_dirs': 'list[str]',
        'run_as_user': 'str',
        'run_on_source_as_user': 'str',
        'log_path': 'str',
        'failed_files': 'list[str]'
    }

    attribute_map = {
        'progress': 'progress',
        'throughput': 'throughput',
        'remaining_time': 'remainingTime',
        'estimated_completion_time': 'estimatedCompletionTime',
        'counters': 'counters',
        'num_files_dry_run': 'numFilesDryRun',
        'num_bytes_dry_run': 'numBytesDryRun',
        'num_files_expected': 'numFilesExpected',
        'num_bytes_expected': 'numBytesExpected',
        'num_files_copied': 'numFilesCopied',
        'num_bytes_copied': 'numBytesCopied',
        'num_files_skipped': 'numFilesSkipped',
        'num_bytes_skipped': 'numBytesSkipped',
        'num_files_deleted': 'numFilesDeleted',
        'num_files_copy_failed': 'numFilesCopyFailed',
        'num_bytes_copy_failed': 'numBytesCopyFailed',
        'setup_error': 'setupError',
        'job_id': 'jobId',
        'job_details_uri': 'jobDetailsUri',
        'dry_run': 'dryRun',
        'snapshotted_dirs': 'snapshottedDirs',
        'run_as_user': 'runAsUser',
        'run_on_source_as_user': 'runOnSourceAsUser',
        'log_path': 'logPath',
        'failed_files': 'failedFiles'
    }

    def __init__(self, progress=None, throughput=None, remaining_time=None, estimated_completion_time=None, counters=None, num_files_dry_run=None, num_bytes_dry_run=None, num_files_expected=None, num_bytes_expected=None, num_files_copied=None, num_bytes_copied=None, num_files_skipped=None, num_bytes_skipped=None, num_files_deleted=None, num_files_copy_failed=None, num_bytes_copy_failed=None, setup_error=None, job_id=None, job_details_uri=None, dry_run=None, snapshotted_dirs=None, run_as_user=None, run_on_source_as_user=None, log_path=None, failed_files=None):
        """
        ApiHdfsReplicationResult - a model defined in Swagger
        """

        self._progress = None
        self._throughput = None
        self._remaining_time = None
        self._estimated_completion_time = None
        self._counters = None
        self._num_files_dry_run = None
        self._num_bytes_dry_run = None
        self._num_files_expected = None
        self._num_bytes_expected = None
        self._num_files_copied = None
        self._num_bytes_copied = None
        self._num_files_skipped = None
        self._num_bytes_skipped = None
        self._num_files_deleted = None
        self._num_files_copy_failed = None
        self._num_bytes_copy_failed = None
        self._setup_error = None
        self._job_id = None
        self._job_details_uri = None
        self._dry_run = None
        self._snapshotted_dirs = None
        self._run_as_user = None
        self._run_on_source_as_user = None
        self._log_path = None
        self._failed_files = None

        if progress is not None:
          self.progress = progress
        if throughput is not None:
          self.throughput = throughput
        if remaining_time is not None:
          self.remaining_time = remaining_time
        if estimated_completion_time is not None:
          self.estimated_completion_time = estimated_completion_time
        if counters is not None:
          self.counters = counters
        if num_files_dry_run is not None:
          self.num_files_dry_run = num_files_dry_run
        if num_bytes_dry_run is not None:
          self.num_bytes_dry_run = num_bytes_dry_run
        if num_files_expected is not None:
          self.num_files_expected = num_files_expected
        if num_bytes_expected is not None:
          self.num_bytes_expected = num_bytes_expected
        if num_files_copied is not None:
          self.num_files_copied = num_files_copied
        if num_bytes_copied is not None:
          self.num_bytes_copied = num_bytes_copied
        if num_files_skipped is not None:
          self.num_files_skipped = num_files_skipped
        if num_bytes_skipped is not None:
          self.num_bytes_skipped = num_bytes_skipped
        if num_files_deleted is not None:
          self.num_files_deleted = num_files_deleted
        if num_files_copy_failed is not None:
          self.num_files_copy_failed = num_files_copy_failed
        if num_bytes_copy_failed is not None:
          self.num_bytes_copy_failed = num_bytes_copy_failed
        if setup_error is not None:
          self.setup_error = setup_error
        if job_id is not None:
          self.job_id = job_id
        if job_details_uri is not None:
          self.job_details_uri = job_details_uri
        if dry_run is not None:
          self.dry_run = dry_run
        if snapshotted_dirs is not None:
          self.snapshotted_dirs = snapshotted_dirs
        if run_as_user is not None:
          self.run_as_user = run_as_user
        if run_on_source_as_user is not None:
          self.run_on_source_as_user = run_on_source_as_user
        if log_path is not None:
          self.log_path = log_path
        if failed_files is not None:
          self.failed_files = failed_files

    @property
    def progress(self):
        """
        Gets the progress of this ApiHdfsReplicationResult.
        The file copy progress percentage.

        :return: The progress of this ApiHdfsReplicationResult.
        :rtype: int
        """
        return self._progress

    @progress.setter
    def progress(self, progress):
        """
        Sets the progress of this ApiHdfsReplicationResult.
        The file copy progress percentage.

        :param progress: The progress of this ApiHdfsReplicationResult.
        :type: int
        """

        self._progress = progress

    @property
    def throughput(self):
        """
        Gets the throughput of this ApiHdfsReplicationResult.
        The data throughput in KB/s.

        :return: The throughput of this ApiHdfsReplicationResult.
        :rtype: float
        """
        return self._throughput

    @throughput.setter
    def throughput(self, throughput):
        """
        Sets the throughput of this ApiHdfsReplicationResult.
        The data throughput in KB/s.

        :param throughput: The throughput of this ApiHdfsReplicationResult.
        :type: float
        """

        self._throughput = throughput

    @property
    def remaining_time(self):
        """
        Gets the remaining_time of this ApiHdfsReplicationResult.
        The time remaining for mapper phase (seconds).

        :return: The remaining_time of this ApiHdfsReplicationResult.
        :rtype: int
        """
        return self._remaining_time

    @remaining_time.setter
    def remaining_time(self, remaining_time):
        """
        Sets the remaining_time of this ApiHdfsReplicationResult.
        The time remaining for mapper phase (seconds).

        :param remaining_time: The remaining_time of this ApiHdfsReplicationResult.
        :type: int
        """

        self._remaining_time = remaining_time

    @property
    def estimated_completion_time(self):
        """
        Gets the estimated_completion_time of this ApiHdfsReplicationResult.
        The estimated completion time for the mapper phase.

        :return: The estimated_completion_time of this ApiHdfsReplicationResult.
        :rtype: str
        """
        return self._estimated_completion_time

    @estimated_completion_time.setter
    def estimated_completion_time(self, estimated_completion_time):
        """
        Sets the estimated_completion_time of this ApiHdfsReplicationResult.
        The estimated completion time for the mapper phase.

        :param estimated_completion_time: The estimated_completion_time of this ApiHdfsReplicationResult.
        :type: str
        """

        self._estimated_completion_time = estimated_completion_time

    @property
    def counters(self):
        """
        Gets the counters of this ApiHdfsReplicationResult.
        The counters collected from the replication job. <p/> Starting with API v4, the full list of counters is only available in the full view.

        :return: The counters of this ApiHdfsReplicationResult.
        :rtype: list[ApiHdfsReplicationCounter]
        """
        return self._counters

    @counters.setter
    def counters(self, counters):
        """
        Sets the counters of this ApiHdfsReplicationResult.
        The counters collected from the replication job. <p/> Starting with API v4, the full list of counters is only available in the full view.

        :param counters: The counters of this ApiHdfsReplicationResult.
        :type: list[ApiHdfsReplicationCounter]
        """

        self._counters = counters

    @property
    def num_files_dry_run(self):
        """
        Gets the num_files_dry_run of this ApiHdfsReplicationResult.
        The number of files found to copy.

        :return: The num_files_dry_run of this ApiHdfsReplicationResult.
        :rtype: int
        """
        return self._num_files_dry_run

    @num_files_dry_run.setter
    def num_files_dry_run(self, num_files_dry_run):
        """
        Sets the num_files_dry_run of this ApiHdfsReplicationResult.
        The number of files found to copy.

        :param num_files_dry_run: The num_files_dry_run of this ApiHdfsReplicationResult.
        :type: int
        """

        self._num_files_dry_run = num_files_dry_run

    @property
    def num_bytes_dry_run(self):
        """
        Gets the num_bytes_dry_run of this ApiHdfsReplicationResult.
        The number of bytes found to copy.

        :return: The num_bytes_dry_run of this ApiHdfsReplicationResult.
        :rtype: int
        """
        return self._num_bytes_dry_run

    @num_bytes_dry_run.setter
    def num_bytes_dry_run(self, num_bytes_dry_run):
        """
        Sets the num_bytes_dry_run of this ApiHdfsReplicationResult.
        The number of bytes found to copy.

        :param num_bytes_dry_run: The num_bytes_dry_run of this ApiHdfsReplicationResult.
        :type: int
        """

        self._num_bytes_dry_run = num_bytes_dry_run

    @property
    def num_files_expected(self):
        """
        Gets the num_files_expected of this ApiHdfsReplicationResult.
        The number of files expected to be copied.

        :return: The num_files_expected of this ApiHdfsReplicationResult.
        :rtype: int
        """
        return self._num_files_expected

    @num_files_expected.setter
    def num_files_expected(self, num_files_expected):
        """
        Sets the num_files_expected of this ApiHdfsReplicationResult.
        The number of files expected to be copied.

        :param num_files_expected: The num_files_expected of this ApiHdfsReplicationResult.
        :type: int
        """

        self._num_files_expected = num_files_expected

    @property
    def num_bytes_expected(self):
        """
        Gets the num_bytes_expected of this ApiHdfsReplicationResult.
        The number of bytes expected to be copied.

        :return: The num_bytes_expected of this ApiHdfsReplicationResult.
        :rtype: int
        """
        return self._num_bytes_expected

    @num_bytes_expected.setter
    def num_bytes_expected(self, num_bytes_expected):
        """
        Sets the num_bytes_expected of this ApiHdfsReplicationResult.
        The number of bytes expected to be copied.

        :param num_bytes_expected: The num_bytes_expected of this ApiHdfsReplicationResult.
        :type: int
        """

        self._num_bytes_expected = num_bytes_expected

    @property
    def num_files_copied(self):
        """
        Gets the num_files_copied of this ApiHdfsReplicationResult.
        The number of files actually copied.

        :return: The num_files_copied of this ApiHdfsReplicationResult.
        :rtype: int
        """
        return self._num_files_copied

    @num_files_copied.setter
    def num_files_copied(self, num_files_copied):
        """
        Sets the num_files_copied of this ApiHdfsReplicationResult.
        The number of files actually copied.

        :param num_files_copied: The num_files_copied of this ApiHdfsReplicationResult.
        :type: int
        """

        self._num_files_copied = num_files_copied

    @property
    def num_bytes_copied(self):
        """
        Gets the num_bytes_copied of this ApiHdfsReplicationResult.
        The number of bytes actually copied.

        :return: The num_bytes_copied of this ApiHdfsReplicationResult.
        :rtype: int
        """
        return self._num_bytes_copied

    @num_bytes_copied.setter
    def num_bytes_copied(self, num_bytes_copied):
        """
        Sets the num_bytes_copied of this ApiHdfsReplicationResult.
        The number of bytes actually copied.

        :param num_bytes_copied: The num_bytes_copied of this ApiHdfsReplicationResult.
        :type: int
        """

        self._num_bytes_copied = num_bytes_copied

    @property
    def num_files_skipped(self):
        """
        Gets the num_files_skipped of this ApiHdfsReplicationResult.
        The number of files that were unchanged and thus skipped during copying.

        :return: The num_files_skipped of this ApiHdfsReplicationResult.
        :rtype: int
        """
        return self._num_files_skipped

    @num_files_skipped.setter
    def num_files_skipped(self, num_files_skipped):
        """
        Sets the num_files_skipped of this ApiHdfsReplicationResult.
        The number of files that were unchanged and thus skipped during copying.

        :param num_files_skipped: The num_files_skipped of this ApiHdfsReplicationResult.
        :type: int
        """

        self._num_files_skipped = num_files_skipped

    @property
    def num_bytes_skipped(self):
        """
        Gets the num_bytes_skipped of this ApiHdfsReplicationResult.
        The aggregate number of bytes in the skipped files.

        :return: The num_bytes_skipped of this ApiHdfsReplicationResult.
        :rtype: int
        """
        return self._num_bytes_skipped

    @num_bytes_skipped.setter
    def num_bytes_skipped(self, num_bytes_skipped):
        """
        Sets the num_bytes_skipped of this ApiHdfsReplicationResult.
        The aggregate number of bytes in the skipped files.

        :param num_bytes_skipped: The num_bytes_skipped of this ApiHdfsReplicationResult.
        :type: int
        """

        self._num_bytes_skipped = num_bytes_skipped

    @property
    def num_files_deleted(self):
        """
        Gets the num_files_deleted of this ApiHdfsReplicationResult.
        The number of files deleted since they were present at destination, but missing from source.

        :return: The num_files_deleted of this ApiHdfsReplicationResult.
        :rtype: int
        """
        return self._num_files_deleted

    @num_files_deleted.setter
    def num_files_deleted(self, num_files_deleted):
        """
        Sets the num_files_deleted of this ApiHdfsReplicationResult.
        The number of files deleted since they were present at destination, but missing from source.

        :param num_files_deleted: The num_files_deleted of this ApiHdfsReplicationResult.
        :type: int
        """

        self._num_files_deleted = num_files_deleted

    @property
    def num_files_copy_failed(self):
        """
        Gets the num_files_copy_failed of this ApiHdfsReplicationResult.
        The number of files for which copy failed.

        :return: The num_files_copy_failed of this ApiHdfsReplicationResult.
        :rtype: int
        """
        return self._num_files_copy_failed

    @num_files_copy_failed.setter
    def num_files_copy_failed(self, num_files_copy_failed):
        """
        Sets the num_files_copy_failed of this ApiHdfsReplicationResult.
        The number of files for which copy failed.

        :param num_files_copy_failed: The num_files_copy_failed of this ApiHdfsReplicationResult.
        :type: int
        """

        self._num_files_copy_failed = num_files_copy_failed

    @property
    def num_bytes_copy_failed(self):
        """
        Gets the num_bytes_copy_failed of this ApiHdfsReplicationResult.
        The aggregate number of bytes in the files for which copy failed.

        :return: The num_bytes_copy_failed of this ApiHdfsReplicationResult.
        :rtype: int
        """
        return self._num_bytes_copy_failed

    @num_bytes_copy_failed.setter
    def num_bytes_copy_failed(self, num_bytes_copy_failed):
        """
        Sets the num_bytes_copy_failed of this ApiHdfsReplicationResult.
        The aggregate number of bytes in the files for which copy failed.

        :param num_bytes_copy_failed: The num_bytes_copy_failed of this ApiHdfsReplicationResult.
        :type: int
        """

        self._num_bytes_copy_failed = num_bytes_copy_failed

    @property
    def setup_error(self):
        """
        Gets the setup_error of this ApiHdfsReplicationResult.
        The error that happened during job setup, if any.

        :return: The setup_error of this ApiHdfsReplicationResult.
        :rtype: str
        """
        return self._setup_error

    @setup_error.setter
    def setup_error(self, setup_error):
        """
        Sets the setup_error of this ApiHdfsReplicationResult.
        The error that happened during job setup, if any.

        :param setup_error: The setup_error of this ApiHdfsReplicationResult.
        :type: str
        """

        self._setup_error = setup_error

    @property
    def job_id(self):
        """
        Gets the job_id of this ApiHdfsReplicationResult.
        Read-only. The MapReduce job ID for the replication job. Available since API v4. <p/> This can be used to query information about the replication job from the MapReduce server where it was executed. Refer to the \"/activities\" resource for services for further details.

        :return: The job_id of this ApiHdfsReplicationResult.
        :rtype: str
        """
        return self._job_id

    @job_id.setter
    def job_id(self, job_id):
        """
        Sets the job_id of this ApiHdfsReplicationResult.
        Read-only. The MapReduce job ID for the replication job. Available since API v4. <p/> This can be used to query information about the replication job from the MapReduce server where it was executed. Refer to the \"/activities\" resource for services for further details.

        :param job_id: The job_id of this ApiHdfsReplicationResult.
        :type: str
        """

        self._job_id = job_id

    @property
    def job_details_uri(self):
        """
        Gets the job_details_uri of this ApiHdfsReplicationResult.
        Read-only. The URI (relative to the CM server's root) where to find the Activity Monitor page for the job. Available since API v4.

        :return: The job_details_uri of this ApiHdfsReplicationResult.
        :rtype: str
        """
        return self._job_details_uri

    @job_details_uri.setter
    def job_details_uri(self, job_details_uri):
        """
        Sets the job_details_uri of this ApiHdfsReplicationResult.
        Read-only. The URI (relative to the CM server's root) where to find the Activity Monitor page for the job. Available since API v4.

        :param job_details_uri: The job_details_uri of this ApiHdfsReplicationResult.
        :type: str
        """

        self._job_details_uri = job_details_uri

    @property
    def dry_run(self):
        """
        Gets the dry_run of this ApiHdfsReplicationResult.
        Whether this was a dry run.

        :return: The dry_run of this ApiHdfsReplicationResult.
        :rtype: bool
        """
        return self._dry_run

    @dry_run.setter
    def dry_run(self, dry_run):
        """
        Sets the dry_run of this ApiHdfsReplicationResult.
        Whether this was a dry run.

        :param dry_run: The dry_run of this ApiHdfsReplicationResult.
        :type: bool
        """

        self._dry_run = dry_run

    @property
    def snapshotted_dirs(self):
        """
        Gets the snapshotted_dirs of this ApiHdfsReplicationResult.
        The list of directories for which snapshots were taken and used as part of this replication.

        :return: The snapshotted_dirs of this ApiHdfsReplicationResult.
        :rtype: list[str]
        """
        return self._snapshotted_dirs

    @snapshotted_dirs.setter
    def snapshotted_dirs(self, snapshotted_dirs):
        """
        Sets the snapshotted_dirs of this ApiHdfsReplicationResult.
        The list of directories for which snapshots were taken and used as part of this replication.

        :param snapshotted_dirs: The snapshotted_dirs of this ApiHdfsReplicationResult.
        :type: list[str]
        """

        self._snapshotted_dirs = snapshotted_dirs

    @property
    def run_as_user(self):
        """
        Gets the run_as_user of this ApiHdfsReplicationResult.
        Returns run-as user name. Available since API v11.

        :return: The run_as_user of this ApiHdfsReplicationResult.
        :rtype: str
        """
        return self._run_as_user

    @run_as_user.setter
    def run_as_user(self, run_as_user):
        """
        Sets the run_as_user of this ApiHdfsReplicationResult.
        Returns run-as user name. Available since API v11.

        :param run_as_user: The run_as_user of this ApiHdfsReplicationResult.
        :type: str
        """

        self._run_as_user = run_as_user

    @property
    def run_on_source_as_user(self):
        """
        Gets the run_on_source_as_user of this ApiHdfsReplicationResult.
        Returns run-as user name for source cluster. Available since API v18.

        :return: The run_on_source_as_user of this ApiHdfsReplicationResult.
        :rtype: str
        """
        return self._run_on_source_as_user

    @run_on_source_as_user.setter
    def run_on_source_as_user(self, run_on_source_as_user):
        """
        Sets the run_on_source_as_user of this ApiHdfsReplicationResult.
        Returns run-as user name for source cluster. Available since API v18.

        :param run_on_source_as_user: The run_on_source_as_user of this ApiHdfsReplicationResult.
        :type: str
        """

        self._run_on_source_as_user = run_on_source_as_user

    @property
    def log_path(self):
        """
        Gets the log_path of this ApiHdfsReplicationResult.
        Returns HDFS path of DistCp execution log files. Available since API v33.

        :return: The log_path of this ApiHdfsReplicationResult.
        :rtype: str
        """
        return self._log_path

    @log_path.setter
    def log_path(self, log_path):
        """
        Sets the log_path of this ApiHdfsReplicationResult.
        Returns HDFS path of DistCp execution log files. Available since API v33.

        :param log_path: The log_path of this ApiHdfsReplicationResult.
        :type: str
        """

        self._log_path = log_path

    @property
    def failed_files(self):
        """
        Gets the failed_files of this ApiHdfsReplicationResult.
        The list of files that failed during replication. Available since API v11.

        :return: The failed_files of this ApiHdfsReplicationResult.
        :rtype: list[str]
        """
        return self._failed_files

    @failed_files.setter
    def failed_files(self, failed_files):
        """
        Sets the failed_files of this ApiHdfsReplicationResult.
        The list of files that failed during replication. Available since API v11.

        :param failed_files: The failed_files of this ApiHdfsReplicationResult.
        :type: list[str]
        """

        self._failed_files = failed_files

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiHdfsReplicationResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
