# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiHdfsReplicationArguments(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'source_service': 'ApiServiceRef',
        'source_path': 'str',
        'destination_path': 'str',
        'mapreduce_service_name': 'str',
        'scheduler_pool_name': 'str',
        'user_name': 'str',
        'source_user': 'str',
        'num_maps': 'int',
        'dry_run': 'bool',
        'bandwidth_per_map': 'int',
        'abort_on_error': 'bool',
        'remove_missing_files': 'bool',
        'preserve_replication_count': 'bool',
        'preserve_block_size': 'bool',
        'preserve_permissions': 'bool',
        'log_path': 'str',
        'skip_checksum_checks': 'bool',
        'skip_listing_checksum_checks': 'bool',
        'skip_trash': 'bool',
        'replication_strategy': 'ReplicationStrategy',
        'preserve_x_attrs': 'bool',
        'exclusion_filters': 'list[str]',
        'raise_snapshot_diff_failures': 'bool',
        'destination_cloud_account': 'str'
    }

    attribute_map = {
        'source_service': 'sourceService',
        'source_path': 'sourcePath',
        'destination_path': 'destinationPath',
        'mapreduce_service_name': 'mapreduceServiceName',
        'scheduler_pool_name': 'schedulerPoolName',
        'user_name': 'userName',
        'source_user': 'sourceUser',
        'num_maps': 'numMaps',
        'dry_run': 'dryRun',
        'bandwidth_per_map': 'bandwidthPerMap',
        'abort_on_error': 'abortOnError',
        'remove_missing_files': 'removeMissingFiles',
        'preserve_replication_count': 'preserveReplicationCount',
        'preserve_block_size': 'preserveBlockSize',
        'preserve_permissions': 'preservePermissions',
        'log_path': 'logPath',
        'skip_checksum_checks': 'skipChecksumChecks',
        'skip_listing_checksum_checks': 'skipListingChecksumChecks',
        'skip_trash': 'skipTrash',
        'replication_strategy': 'replicationStrategy',
        'preserve_x_attrs': 'preserveXAttrs',
        'exclusion_filters': 'exclusionFilters',
        'raise_snapshot_diff_failures': 'raiseSnapshotDiffFailures',
        'destination_cloud_account': 'destinationCloudAccount'
    }

    def __init__(self, source_service=None, source_path=None, destination_path=None, mapreduce_service_name=None, scheduler_pool_name=None, user_name=None, source_user=None, num_maps=None, dry_run=None, bandwidth_per_map=None, abort_on_error=None, remove_missing_files=None, preserve_replication_count=None, preserve_block_size=None, preserve_permissions=None, log_path=None, skip_checksum_checks=None, skip_listing_checksum_checks=None, skip_trash=None, replication_strategy=None, preserve_x_attrs=None, exclusion_filters=None, raise_snapshot_diff_failures=None, destination_cloud_account=None):
        """
        ApiHdfsReplicationArguments - a model defined in Swagger
        """

        self._source_service = None
        self._source_path = None
        self._destination_path = None
        self._mapreduce_service_name = None
        self._scheduler_pool_name = None
        self._user_name = None
        self._source_user = None
        self._num_maps = None
        self._dry_run = None
        self._bandwidth_per_map = None
        self._abort_on_error = None
        self._remove_missing_files = None
        self._preserve_replication_count = None
        self._preserve_block_size = None
        self._preserve_permissions = None
        self._log_path = None
        self._skip_checksum_checks = None
        self._skip_listing_checksum_checks = None
        self._skip_trash = None
        self._replication_strategy = None
        self._preserve_x_attrs = None
        self._exclusion_filters = None
        self._raise_snapshot_diff_failures = None
        self._destination_cloud_account = None

        if source_service is not None:
          self.source_service = source_service
        if source_path is not None:
          self.source_path = source_path
        if destination_path is not None:
          self.destination_path = destination_path
        if mapreduce_service_name is not None:
          self.mapreduce_service_name = mapreduce_service_name
        if scheduler_pool_name is not None:
          self.scheduler_pool_name = scheduler_pool_name
        if user_name is not None:
          self.user_name = user_name
        if source_user is not None:
          self.source_user = source_user
        if num_maps is not None:
          self.num_maps = num_maps
        if dry_run is not None:
          self.dry_run = dry_run
        if bandwidth_per_map is not None:
          self.bandwidth_per_map = bandwidth_per_map
        if abort_on_error is not None:
          self.abort_on_error = abort_on_error
        if remove_missing_files is not None:
          self.remove_missing_files = remove_missing_files
        if preserve_replication_count is not None:
          self.preserve_replication_count = preserve_replication_count
        if preserve_block_size is not None:
          self.preserve_block_size = preserve_block_size
        if preserve_permissions is not None:
          self.preserve_permissions = preserve_permissions
        if log_path is not None:
          self.log_path = log_path
        if skip_checksum_checks is not None:
          self.skip_checksum_checks = skip_checksum_checks
        if skip_listing_checksum_checks is not None:
          self.skip_listing_checksum_checks = skip_listing_checksum_checks
        if skip_trash is not None:
          self.skip_trash = skip_trash
        if replication_strategy is not None:
          self.replication_strategy = replication_strategy
        if preserve_x_attrs is not None:
          self.preserve_x_attrs = preserve_x_attrs
        if exclusion_filters is not None:
          self.exclusion_filters = exclusion_filters
        if raise_snapshot_diff_failures is not None:
          self.raise_snapshot_diff_failures = raise_snapshot_diff_failures
        if destination_cloud_account is not None:
          self.destination_cloud_account = destination_cloud_account

    @property
    def source_service(self):
        """
        Gets the source_service of this ApiHdfsReplicationArguments.
        The service to replicate from.

        :return: The source_service of this ApiHdfsReplicationArguments.
        :rtype: ApiServiceRef
        """
        return self._source_service

    @source_service.setter
    def source_service(self, source_service):
        """
        Sets the source_service of this ApiHdfsReplicationArguments.
        The service to replicate from.

        :param source_service: The source_service of this ApiHdfsReplicationArguments.
        :type: ApiServiceRef
        """

        self._source_service = source_service

    @property
    def source_path(self):
        """
        Gets the source_path of this ApiHdfsReplicationArguments.
        The path to replicate.

        :return: The source_path of this ApiHdfsReplicationArguments.
        :rtype: str
        """
        return self._source_path

    @source_path.setter
    def source_path(self, source_path):
        """
        Sets the source_path of this ApiHdfsReplicationArguments.
        The path to replicate.

        :param source_path: The source_path of this ApiHdfsReplicationArguments.
        :type: str
        """

        self._source_path = source_path

    @property
    def destination_path(self):
        """
        Gets the destination_path of this ApiHdfsReplicationArguments.
        The destination to replicate to.

        :return: The destination_path of this ApiHdfsReplicationArguments.
        :rtype: str
        """
        return self._destination_path

    @destination_path.setter
    def destination_path(self, destination_path):
        """
        Sets the destination_path of this ApiHdfsReplicationArguments.
        The destination to replicate to.

        :param destination_path: The destination_path of this ApiHdfsReplicationArguments.
        :type: str
        """

        self._destination_path = destination_path

    @property
    def mapreduce_service_name(self):
        """
        Gets the mapreduce_service_name of this ApiHdfsReplicationArguments.
        The mapreduce service to use for the replication job.

        :return: The mapreduce_service_name of this ApiHdfsReplicationArguments.
        :rtype: str
        """
        return self._mapreduce_service_name

    @mapreduce_service_name.setter
    def mapreduce_service_name(self, mapreduce_service_name):
        """
        Sets the mapreduce_service_name of this ApiHdfsReplicationArguments.
        The mapreduce service to use for the replication job.

        :param mapreduce_service_name: The mapreduce_service_name of this ApiHdfsReplicationArguments.
        :type: str
        """

        self._mapreduce_service_name = mapreduce_service_name

    @property
    def scheduler_pool_name(self):
        """
        Gets the scheduler_pool_name of this ApiHdfsReplicationArguments.
        Name of the scheduler pool to use when submitting the MapReduce job. Currently supports the capacity and fair schedulers. The option is ignored if a different scheduler is configured.

        :return: The scheduler_pool_name of this ApiHdfsReplicationArguments.
        :rtype: str
        """
        return self._scheduler_pool_name

    @scheduler_pool_name.setter
    def scheduler_pool_name(self, scheduler_pool_name):
        """
        Sets the scheduler_pool_name of this ApiHdfsReplicationArguments.
        Name of the scheduler pool to use when submitting the MapReduce job. Currently supports the capacity and fair schedulers. The option is ignored if a different scheduler is configured.

        :param scheduler_pool_name: The scheduler_pool_name of this ApiHdfsReplicationArguments.
        :type: str
        """

        self._scheduler_pool_name = scheduler_pool_name

    @property
    def user_name(self):
        """
        Gets the user_name of this ApiHdfsReplicationArguments.
        The user which will execute the MapReduce job. Required if running with Kerberos enabled.

        :return: The user_name of this ApiHdfsReplicationArguments.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """
        Sets the user_name of this ApiHdfsReplicationArguments.
        The user which will execute the MapReduce job. Required if running with Kerberos enabled.

        :param user_name: The user_name of this ApiHdfsReplicationArguments.
        :type: str
        """

        self._user_name = user_name

    @property
    def source_user(self):
        """
        Gets the source_user of this ApiHdfsReplicationArguments.
        The user which will perform operations on source cluster. Required if running with Kerberos enabled.

        :return: The source_user of this ApiHdfsReplicationArguments.
        :rtype: str
        """
        return self._source_user

    @source_user.setter
    def source_user(self, source_user):
        """
        Sets the source_user of this ApiHdfsReplicationArguments.
        The user which will perform operations on source cluster. Required if running with Kerberos enabled.

        :param source_user: The source_user of this ApiHdfsReplicationArguments.
        :type: str
        """

        self._source_user = source_user

    @property
    def num_maps(self):
        """
        Gets the num_maps of this ApiHdfsReplicationArguments.
        The number of mappers to use for the mapreduce replication job.

        :return: The num_maps of this ApiHdfsReplicationArguments.
        :rtype: int
        """
        return self._num_maps

    @num_maps.setter
    def num_maps(self, num_maps):
        """
        Sets the num_maps of this ApiHdfsReplicationArguments.
        The number of mappers to use for the mapreduce replication job.

        :param num_maps: The num_maps of this ApiHdfsReplicationArguments.
        :type: int
        """

        self._num_maps = num_maps

    @property
    def dry_run(self):
        """
        Gets the dry_run of this ApiHdfsReplicationArguments.
        Whether to perform a dry run. Defaults to false.

        :return: The dry_run of this ApiHdfsReplicationArguments.
        :rtype: bool
        """
        return self._dry_run

    @dry_run.setter
    def dry_run(self, dry_run):
        """
        Sets the dry_run of this ApiHdfsReplicationArguments.
        Whether to perform a dry run. Defaults to false.

        :param dry_run: The dry_run of this ApiHdfsReplicationArguments.
        :type: bool
        """

        self._dry_run = dry_run

    @property
    def bandwidth_per_map(self):
        """
        Gets the bandwidth_per_map of this ApiHdfsReplicationArguments.
        The maximum bandwidth (in MB) per mapper in the mapreduce replication job.

        :return: The bandwidth_per_map of this ApiHdfsReplicationArguments.
        :rtype: int
        """
        return self._bandwidth_per_map

    @bandwidth_per_map.setter
    def bandwidth_per_map(self, bandwidth_per_map):
        """
        Sets the bandwidth_per_map of this ApiHdfsReplicationArguments.
        The maximum bandwidth (in MB) per mapper in the mapreduce replication job.

        :param bandwidth_per_map: The bandwidth_per_map of this ApiHdfsReplicationArguments.
        :type: int
        """

        self._bandwidth_per_map = bandwidth_per_map

    @property
    def abort_on_error(self):
        """
        Gets the abort_on_error of this ApiHdfsReplicationArguments.
        Whether to abort on a replication failure. Defaults to false.

        :return: The abort_on_error of this ApiHdfsReplicationArguments.
        :rtype: bool
        """
        return self._abort_on_error

    @abort_on_error.setter
    def abort_on_error(self, abort_on_error):
        """
        Sets the abort_on_error of this ApiHdfsReplicationArguments.
        Whether to abort on a replication failure. Defaults to false.

        :param abort_on_error: The abort_on_error of this ApiHdfsReplicationArguments.
        :type: bool
        """

        self._abort_on_error = abort_on_error

    @property
    def remove_missing_files(self):
        """
        Gets the remove_missing_files of this ApiHdfsReplicationArguments.
        Whether to delete destination files that are missing in source. Defaults to false.

        :return: The remove_missing_files of this ApiHdfsReplicationArguments.
        :rtype: bool
        """
        return self._remove_missing_files

    @remove_missing_files.setter
    def remove_missing_files(self, remove_missing_files):
        """
        Sets the remove_missing_files of this ApiHdfsReplicationArguments.
        Whether to delete destination files that are missing in source. Defaults to false.

        :param remove_missing_files: The remove_missing_files of this ApiHdfsReplicationArguments.
        :type: bool
        """

        self._remove_missing_files = remove_missing_files

    @property
    def preserve_replication_count(self):
        """
        Gets the preserve_replication_count of this ApiHdfsReplicationArguments.
        Whether to preserve the HDFS replication count. Defaults to false.

        :return: The preserve_replication_count of this ApiHdfsReplicationArguments.
        :rtype: bool
        """
        return self._preserve_replication_count

    @preserve_replication_count.setter
    def preserve_replication_count(self, preserve_replication_count):
        """
        Sets the preserve_replication_count of this ApiHdfsReplicationArguments.
        Whether to preserve the HDFS replication count. Defaults to false.

        :param preserve_replication_count: The preserve_replication_count of this ApiHdfsReplicationArguments.
        :type: bool
        """

        self._preserve_replication_count = preserve_replication_count

    @property
    def preserve_block_size(self):
        """
        Gets the preserve_block_size of this ApiHdfsReplicationArguments.
        Whether to preserve the HDFS block size. Defaults to false.

        :return: The preserve_block_size of this ApiHdfsReplicationArguments.
        :rtype: bool
        """
        return self._preserve_block_size

    @preserve_block_size.setter
    def preserve_block_size(self, preserve_block_size):
        """
        Sets the preserve_block_size of this ApiHdfsReplicationArguments.
        Whether to preserve the HDFS block size. Defaults to false.

        :param preserve_block_size: The preserve_block_size of this ApiHdfsReplicationArguments.
        :type: bool
        """

        self._preserve_block_size = preserve_block_size

    @property
    def preserve_permissions(self):
        """
        Gets the preserve_permissions of this ApiHdfsReplicationArguments.
        Whether to preserve the HDFS owner, group and permissions. Defaults to false. Starting from V10, it also preserves ACLs. Defaults to null (no preserve). ACLs is preserved if both clusters enable ACL support, and replication ignores any ACL related failures.

        :return: The preserve_permissions of this ApiHdfsReplicationArguments.
        :rtype: bool
        """
        return self._preserve_permissions

    @preserve_permissions.setter
    def preserve_permissions(self, preserve_permissions):
        """
        Sets the preserve_permissions of this ApiHdfsReplicationArguments.
        Whether to preserve the HDFS owner, group and permissions. Defaults to false. Starting from V10, it also preserves ACLs. Defaults to null (no preserve). ACLs is preserved if both clusters enable ACL support, and replication ignores any ACL related failures.

        :param preserve_permissions: The preserve_permissions of this ApiHdfsReplicationArguments.
        :type: bool
        """

        self._preserve_permissions = preserve_permissions

    @property
    def log_path(self):
        """
        Gets the log_path of this ApiHdfsReplicationArguments.
        The HDFS path where the replication log files should be written to.

        :return: The log_path of this ApiHdfsReplicationArguments.
        :rtype: str
        """
        return self._log_path

    @log_path.setter
    def log_path(self, log_path):
        """
        Sets the log_path of this ApiHdfsReplicationArguments.
        The HDFS path where the replication log files should be written to.

        :param log_path: The log_path of this ApiHdfsReplicationArguments.
        :type: str
        """

        self._log_path = log_path

    @property
    def skip_checksum_checks(self):
        """
        Gets the skip_checksum_checks of this ApiHdfsReplicationArguments.
        Whether to skip checksum based file validation during replication. Defaults to false.

        :return: The skip_checksum_checks of this ApiHdfsReplicationArguments.
        :rtype: bool
        """
        return self._skip_checksum_checks

    @skip_checksum_checks.setter
    def skip_checksum_checks(self, skip_checksum_checks):
        """
        Sets the skip_checksum_checks of this ApiHdfsReplicationArguments.
        Whether to skip checksum based file validation during replication. Defaults to false.

        :param skip_checksum_checks: The skip_checksum_checks of this ApiHdfsReplicationArguments.
        :type: bool
        """

        self._skip_checksum_checks = skip_checksum_checks

    @property
    def skip_listing_checksum_checks(self):
        """
        Gets the skip_listing_checksum_checks of this ApiHdfsReplicationArguments.
        Whether to skip checksum based file comparison during replication. Defaults to false.

        :return: The skip_listing_checksum_checks of this ApiHdfsReplicationArguments.
        :rtype: bool
        """
        return self._skip_listing_checksum_checks

    @skip_listing_checksum_checks.setter
    def skip_listing_checksum_checks(self, skip_listing_checksum_checks):
        """
        Sets the skip_listing_checksum_checks of this ApiHdfsReplicationArguments.
        Whether to skip checksum based file comparison during replication. Defaults to false.

        :param skip_listing_checksum_checks: The skip_listing_checksum_checks of this ApiHdfsReplicationArguments.
        :type: bool
        """

        self._skip_listing_checksum_checks = skip_listing_checksum_checks

    @property
    def skip_trash(self):
        """
        Gets the skip_trash of this ApiHdfsReplicationArguments.
        Whether to permanently delete destination files that are missing in source. Defaults to null.

        :return: The skip_trash of this ApiHdfsReplicationArguments.
        :rtype: bool
        """
        return self._skip_trash

    @skip_trash.setter
    def skip_trash(self, skip_trash):
        """
        Sets the skip_trash of this ApiHdfsReplicationArguments.
        Whether to permanently delete destination files that are missing in source. Defaults to null.

        :param skip_trash: The skip_trash of this ApiHdfsReplicationArguments.
        :type: bool
        """

        self._skip_trash = skip_trash

    @property
    def replication_strategy(self):
        """
        Gets the replication_strategy of this ApiHdfsReplicationArguments.
        The strategy for distributing the file replication tasks among the mappers of the MR job associated with a replication. Default is ReplicationStrategy#STATIC.

        :return: The replication_strategy of this ApiHdfsReplicationArguments.
        :rtype: ReplicationStrategy
        """
        return self._replication_strategy

    @replication_strategy.setter
    def replication_strategy(self, replication_strategy):
        """
        Sets the replication_strategy of this ApiHdfsReplicationArguments.
        The strategy for distributing the file replication tasks among the mappers of the MR job associated with a replication. Default is ReplicationStrategy#STATIC.

        :param replication_strategy: The replication_strategy of this ApiHdfsReplicationArguments.
        :type: ReplicationStrategy
        """

        self._replication_strategy = replication_strategy

    @property
    def preserve_x_attrs(self):
        """
        Gets the preserve_x_attrs of this ApiHdfsReplicationArguments.
        Whether to preserve XAttrs, default to false This is introduced in V10. To preserve XAttrs, both CDH versions should be >= 5.2. Replication fails if either cluster does not support XAttrs.

        :return: The preserve_x_attrs of this ApiHdfsReplicationArguments.
        :rtype: bool
        """
        return self._preserve_x_attrs

    @preserve_x_attrs.setter
    def preserve_x_attrs(self, preserve_x_attrs):
        """
        Sets the preserve_x_attrs of this ApiHdfsReplicationArguments.
        Whether to preserve XAttrs, default to false This is introduced in V10. To preserve XAttrs, both CDH versions should be >= 5.2. Replication fails if either cluster does not support XAttrs.

        :param preserve_x_attrs: The preserve_x_attrs of this ApiHdfsReplicationArguments.
        :type: bool
        """

        self._preserve_x_attrs = preserve_x_attrs

    @property
    def exclusion_filters(self):
        """
        Gets the exclusion_filters of this ApiHdfsReplicationArguments.
        Specify regular expression strings to match full paths of files and directories matching source paths and exclude them from the replication. Optional. Available since V11.

        :return: The exclusion_filters of this ApiHdfsReplicationArguments.
        :rtype: list[str]
        """
        return self._exclusion_filters

    @exclusion_filters.setter
    def exclusion_filters(self, exclusion_filters):
        """
        Sets the exclusion_filters of this ApiHdfsReplicationArguments.
        Specify regular expression strings to match full paths of files and directories matching source paths and exclude them from the replication. Optional. Available since V11.

        :param exclusion_filters: The exclusion_filters of this ApiHdfsReplicationArguments.
        :type: list[str]
        """

        self._exclusion_filters = exclusion_filters

    @property
    def raise_snapshot_diff_failures(self):
        """
        Gets the raise_snapshot_diff_failures of this ApiHdfsReplicationArguments.
        Flag indicating if failures during snapshotDiff should be ignored or not. When it is set to false then, replication will fallback to full copy listing in case of any error in snapshot diff handling and it will ignore snapshot delete/rename failures at the end of a replication. The flag is by default set to false in distcp tool which means it will ignore snapshot diff failures and mark replication as success for snapshot delete/rename failures. In UI, the flag is set to true by default when source CM Version is greater than 5.14.

        :return: The raise_snapshot_diff_failures of this ApiHdfsReplicationArguments.
        :rtype: bool
        """
        return self._raise_snapshot_diff_failures

    @raise_snapshot_diff_failures.setter
    def raise_snapshot_diff_failures(self, raise_snapshot_diff_failures):
        """
        Sets the raise_snapshot_diff_failures of this ApiHdfsReplicationArguments.
        Flag indicating if failures during snapshotDiff should be ignored or not. When it is set to false then, replication will fallback to full copy listing in case of any error in snapshot diff handling and it will ignore snapshot delete/rename failures at the end of a replication. The flag is by default set to false in distcp tool which means it will ignore snapshot diff failures and mark replication as success for snapshot delete/rename failures. In UI, the flag is set to true by default when source CM Version is greater than 5.14.

        :param raise_snapshot_diff_failures: The raise_snapshot_diff_failures of this ApiHdfsReplicationArguments.
        :type: bool
        """

        self._raise_snapshot_diff_failures = raise_snapshot_diff_failures

    @property
    def destination_cloud_account(self):
        """
        Gets the destination_cloud_account of this ApiHdfsReplicationArguments.
        The cloud account name which is used in direct hive cloud replication, if specified.

        :return: The destination_cloud_account of this ApiHdfsReplicationArguments.
        :rtype: str
        """
        return self._destination_cloud_account

    @destination_cloud_account.setter
    def destination_cloud_account(self, destination_cloud_account):
        """
        Sets the destination_cloud_account of this ApiHdfsReplicationArguments.
        The cloud account name which is used in direct hive cloud replication, if specified.

        :param destination_cloud_account: The destination_cloud_account of this ApiHdfsReplicationArguments.
        :type: str
        """

        self._destination_cloud_account = destination_cloud_account

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiHdfsReplicationArguments):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
