# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiHBaseSnapshotResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'processed_table_count': 'int',
        'processed_tables': 'list[str]',
        'unprocessed_table_count': 'int',
        'unprocessed_tables': 'list[str]',
        'created_snapshot_count': 'int',
        'created_snapshots': 'list[ApiHBaseSnapshot]',
        'deleted_snapshot_count': 'int',
        'deleted_snapshots': 'list[ApiHBaseSnapshot]',
        'creation_error_count': 'int',
        'creation_errors': 'list[ApiHBaseSnapshotError]',
        'deletion_error_count': 'int',
        'deletion_errors': 'list[ApiHBaseSnapshotError]'
    }

    attribute_map = {
        'processed_table_count': 'processedTableCount',
        'processed_tables': 'processedTables',
        'unprocessed_table_count': 'unprocessedTableCount',
        'unprocessed_tables': 'unprocessedTables',
        'created_snapshot_count': 'createdSnapshotCount',
        'created_snapshots': 'createdSnapshots',
        'deleted_snapshot_count': 'deletedSnapshotCount',
        'deleted_snapshots': 'deletedSnapshots',
        'creation_error_count': 'creationErrorCount',
        'creation_errors': 'creationErrors',
        'deletion_error_count': 'deletionErrorCount',
        'deletion_errors': 'deletionErrors'
    }

    def __init__(self, processed_table_count=None, processed_tables=None, unprocessed_table_count=None, unprocessed_tables=None, created_snapshot_count=None, created_snapshots=None, deleted_snapshot_count=None, deleted_snapshots=None, creation_error_count=None, creation_errors=None, deletion_error_count=None, deletion_errors=None):
        """
        ApiHBaseSnapshotResult - a model defined in Swagger
        """

        self._processed_table_count = None
        self._processed_tables = None
        self._unprocessed_table_count = None
        self._unprocessed_tables = None
        self._created_snapshot_count = None
        self._created_snapshots = None
        self._deleted_snapshot_count = None
        self._deleted_snapshots = None
        self._creation_error_count = None
        self._creation_errors = None
        self._deletion_error_count = None
        self._deletion_errors = None

        if processed_table_count is not None:
          self.processed_table_count = processed_table_count
        if processed_tables is not None:
          self.processed_tables = processed_tables
        if unprocessed_table_count is not None:
          self.unprocessed_table_count = unprocessed_table_count
        if unprocessed_tables is not None:
          self.unprocessed_tables = unprocessed_tables
        if created_snapshot_count is not None:
          self.created_snapshot_count = created_snapshot_count
        if created_snapshots is not None:
          self.created_snapshots = created_snapshots
        if deleted_snapshot_count is not None:
          self.deleted_snapshot_count = deleted_snapshot_count
        if deleted_snapshots is not None:
          self.deleted_snapshots = deleted_snapshots
        if creation_error_count is not None:
          self.creation_error_count = creation_error_count
        if creation_errors is not None:
          self.creation_errors = creation_errors
        if deletion_error_count is not None:
          self.deletion_error_count = deletion_error_count
        if deletion_errors is not None:
          self.deletion_errors = deletion_errors

    @property
    def processed_table_count(self):
        """
        Gets the processed_table_count of this ApiHBaseSnapshotResult.
        Number of processed tables.

        :return: The processed_table_count of this ApiHBaseSnapshotResult.
        :rtype: int
        """
        return self._processed_table_count

    @processed_table_count.setter
    def processed_table_count(self, processed_table_count):
        """
        Sets the processed_table_count of this ApiHBaseSnapshotResult.
        Number of processed tables.

        :param processed_table_count: The processed_table_count of this ApiHBaseSnapshotResult.
        :type: int
        """

        self._processed_table_count = processed_table_count

    @property
    def processed_tables(self):
        """
        Gets the processed_tables of this ApiHBaseSnapshotResult.
        The list of processed tables. <p/> This is only available in the full view.

        :return: The processed_tables of this ApiHBaseSnapshotResult.
        :rtype: list[str]
        """
        return self._processed_tables

    @processed_tables.setter
    def processed_tables(self, processed_tables):
        """
        Sets the processed_tables of this ApiHBaseSnapshotResult.
        The list of processed tables. <p/> This is only available in the full view.

        :param processed_tables: The processed_tables of this ApiHBaseSnapshotResult.
        :type: list[str]
        """

        self._processed_tables = processed_tables

    @property
    def unprocessed_table_count(self):
        """
        Gets the unprocessed_table_count of this ApiHBaseSnapshotResult.
        Number of unprocessed tables.

        :return: The unprocessed_table_count of this ApiHBaseSnapshotResult.
        :rtype: int
        """
        return self._unprocessed_table_count

    @unprocessed_table_count.setter
    def unprocessed_table_count(self, unprocessed_table_count):
        """
        Sets the unprocessed_table_count of this ApiHBaseSnapshotResult.
        Number of unprocessed tables.

        :param unprocessed_table_count: The unprocessed_table_count of this ApiHBaseSnapshotResult.
        :type: int
        """

        self._unprocessed_table_count = unprocessed_table_count

    @property
    def unprocessed_tables(self):
        """
        Gets the unprocessed_tables of this ApiHBaseSnapshotResult.
        The list of unprocessed tables. Note that tables that are currently being processed will also be included in this list. <p/> This is only available in the full view.

        :return: The unprocessed_tables of this ApiHBaseSnapshotResult.
        :rtype: list[str]
        """
        return self._unprocessed_tables

    @unprocessed_tables.setter
    def unprocessed_tables(self, unprocessed_tables):
        """
        Sets the unprocessed_tables of this ApiHBaseSnapshotResult.
        The list of unprocessed tables. Note that tables that are currently being processed will also be included in this list. <p/> This is only available in the full view.

        :param unprocessed_tables: The unprocessed_tables of this ApiHBaseSnapshotResult.
        :type: list[str]
        """

        self._unprocessed_tables = unprocessed_tables

    @property
    def created_snapshot_count(self):
        """
        Gets the created_snapshot_count of this ApiHBaseSnapshotResult.
        Number of snapshots created.

        :return: The created_snapshot_count of this ApiHBaseSnapshotResult.
        :rtype: int
        """
        return self._created_snapshot_count

    @created_snapshot_count.setter
    def created_snapshot_count(self, created_snapshot_count):
        """
        Sets the created_snapshot_count of this ApiHBaseSnapshotResult.
        Number of snapshots created.

        :param created_snapshot_count: The created_snapshot_count of this ApiHBaseSnapshotResult.
        :type: int
        """

        self._created_snapshot_count = created_snapshot_count

    @property
    def created_snapshots(self):
        """
        Gets the created_snapshots of this ApiHBaseSnapshotResult.
        List of snapshots created. <p/> This is only available in the full view.

        :return: The created_snapshots of this ApiHBaseSnapshotResult.
        :rtype: list[ApiHBaseSnapshot]
        """
        return self._created_snapshots

    @created_snapshots.setter
    def created_snapshots(self, created_snapshots):
        """
        Sets the created_snapshots of this ApiHBaseSnapshotResult.
        List of snapshots created. <p/> This is only available in the full view.

        :param created_snapshots: The created_snapshots of this ApiHBaseSnapshotResult.
        :type: list[ApiHBaseSnapshot]
        """

        self._created_snapshots = created_snapshots

    @property
    def deleted_snapshot_count(self):
        """
        Gets the deleted_snapshot_count of this ApiHBaseSnapshotResult.
        Number of snapshots deleted.

        :return: The deleted_snapshot_count of this ApiHBaseSnapshotResult.
        :rtype: int
        """
        return self._deleted_snapshot_count

    @deleted_snapshot_count.setter
    def deleted_snapshot_count(self, deleted_snapshot_count):
        """
        Sets the deleted_snapshot_count of this ApiHBaseSnapshotResult.
        Number of snapshots deleted.

        :param deleted_snapshot_count: The deleted_snapshot_count of this ApiHBaseSnapshotResult.
        :type: int
        """

        self._deleted_snapshot_count = deleted_snapshot_count

    @property
    def deleted_snapshots(self):
        """
        Gets the deleted_snapshots of this ApiHBaseSnapshotResult.
        List of snapshots deleted. <p/> This is only available in the full view.

        :return: The deleted_snapshots of this ApiHBaseSnapshotResult.
        :rtype: list[ApiHBaseSnapshot]
        """
        return self._deleted_snapshots

    @deleted_snapshots.setter
    def deleted_snapshots(self, deleted_snapshots):
        """
        Sets the deleted_snapshots of this ApiHBaseSnapshotResult.
        List of snapshots deleted. <p/> This is only available in the full view.

        :param deleted_snapshots: The deleted_snapshots of this ApiHBaseSnapshotResult.
        :type: list[ApiHBaseSnapshot]
        """

        self._deleted_snapshots = deleted_snapshots

    @property
    def creation_error_count(self):
        """
        Gets the creation_error_count of this ApiHBaseSnapshotResult.
        Number of errors detected when creating snapshots.

        :return: The creation_error_count of this ApiHBaseSnapshotResult.
        :rtype: int
        """
        return self._creation_error_count

    @creation_error_count.setter
    def creation_error_count(self, creation_error_count):
        """
        Sets the creation_error_count of this ApiHBaseSnapshotResult.
        Number of errors detected when creating snapshots.

        :param creation_error_count: The creation_error_count of this ApiHBaseSnapshotResult.
        :type: int
        """

        self._creation_error_count = creation_error_count

    @property
    def creation_errors(self):
        """
        Gets the creation_errors of this ApiHBaseSnapshotResult.
        List of errors encountered when creating snapshots. <p/> This is only available in the full view.

        :return: The creation_errors of this ApiHBaseSnapshotResult.
        :rtype: list[ApiHBaseSnapshotError]
        """
        return self._creation_errors

    @creation_errors.setter
    def creation_errors(self, creation_errors):
        """
        Sets the creation_errors of this ApiHBaseSnapshotResult.
        List of errors encountered when creating snapshots. <p/> This is only available in the full view.

        :param creation_errors: The creation_errors of this ApiHBaseSnapshotResult.
        :type: list[ApiHBaseSnapshotError]
        """

        self._creation_errors = creation_errors

    @property
    def deletion_error_count(self):
        """
        Gets the deletion_error_count of this ApiHBaseSnapshotResult.
        Number of errors detected when deleting snapshots.

        :return: The deletion_error_count of this ApiHBaseSnapshotResult.
        :rtype: int
        """
        return self._deletion_error_count

    @deletion_error_count.setter
    def deletion_error_count(self, deletion_error_count):
        """
        Sets the deletion_error_count of this ApiHBaseSnapshotResult.
        Number of errors detected when deleting snapshots.

        :param deletion_error_count: The deletion_error_count of this ApiHBaseSnapshotResult.
        :type: int
        """

        self._deletion_error_count = deletion_error_count

    @property
    def deletion_errors(self):
        """
        Gets the deletion_errors of this ApiHBaseSnapshotResult.
        List of errors encountered when deleting snapshots. <p/> This is only available in the full view.

        :return: The deletion_errors of this ApiHBaseSnapshotResult.
        :rtype: list[ApiHBaseSnapshotError]
        """
        return self._deletion_errors

    @deletion_errors.setter
    def deletion_errors(self, deletion_errors):
        """
        Sets the deletion_errors of this ApiHBaseSnapshotResult.
        List of errors encountered when deleting snapshots. <p/> This is only available in the full view.

        :param deletion_errors: The deletion_errors of this ApiHBaseSnapshotResult.
        :type: list[ApiHBaseSnapshotError]
        """

        self._deletion_errors = deletion_errors

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiHBaseSnapshotResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
