# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiComponentInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'cdh_version': 'str',
        'cdh_release': 'str',
        'component_version': 'str',
        'component_release': 'str',
        'component_info_source': 'str',
        'is_active': 'bool',
        'component_config': 'dict(str, str)'
    }

    attribute_map = {
        'name': 'name',
        'cdh_version': 'cdhVersion',
        'cdh_release': 'cdhRelease',
        'component_version': 'componentVersion',
        'component_release': 'componentRelease',
        'component_info_source': 'componentInfoSource',
        'is_active': 'isActive',
        'component_config': 'componentConfig'
    }

    def __init__(self, name=None, cdh_version=None, cdh_release=None, component_version=None, component_release=None, component_info_source=None, is_active=None, component_config=None):
        """
        ApiComponentInfo - a model defined in Swagger
        """

        self._name = None
        self._cdh_version = None
        self._cdh_release = None
        self._component_version = None
        self._component_release = None
        self._component_info_source = None
        self._is_active = None
        self._component_config = None

        if name is not None:
          self.name = name
        if cdh_version is not None:
          self.cdh_version = cdh_version
        if cdh_release is not None:
          self.cdh_release = cdh_release
        if component_version is not None:
          self.component_version = component_version
        if component_release is not None:
          self.component_release = component_release
        if component_info_source is not None:
          self.component_info_source = component_info_source
        if is_active is not None:
          self.is_active = is_active
        if component_config is not None:
          self.component_config = component_config

    @property
    def name(self):
        """
        Gets the name of this ApiComponentInfo.
        The name of the component.

        :return: The name of this ApiComponentInfo.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApiComponentInfo.
        The name of the component.

        :param name: The name of this ApiComponentInfo.
        :type: str
        """

        self._name = name

    @property
    def cdh_version(self):
        """
        Gets the cdh_version of this ApiComponentInfo.
        The CDH version on the host.

        :return: The cdh_version of this ApiComponentInfo.
        :rtype: str
        """
        return self._cdh_version

    @cdh_version.setter
    def cdh_version(self, cdh_version):
        """
        Sets the cdh_version of this ApiComponentInfo.
        The CDH version on the host.

        :param cdh_version: The cdh_version of this ApiComponentInfo.
        :type: str
        """

        self._cdh_version = cdh_version

    @property
    def cdh_release(self):
        """
        Gets the cdh_release of this ApiComponentInfo.
        CDH release on the host.

        :return: The cdh_release of this ApiComponentInfo.
        :rtype: str
        """
        return self._cdh_release

    @cdh_release.setter
    def cdh_release(self, cdh_release):
        """
        Sets the cdh_release of this ApiComponentInfo.
        CDH release on the host.

        :param cdh_release: The cdh_release of this ApiComponentInfo.
        :type: str
        """

        self._cdh_release = cdh_release

    @property
    def component_version(self):
        """
        Gets the component_version of this ApiComponentInfo.
        Component version on the host.

        :return: The component_version of this ApiComponentInfo.
        :rtype: str
        """
        return self._component_version

    @component_version.setter
    def component_version(self, component_version):
        """
        Sets the component_version of this ApiComponentInfo.
        Component version on the host.

        :param component_version: The component_version of this ApiComponentInfo.
        :type: str
        """

        self._component_version = component_version

    @property
    def component_release(self):
        """
        Gets the component_release of this ApiComponentInfo.
        Component release on the host.

        :return: The component_release of this ApiComponentInfo.
        :rtype: str
        """
        return self._component_release

    @component_release.setter
    def component_release(self, component_release):
        """
        Sets the component_release of this ApiComponentInfo.
        Component release on the host.

        :param component_release: The component_release of this ApiComponentInfo.
        :type: str
        """

        self._component_release = component_release

    @property
    def component_info_source(self):
        """
        Gets the component_info_source of this ApiComponentInfo.
        Source from which component is taken.

        :return: The component_info_source of this ApiComponentInfo.
        :rtype: str
        """
        return self._component_info_source

    @component_info_source.setter
    def component_info_source(self, component_info_source):
        """
        Sets the component_info_source of this ApiComponentInfo.
        Source from which component is taken.

        :param component_info_source: The component_info_source of this ApiComponentInfo.
        :type: str
        """

        self._component_info_source = component_info_source

    @property
    def is_active(self):
        """
        Gets the is_active of this ApiComponentInfo.
        returns true if component is active.

        :return: The is_active of this ApiComponentInfo.
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active):
        """
        Sets the is_active of this ApiComponentInfo.
        returns true if component is active.

        :param is_active: The is_active of this ApiComponentInfo.
        :type: bool
        """

        self._is_active = is_active

    @property
    def component_config(self):
        """
        Gets the component_config of this ApiComponentInfo.
        list of config name and value pair associated with component.

        :return: The component_config of this ApiComponentInfo.
        :rtype: dict(str, str)
        """
        return self._component_config

    @component_config.setter
    def component_config(self, component_config):
        """
        Sets the component_config of this ApiComponentInfo.
        list of config name and value pair associated with component.

        :param component_config: The component_config of this ApiComponentInfo.
        :type: dict(str, str)
        """

        self._component_config = component_config

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiComponentInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
