# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiCollectDiagnosticDataArguments(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'bundle_size_bytes': 'int',
        'start_time': 'str',
        'end_time': 'str',
        'include_info_log': 'bool',
        'ticket_number': 'str',
        'comments': 'str',
        'cluster_name': 'str',
        'enable_monitor_metrics_collection': 'bool',
        'roles': 'list[str]'
    }

    attribute_map = {
        'bundle_size_bytes': 'bundleSizeBytes',
        'start_time': 'startTime',
        'end_time': 'endTime',
        'include_info_log': 'includeInfoLog',
        'ticket_number': 'ticketNumber',
        'comments': 'comments',
        'cluster_name': 'clusterName',
        'enable_monitor_metrics_collection': 'enableMonitorMetricsCollection',
        'roles': 'roles'
    }

    def __init__(self, bundle_size_bytes=None, start_time=None, end_time=None, include_info_log=None, ticket_number=None, comments=None, cluster_name=None, enable_monitor_metrics_collection=None, roles=None):
        """
        ApiCollectDiagnosticDataArguments - a model defined in Swagger
        """

        self._bundle_size_bytes = None
        self._start_time = None
        self._end_time = None
        self._include_info_log = None
        self._ticket_number = None
        self._comments = None
        self._cluster_name = None
        self._enable_monitor_metrics_collection = None
        self._roles = None

        if bundle_size_bytes is not None:
          self.bundle_size_bytes = bundle_size_bytes
        if start_time is not None:
          self.start_time = start_time
        if end_time is not None:
          self.end_time = end_time
        if include_info_log is not None:
          self.include_info_log = include_info_log
        if ticket_number is not None:
          self.ticket_number = ticket_number
        if comments is not None:
          self.comments = comments
        if cluster_name is not None:
          self.cluster_name = cluster_name
        if enable_monitor_metrics_collection is not None:
          self.enable_monitor_metrics_collection = enable_monitor_metrics_collection
        if roles is not None:
          self.roles = roles

    @property
    def bundle_size_bytes(self):
        """
        Gets the bundle_size_bytes of this ApiCollectDiagnosticDataArguments.
        The maximum approximate bundle size of the output file. Defaults to 0.

        :return: The bundle_size_bytes of this ApiCollectDiagnosticDataArguments.
        :rtype: int
        """
        return self._bundle_size_bytes

    @bundle_size_bytes.setter
    def bundle_size_bytes(self, bundle_size_bytes):
        """
        Sets the bundle_size_bytes of this ApiCollectDiagnosticDataArguments.
        The maximum approximate bundle size of the output file. Defaults to 0.

        :param bundle_size_bytes: The bundle_size_bytes of this ApiCollectDiagnosticDataArguments.
        :type: int
        """

        self._bundle_size_bytes = bundle_size_bytes

    @property
    def start_time(self):
        """
        Gets the start_time of this ApiCollectDiagnosticDataArguments.
        This parameter is ignored between CM 4.5 and CM 5.7 versions. For versions from CM 4.5 to CM 5.7, use endTime and bundleSizeBytes instead.  For CM 5.7+ versions, startTime is an optional parameter that is with endTime and bundleSizeBytes. This was introduced to perform diagnostic data estimation and collection of global diagnostics data for a certain time range. The start time (in ISO 8601 format) of the period to collection statistics for.

        :return: The start_time of this ApiCollectDiagnosticDataArguments.
        :rtype: str
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """
        Sets the start_time of this ApiCollectDiagnosticDataArguments.
        This parameter is ignored between CM 4.5 and CM 5.7 versions. For versions from CM 4.5 to CM 5.7, use endTime and bundleSizeBytes instead.  For CM 5.7+ versions, startTime is an optional parameter that is with endTime and bundleSizeBytes. This was introduced to perform diagnostic data estimation and collection of global diagnostics data for a certain time range. The start time (in ISO 8601 format) of the period to collection statistics for.

        :param start_time: The start_time of this ApiCollectDiagnosticDataArguments.
        :type: str
        """

        self._start_time = start_time

    @property
    def end_time(self):
        """
        Gets the end_time of this ApiCollectDiagnosticDataArguments.
        The end time (in ISO 8601 format) of the period to collection statistics for.

        :return: The end_time of this ApiCollectDiagnosticDataArguments.
        :rtype: str
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """
        Sets the end_time of this ApiCollectDiagnosticDataArguments.
        The end time (in ISO 8601 format) of the period to collection statistics for.

        :param end_time: The end_time of this ApiCollectDiagnosticDataArguments.
        :type: str
        """

        self._end_time = end_time

    @property
    def include_info_log(self):
        """
        Gets the include_info_log of this ApiCollectDiagnosticDataArguments.
        This parameter is ignored as of CM 4.5. INFO logs are always collected. Whether to include INFO level logs. WARN, ERROR, and FATAL level logs are always included.

        :return: The include_info_log of this ApiCollectDiagnosticDataArguments.
        :rtype: bool
        """
        return self._include_info_log

    @include_info_log.setter
    def include_info_log(self, include_info_log):
        """
        Sets the include_info_log of this ApiCollectDiagnosticDataArguments.
        This parameter is ignored as of CM 4.5. INFO logs are always collected. Whether to include INFO level logs. WARN, ERROR, and FATAL level logs are always included.

        :param include_info_log: The include_info_log of this ApiCollectDiagnosticDataArguments.
        :type: bool
        """

        self._include_info_log = include_info_log

    @property
    def ticket_number(self):
        """
        Gets the ticket_number of this ApiCollectDiagnosticDataArguments.
        The support ticket number to attach to this data collection.

        :return: The ticket_number of this ApiCollectDiagnosticDataArguments.
        :rtype: str
        """
        return self._ticket_number

    @ticket_number.setter
    def ticket_number(self, ticket_number):
        """
        Sets the ticket_number of this ApiCollectDiagnosticDataArguments.
        The support ticket number to attach to this data collection.

        :param ticket_number: The ticket_number of this ApiCollectDiagnosticDataArguments.
        :type: str
        """

        self._ticket_number = ticket_number

    @property
    def comments(self):
        """
        Gets the comments of this ApiCollectDiagnosticDataArguments.
        Comments to include with this data collection.

        :return: The comments of this ApiCollectDiagnosticDataArguments.
        :rtype: str
        """
        return self._comments

    @comments.setter
    def comments(self, comments):
        """
        Sets the comments of this ApiCollectDiagnosticDataArguments.
        Comments to include with this data collection.

        :param comments: The comments of this ApiCollectDiagnosticDataArguments.
        :type: str
        """

        self._comments = comments

    @property
    def cluster_name(self):
        """
        Gets the cluster_name of this ApiCollectDiagnosticDataArguments.
        Name of the cluster to collect. If null, collects from all clusters.

        :return: The cluster_name of this ApiCollectDiagnosticDataArguments.
        :rtype: str
        """
        return self._cluster_name

    @cluster_name.setter
    def cluster_name(self, cluster_name):
        """
        Sets the cluster_name of this ApiCollectDiagnosticDataArguments.
        Name of the cluster to collect. If null, collects from all clusters.

        :param cluster_name: The cluster_name of this ApiCollectDiagnosticDataArguments.
        :type: str
        """

        self._cluster_name = cluster_name

    @property
    def enable_monitor_metrics_collection(self):
        """
        Gets the enable_monitor_metrics_collection of this ApiCollectDiagnosticDataArguments.
        Flag to enable collection of metrics for chart display.

        :return: The enable_monitor_metrics_collection of this ApiCollectDiagnosticDataArguments.
        :rtype: bool
        """
        return self._enable_monitor_metrics_collection

    @enable_monitor_metrics_collection.setter
    def enable_monitor_metrics_collection(self, enable_monitor_metrics_collection):
        """
        Sets the enable_monitor_metrics_collection of this ApiCollectDiagnosticDataArguments.
        Flag to enable collection of metrics for chart display.

        :param enable_monitor_metrics_collection: The enable_monitor_metrics_collection of this ApiCollectDiagnosticDataArguments.
        :type: bool
        """

        self._enable_monitor_metrics_collection = enable_monitor_metrics_collection

    @property
    def roles(self):
        """
        Gets the roles of this ApiCollectDiagnosticDataArguments.
        List of roles for which to get logs and metrics.  If set, this restricts the roles for log and metrics collection to the list specified.  If empty, the default is to get logs for all roles (in the selected cluster, if one is selected).  Introduced in API v10 of the API.

        :return: The roles of this ApiCollectDiagnosticDataArguments.
        :rtype: list[str]
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """
        Sets the roles of this ApiCollectDiagnosticDataArguments.
        List of roles for which to get logs and metrics.  If set, this restricts the roles for log and metrics collection to the list specified.  If empty, the default is to get logs for all roles (in the selected cluster, if one is selected).  Introduced in API v10 of the API.

        :param roles: The roles of this ApiCollectDiagnosticDataArguments.
        :type: list[str]
        """

        self._roles = roles

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiCollectDiagnosticDataArguments):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
