# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiClusterTemplateHostTemplate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ref_name': 'str',
        'role_config_groups_ref_names': 'list[str]',
        'cardinality': 'int',
        'tags': 'list[ApiEntityTag]'
    }

    attribute_map = {
        'ref_name': 'refName',
        'role_config_groups_ref_names': 'roleConfigGroupsRefNames',
        'cardinality': 'cardinality',
        'tags': 'tags'
    }

    def __init__(self, ref_name=None, role_config_groups_ref_names=None, cardinality=None, tags=None):
        """
        ApiClusterTemplateHostTemplate - a model defined in Swagger
        """

        self._ref_name = None
        self._role_config_groups_ref_names = None
        self._cardinality = None
        self._tags = None

        if ref_name is not None:
          self.ref_name = ref_name
        if role_config_groups_ref_names is not None:
          self.role_config_groups_ref_names = role_config_groups_ref_names
        if cardinality is not None:
          self.cardinality = cardinality
        if tags is not None:
          self.tags = tags

    @property
    def ref_name(self):
        """
        Gets the ref_name of this ApiClusterTemplateHostTemplate.
        Reference name

        :return: The ref_name of this ApiClusterTemplateHostTemplate.
        :rtype: str
        """
        return self._ref_name

    @ref_name.setter
    def ref_name(self, ref_name):
        """
        Sets the ref_name of this ApiClusterTemplateHostTemplate.
        Reference name

        :param ref_name: The ref_name of this ApiClusterTemplateHostTemplate.
        :type: str
        """

        self._ref_name = ref_name

    @property
    def role_config_groups_ref_names(self):
        """
        Gets the role_config_groups_ref_names of this ApiClusterTemplateHostTemplate.
        List of role config groups

        :return: The role_config_groups_ref_names of this ApiClusterTemplateHostTemplate.
        :rtype: list[str]
        """
        return self._role_config_groups_ref_names

    @role_config_groups_ref_names.setter
    def role_config_groups_ref_names(self, role_config_groups_ref_names):
        """
        Sets the role_config_groups_ref_names of this ApiClusterTemplateHostTemplate.
        List of role config groups

        :param role_config_groups_ref_names: The role_config_groups_ref_names of this ApiClusterTemplateHostTemplate.
        :type: list[str]
        """

        self._role_config_groups_ref_names = role_config_groups_ref_names

    @property
    def cardinality(self):
        """
        Gets the cardinality of this ApiClusterTemplateHostTemplate.
        Represent the cardinality of this host template on source. Defaults to 0.

        :return: The cardinality of this ApiClusterTemplateHostTemplate.
        :rtype: int
        """
        return self._cardinality

    @cardinality.setter
    def cardinality(self, cardinality):
        """
        Sets the cardinality of this ApiClusterTemplateHostTemplate.
        Represent the cardinality of this host template on source. Defaults to 0.

        :param cardinality: The cardinality of this ApiClusterTemplateHostTemplate.
        :type: int
        """

        self._cardinality = cardinality

    @property
    def tags(self):
        """
        Gets the tags of this ApiClusterTemplateHostTemplate.
        The tags to be added to hosts when this template is applied

        :return: The tags of this ApiClusterTemplateHostTemplate.
        :rtype: list[ApiEntityTag]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this ApiClusterTemplateHostTemplate.
        The tags to be added to hosts when this template is applied

        :param tags: The tags of this ApiClusterTemplateHostTemplate.
        :type: list[ApiEntityTag]
        """

        self._tags = tags

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiClusterTemplateHostTemplate):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
