# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ApiCertificateRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'hostname': 'str',
        'csr': 'str',
        'token': 'str'
    }

    attribute_map = {
        'hostname': 'hostname',
        'csr': 'csr',
        'token': 'token'
    }

    def __init__(self, hostname=None, csr=None, token=None):
        """
        ApiCertificateRequest - a model defined in Swagger
        """

        self._hostname = None
        self._csr = None
        self._token = None

        if hostname is not None:
          self.hostname = hostname
        if csr is not None:
          self.csr = csr
        if token is not None:
          self.token = token

    @property
    def hostname(self):
        """
        Gets the hostname of this ApiCertificateRequest.
        Get the hostname of the host requesting certificates

        :return: The hostname of this ApiCertificateRequest.
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """
        Sets the hostname of this ApiCertificateRequest.
        Get the hostname of the host requesting certificates

        :param hostname: The hostname of this ApiCertificateRequest.
        :type: str
        """

        self._hostname = hostname

    @property
    def csr(self):
        """
        Gets the csr of this ApiCertificateRequest.
        Get the certificate signing request in PEM format

        :return: The csr of this ApiCertificateRequest.
        :rtype: str
        """
        return self._csr

    @csr.setter
    def csr(self, csr):
        """
        Sets the csr of this ApiCertificateRequest.
        Get the certificate signing request in PEM format

        :param csr: The csr of this ApiCertificateRequest.
        :type: str
        """

        self._csr = csr

    @property
    def token(self):
        """
        Gets the token of this ApiCertificateRequest.
        Get the certificate request token

        :return: The token of this ApiCertificateRequest.
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """
        Sets the token of this ApiCertificateRequest.
        Get the certificate request token

        :param token: The token of this ApiCertificateRequest.
        :type: str
        """

        self._token = token

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ApiCertificateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
