# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ServicesResourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def add_tags(self, cluster_name, service_name, **kwargs):
        """
        Attach tags to the service.
        Attach tags to the service. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_tags(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the service (required)
        :param list[ApiEntityTag] body: List of tags to add to the service
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_tags_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.add_tags_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def add_tags_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Attach tags to the service.
        Attach tags to the service. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_tags_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the service (required)
        :param list[ApiEntityTag] body: List of tags to add to the service
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `add_tags`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `add_tags`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/tags', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ApiEntityTag]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def collect_yarn_application_diagnostics(self, cluster_name, service_name, **kwargs):
        """
        Collect the Diagnostics data for Yarn applications.
        Collect the Diagnostics data for Yarn applications <p> Available since API v8.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.collect_yarn_application_diagnostics(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the YARN service on which to run the command. (required)
        :param ApiYarnApplicationDiagnosticsCollectionArgs body: Arguments used for collecting diagnostics data for Yarn applications
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.collect_yarn_application_diagnostics_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.collect_yarn_application_diagnostics_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def collect_yarn_application_diagnostics_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Collect the Diagnostics data for Yarn applications.
        Collect the Diagnostics data for Yarn applications <p> Available since API v8.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.collect_yarn_application_diagnostics_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the YARN service on which to run the command. (required)
        :param ApiYarnApplicationDiagnosticsCollectionArgs body: Arguments used for collecting diagnostics data for Yarn applications
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method collect_yarn_application_diagnostics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `collect_yarn_application_diagnostics`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `collect_yarn_application_diagnostics`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/yarnApplicationDiagnosticsCollection', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def copy_hdfs_file(self, cluster_name, service_name, **kwargs):
        """
        Copies source HDFS file to destination cluster HDFS.
        Copies source HDFS file to destination cluster HDFS
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.copy_hdfs_file(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The source HDFS service (required)
        :param str destination_path: HDFS full path at destination
        :param str source_path: HDFS full path at source
        :param ApiServiceRef body: ApiServiceRef for the destination
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.copy_hdfs_file_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.copy_hdfs_file_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def copy_hdfs_file_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Copies source HDFS file to destination cluster HDFS.
        Copies source HDFS file to destination cluster HDFS
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.copy_hdfs_file_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The source HDFS service (required)
        :param str destination_path: HDFS full path at destination
        :param str source_path: HDFS full path at source
        :param ApiServiceRef body: ApiServiceRef for the destination
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'destination_path', 'source_path', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_hdfs_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `copy_hdfs_file`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `copy_hdfs_file`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'destination_path' in params:
            query_params.append(('destinationPath', params['destination_path']))
        if 'source_path' in params:
            query_params.append(('sourcePath', params['source_path']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/copyHdfsFile', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_beeswax_warehouse_command(self, cluster_name, service_name, **kwargs):
        """
        Create the Beeswax role's Hive warehouse directory, on Hue services.
        Create the Beeswax role's Hive warehouse directory, on Hue services.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_beeswax_warehouse_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Hue service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_beeswax_warehouse_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.create_beeswax_warehouse_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def create_beeswax_warehouse_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Create the Beeswax role's Hive warehouse directory, on Hue services.
        Create the Beeswax role's Hive warehouse directory, on Hue services.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_beeswax_warehouse_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Hue service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_beeswax_warehouse_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `create_beeswax_warehouse_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `create_beeswax_warehouse_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hueCreateHiveWarehouse', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_h_base_root_command(self, cluster_name, service_name, **kwargs):
        """
        Creates the root directory of an HBase service.
        Creates the root directory of an HBase service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_h_base_root_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HBase service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_h_base_root_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.create_h_base_root_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def create_h_base_root_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Creates the root directory of an HBase service.
        Creates the root directory of an HBase service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_h_base_root_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HBase service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_h_base_root_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `create_h_base_root_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `create_h_base_root_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hbaseCreateRoot', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_hdfs_file(self, cluster_name, service_name, **kwargs):
        """
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_hdfs_file(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name (required)
        :param str path: full path to the HDFS file to be created
        :param str body: Content to be put in the file to be created
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_hdfs_file_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.create_hdfs_file_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def create_hdfs_file_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_hdfs_file_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name (required)
        :param str path: full path to the HDFS file to be created
        :param str body: Content to be put in the file to be created
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'path', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_hdfs_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `create_hdfs_file`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `create_hdfs_file`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'path' in params:
            query_params.append(('path', params['path']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/createHdfsFile', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='str',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_hive_user_dir_command(self, cluster_name, service_name, **kwargs):
        """
        Create the Hive user directory.
        Create the Hive user directory <p> Available since API v4. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_hive_user_dir_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Hive service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_hive_user_dir_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.create_hive_user_dir_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def create_hive_user_dir_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Create the Hive user directory.
        Create the Hive user directory <p> Available since API v4. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_hive_user_dir_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Hive service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_hive_user_dir_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `create_hive_user_dir_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `create_hive_user_dir_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hiveCreateHiveUserDir', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_hive_warehouse_command(self, cluster_name, service_name, **kwargs):
        """
        Create the Hive warehouse directory, on Hive services.
        Create the Hive warehouse directory, on Hive services. <p> Available since API v3. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_hive_warehouse_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Hive service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_hive_warehouse_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.create_hive_warehouse_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def create_hive_warehouse_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Create the Hive warehouse directory, on Hive services.
        Create the Hive warehouse directory, on Hive services. <p> Available since API v3. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_hive_warehouse_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Hive service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_hive_warehouse_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `create_hive_warehouse_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `create_hive_warehouse_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hiveCreateHiveWarehouse', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_hive_warehouse_external_command(self, cluster_name, service_name, **kwargs):
        """
        Create the Hive warehouse external directory for Private Cloud.
        Create the Hive warehouse external directory for Private Cloud.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_hive_warehouse_external_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Hive service name. (required)
        :param str directory: Name of the warehouse external directory.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_hive_warehouse_external_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.create_hive_warehouse_external_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def create_hive_warehouse_external_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Create the Hive warehouse external directory for Private Cloud.
        Create the Hive warehouse external directory for Private Cloud.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_hive_warehouse_external_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Hive service name. (required)
        :param str directory: Name of the warehouse external directory.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'directory']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_hive_warehouse_external_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `create_hive_warehouse_external_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `create_hive_warehouse_external_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'directory' in params:
            query_params.append(('directory', params['directory']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hiveCreateHiveWarehouseExternal', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_impala_user_dir_command(self, cluster_name, service_name, **kwargs):
        """
        Create the Impala user directory.
        Create the Impala user directory <p> Available since API v6. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_impala_user_dir_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Impala service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_impala_user_dir_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.create_impala_user_dir_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def create_impala_user_dir_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Create the Impala user directory.
        Create the Impala user directory <p> Available since API v6. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_impala_user_dir_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Impala service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_impala_user_dir_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `create_impala_user_dir_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `create_impala_user_dir_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/impalaCreateUserDir', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_oozie_db(self, cluster_name, service_name, **kwargs):
        """
        Creates the Oozie Database Schema in the configured database.
        Creates the Oozie Database Schema in the configured database. This command does not create database. This command creates only tables required by Oozie. To create database, please refer to oozieCreateEmbeddedDatabase()  <p> Available since API v2. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_oozie_db(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Oozie service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_oozie_db_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.create_oozie_db_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def create_oozie_db_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Creates the Oozie Database Schema in the configured database.
        Creates the Oozie Database Schema in the configured database. This command does not create database. This command creates only tables required by Oozie. To create database, please refer to oozieCreateEmbeddedDatabase()  <p> Available since API v2. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_oozie_db_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Oozie service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_oozie_db" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `create_oozie_db`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `create_oozie_db`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/createOozieDb', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_services(self, cluster_name, **kwargs):
        """
        Creates a list of services.
        Creates a list of services. <p> There are typically two service creation strategies: <ol> <li> The caller may choose to set up a new service piecemeal, by first creating the service itself (without any roles or configuration), and then create the roles, and then specify configuration. </li> <li> Alternatively, the caller can pack all the information in one call, by fully specifying the fields in the com.cloudera.api.model.ApiService object, with <ul> <li>service config and role type config, and</li> <li>role to host assignment.</li> </ul> </li> </ol>  <table> <thead> <tr> <th>Cluster Version</th> <th>Available Service Types</th> </tr> </thead> <tbody> <tr> <td>CDH4</td> <td>HDFS, MAPREDUCE, HBASE, OOZIE, ZOOKEEPER, HUE, YARN, IMPALA, FLUME, HIVE, SOLR, SQOOP, KS_INDEXER</td> </tr> <tr> <td>CDH5</td> <td>HDFS, MAPREDUCE, HBASE, OOZIE, ZOOKEEPER, HUE, YARN, IMPALA, FLUME, HIVE, SOLR, SQOOP, KS_INDEXER, SQOOP_CLIENT, SENTRY, ACCUMULO16, KMS, SPARK_ON_YARN, KAFKA </td> </tr> </tbody> </table>  As of V6, GET /{clusterName}/serviceTypes should be used to get the service types available to the cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_services(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param ApiServiceList body: Details of the services to create.
        :return: ApiServiceList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_services_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.create_services_with_http_info(cluster_name, **kwargs)
            return data

    def create_services_with_http_info(self, cluster_name, **kwargs):
        """
        Creates a list of services.
        Creates a list of services. <p> There are typically two service creation strategies: <ol> <li> The caller may choose to set up a new service piecemeal, by first creating the service itself (without any roles or configuration), and then create the roles, and then specify configuration. </li> <li> Alternatively, the caller can pack all the information in one call, by fully specifying the fields in the com.cloudera.api.model.ApiService object, with <ul> <li>service config and role type config, and</li> <li>role to host assignment.</li> </ul> </li> </ol>  <table> <thead> <tr> <th>Cluster Version</th> <th>Available Service Types</th> </tr> </thead> <tbody> <tr> <td>CDH4</td> <td>HDFS, MAPREDUCE, HBASE, OOZIE, ZOOKEEPER, HUE, YARN, IMPALA, FLUME, HIVE, SOLR, SQOOP, KS_INDEXER</td> </tr> <tr> <td>CDH5</td> <td>HDFS, MAPREDUCE, HBASE, OOZIE, ZOOKEEPER, HUE, YARN, IMPALA, FLUME, HIVE, SOLR, SQOOP, KS_INDEXER, SQOOP_CLIENT, SENTRY, ACCUMULO16, KMS, SPARK_ON_YARN, KAFKA </td> </tr> </tbody> </table>  As of V6, GET /{clusterName}/serviceTypes should be used to get the service types available to the cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_services_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param ApiServiceList body: Details of the services to create.
        :return: ApiServiceList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_services" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `create_services`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiServiceList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_solr_hdfs_home_dir_command(self, cluster_name, service_name, **kwargs):
        """
        Creates the home directory of a Solr service in HDFS.
        Creates the home directory of a Solr service in HDFS.  <p> Available since API v4.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_solr_hdfs_home_dir_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Solr service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_solr_hdfs_home_dir_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.create_solr_hdfs_home_dir_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def create_solr_hdfs_home_dir_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Creates the home directory of a Solr service in HDFS.
        Creates the home directory of a Solr service in HDFS.  <p> Available since API v4.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_solr_hdfs_home_dir_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Solr service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_solr_hdfs_home_dir_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `create_solr_hdfs_home_dir_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `create_solr_hdfs_home_dir_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/createSolrHdfsHomeDir', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_sqoop_user_dir_command(self, cluster_name, service_name, **kwargs):
        """
        Creates the user directory of a Sqoop service in HDFS.
        Creates the user directory of a Sqoop service in HDFS.  <p> Available since API v4.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_sqoop_user_dir_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Sqoop service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_sqoop_user_dir_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.create_sqoop_user_dir_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def create_sqoop_user_dir_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Creates the user directory of a Sqoop service in HDFS.
        Creates the user directory of a Sqoop service in HDFS.  <p> Available since API v4.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_sqoop_user_dir_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Sqoop service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_sqoop_user_dir_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `create_sqoop_user_dir_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `create_sqoop_user_dir_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/createSqoopUserDir', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_yarn_cm_container_usage_input_dir_command(self, cluster_name, service_name, **kwargs):
        """
        Creates the HDFS directory where YARN container usage metrics are stored by NodeManagers for CM to read and aggregate into app usage metrics.
        Creates the HDFS directory where YARN container usage metrics are stored by NodeManagers for CM to read and aggregate into app usage metrics. <p> Available since API v13. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_yarn_cm_container_usage_input_dir_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The YARN service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_yarn_cm_container_usage_input_dir_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.create_yarn_cm_container_usage_input_dir_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def create_yarn_cm_container_usage_input_dir_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Creates the HDFS directory where YARN container usage metrics are stored by NodeManagers for CM to read and aggregate into app usage metrics.
        Creates the HDFS directory where YARN container usage metrics are stored by NodeManagers for CM to read and aggregate into app usage metrics. <p> Available since API v13. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_yarn_cm_container_usage_input_dir_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The YARN service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_yarn_cm_container_usage_input_dir_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `create_yarn_cm_container_usage_input_dir_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `create_yarn_cm_container_usage_input_dir_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/yarnCreateCmContainerUsageInputDirCommand', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_yarn_job_history_dir_command(self, cluster_name, service_name, **kwargs):
        """
        Create the Yarn job history directory.
        Create the Yarn job history directory <p> Available since API v6. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_yarn_job_history_dir_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The YARN service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_yarn_job_history_dir_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.create_yarn_job_history_dir_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def create_yarn_job_history_dir_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Create the Yarn job history directory.
        Create the Yarn job history directory <p> Available since API v6. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_yarn_job_history_dir_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The YARN service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_yarn_job_history_dir_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `create_yarn_job_history_dir_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `create_yarn_job_history_dir_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/yarnCreateJobHistoryDirCommand', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_yarn_node_manager_remote_app_log_dir_command(self, cluster_name, service_name, **kwargs):
        """
        Create the Yarn NodeManager remote application log directory.
        Create the Yarn NodeManager remote application log directory <p> Available since API v6. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_yarn_node_manager_remote_app_log_dir_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The YARN service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_yarn_node_manager_remote_app_log_dir_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.create_yarn_node_manager_remote_app_log_dir_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def create_yarn_node_manager_remote_app_log_dir_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Create the Yarn NodeManager remote application log directory.
        Create the Yarn NodeManager remote application log directory <p> Available since API v6. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_yarn_node_manager_remote_app_log_dir_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The YARN service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_yarn_node_manager_remote_app_log_dir_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `create_yarn_node_manager_remote_app_log_dir_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `create_yarn_node_manager_remote_app_log_dir_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/yarnNodeManagerRemoteAppLogDirCommand', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def decommission_command(self, cluster_name, service_name, **kwargs):
        """
        Decommission roles of a service.
        Decommission roles of a service. <p> For HBase services, the list should contain names of RegionServers to decommission. <p> For HDFS services, the list should contain names of DataNodes to decommission.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.decommission_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HBase service name. (required)
        :param ApiRoleNameList body: List of role names to decommision.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.decommission_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.decommission_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def decommission_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Decommission roles of a service.
        Decommission roles of a service. <p> For HBase services, the list should contain names of RegionServers to decommission. <p> For HDFS services, the list should contain names of DataNodes to decommission.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.decommission_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HBase service name. (required)
        :param ApiRoleNameList body: List of role names to decommision.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method decommission_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `decommission_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `decommission_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/decommission', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_service(self, cluster_name, service_name, **kwargs):
        """
        Deletes a service from the system.
        Deletes a service from the system.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_service(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service to delete. (required)
        :return: ApiService
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_service_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.delete_service_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def delete_service_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Deletes a service from the system.
        Deletes a service from the system.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_service_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service to delete. (required)
        :return: ApiService
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_service" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `delete_service`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `delete_service`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiService',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_tags(self, cluster_name, service_name, **kwargs):
        """
        Remove the tags associated with the service.
        Remove the tags associated with the service. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_tags(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the service to remove tags from (required)
        :param list[ApiEntityTag] body: List of tags to remove from the service
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_tags_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.delete_tags_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def delete_tags_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Remove the tags associated with the service.
        Remove the tags associated with the service. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_tags_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the service to remove tags from (required)
        :param list[ApiEntityTag] body: List of tags to remove from the service
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `delete_tags`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `delete_tags`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/tags', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ApiEntityTag]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def deploy_client_config_command(self, cluster_name, service_name, **kwargs):
        """
        Deploy a service's client configuration.
        Deploy a service's client configuration. <p> The client configuration is deployed to the hosts where the given roles are running. <p/> Added in v3: passing null for the role name list will deploy client configs to all known service roles. Added in v6: passing an empty role name list will deploy client configs to all known service roles. <p/> In Cloudera Manager 5.3 and newer, client configurations are fully managed, meaning that the server maintains state about which client configurations should exist and be managed by alternatives, and the agents actively rectify their hosts with this state. Consequently, if this API call is made with a specific set of roles, Cloudera Manager will deactivate, from alternatives, any deployed client configs from any non-gateway roles that are <em>not</em> specified as arguments. Gateway roles are always preserved, and calling this API with an empty or null argument continues to deploy to all roles. <p/>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deploy_client_config_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :param ApiRoleNameList body: List of role names.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.deploy_client_config_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.deploy_client_config_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def deploy_client_config_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Deploy a service's client configuration.
        Deploy a service's client configuration. <p> The client configuration is deployed to the hosts where the given roles are running. <p/> Added in v3: passing null for the role name list will deploy client configs to all known service roles. Added in v6: passing an empty role name list will deploy client configs to all known service roles. <p/> In Cloudera Manager 5.3 and newer, client configurations are fully managed, meaning that the server maintains state about which client configurations should exist and be managed by alternatives, and the agents actively rectify their hosts with this state. Consequently, if this API call is made with a specific set of roles, Cloudera Manager will deactivate, from alternatives, any deployed client configs from any non-gateway roles that are <em>not</em> specified as arguments. Gateway roles are always preserved, and calling this API with an empty or null argument continues to deploy to all roles. <p/>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deploy_client_config_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :param ApiRoleNameList body: List of role names.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deploy_client_config_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `deploy_client_config_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `deploy_client_config_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/deployClientConfig', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def disable_jt_ha_command(self, cluster_name, service_name, **kwargs):
        """
        Disable high availability (HA) for JobTracker.
        Disable high availability (HA) for JobTracker.  As part of disabling HA, any services that depend on the MapReduce service being modified will be stopped. The command arguments provide options to specify name of JobTracker that will be preserved. The Command will redeploy the client configurations for services of the cluster after HA has been disabled.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_jt_ha_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The MapReduce service name. (required)
        :param ApiDisableJtHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.disable_jt_ha_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.disable_jt_ha_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def disable_jt_ha_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Disable high availability (HA) for JobTracker.
        Disable high availability (HA) for JobTracker.  As part of disabling HA, any services that depend on the MapReduce service being modified will be stopped. The command arguments provide options to specify name of JobTracker that will be preserved. The Command will redeploy the client configurations for services of the cluster after HA has been disabled.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_jt_ha_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The MapReduce service name. (required)
        :param ApiDisableJtHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_jt_ha_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `disable_jt_ha_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `disable_jt_ha_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/disableJtHa', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def disable_llama_ha_command(self, cluster_name, service_name, **kwargs):
        """
        Not Supported.
        Not Supported. Llama was removed.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_llama_ha_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :param ApiDisableLlamaHaArguments body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.disable_llama_ha_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.disable_llama_ha_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def disable_llama_ha_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Not Supported.
        Not Supported. Llama was removed.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_llama_ha_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :param ApiDisableLlamaHaArguments body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_llama_ha_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `disable_llama_ha_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `disable_llama_ha_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/impalaDisableLlamaHa', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def disable_llama_rm_command(self, cluster_name, service_name, **kwargs):
        """
        Not Supported.
        Not Supported. Llama was removed.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_llama_rm_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.disable_llama_rm_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.disable_llama_rm_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def disable_llama_rm_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Not Supported.
        Not Supported. Llama was removed.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_llama_rm_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_llama_rm_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `disable_llama_rm_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `disable_llama_rm_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/impalaDisableLlamaRm', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def disable_oozie_ha_command(self, cluster_name, service_name, **kwargs):
        """
        Disable high availability (HA) for Oozie.
        Disable high availability (HA) for Oozie.  As part of disabling HA, any services that depend on the Oozie service being modified will be stopped. The command arguments provide options to specify name of Oozie Server that will be preserved. After deleting, other Oozie servers, all the services that were stopped are restarted.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_oozie_ha_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Oozie service name. (required)
        :param ApiDisableOozieHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.disable_oozie_ha_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.disable_oozie_ha_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def disable_oozie_ha_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Disable high availability (HA) for Oozie.
        Disable high availability (HA) for Oozie.  As part of disabling HA, any services that depend on the Oozie service being modified will be stopped. The command arguments provide options to specify name of Oozie Server that will be preserved. After deleting, other Oozie servers, all the services that were stopped are restarted.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_oozie_ha_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Oozie service name. (required)
        :param ApiDisableOozieHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_oozie_ha_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `disable_oozie_ha_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `disable_oozie_ha_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/oozieDisableHa', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def disable_rm_ha_command(self, cluster_name, service_name, **kwargs):
        """
        Disable high availability (HA) for ResourceManager.
        Disable high availability (HA) for ResourceManager.  As part of disabling HA, any services that depend on the YARN service being modified will be stopped. The command arguments provide options to specify name of ResourceManager that will be preserved. The command will redeploy the client configurations for services of the cluster after HA has been disabled.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_rm_ha_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The YARN service name. (required)
        :param ApiDisableRmHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.disable_rm_ha_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.disable_rm_ha_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def disable_rm_ha_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Disable high availability (HA) for ResourceManager.
        Disable high availability (HA) for ResourceManager.  As part of disabling HA, any services that depend on the YARN service being modified will be stopped. The command arguments provide options to specify name of ResourceManager that will be preserved. The command will redeploy the client configurations for services of the cluster after HA has been disabled.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_rm_ha_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The YARN service name. (required)
        :param ApiDisableRmHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_rm_ha_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `disable_rm_ha_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `disable_rm_ha_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/disableRmHa', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def disable_sentry_ha_command(self, cluster_name, service_name, **kwargs):
        """
        Disable high availability (HA) for Sentry service.
        Disable high availability (HA) for Sentry service. <p> This command only applies to CDH 5.13+ Sentry services. <p> The command will keep exactly one Sentry server, on the specified host, and update the ZooKeeper configs needed for Sentry. <p> All services that depend on HDFS will be restarted after enabling Sentry HA. <p> Note: Sentry doesn't support Rolling Restart.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_sentry_ha_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the Sentry service name. (required)
        :param ApiDisableSentryHaArgs body: An instance of ApiDisableSentryHaArgs representing the arguments to the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.disable_sentry_ha_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.disable_sentry_ha_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def disable_sentry_ha_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Disable high availability (HA) for Sentry service.
        Disable high availability (HA) for Sentry service. <p> This command only applies to CDH 5.13+ Sentry services. <p> The command will keep exactly one Sentry server, on the specified host, and update the ZooKeeper configs needed for Sentry. <p> All services that depend on HDFS will be restarted after enabling Sentry HA. <p> Note: Sentry doesn't support Rolling Restart.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_sentry_ha_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the Sentry service name. (required)
        :param ApiDisableSentryHaArgs body: An instance of ApiDisableSentryHaArgs representing the arguments to the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_sentry_ha_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `disable_sentry_ha_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `disable_sentry_ha_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/disableSentryHa', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def enable_jt_ha_command(self, cluster_name, service_name, **kwargs):
        """
        Enable high availability (HA) for a JobTracker.
        Enable high availability (HA) for a JobTracker. <p> This command only applies to CDH4 MapReduce services. <p> The command will create a new JobTracker on the specified host and then create an active/standby pair with the existing JobTracker. Autofailover will be enabled using ZooKeeper. A ZNode will be created for this purpose. Command arguments provide option to forcefully create this ZNode if one already exists. A node may already exists if JobTracker was previously enabled in HA mode but HA mode was disabled later on. The ZNode is not deleted when HA is disabled. <p> As part of enabling HA, any services that depends on the MapReduce service being modified will be stopped. Command will redeploy the client configurations for services of the cluster after HA has been enabled.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enable_jt_ha_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The MapReduce service name. (required)
        :param ApiEnableJtHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.enable_jt_ha_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.enable_jt_ha_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def enable_jt_ha_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Enable high availability (HA) for a JobTracker.
        Enable high availability (HA) for a JobTracker. <p> This command only applies to CDH4 MapReduce services. <p> The command will create a new JobTracker on the specified host and then create an active/standby pair with the existing JobTracker. Autofailover will be enabled using ZooKeeper. A ZNode will be created for this purpose. Command arguments provide option to forcefully create this ZNode if one already exists. A node may already exists if JobTracker was previously enabled in HA mode but HA mode was disabled later on. The ZNode is not deleted when HA is disabled. <p> As part of enabling HA, any services that depends on the MapReduce service being modified will be stopped. Command will redeploy the client configurations for services of the cluster after HA has been enabled.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enable_jt_ha_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The MapReduce service name. (required)
        :param ApiEnableJtHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_jt_ha_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `enable_jt_ha_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `enable_jt_ha_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/enableJtHa', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def enable_llama_ha_command(self, cluster_name, service_name, **kwargs):
        """
        Not Supported.
        Not Supported. Llama was removed.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enable_llama_ha_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :param ApiEnableLlamaHaArguments body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.enable_llama_ha_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.enable_llama_ha_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def enable_llama_ha_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Not Supported.
        Not Supported. Llama was removed.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enable_llama_ha_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :param ApiEnableLlamaHaArguments body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_llama_ha_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `enable_llama_ha_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `enable_llama_ha_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/impalaEnableLlamaHa', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def enable_llama_rm_command(self, cluster_name, service_name, **kwargs):
        """
        Not Supported.
        Not Supported. Llama was removed.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enable_llama_rm_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :param ApiEnableLlamaRmArguments body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.enable_llama_rm_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.enable_llama_rm_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def enable_llama_rm_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Not Supported.
        Not Supported. Llama was removed.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enable_llama_rm_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :param ApiEnableLlamaRmArguments body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_llama_rm_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `enable_llama_rm_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `enable_llama_rm_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/impalaEnableLlamaRm', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def enable_oozie_ha_command(self, cluster_name, service_name, **kwargs):
        """
        Enable high availability (HA) for Oozie service.
        Enable high availability (HA) for Oozie service. <p> This command only applies to CDH5+ Oozie services. <p> The command will create new Oozie Servers on the specified hosts and set the ZooKeeper and Load Balancer configs needed for Oozie HA. <p> As part of enabling HA, any services that depends on the Oozie service being modified will be stopped and restarted after enabling Oozie HA.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enable_oozie_ha_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Oozie service name. (required)
        :param ApiEnableOozieHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.enable_oozie_ha_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.enable_oozie_ha_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def enable_oozie_ha_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Enable high availability (HA) for Oozie service.
        Enable high availability (HA) for Oozie service. <p> This command only applies to CDH5+ Oozie services. <p> The command will create new Oozie Servers on the specified hosts and set the ZooKeeper and Load Balancer configs needed for Oozie HA. <p> As part of enabling HA, any services that depends on the Oozie service being modified will be stopped and restarted after enabling Oozie HA.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enable_oozie_ha_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Oozie service name. (required)
        :param ApiEnableOozieHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_oozie_ha_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `enable_oozie_ha_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `enable_oozie_ha_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/oozieEnableHa', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def enable_rm_ha_command(self, cluster_name, service_name, **kwargs):
        """
        Enable high availability (HA) for a YARN ResourceManager.
        Enable high availability (HA) for a YARN ResourceManager. <p> This command only applies to CDH5+ YARN services. <p> The command will create a new ResourceManager on the specified host and then create an active/standby pair with the existing ResourceManager. Autofailover will be enabled using ZooKeeper. <p> As part of enabling HA, any services that depends on the YARN service being modified will be stopped. Command will redeploy the client configurations for services of the cluster after HA has been enabled.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enable_rm_ha_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The YARN service name. (required)
        :param ApiEnableRmHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.enable_rm_ha_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.enable_rm_ha_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def enable_rm_ha_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Enable high availability (HA) for a YARN ResourceManager.
        Enable high availability (HA) for a YARN ResourceManager. <p> This command only applies to CDH5+ YARN services. <p> The command will create a new ResourceManager on the specified host and then create an active/standby pair with the existing ResourceManager. Autofailover will be enabled using ZooKeeper. <p> As part of enabling HA, any services that depends on the YARN service being modified will be stopped. Command will redeploy the client configurations for services of the cluster after HA has been enabled.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enable_rm_ha_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The YARN service name. (required)
        :param ApiEnableRmHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_rm_ha_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `enable_rm_ha_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `enable_rm_ha_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/enableRmHa', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def enable_sentry_ha_command(self, cluster_name, service_name, **kwargs):
        """
        Enable high availability (HA) for Sentry service.
        Enable high availability (HA) for Sentry service. <p> This command only applies to CDH 5.13+ Sentry services. <p> The command will create a new Sentry server on the specified host and set the ZooKeeper configs needed for Sentry HA. <p> As part of enabling HA, all services that depend on HDFS will be restarted after enabling Sentry HA. <p> Note: Sentry doesn't support Rolling Restart.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enable_sentry_ha_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the Sentry service name. (required)
        :param ApiEnableSentryHaArgs body: An instance of ApiEnableSentryHaArgs representing the arguments to the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.enable_sentry_ha_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.enable_sentry_ha_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def enable_sentry_ha_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Enable high availability (HA) for Sentry service.
        Enable high availability (HA) for Sentry service. <p> This command only applies to CDH 5.13+ Sentry services. <p> The command will create a new Sentry server on the specified host and set the ZooKeeper configs needed for Sentry HA. <p> As part of enabling HA, all services that depend on HDFS will be restarted after enabling Sentry HA. <p> Note: Sentry doesn't support Rolling Restart.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enable_sentry_ha_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the Sentry service name. (required)
        :param ApiEnableSentryHaArgs body: An instance of ApiEnableSentryHaArgs representing the arguments to the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_sentry_ha_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `enable_sentry_ha_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `enable_sentry_ha_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/enableSentryHa', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def enter_maintenance_mode(self, cluster_name, service_name, **kwargs):
        """
        Put the service into maintenance mode.
        Put the service into maintenance mode. This is a synchronous command. The result is known immediately upon return.  <p> Available since API v2. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enter_maintenance_mode(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.enter_maintenance_mode_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.enter_maintenance_mode_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def enter_maintenance_mode_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Put the service into maintenance mode.
        Put the service into maintenance mode. This is a synchronous command. The result is known immediately upon return.  <p> Available since API v2. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enter_maintenance_mode_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enter_maintenance_mode" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `enter_maintenance_mode`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `enter_maintenance_mode`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/enterMaintenanceMode', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def exit_maintenance_mode(self, cluster_name, service_name, **kwargs):
        """
        Take the service out of maintenance mode.
        Take the service out of maintenance mode. This is a synchronous command. The result is known immediately upon return.  <p> Available since API v2. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.exit_maintenance_mode(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.exit_maintenance_mode_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.exit_maintenance_mode_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def exit_maintenance_mode_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Take the service out of maintenance mode.
        Take the service out of maintenance mode. This is a synchronous command. The result is known immediately upon return.  <p> Available since API v2. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.exit_maintenance_mode_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exit_maintenance_mode" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `exit_maintenance_mode`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `exit_maintenance_mode`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/exitMaintenanceMode', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def first_run(self, cluster_name, service_name, **kwargs):
        """
        Prepare and start a service.
        Prepare and start a service.  <p> Perform all the steps needed to prepare the service and start it. </p>  <p> Available since API v7. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.first_run(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the cluster. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.first_run_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.first_run_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def first_run_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Prepare and start a service.
        Prepare and start a service.  <p> Perform all the steps needed to prepare the service and start it. </p>  <p> Available since API v7. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.first_run_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the cluster. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method first_run" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `first_run`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `first_run`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/firstRun', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_client_config(self, cluster_name, service_name, **kwargs):
        """
        Download a zip-compressed archive of the client configuration, of a specific service.
        Download a zip-compressed archive of the client configuration, of a specific service. This resource does not require any authentication.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_client_config(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_client_config_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.get_client_config_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def get_client_config_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Download a zip-compressed archive of the client configuration, of a specific service.
        Download a zip-compressed archive of the client configuration, of a specific service. This resource does not require any authentication.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_client_config_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_client_config`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_client_config`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/octet-stream'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/clientConfig', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_hdfs_usage_report(self, cluster_name, service_name, **kwargs):
        """
        Fetch the HDFS usage report.
        Fetch the HDFS usage report. For the requested time range, at the specified aggregation intervals, the report shows HDFS disk usages per user. <p> This call supports returning JSON or CSV, as determined by the \"Accept\" header of application/json or text/csv. <p> Available since API v4. Only available with Cloudera Manager Enterprise Edition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_hdfs_usage_report(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param str aggregation: The (optional) aggregation period for the data. Supports \"hourly\", \"daily\" (default) and \"weekly\".
        :param str _from: The (optional) start time of the report in ISO 8601 format ( defaults to 24 hours before \"to\" time).
        :param str nameservice: The (optional) HDFS nameservice. Required for HA setup.
        :param str to: The (optional) end time of the report in ISO 8601 format ( defaults to now).
        :return: ApiHdfsUsageReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_hdfs_usage_report_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.get_hdfs_usage_report_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def get_hdfs_usage_report_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Fetch the HDFS usage report.
        Fetch the HDFS usage report. For the requested time range, at the specified aggregation intervals, the report shows HDFS disk usages per user. <p> This call supports returning JSON or CSV, as determined by the \"Accept\" header of application/json or text/csv. <p> Available since API v4. Only available with Cloudera Manager Enterprise Edition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_hdfs_usage_report_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param str aggregation: The (optional) aggregation period for the data. Supports \"hourly\", \"daily\" (default) and \"weekly\".
        :param str _from: The (optional) start time of the report in ISO 8601 format ( defaults to 24 hours before \"to\" time).
        :param str nameservice: The (optional) HDFS nameservice. Required for HA setup.
        :param str to: The (optional) end time of the report in ISO 8601 format ( defaults to now).
        :return: ApiHdfsUsageReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'aggregation', '_from', 'nameservice', 'to']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hdfs_usage_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_hdfs_usage_report`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_hdfs_usage_report`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'aggregation' in params:
            query_params.append(('aggregation', params['aggregation']))
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'nameservice' in params:
            query_params.append(('nameservice', params['nameservice']))
        if 'to' in params:
            query_params.append(('to', params['to']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/csv', 'application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/reports/hdfsUsageReport', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiHdfsUsageReport',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_impala_utilization(self, cluster_name, service_name, **kwargs):
        """
        Provides the resource utilization of the Impala service as well as the resource utilization per tenant.
        Provides the resource utilization of the Impala service as well as the resource utilization per tenant. Only available with Cloudera Manager Enterprise Edition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_impala_utilization(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: service name (required)
        :param list[str] days_of_week: The days of the week for which the user wants to report utilization. Days is a list of number between 1 to 7, where 1 corresponds to Mon. and 7 corresponds to Sun. All 7 days are included if this is not specified.
        :param int end_hour_of_day: The end hour of a day for which the user wants to report utilization. The hour is a number between [0-23]. Default value is 23 if this is not specified.
        :param str _from: Start of the time range to report utilization in ISO 8601 format.
        :param int start_hour_of_day: The start hour of a day for which the user wants to report utilization. The hour is a number between [0-23]. Default value is 0 if this is not specified.
        :param str tenant_type: The type of the tenant (POOL or USER).
        :param str to: End of the the time range to report utilization in ISO 8601 format (defaults to now).
        :return: ApiImpalaUtilization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_impala_utilization_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.get_impala_utilization_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def get_impala_utilization_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Provides the resource utilization of the Impala service as well as the resource utilization per tenant.
        Provides the resource utilization of the Impala service as well as the resource utilization per tenant. Only available with Cloudera Manager Enterprise Edition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_impala_utilization_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: service name (required)
        :param list[str] days_of_week: The days of the week for which the user wants to report utilization. Days is a list of number between 1 to 7, where 1 corresponds to Mon. and 7 corresponds to Sun. All 7 days are included if this is not specified.
        :param int end_hour_of_day: The end hour of a day for which the user wants to report utilization. The hour is a number between [0-23]. Default value is 23 if this is not specified.
        :param str _from: Start of the time range to report utilization in ISO 8601 format.
        :param int start_hour_of_day: The start hour of a day for which the user wants to report utilization. The hour is a number between [0-23]. Default value is 0 if this is not specified.
        :param str tenant_type: The type of the tenant (POOL or USER).
        :param str to: End of the the time range to report utilization in ISO 8601 format (defaults to now).
        :return: ApiImpalaUtilization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'days_of_week', 'end_hour_of_day', '_from', 'start_hour_of_day', 'tenant_type', 'to']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_impala_utilization" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_impala_utilization`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_impala_utilization`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'days_of_week' in params:
            query_params.append(('daysOfWeek', params['days_of_week']))
            collection_formats['daysOfWeek'] = 'multi'
        if 'end_hour_of_day' in params:
            query_params.append(('endHourOfDay', params['end_hour_of_day']))
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'start_hour_of_day' in params:
            query_params.append(('startHourOfDay', params['start_hour_of_day']))
        if 'tenant_type' in params:
            query_params.append(('tenantType', params['tenant_type']))
        if 'to' in params:
            query_params.append(('to', params['to']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/impalaUtilization', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiImpalaUtilization',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_metrics(self, cluster_name, service_name, **kwargs):
        """
        Fetch metric readings for a particular service.
        Fetch metric readings for a particular service. <p> By default, this call will look up all metrics available for the service. If only specific metrics are desired, use the <i>metrics</i> parameter. <p> By default, the returned results correspond to a 5 minute window based on the provided end time (which defaults to the current server time). The <i>from</i> and <i>to</i> parameters can be used to control the window being queried. A maximum window of 3 hours is enforced. <p> When requesting a \"full\" view, aside from the extended properties of the returned metric data, the collection will also contain information about all metrics available for the service, even if no readings are available in the requested window. <p> HDFS services that have more than one nameservice will not expose any metrics. Instead, the nameservices should be queried separately. <p/>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_metrics(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service. (required)
        :param str _from: Start of the period to query.
        :param list[str] metrics: Filter for which metrics to query.
        :param str to: End of the period to query.
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiMetricList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_metrics_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.get_metrics_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def get_metrics_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Fetch metric readings for a particular service.
        Fetch metric readings for a particular service. <p> By default, this call will look up all metrics available for the service. If only specific metrics are desired, use the <i>metrics</i> parameter. <p> By default, the returned results correspond to a 5 minute window based on the provided end time (which defaults to the current server time). The <i>from</i> and <i>to</i> parameters can be used to control the window being queried. A maximum window of 3 hours is enforced. <p> When requesting a \"full\" view, aside from the extended properties of the returned metric data, the collection will also contain information about all metrics available for the service, even if no readings are available in the requested window. <p> HDFS services that have more than one nameservice will not expose any metrics. Instead, the nameservices should be queried separately. <p/>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_metrics_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service. (required)
        :param str _from: Start of the period to query.
        :param list[str] metrics: Filter for which metrics to query.
        :param str to: End of the period to query.
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiMetricList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', '_from', 'metrics', 'to', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_metrics`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_metrics`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'metrics' in params:
            query_params.append(('metrics', params['metrics']))
            collection_formats['metrics'] = 'multi'
        if 'to' in params:
            query_params.append(('to', params['to']))
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/metrics', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiMetricList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_mr_usage_report(self, cluster_name, service_name, **kwargs):
        """
        Fetch the MR usage report.
        Fetch the MR usage report. For the requested time range, at the specified aggregation intervals, the report shows job CPU usages (and other metrics) per user. <p> This call supports returning JSON or CSV, as determined by the \"Accept\" header of application/json or text/csv. <p> Available since API v4. Only available with Cloudera Manager Enterprise Edition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_mr_usage_report(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The MR service name. (required)
        :param str aggregation: The (optional) aggregation period for the data. Supports \"hourly\", \"daily\" (default) and \"weekly\".
        :param str _from: The (optional) start time of the report in ISO 8601 format (defaults to 24 hours before \"to\" time).
        :param str to: The (optional) end time of the report in ISO 8601 format (defaults to now).
        :return: ApiMrUsageReport
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_mr_usage_report_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.get_mr_usage_report_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def get_mr_usage_report_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Fetch the MR usage report.
        Fetch the MR usage report. For the requested time range, at the specified aggregation intervals, the report shows job CPU usages (and other metrics) per user. <p> This call supports returning JSON or CSV, as determined by the \"Accept\" header of application/json or text/csv. <p> Available since API v4. Only available with Cloudera Manager Enterprise Edition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_mr_usage_report_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The MR service name. (required)
        :param str aggregation: The (optional) aggregation period for the data. Supports \"hourly\", \"daily\" (default) and \"weekly\".
        :param str _from: The (optional) start time of the report in ISO 8601 format (defaults to 24 hours before \"to\" time).
        :param str to: The (optional) end time of the report in ISO 8601 format (defaults to now).
        :return: ApiMrUsageReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'aggregation', '_from', 'to']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mr_usage_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_mr_usage_report`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_mr_usage_report`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'aggregation' in params:
            query_params.append(('aggregation', params['aggregation']))
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'to' in params:
            query_params.append(('to', params['to']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/csv', 'application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/reports/mrUsageReport', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiMrUsageReport',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_yarn_utilization(self, cluster_name, service_name, **kwargs):
        """
        Provides the resource utilization of the yarn service as well as the resource utilization per tenant.
        Provides the resource utilization of the yarn service as well as the resource utilization per tenant. Only available with Cloudera Manager Enterprise Edition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_yarn_utilization(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: service name (required)
        :param list[str] days_of_week: The days of the week for which the user wants to report utilization. Days is a list of number between 1 to 7, where 1 corresponds to Mon. and 7 corresponds to Sun. All 7 days are included if this is not specified.
        :param int end_hour_of_day: The end hour of a day for which the user wants to report utilization. The hour is a number between [0-23]. Default value is 23 if this is not specified.
        :param str _from: Start of the time range to report utilization in ISO 8601 format.
        :param int start_hour_of_day: The start hour of a day for which the user wants to report utilization. The hour is a number between [0-23]. Default value is 0 if this is not specified.
        :param str tenant_type: The type of the tenant (POOL or USER).
        :param str to: End of the the time range to report utilization in ISO 8601 format (defaults to now).
        :return: ApiYarnUtilization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_yarn_utilization_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.get_yarn_utilization_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def get_yarn_utilization_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Provides the resource utilization of the yarn service as well as the resource utilization per tenant.
        Provides the resource utilization of the yarn service as well as the resource utilization per tenant. Only available with Cloudera Manager Enterprise Edition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_yarn_utilization_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: service name (required)
        :param list[str] days_of_week: The days of the week for which the user wants to report utilization. Days is a list of number between 1 to 7, where 1 corresponds to Mon. and 7 corresponds to Sun. All 7 days are included if this is not specified.
        :param int end_hour_of_day: The end hour of a day for which the user wants to report utilization. The hour is a number between [0-23]. Default value is 23 if this is not specified.
        :param str _from: Start of the time range to report utilization in ISO 8601 format.
        :param int start_hour_of_day: The start hour of a day for which the user wants to report utilization. The hour is a number between [0-23]. Default value is 0 if this is not specified.
        :param str tenant_type: The type of the tenant (POOL or USER).
        :param str to: End of the the time range to report utilization in ISO 8601 format (defaults to now).
        :return: ApiYarnUtilization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'days_of_week', 'end_hour_of_day', '_from', 'start_hour_of_day', 'tenant_type', 'to']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_yarn_utilization" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_yarn_utilization`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_yarn_utilization`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'days_of_week' in params:
            query_params.append(('daysOfWeek', params['days_of_week']))
            collection_formats['daysOfWeek'] = 'multi'
        if 'end_hour_of_day' in params:
            query_params.append(('endHourOfDay', params['end_hour_of_day']))
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'start_hour_of_day' in params:
            query_params.append(('startHourOfDay', params['start_hour_of_day']))
        if 'tenant_type' in params:
            query_params.append(('tenantType', params['tenant_type']))
        if 'to' in params:
            query_params.append(('to', params['to']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/yarnUtilization', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiYarnUtilization',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hbase_shell_command(self, cluster_name, service_name, **kwargs):
        """
        Execute a hbase shell command.
        Execute a hbase shell command
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hbase_shell_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HBase service name (required)
        :param ApiHBaseShellCommand body: hbase shell command to be executed
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hbase_shell_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hbase_shell_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hbase_shell_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Execute a hbase shell command.
        Execute a hbase shell command
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hbase_shell_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HBase service name (required)
        :param ApiHBaseShellCommand body: hbase shell command to be executed
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hbase_shell_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hbase_shell_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hbase_shell_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hbaseShellCommand', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hbase_upgrade_command(self, cluster_name, service_name, **kwargs):
        """
        Upgrade HBase data in HDFS and ZooKeeper as part of upgrade from CDH4 to CDH5.
        Upgrade HBase data in HDFS and ZooKeeper as part of upgrade from CDH4 to CDH5. <p/> This is required in order to run HBase after upgrade. <p/> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hbase_upgrade_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HBase service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hbase_upgrade_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hbase_upgrade_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hbase_upgrade_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Upgrade HBase data in HDFS and ZooKeeper as part of upgrade from CDH4 to CDH5.
        Upgrade HBase data in HDFS and ZooKeeper as part of upgrade from CDH4 to CDH5. <p/> This is required in order to run HBase after upgrade. <p/> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hbase_upgrade_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HBase service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hbase_upgrade_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hbase_upgrade_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hbase_upgrade_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hbaseUpgrade', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hdfs_create_tmp_dir(self, cluster_name, service_name, **kwargs):
        """
        Creates a tmp directory on the HDFS filesystem.
        Creates a tmp directory on the HDFS filesystem. <p> Available since API v2. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_create_tmp_dir(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the HDFS service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hdfs_create_tmp_dir_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hdfs_create_tmp_dir_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hdfs_create_tmp_dir_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Creates a tmp directory on the HDFS filesystem.
        Creates a tmp directory on the HDFS filesystem. <p> Available since API v2. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_create_tmp_dir_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the HDFS service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hdfs_create_tmp_dir" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hdfs_create_tmp_dir`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hdfs_create_tmp_dir`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hdfsCreateTmpDir', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hdfs_disable_auto_failover_command(self, cluster_name, service_name, **kwargs):
        """
        Disable auto-failover for a highly available HDFS nameservice.
        Disable auto-failover for a highly available HDFS nameservice. <p> The command will modify the nameservice's NameNodes configuration to disable automatic failover, and delete the existing failover controllers. <p> The ZooKeeper dependency of the service will not be removed.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_disable_auto_failover_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param str body: The nameservice name.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hdfs_disable_auto_failover_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hdfs_disable_auto_failover_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hdfs_disable_auto_failover_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Disable auto-failover for a highly available HDFS nameservice.
        Disable auto-failover for a highly available HDFS nameservice. <p> The command will modify the nameservice's NameNodes configuration to disable automatic failover, and delete the existing failover controllers. <p> The ZooKeeper dependency of the service will not be removed.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_disable_auto_failover_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param str body: The nameservice name.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hdfs_disable_auto_failover_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hdfs_disable_auto_failover_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hdfs_disable_auto_failover_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['text/plain', 'application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hdfsDisableAutoFailover', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hdfs_disable_ha_command(self, cluster_name, service_name, **kwargs):
        """
        Disable high availability (HA) for an HDFS NameNode.
        Disable high availability (HA) for an HDFS NameNode. <p> The NameNode to be kept must be running before HA can be disabled. <p> As part of disabling HA, any services that depend on the HDFS service being modified will be stopped. The command arguments provide options to re-start these services and to re-deploy the client configurations for services of the cluster after HA has been disabled.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_disable_ha_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param ApiHdfsDisableHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hdfs_disable_ha_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hdfs_disable_ha_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hdfs_disable_ha_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Disable high availability (HA) for an HDFS NameNode.
        Disable high availability (HA) for an HDFS NameNode. <p> The NameNode to be kept must be running before HA can be disabled. <p> As part of disabling HA, any services that depend on the HDFS service being modified will be stopped. The command arguments provide options to re-start these services and to re-deploy the client configurations for services of the cluster after HA has been disabled.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_disable_ha_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param ApiHdfsDisableHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hdfs_disable_ha_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hdfs_disable_ha_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hdfs_disable_ha_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hdfsDisableHa', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hdfs_disable_nn_ha_command(self, cluster_name, service_name, **kwargs):
        """
        Disable High Availability (HA) with Automatic Failover for an HDFS NameNode.
        Disable High Availability (HA) with Automatic Failover for an HDFS NameNode. <p> As part of disabling HA, any services that depend on the HDFS service being modified will be stopped. The command will delete the Standby NameNode associated with the specified NameNode. Any FailoverControllers associated with the NameNode's nameservice are also deleted. A SecondaryNameNode is created on the host specified by the arugments. <p> If no nameservices uses Quorum Journal after HA is disabled for the specified nameservice, then all JournalNodes are also deleted. <p> Then, HDFS service is restarted and all services that were stopped are started again afterwards. Finally, client configs for HDFS and its depedents will be re-deployed.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_disable_nn_ha_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param ApiDisableNnHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hdfs_disable_nn_ha_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hdfs_disable_nn_ha_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hdfs_disable_nn_ha_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Disable High Availability (HA) with Automatic Failover for an HDFS NameNode.
        Disable High Availability (HA) with Automatic Failover for an HDFS NameNode. <p> As part of disabling HA, any services that depend on the HDFS service being modified will be stopped. The command will delete the Standby NameNode associated with the specified NameNode. Any FailoverControllers associated with the NameNode's nameservice are also deleted. A SecondaryNameNode is created on the host specified by the arugments. <p> If no nameservices uses Quorum Journal after HA is disabled for the specified nameservice, then all JournalNodes are also deleted. <p> Then, HDFS service is restarted and all services that were stopped are started again afterwards. Finally, client configs for HDFS and its depedents will be re-deployed.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_disable_nn_ha_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param ApiDisableNnHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hdfs_disable_nn_ha_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hdfs_disable_nn_ha_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hdfs_disable_nn_ha_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hdfsDisableNnHa', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hdfs_enable_auto_failover_command(self, cluster_name, service_name, **kwargs):
        """
        Enable auto-failover for an HDFS nameservice.
        Enable auto-failover for an HDFS nameservice. <p> This command requires that the nameservice exists, and HA has been configured for that nameservice. <p> The command will create the needed failover controllers, perform the needed initialization and configuration, and will start the new roles. The existing NameNodes which are part of the nameservice will be re-started in the process. <p> This process may require changing the service's configuration, to add a dependency on the provided ZooKeeper service. This will be done if such a dependency has not been configured yet, and will cause roles that are not affected by this command to show an \"outdated configuration\" status. <p> If a ZooKeeper dependency has already been set up by some other means, it does not need to be provided in the command arguments.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_enable_auto_failover_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param ApiHdfsFailoverArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hdfs_enable_auto_failover_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hdfs_enable_auto_failover_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hdfs_enable_auto_failover_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Enable auto-failover for an HDFS nameservice.
        Enable auto-failover for an HDFS nameservice. <p> This command requires that the nameservice exists, and HA has been configured for that nameservice. <p> The command will create the needed failover controllers, perform the needed initialization and configuration, and will start the new roles. The existing NameNodes which are part of the nameservice will be re-started in the process. <p> This process may require changing the service's configuration, to add a dependency on the provided ZooKeeper service. This will be done if such a dependency has not been configured yet, and will cause roles that are not affected by this command to show an \"outdated configuration\" status. <p> If a ZooKeeper dependency has already been set up by some other means, it does not need to be provided in the command arguments.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_enable_auto_failover_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param ApiHdfsFailoverArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hdfs_enable_auto_failover_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hdfs_enable_auto_failover_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hdfs_enable_auto_failover_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hdfsEnableAutoFailover', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hdfs_enable_ha_command(self, cluster_name, service_name, **kwargs):
        """
        Enable high availability (HA) for an HDFS NameNode.
        Enable high availability (HA) for an HDFS NameNode. <p> The command will set up the given \"active\" and \"stand-by\" NameNodes as an HA pair. Both nodes need to already exist. <p> If there is a SecondaryNameNode associated with either given NameNode instance, it will be deleted. <p> Note that while the shared edits path may be different for both nodes, they need to point to the same underlying storage (e.g., an NFS share). <p> As part of enabling HA, any services that depend on the HDFS service being modified will be stopped. The command arguments provide options to re-start these services and to re-deploy the client configurations for services of the cluster after HA has been enabled.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_enable_ha_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param ApiHdfsHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hdfs_enable_ha_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hdfs_enable_ha_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hdfs_enable_ha_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Enable high availability (HA) for an HDFS NameNode.
        Enable high availability (HA) for an HDFS NameNode. <p> The command will set up the given \"active\" and \"stand-by\" NameNodes as an HA pair. Both nodes need to already exist. <p> If there is a SecondaryNameNode associated with either given NameNode instance, it will be deleted. <p> Note that while the shared edits path may be different for both nodes, they need to point to the same underlying storage (e.g., an NFS share). <p> As part of enabling HA, any services that depend on the HDFS service being modified will be stopped. The command arguments provide options to re-start these services and to re-deploy the client configurations for services of the cluster after HA has been enabled.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_enable_ha_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param ApiHdfsHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hdfs_enable_ha_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hdfs_enable_ha_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hdfs_enable_ha_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hdfsEnableHa', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hdfs_enable_nn_ha_command(self, cluster_name, service_name, **kwargs):
        """
        Enable High Availability (HA) with Automatic Failover for an HDFS NameNode.
        Enable High Availability (HA) with Automatic Failover for an HDFS NameNode. <p> The command will create a Standby NameNode for the given nameservice and create FailoverControllers for both Active and Standby NameNodes. The SecondaryNameNode associated with the Active NameNode will be deleted. <p> The command will also create JournalNodes needed for HDFS HA if they do not already exist. <p> As part of enabling HA, any services that depend on the HDFS service being modified will be stopped. They will be restarted after HA has been enabled. Finally, client configs for HDFS and its depedents will be re-deployed.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_enable_nn_ha_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param ApiEnableNnHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hdfs_enable_nn_ha_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hdfs_enable_nn_ha_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hdfs_enable_nn_ha_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Enable High Availability (HA) with Automatic Failover for an HDFS NameNode.
        Enable High Availability (HA) with Automatic Failover for an HDFS NameNode. <p> The command will create a Standby NameNode for the given nameservice and create FailoverControllers for both Active and Standby NameNodes. The SecondaryNameNode associated with the Active NameNode will be deleted. <p> The command will also create JournalNodes needed for HDFS HA if they do not already exist. <p> As part of enabling HA, any services that depend on the HDFS service being modified will be stopped. They will be restarted after HA has been enabled. Finally, client configs for HDFS and its depedents will be re-deployed.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_enable_nn_ha_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param ApiEnableNnHaArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hdfs_enable_nn_ha_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hdfs_enable_nn_ha_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hdfs_enable_nn_ha_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hdfsEnableNnHa', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hdfs_failover_command(self, cluster_name, service_name, **kwargs):
        """
        Initiate a failover in an HDFS HA NameNode pair.
        Initiate a failover in an HDFS HA NameNode pair. <p> The arguments should contain the names of the two NameNodes in the HA pair. The first one should be the currently active NameNode, the second one the NameNode to be made active.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_failover_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param bool force: Whether to force failover.
        :param ApiRoleNameList body: Names of the NameNodes in the HA pair.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hdfs_failover_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hdfs_failover_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hdfs_failover_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Initiate a failover in an HDFS HA NameNode pair.
        Initiate a failover in an HDFS HA NameNode pair. <p> The arguments should contain the names of the two NameNodes in the HA pair. The first one should be the currently active NameNode, the second one the NameNode to be made active.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_failover_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param bool force: Whether to force failover.
        :param ApiRoleNameList body: Names of the NameNodes in the HA pair.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'force', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hdfs_failover_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hdfs_failover_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hdfs_failover_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hdfsFailover', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hdfs_finalize_rolling_upgrade(self, cluster_name, service_name, **kwargs):
        """
        Finalizes the rolling upgrade for HDFS by updating the NameNode metadata permanently to the next version.
        Finalizes the rolling upgrade for HDFS by updating the NameNode metadata permanently to the next version. Should be done after doing a rolling upgrade to a CDH version >= 5.2.0. <p> Available since API v8.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_finalize_rolling_upgrade(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hdfs_finalize_rolling_upgrade_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hdfs_finalize_rolling_upgrade_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hdfs_finalize_rolling_upgrade_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Finalizes the rolling upgrade for HDFS by updating the NameNode metadata permanently to the next version.
        Finalizes the rolling upgrade for HDFS by updating the NameNode metadata permanently to the next version. Should be done after doing a rolling upgrade to a CDH version >= 5.2.0. <p> Available since API v8.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_finalize_rolling_upgrade_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hdfs_finalize_rolling_upgrade" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hdfs_finalize_rolling_upgrade`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hdfs_finalize_rolling_upgrade`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hdfsFinalizeRollingUpgrade', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hdfs_roll_edits_command(self, cluster_name, service_name, **kwargs):
        """
        Roll the edits of an HDFS NameNode or Nameservice.
        Roll the edits of an HDFS NameNode or Nameservice. <p> Available since API v3.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_roll_edits_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param ApiRollEditsArgs body: Arguments to the Roll Edits command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hdfs_roll_edits_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hdfs_roll_edits_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hdfs_roll_edits_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Roll the edits of an HDFS NameNode or Nameservice.
        Roll the edits of an HDFS NameNode or Nameservice. <p> Available since API v3.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_roll_edits_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :param ApiRollEditsArgs body: Arguments to the Roll Edits command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hdfs_roll_edits_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hdfs_roll_edits_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hdfs_roll_edits_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hdfsRollEdits', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hdfs_upgrade_metadata_command(self, cluster_name, service_name, **kwargs):
        """
        Upgrade HDFS Metadata as part of a major version upgrade.
        Upgrade HDFS Metadata as part of a major version upgrade. <p/> When doing a major version upgrade for HDFS, it is necessary to start HDFS in a special mode where it will do any necessary upgrades of stored metadata. Trying to start HDFS normally will result in an error message and the NameNode(s) failing to start. <p/> The metadata upgrade must eventually be finalized, using the hdfsFinalizeMetadataUpgrade command on the NameNode. <p/> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_upgrade_metadata_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hdfs_upgrade_metadata_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hdfs_upgrade_metadata_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hdfs_upgrade_metadata_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Upgrade HDFS Metadata as part of a major version upgrade.
        Upgrade HDFS Metadata as part of a major version upgrade. <p/> When doing a major version upgrade for HDFS, it is necessary to start HDFS in a special mode where it will do any necessary upgrades of stored metadata. Trying to start HDFS normally will result in an error message and the NameNode(s) failing to start. <p/> The metadata upgrade must eventually be finalized, using the hdfsFinalizeMetadataUpgrade command on the NameNode. <p/> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hdfs_upgrade_metadata_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The HDFS service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hdfs_upgrade_metadata_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hdfs_upgrade_metadata_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hdfs_upgrade_metadata_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hdfsUpgradeMetadata', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hive_create_metastore_database_command(self, cluster_name, service_name, **kwargs):
        """
        Create the Hive Metastore Database.
        Create the Hive Metastore Database. Only works with embedded postgresql database. <p> This command is to be run whenever a new user and database needs to be created in the embedded postgresql database for a Hive service. This command should usually be followed by a call to hiveCreateMetastoreDatabaseTables. <p> Available since API v4.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hive_create_metastore_database_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Hive service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hive_create_metastore_database_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hive_create_metastore_database_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hive_create_metastore_database_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Create the Hive Metastore Database.
        Create the Hive Metastore Database. Only works with embedded postgresql database. <p> This command is to be run whenever a new user and database needs to be created in the embedded postgresql database for a Hive service. This command should usually be followed by a call to hiveCreateMetastoreDatabaseTables. <p> Available since API v4.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hive_create_metastore_database_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Hive service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hive_create_metastore_database_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hive_create_metastore_database_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hive_create_metastore_database_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hiveCreateMetastoreDatabase', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hive_create_metastore_database_tables_command(self, cluster_name, service_name, **kwargs):
        """
        Create the Hive Metastore Database tables.
        Create the Hive Metastore Database tables. <p> This command is to be run whenever a new database has been specified. Will do nothing if tables already exist. Will not perform an upgrade. Only Available when all Hive Metastore Servers are stopped. <p> Available since API v3.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hive_create_metastore_database_tables_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Hive service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hive_create_metastore_database_tables_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hive_create_metastore_database_tables_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hive_create_metastore_database_tables_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Create the Hive Metastore Database tables.
        Create the Hive Metastore Database tables. <p> This command is to be run whenever a new database has been specified. Will do nothing if tables already exist. Will not perform an upgrade. Only Available when all Hive Metastore Servers are stopped. <p> Available since API v3.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hive_create_metastore_database_tables_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Hive service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hive_create_metastore_database_tables_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hive_create_metastore_database_tables_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hive_create_metastore_database_tables_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hiveCreateMetastoreDatabaseTables', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hive_update_metastore_namenodes_command(self, cluster_name, service_name, **kwargs):
        """
        Update Hive Metastore to point to a NameNode's Nameservice name instead of hostname.
        Update Hive Metastore to point to a NameNode's Nameservice name instead of hostname. <p> <strong>Back up the Hive Metastore Database before running this command.</strong> <p> This command is to be run after enabling HDFS High Availability. Only available when all Hive Metastore Servers are stopped. <p> Available since API v4.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hive_update_metastore_namenodes_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Hive service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hive_update_metastore_namenodes_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hive_update_metastore_namenodes_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hive_update_metastore_namenodes_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Update Hive Metastore to point to a NameNode's Nameservice name instead of hostname.
        Update Hive Metastore to point to a NameNode's Nameservice name instead of hostname. <p> <strong>Back up the Hive Metastore Database before running this command.</strong> <p> This command is to be run after enabling HDFS High Availability. Only available when all Hive Metastore Servers are stopped. <p> Available since API v4.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hive_update_metastore_namenodes_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Hive service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hive_update_metastore_namenodes_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hive_update_metastore_namenodes_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hive_update_metastore_namenodes_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hiveUpdateMetastoreNamenodes', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hive_upgrade_metastore_command(self, cluster_name, service_name, **kwargs):
        """
        Upgrade Hive Metastore as part of a major version upgrade.
        Upgrade Hive Metastore as part of a major version upgrade. <p/> When doing a major version upgrade for Hive, it is necessary to upgrade data in the metastore database. <p/> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hive_upgrade_metastore_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Hive service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hive_upgrade_metastore_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hive_upgrade_metastore_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hive_upgrade_metastore_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Upgrade Hive Metastore as part of a major version upgrade.
        Upgrade Hive Metastore as part of a major version upgrade. <p/> When doing a major version upgrade for Hive, it is necessary to upgrade data in the metastore database. <p/> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hive_upgrade_metastore_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Hive service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hive_upgrade_metastore_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hive_upgrade_metastore_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hive_upgrade_metastore_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hiveUpgradeMetastore', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hive_validate_metastore_schema_command(self, cluster_name, service_name, **kwargs):
        """
        Validate the Hive Metastore Schema.
        Validate the Hive Metastore Schema. <p> This command checks the Hive metastore schema for any errors and corruptions. This command is to be run on two instances: <li>After the Hive Metastore database tables are created.</li> <li>Both before and after upgrading the Hive metastore database schema./li> * <p> Available since API v17.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hive_validate_metastore_schema_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Hive service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hive_validate_metastore_schema_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hive_validate_metastore_schema_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hive_validate_metastore_schema_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Validate the Hive Metastore Schema.
        Validate the Hive Metastore Schema. <p> This command checks the Hive metastore schema for any errors and corruptions. This command is to be run on two instances: <li>After the Hive Metastore database tables are created.</li> <li>Both before and after upgrading the Hive metastore database schema./li> * <p> Available since API v17.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hive_validate_metastore_schema_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Hive service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hive_validate_metastore_schema_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hive_validate_metastore_schema_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hive_validate_metastore_schema_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hiveValidateMetastoreSchema', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hue_dump_db_command(self, cluster_name, service_name, **kwargs):
        """
        Runs Hue's dumpdata command.
        Runs Hue's dumpdata command.  Available since API v10.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hue_dump_db_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hue_dump_db_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hue_dump_db_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hue_dump_db_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Runs Hue's dumpdata command.
        Runs Hue's dumpdata command.  Available since API v10.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hue_dump_db_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hue_dump_db_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hue_dump_db_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hue_dump_db_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hueDumpDb', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hue_load_db_command(self, cluster_name, service_name, **kwargs):
        """
        Runs Hue's loaddata command.
        Runs Hue's loaddata command.  Available since API v10.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hue_load_db_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hue_load_db_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hue_load_db_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hue_load_db_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Runs Hue's loaddata command.
        Runs Hue's loaddata command.  Available since API v10.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hue_load_db_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hue_load_db_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hue_load_db_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hue_load_db_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hueLoadDb', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def hue_sync_db_command(self, cluster_name, service_name, **kwargs):
        """
        Runs Hue's syncdb command.
        Runs Hue's syncdb command.  Available since API v10.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hue_sync_db_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.hue_sync_db_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.hue_sync_db_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def hue_sync_db_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Runs Hue's syncdb command.
        Runs Hue's syncdb command.  Available since API v10.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.hue_sync_db_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hue_sync_db_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `hue_sync_db_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `hue_sync_db_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/hueSyncDb', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def impala_create_catalog_database_command(self, cluster_name, service_name, **kwargs):
        """
        .
        <strong>Not needed in CM 5.0.0 Release, since Impala Catalog Database is not yet available in CDH as of this release.</strong> Create the Impala Catalog Database. Only works with embedded postgresql database. <p> This command is to be run whenever a new user and database needs to be created in the embedded postgresql database for the Impala Catalog Server. This command should usually be followed by a call to impalaCreateCatalogDatabaseTables. <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.impala_create_catalog_database_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Impala service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.impala_create_catalog_database_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.impala_create_catalog_database_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def impala_create_catalog_database_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        .
        <strong>Not needed in CM 5.0.0 Release, since Impala Catalog Database is not yet available in CDH as of this release.</strong> Create the Impala Catalog Database. Only works with embedded postgresql database. <p> This command is to be run whenever a new user and database needs to be created in the embedded postgresql database for the Impala Catalog Server. This command should usually be followed by a call to impalaCreateCatalogDatabaseTables. <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.impala_create_catalog_database_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Impala service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method impala_create_catalog_database_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `impala_create_catalog_database_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `impala_create_catalog_database_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/impalaCreateCatalogDatabase', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def impala_create_catalog_database_tables_command(self, cluster_name, service_name, **kwargs):
        """
        .
        <strong>Not needed in CM 5.0.0 Release, since Impala Catalog Database is not yet available in CDH as of this release.</strong> Create the Impala Catalog Database tables. <p> This command is to be run whenever a new database has been specified. Will do nothing if tables already exist. Will not perform an upgrade. Only available when all Impala Catalog Servers are stopped. <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.impala_create_catalog_database_tables_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Impala service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.impala_create_catalog_database_tables_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.impala_create_catalog_database_tables_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def impala_create_catalog_database_tables_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        .
        <strong>Not needed in CM 5.0.0 Release, since Impala Catalog Database is not yet available in CDH as of this release.</strong> Create the Impala Catalog Database tables. <p> This command is to be run whenever a new database has been specified. Will do nothing if tables already exist. Will not perform an upgrade. Only available when all Impala Catalog Servers are stopped. <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.impala_create_catalog_database_tables_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Impala service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method impala_create_catalog_database_tables_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `impala_create_catalog_database_tables_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `impala_create_catalog_database_tables_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/impalaCreateCatalogDatabaseTables', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def import_mr_configs_into_yarn(self, cluster_name, service_name, **kwargs):
        """
        Import MapReduce configuration into Yarn, overwriting Yarn configuration.
        Import MapReduce configuration into Yarn, overwriting Yarn configuration. <p> You will lose existing Yarn configuration. Read all MapReduce configuration, role assignments, and role configuration groups and update Yarn with corresponding values. MR1 configuration will be converted into the equivalent MR2 configuration. <p> Before running this command, Yarn must be stopped and MapReduce must exist with valid configuration. <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_mr_configs_into_yarn(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Yarn service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.import_mr_configs_into_yarn_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.import_mr_configs_into_yarn_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def import_mr_configs_into_yarn_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Import MapReduce configuration into Yarn, overwriting Yarn configuration.
        Import MapReduce configuration into Yarn, overwriting Yarn configuration. <p> You will lose existing Yarn configuration. Read all MapReduce configuration, role assignments, and role configuration groups and update Yarn with corresponding values. MR1 configuration will be converted into the equivalent MR2 configuration. <p> Before running this command, Yarn must be stopped and MapReduce must exist with valid configuration. <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_mr_configs_into_yarn_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Yarn service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_mr_configs_into_yarn" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `import_mr_configs_into_yarn`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `import_mr_configs_into_yarn`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/importMrConfigsIntoYarn', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def init_solr_command(self, cluster_name, service_name, **kwargs):
        """
        Initializes the Solr service in Zookeeper.
        Initializes the Solr service in Zookeeper.  <p> Available since API v4.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.init_solr_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Solr service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.init_solr_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.init_solr_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def init_solr_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Initializes the Solr service in Zookeeper.
        Initializes the Solr service in Zookeeper.  <p> Available since API v4.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.init_solr_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Solr service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method init_solr_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `init_solr_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `init_solr_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/initSolr', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def install_mr_framework_jars(self, cluster_name, service_name, **kwargs):
        """
        Creates an HDFS directory to hold the MapReduce2 framework JARs (if necessary), and uploads the framework JARs to it.
        Creates an HDFS directory to hold the MapReduce2 framework JARs (if necessary), and uploads the framework JARs to it. <p> This command is run automatically when starting a YARN service for the first time, or when upgrading an existing YARN service. It can also be run manually to ensure that the latest version of the framework JARS is installed. <p> Available since API v30. <p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.install_mr_framework_jars(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the YARN service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.install_mr_framework_jars_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.install_mr_framework_jars_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def install_mr_framework_jars_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Creates an HDFS directory to hold the MapReduce2 framework JARs (if necessary), and uploads the framework JARs to it.
        Creates an HDFS directory to hold the MapReduce2 framework JARs (if necessary), and uploads the framework JARs to it. <p> This command is run automatically when starting a YARN service for the first time, or when upgrading an existing YARN service. It can also be run manually to ensure that the latest version of the framework JARS is installed. <p> Available since API v30. <p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.install_mr_framework_jars_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the YARN service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method install_mr_framework_jars" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `install_mr_framework_jars`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `install_mr_framework_jars`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/installMrFrameworkJars', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def install_oozie_share_lib(self, cluster_name, service_name, **kwargs):
        """
        Creates directory for Oozie user in HDFS and installs the ShareLib in it.
        Creates directory for Oozie user in HDFS and installs the ShareLib in it. <p/> This command should be re-run after a major version upgrade to refresh the ShareLib to the latest version. <p/> Available since API v3. <p/>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.install_oozie_share_lib(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Oozie service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.install_oozie_share_lib_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.install_oozie_share_lib_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def install_oozie_share_lib_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Creates directory for Oozie user in HDFS and installs the ShareLib in it.
        Creates directory for Oozie user in HDFS and installs the ShareLib in it. <p/> This command should be re-run after a major version upgrade to refresh the ShareLib to the latest version. <p/> Available since API v3. <p/>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.install_oozie_share_lib_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Oozie service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method install_oozie_share_lib" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `install_oozie_share_lib`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `install_oozie_share_lib`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/installOozieShareLib', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def ks_migrate_to_sentry(self, cluster_name, service_name, **kwargs):
        """
        Migrates the HBase Indexer policy-based permissions to Sentry, by invoking the SentryConfigToolIndexer.
        Migrates the HBase Indexer policy-based permissions to Sentry, by invoking the SentryConfigToolIndexer. <p> Note: <li> <ul>KeyStore Indexer service should be in Stopped state.</ul> <ul>This is only needed for upgrading to CDH6.0.</ul> <p> Available since API v30.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.ks_migrate_to_sentry(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the KeyStore Indexer service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.ks_migrate_to_sentry_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.ks_migrate_to_sentry_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def ks_migrate_to_sentry_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Migrates the HBase Indexer policy-based permissions to Sentry, by invoking the SentryConfigToolIndexer.
        Migrates the HBase Indexer policy-based permissions to Sentry, by invoking the SentryConfigToolIndexer. <p> Note: <li> <ul>KeyStore Indexer service should be in Stopped state.</ul> <ul>This is only needed for upgrading to CDH6.0.</ul> <p> Available since API v30.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.ks_migrate_to_sentry_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the KeyStore Indexer service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ks_migrate_to_sentry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `ks_migrate_to_sentry`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `ks_migrate_to_sentry`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/migrateToSentry', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_active_commands(self, cluster_name, service_name, **kwargs):
        """
        List active service commands.
        List active service commands.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_active_commands(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to which the role belongs. (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiCommandList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_active_commands_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.list_active_commands_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def list_active_commands_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        List active service commands.
        List active service commands.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_active_commands_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to which the role belongs. (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiCommandList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_active_commands" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `list_active_commands`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `list_active_commands`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommandList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_role_types(self, cluster_name, service_name, **kwargs):
        """
        List the supported role types for a service.
        List the supported role types for a service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_role_types(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to modify. (required)
        :return: ApiRoleTypeList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_role_types_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.list_role_types_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def list_role_types_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        List the supported role types for a service.
        List the supported role types for a service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_role_types_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to modify. (required)
        :return: ApiRoleTypeList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_role_types" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `list_role_types`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `list_role_types`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/roleTypes', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiRoleTypeList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_service_commands(self, cluster_name, service_name, **kwargs):
        """
        Lists all the commands that can be executed by name on the provided service.
        Lists all the commands that can be executed by name on the provided service.  <p> Available since API v6. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_service_commands(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :return: ApiCommandMetadataList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_service_commands_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.list_service_commands_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def list_service_commands_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Lists all the commands that can be executed by name on the provided service.
        Lists all the commands that can be executed by name on the provided service.  <p> Available since API v6. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_service_commands_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :return: ApiCommandMetadataList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_service_commands" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `list_service_commands`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `list_service_commands`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commandsByName', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommandMetadataList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def offline_command(self, cluster_name, service_name, **kwargs):
        """
        Offline roles of a service.
        Offline roles of a service. <p> Currently the offline operation is only supported by HDFS. <p> For HDFS, the offline operation will put DataNodes into <em>HDFS IN MAINTENANCE</em> state which prevents unnecessary re-replication which could occur if decommissioned. <p> The <em>timeout</em> parameter is used to specify a timeout for offline. For HDFS, when the timeout expires, the DataNode will automatically transition out of <em>HDFS IN MAINTENANCE</em> state, back to <em>HDFS IN SERVICE</em> state. <p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.offline_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :param int timeout: Offline timeout in seconds. Offlined roles will automatically transition from offline state to normal state after timeout. Specify as null to get the default timeout (4 hours).
        :param ApiRoleNameList body: List of role names to offline.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.offline_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.offline_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def offline_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Offline roles of a service.
        Offline roles of a service. <p> Currently the offline operation is only supported by HDFS. <p> For HDFS, the offline operation will put DataNodes into <em>HDFS IN MAINTENANCE</em> state which prevents unnecessary re-replication which could occur if decommissioned. <p> The <em>timeout</em> parameter is used to specify a timeout for offline. For HDFS, when the timeout expires, the DataNode will automatically transition out of <em>HDFS IN MAINTENANCE</em> state, back to <em>HDFS IN SERVICE</em> state. <p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.offline_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :param int timeout: Offline timeout in seconds. Offlined roles will automatically transition from offline state to normal state after timeout. Specify as null to get the default timeout (4 hours).
        :param ApiRoleNameList body: List of role names to offline.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'timeout', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method offline_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `offline_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `offline_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/offline', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def oozie_create_embedded_database_command(self, cluster_name, service_name, **kwargs):
        """
        Create the Oozie Server Database.
        Create the Oozie Server Database. Only works with embedded postgresql database. <p> This command is to be run whenever a new user and database need to be created in the embedded postgresql database for an Oozie service. This command should usually be followed by a call to createOozieDb. <p> Available since API v10.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.oozie_create_embedded_database_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Oozie service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.oozie_create_embedded_database_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.oozie_create_embedded_database_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def oozie_create_embedded_database_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Create the Oozie Server Database.
        Create the Oozie Server Database. Only works with embedded postgresql database. <p> This command is to be run whenever a new user and database need to be created in the embedded postgresql database for an Oozie service. This command should usually be followed by a call to createOozieDb. <p> Available since API v10.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.oozie_create_embedded_database_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Oozie service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method oozie_create_embedded_database_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `oozie_create_embedded_database_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `oozie_create_embedded_database_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/oozieCreateEmbeddedDatabase', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def oozie_dump_database_command(self, cluster_name, service_name, **kwargs):
        """
        Dump the Oozie Server Database.
        Dump the Oozie Server Database.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.oozie_dump_database_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.oozie_dump_database_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.oozie_dump_database_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def oozie_dump_database_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Dump the Oozie Server Database.
        Dump the Oozie Server Database.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.oozie_dump_database_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method oozie_dump_database_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `oozie_dump_database_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `oozie_dump_database_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/oozieDumpDatabase', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def oozie_load_database_command(self, cluster_name, service_name, **kwargs):
        """
        Load the Oozie Server Database from dump.
        Load the Oozie Server Database from dump.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.oozie_load_database_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.oozie_load_database_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.oozie_load_database_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def oozie_load_database_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Load the Oozie Server Database from dump.
        Load the Oozie Server Database from dump.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.oozie_load_database_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method oozie_load_database_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `oozie_load_database_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `oozie_load_database_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/oozieLoadDatabase', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def oozie_upgrade_db_command(self, cluster_name, service_name, **kwargs):
        """
        Upgrade Oozie Database schema as part of a major version upgrade.
        Upgrade Oozie Database schema as part of a major version upgrade. <p/> When doing a major version upgrade for Oozie, it is necessary to upgrade the schema of its database before Oozie can run successfully. <p/> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.oozie_upgrade_db_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Oozie service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.oozie_upgrade_db_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.oozie_upgrade_db_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def oozie_upgrade_db_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Upgrade Oozie Database schema as part of a major version upgrade.
        Upgrade Oozie Database schema as part of a major version upgrade. <p/> When doing a major version upgrade for Oozie, it is necessary to upgrade the schema of its database before Oozie can run successfully. <p/> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.oozie_upgrade_db_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Oozie service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method oozie_upgrade_db_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `oozie_upgrade_db_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `oozie_upgrade_db_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/oozieUpgradeDb', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_service(self, cluster_name, service_name, **kwargs):
        """
        Retrieves details information about a service.
        Retrieves details information about a service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_service(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :param str view: DataView to materialize. Defaults to 'full'.
        :return: ApiService
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_service_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.read_service_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def read_service_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Retrieves details information about a service.
        Retrieves details information about a service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_service_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :param str view: DataView to materialize. Defaults to 'full'.
        :return: ApiService
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_service" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `read_service`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `read_service`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiService',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_service_config(self, cluster_name, service_name, **kwargs):
        """
        Retrieves the configuration of a specific service.
        Retrieves the configuration of a specific service. <p> The \"summary\" view contains only the configured parameters, and configuration for role types that contain configured parameters. <p> The \"full\" view contains all available configuration parameters for the service and its role types. This mode performs validation on the configuration, which could take a few seconds on a large cluster (around 500 nodes or more).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_service_config(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to query. (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiServiceConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_service_config_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.read_service_config_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def read_service_config_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Retrieves the configuration of a specific service.
        Retrieves the configuration of a specific service. <p> The \"summary\" view contains only the configured parameters, and configuration for role types that contain configured parameters. <p> The \"full\" view contains all available configuration parameters for the service and its role types. This mode performs validation on the configuration, which could take a few seconds on a large cluster (around 500 nodes or more).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_service_config_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to query. (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiServiceConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_service_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `read_service_config`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `read_service_config`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/config', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiServiceConfig',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_services(self, cluster_name, **kwargs):
        """
        Lists all services registered in the cluster.
        Lists all services registered in the cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_services(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str view: 
        :return: ApiServiceList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_services_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.read_services_with_http_info(cluster_name, **kwargs)
            return data

    def read_services_with_http_info(self, cluster_name, **kwargs):
        """
        Lists all services registered in the cluster.
        Lists all services registered in the cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_services_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str view: 
        :return: ApiServiceList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_services" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `read_services`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiServiceList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_tags(self, cluster_name, service_name, **kwargs):
        """
        Returns the tags associated with this service.
        Returns the tags associated with this service. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_tags(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service (required)
        :param int limit: Number of tags
        :param int offset: Index of the first tag to retrieve
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_tags_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.read_tags_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def read_tags_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Returns the tags associated with this service.
        Returns the tags associated with this service. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_tags_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The name of the service (required)
        :param int limit: Number of tags
        :param int offset: Index of the first tag to retrieve
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'limit', 'offset']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `read_tags`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `read_tags`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/tags', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ApiEntityTag]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def recommission_command(self, cluster_name, service_name, **kwargs):
        """
        Recommission roles of a service.
        Recommission roles of a service. <p> The list should contain names of slave roles to recommission. </p>  <p> Available since API v2. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.recommission_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the service on which to run the command. (required)
        :param ApiRoleNameList body: List of role names to recommision.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.recommission_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.recommission_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def recommission_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Recommission roles of a service.
        Recommission roles of a service. <p> The list should contain names of slave roles to recommission. </p>  <p> Available since API v2. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.recommission_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the service on which to run the command. (required)
        :param ApiRoleNameList body: List of role names to recommision.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method recommission_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `recommission_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `recommission_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/recommission', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def recommission_with_start_command(self, cluster_name, service_name, **kwargs):
        """
        Start and recommission roles of a service.
        Start and recommission roles of a service. <p> The list should contain names of slave roles to start and recommission. </p>  <p> Warning: Evolving. This method may change in the future and does not offer standard compatibility guarantees. Only support by HDFS. Do not use without guidance from Cloudera. </p>  <p> Available since API v15. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.recommission_with_start_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the service on which to run the command. (required)
        :param ApiRoleNameList body: List of role names to recommision.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.recommission_with_start_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.recommission_with_start_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def recommission_with_start_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Start and recommission roles of a service.
        Start and recommission roles of a service. <p> The list should contain names of slave roles to start and recommission. </p>  <p> Warning: Evolving. This method may change in the future and does not offer standard compatibility guarantees. Only support by HDFS. Do not use without guidance from Cloudera. </p>  <p> Available since API v15. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.recommission_with_start_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the service on which to run the command. (required)
        :param ApiRoleNameList body: List of role names to recommision.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method recommission_with_start_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `recommission_with_start_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `recommission_with_start_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/recommissionWithStart', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def restart_command(self, cluster_name, service_name, **kwargs):
        """
        Restart the service.
        Restart the service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.restart_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to start. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.restart_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.restart_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def restart_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Restart the service.
        Restart the service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.restart_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to start. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method restart_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `restart_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `restart_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/restart', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def rolling_restart(self, cluster_name, service_name, **kwargs):
        """
        Command to run rolling restart of roles in a service.
        Command to run rolling restart of roles in a service. The sequence is: <ol> <li>Restart all the non-slave roles <li>If slaves are present restart them in batches of size specified in RollingRestartCmdArgs <li>Perform any post-command needed after rolling restart </ol> <p> Available since API v3. Only available with Cloudera Manager Enterprise Edition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.rolling_restart(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :param ApiRollingRestartArgs body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.rolling_restart_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.rolling_restart_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def rolling_restart_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Command to run rolling restart of roles in a service.
        Command to run rolling restart of roles in a service. The sequence is: <ol> <li>Restart all the non-slave roles <li>If slaves are present restart them in batches of size specified in RollingRestartCmdArgs <li>Perform any post-command needed after rolling restart </ol> <p> Available since API v3. Only available with Cloudera Manager Enterprise Edition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.rolling_restart_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name:  (required)
        :param ApiRollingRestartArgs body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rolling_restart" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `rolling_restart`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `rolling_restart`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/rollingRestart', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def sentry_create_database_command(self, cluster_name, service_name, **kwargs):
        """
        Create the Sentry Server Database.
        Create the Sentry Server Database. Only works with embedded postgresql database. <p> This command is to be run whenever a new user and database need to be created in the embedded postgresql database for a Sentry service. This command should usually be followed by a call to sentryCreateDatabaseTables. <p> Available since API v7.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.sentry_create_database_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Sentry service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.sentry_create_database_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.sentry_create_database_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def sentry_create_database_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Create the Sentry Server Database.
        Create the Sentry Server Database. Only works with embedded postgresql database. <p> This command is to be run whenever a new user and database need to be created in the embedded postgresql database for a Sentry service. This command should usually be followed by a call to sentryCreateDatabaseTables. <p> Available since API v7.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.sentry_create_database_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Sentry service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sentry_create_database_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `sentry_create_database_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `sentry_create_database_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/sentryCreateDatabase', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def sentry_create_database_tables_command(self, cluster_name, service_name, **kwargs):
        """
        Create the Sentry Server Database tables.
        Create the Sentry Server Database tables. <p> This command is to be run whenever a new database has been specified. Will do nothing if tables already exist. Will not perform an upgrade. Only Available when Sentry Server is stopped. <p> Available since API v7.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.sentry_create_database_tables_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Sentry service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.sentry_create_database_tables_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.sentry_create_database_tables_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def sentry_create_database_tables_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Create the Sentry Server Database tables.
        Create the Sentry Server Database tables. <p> This command is to be run whenever a new database has been specified. Will do nothing if tables already exist. Will not perform an upgrade. Only Available when Sentry Server is stopped. <p> Available since API v7.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.sentry_create_database_tables_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Sentry service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sentry_create_database_tables_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `sentry_create_database_tables_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `sentry_create_database_tables_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/sentryCreateDatabaseTables', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def sentry_upgrade_database_tables_command(self, cluster_name, service_name, **kwargs):
        """
        Upgrade the Sentry Server Database tables.
        Upgrade the Sentry Server Database tables. <p> This command is to be run whenever Sentry requires an upgrade to its database tables. <p> Available since API v8.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.sentry_upgrade_database_tables_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Sentry service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.sentry_upgrade_database_tables_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.sentry_upgrade_database_tables_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def sentry_upgrade_database_tables_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Upgrade the Sentry Server Database tables.
        Upgrade the Sentry Server Database tables. <p> This command is to be run whenever Sentry requires an upgrade to its database tables. <p> Available since API v8.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.sentry_upgrade_database_tables_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Sentry service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sentry_upgrade_database_tables_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `sentry_upgrade_database_tables_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `sentry_upgrade_database_tables_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/sentryUpgradeDatabaseTables', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def service_command_by_name(self, cluster_name, command_name, service_name, **kwargs):
        """
        Executes a command on the service specified by name.
        Executes a command on the service specified by name. <p> Available since API v6. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.service_command_by_name(cluster_name, command_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str command_name: The command name. (required)
        :param str service_name: The service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.service_command_by_name_with_http_info(cluster_name, command_name, service_name, **kwargs)
        else:
            (data) = self.service_command_by_name_with_http_info(cluster_name, command_name, service_name, **kwargs)
            return data

    def service_command_by_name_with_http_info(self, cluster_name, command_name, service_name, **kwargs):
        """
        Executes a command on the service specified by name.
        Executes a command on the service specified by name. <p> Available since API v6. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.service_command_by_name_with_http_info(cluster_name, command_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str command_name: The command name. (required)
        :param str service_name: The service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'command_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method service_command_by_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `service_command_by_name`")
        # verify the required parameter 'command_name' is set
        if ('command_name' not in params) or (params['command_name'] is None):
            raise ValueError("Missing the required parameter `command_name` when calling `service_command_by_name`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `service_command_by_name`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'command_name' in params:
            path_params['commandName'] = params['command_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/{commandName}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def solr_bootstrap_collections_command(self, cluster_name, service_name, **kwargs):
        """
        Bootstraps Solr Collections after the CDH upgrade.
        Bootstraps Solr Collections after the CDH upgrade. <p> Note: This is only needed for upgrading to CDH6.0. <p> Available since API v30.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.solr_bootstrap_collections_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the Solr service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.solr_bootstrap_collections_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.solr_bootstrap_collections_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def solr_bootstrap_collections_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Bootstraps Solr Collections after the CDH upgrade.
        Bootstraps Solr Collections after the CDH upgrade. <p> Note: This is only needed for upgrading to CDH6.0. <p> Available since API v30.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.solr_bootstrap_collections_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the Solr service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method solr_bootstrap_collections_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `solr_bootstrap_collections_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `solr_bootstrap_collections_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/solrBootstrapCollections', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def solr_bootstrap_config_command(self, cluster_name, service_name, **kwargs):
        """
        Bootstraps Solr config during the CDH upgrade.
        Bootstraps Solr config during the CDH upgrade. <p> Note: This is only needed for upgrading to CDH6.0. <p> Available since API v30.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.solr_bootstrap_config_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the Solr service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.solr_bootstrap_config_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.solr_bootstrap_config_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def solr_bootstrap_config_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Bootstraps Solr config during the CDH upgrade.
        Bootstraps Solr config during the CDH upgrade. <p> Note: This is only needed for upgrading to CDH6.0. <p> Available since API v30.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.solr_bootstrap_config_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the Solr service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method solr_bootstrap_config_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `solr_bootstrap_config_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `solr_bootstrap_config_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/solrBootstrapConfig', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def solr_config_backup_command(self, cluster_name, service_name, **kwargs):
        """
        Backs up Solr configuration metadata before CDH upgrade.
        Backs up Solr configuration metadata before CDH upgrade. <p> Note: <li> <ul>Solr service should be in Stopped state.</ul> <ul>HDFS and Zookeeper services should in Running state.</ul> <ul>This is only needed for upgrading to CDH6.0.</ul> </p> Available since API v30.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.solr_config_backup_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the Solr service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.solr_config_backup_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.solr_config_backup_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def solr_config_backup_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Backs up Solr configuration metadata before CDH upgrade.
        Backs up Solr configuration metadata before CDH upgrade. <p> Note: <li> <ul>Solr service should be in Stopped state.</ul> <ul>HDFS and Zookeeper services should in Running state.</ul> <ul>This is only needed for upgrading to CDH6.0.</ul> </p> Available since API v30.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.solr_config_backup_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the Solr service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method solr_config_backup_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `solr_config_backup_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `solr_config_backup_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/solrConfigBackup', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def solr_migrate_sentry_privileges_command(self, cluster_name, service_name, **kwargs):
        """
        Migrates Sentry privileges to new model compatible to support more granular permissions if Solr is configured with a Sentry service.
        Migrates Sentry privileges to new model compatible to support more granular permissions if Solr is configured with a Sentry service. <p> Note: <li> <ul>Solr service should be in Stopped state.</ul> <ul>HDFS, Zookeeper, and Sentry services should in Running state.</ul> <ul>This is only needed for upgrading to CDH6.0.</ul> <p> Available since API v30.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.solr_migrate_sentry_privileges_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the Solr service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.solr_migrate_sentry_privileges_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.solr_migrate_sentry_privileges_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def solr_migrate_sentry_privileges_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Migrates Sentry privileges to new model compatible to support more granular permissions if Solr is configured with a Sentry service.
        Migrates Sentry privileges to new model compatible to support more granular permissions if Solr is configured with a Sentry service. <p> Note: <li> <ul>Solr service should be in Stopped state.</ul> <ul>HDFS, Zookeeper, and Sentry services should in Running state.</ul> <ul>This is only needed for upgrading to CDH6.0.</ul> <p> Available since API v30.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.solr_migrate_sentry_privileges_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the Solr service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method solr_migrate_sentry_privileges_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `solr_migrate_sentry_privileges_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `solr_migrate_sentry_privileges_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/solrMigrateSentryPrivilegesCommand', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def solr_reinitialize_state_for_upgrade_command(self, cluster_name, service_name, **kwargs):
        """
        Reinitializes the Solr state by clearing the Solr HDFS data directory, the Solr data directory, and the Zookeeper state.
        Reinitializes the Solr state by clearing the Solr HDFS data directory, the Solr data directory, and the Zookeeper state. <p> Note: <li> <ul>Solr service should be in Stopped state.</ul> <ul>HDFS and Zookeeper services should in Running state.</ul> <ul>This is only needed for upgrading to CDH6.0.</ul> <p> Available since API v30.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.solr_reinitialize_state_for_upgrade_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the Solr service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.solr_reinitialize_state_for_upgrade_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.solr_reinitialize_state_for_upgrade_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def solr_reinitialize_state_for_upgrade_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Reinitializes the Solr state by clearing the Solr HDFS data directory, the Solr data directory, and the Zookeeper state.
        Reinitializes the Solr state by clearing the Solr HDFS data directory, the Solr data directory, and the Zookeeper state. <p> Note: <li> <ul>Solr service should be in Stopped state.</ul> <ul>HDFS and Zookeeper services should in Running state.</ul> <ul>This is only needed for upgrading to CDH6.0.</ul> <p> Available since API v30.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.solr_reinitialize_state_for_upgrade_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the Solr service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method solr_reinitialize_state_for_upgrade_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `solr_reinitialize_state_for_upgrade_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `solr_reinitialize_state_for_upgrade_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/solrReinitializeStateForUpgrade', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def solr_validate_metadata_command(self, cluster_name, service_name, **kwargs):
        """
        Validates Solr metadata and configurations.
        Validates Solr metadata and configurations. <p> Note: This is only needed for upgrading to CDH6.0. <p> Available since API v30.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.solr_validate_metadata_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the Solr service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.solr_validate_metadata_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.solr_validate_metadata_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def solr_validate_metadata_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Validates Solr metadata and configurations.
        Validates Solr metadata and configurations. <p> Note: This is only needed for upgrading to CDH6.0. <p> Available since API v30.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.solr_validate_metadata_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: A String representing the Solr service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method solr_validate_metadata_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `solr_validate_metadata_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `solr_validate_metadata_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/solrValidateMetadata', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def sqoop_create_database_tables_command(self, cluster_name, service_name, **kwargs):
        """
        Create the Sqoop2 Server Database tables.
        Create the Sqoop2 Server Database tables. <p> This command is to be run whenever a new database has been specified. Will do nothing if tables already exist. Will not perform an upgrade. Only available when Sqoop2 Server is stopped. <p> Available since API v10.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.sqoop_create_database_tables_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Sentry service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.sqoop_create_database_tables_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.sqoop_create_database_tables_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def sqoop_create_database_tables_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Create the Sqoop2 Server Database tables.
        Create the Sqoop2 Server Database tables. <p> This command is to be run whenever a new database has been specified. Will do nothing if tables already exist. Will not perform an upgrade. Only available when Sqoop2 Server is stopped. <p> Available since API v10.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.sqoop_create_database_tables_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Sentry service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sqoop_create_database_tables_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `sqoop_create_database_tables_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `sqoop_create_database_tables_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/sqoopCreateDatabaseTables', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def sqoop_upgrade_db_command(self, cluster_name, service_name, **kwargs):
        """
        Upgrade Sqoop Database schema as part of a major version upgrade.
        Upgrade Sqoop Database schema as part of a major version upgrade. <p/> When doing a major version upgrade for Sqoop, it is necessary to upgrade the schema of its database before Sqoop can run successfully. <p/> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.sqoop_upgrade_db_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Sqoop service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.sqoop_upgrade_db_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.sqoop_upgrade_db_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def sqoop_upgrade_db_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Upgrade Sqoop Database schema as part of a major version upgrade.
        Upgrade Sqoop Database schema as part of a major version upgrade. <p/> When doing a major version upgrade for Sqoop, it is necessary to upgrade the schema of its database before Sqoop can run successfully. <p/> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.sqoop_upgrade_db_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The Sqoop service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sqoop_upgrade_db_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `sqoop_upgrade_db_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `sqoop_upgrade_db_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/sqoopUpgradeDb', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def start_command(self, cluster_name, service_name, **kwargs):
        """
        Start the service.
        Start the service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.start_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to start. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.start_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.start_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def start_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Start the service.
        Start the service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.start_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to start. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `start_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `start_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/start', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def stop_command(self, cluster_name, service_name, **kwargs):
        """
        Stop the service.
        Stop the service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.stop_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to stop. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.stop_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.stop_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def stop_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Stop the service.
        Stop the service.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.stop_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to stop. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stop_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `stop_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `stop_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/stop', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def switch_to_mr2(self, cluster_name, service_name, **kwargs):
        """
        Change the cluster to use MR2 instead of MR1.
        Change the cluster to use MR2 instead of MR1. Services will be restarted. <p> Will perform the following steps: <ul> <li>Update all services that depend on MapReduce to instead depend on Yarn. </li> <li>Stop MapReduce</li> <li>Start Yarn (MR2 Included)</li> <li>Deploy Yarn (MR2) Client Configuration</li> </ul> <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.switch_to_mr2(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Yarn service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.switch_to_mr2_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.switch_to_mr2_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def switch_to_mr2_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Change the cluster to use MR2 instead of MR1.
        Change the cluster to use MR2 instead of MR1. Services will be restarted. <p> Will perform the following steps: <ul> <li>Update all services that depend on MapReduce to instead depend on Yarn. </li> <li>Stop MapReduce</li> <li>Start Yarn (MR2 Included)</li> <li>Deploy Yarn (MR2) Client Configuration</li> </ul> <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.switch_to_mr2_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: Name of the Yarn service on which to run the command. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method switch_to_mr2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `switch_to_mr2`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `switch_to_mr2`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/switchToMr2', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_service(self, cluster_name, service_name, **kwargs):
        """
        Updates service information.
        Updates service information. <p/> This method will update only writable fields of the service information. Currently this only includes the service display name. <p/> Available since API v3.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_service(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :param ApiService body: Updated service information.
        :return: ApiService
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_service_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.update_service_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def update_service_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Updates service information.
        Updates service information. <p/> This method will update only writable fields of the service information. Currently this only includes the service display name. <p/> Available since API v3.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_service_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service name. (required)
        :param ApiService body: Updated service information.
        :return: ApiService
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_service" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `update_service`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `update_service`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiService',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_service_config(self, cluster_name, service_name, **kwargs):
        """
        Updates the service configuration with the given values.
        Updates the service configuration with the given values. <p> If a value is set in the given configuration, it will be added to the service's configuration, replacing any existing entries. If a value is unset (its value is null), the existing configuration for the attribute will be erased, if any. <p> Attributes that are not listed in the input will maintain their current values in the configuration.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_service_config(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to modify. (required)
        :param str message: Optional message describing the changes.
        :param ApiServiceConfig body: Configuration changes.
        :return: ApiServiceConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_service_config_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.update_service_config_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def update_service_config_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Updates the service configuration with the given values.
        Updates the service configuration with the given values. <p> If a value is set in the given configuration, it will be added to the service's configuration, replacing any existing entries. If a value is unset (its value is null), the existing configuration for the attribute will be erased, if any. <p> Attributes that are not listed in the input will maintain their current values in the configuration.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_service_config_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to modify. (required)
        :param str message: Optional message describing the changes.
        :param ApiServiceConfig body: Configuration changes.
        :return: ApiServiceConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'message', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_service_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `update_service_config`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `update_service_config`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'message' in params:
            query_params.append(('message', params['message']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/config', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiServiceConfig',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def yarn_format_state_store(self, cluster_name, service_name, **kwargs):
        """
        Formats the state store in ZooKeeper used for Resource Manager High Availability.
        Formats the state store in ZooKeeper used for Resource Manager High Availability. Typically used while moving from non-secure to secure cluster or vice-versa. <p> Available since API v8.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.yarn_format_state_store(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The YARN service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.yarn_format_state_store_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.yarn_format_state_store_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def yarn_format_state_store_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Formats the state store in ZooKeeper used for Resource Manager High Availability.
        Formats the state store in ZooKeeper used for Resource Manager High Availability. Typically used while moving from non-secure to secure cluster or vice-versa. <p> Available since API v8.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.yarn_format_state_store_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The YARN service name. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method yarn_format_state_store" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `yarn_format_state_store`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `yarn_format_state_store`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/yarnFormatStateStore', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def zoo_keeper_cleanup_command(self, cluster_name, service_name, **kwargs):
        """
        Clean up all running server instances of a ZooKeeper service.
        Clean up all running server instances of a ZooKeeper service. <p> This command removes snapshots and transaction log files kept by ZooKeeper for backup purposes. Refer to the ZooKeeper documentation for more details.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.zoo_keeper_cleanup_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to start. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.zoo_keeper_cleanup_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.zoo_keeper_cleanup_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def zoo_keeper_cleanup_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Clean up all running server instances of a ZooKeeper service.
        Clean up all running server instances of a ZooKeeper service. <p> This command removes snapshots and transaction log files kept by ZooKeeper for backup purposes. Refer to the ZooKeeper documentation for more details.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.zoo_keeper_cleanup_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to start. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method zoo_keeper_cleanup_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `zoo_keeper_cleanup_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `zoo_keeper_cleanup_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/zooKeeperCleanup', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def zoo_keeper_init_command(self, cluster_name, service_name, **kwargs):
        """
        Initializes all the server instances of a ZooKeeper service.
        Initializes all the server instances of a ZooKeeper service. <p> ZooKeeper server roles need to be initialized before they can be used.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.zoo_keeper_init_command(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to start. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.zoo_keeper_init_command_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.zoo_keeper_init_command_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def zoo_keeper_init_command_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Initializes all the server instances of a ZooKeeper service.
        Initializes all the server instances of a ZooKeeper service. <p> ZooKeeper server roles need to be initialized before they can be used.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.zoo_keeper_init_command_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str service_name: The service to start. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method zoo_keeper_init_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `zoo_keeper_init_command`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `zoo_keeper_init_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/commands/zooKeeperInit', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
