# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class HostsResourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def add_tags(self, hostname, **kwargs):
        """
        Attach tags to the host.
        Attach tags to the host. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_tags(hostname, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str hostname: Name of the host (required)
        :param list[ApiEntityTag] body: List of tags to add to the host
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_tags_with_http_info(hostname, **kwargs)
        else:
            (data) = self.add_tags_with_http_info(hostname, **kwargs)
            return data

    def add_tags_with_http_info(self, hostname, **kwargs):
        """
        Attach tags to the host.
        Attach tags to the host. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_tags_with_http_info(hostname, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str hostname: Name of the host (required)
        :param list[ApiEntityTag] body: List of tags to add to the host
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hostname', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hostname' is set
        if ('hostname' not in params) or (params['hostname'] is None):
            raise ValueError("Missing the required parameter `hostname` when calling `add_tags`")


        collection_formats = {}

        path_params = {}
        if 'hostname' in params:
            path_params['hostname'] = params['hostname']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts/{hostname}/tags', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ApiEntityTag]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_hosts(self, **kwargs):
        """
        .
        <p>Create one or more hosts.</p> <p>You must specify at least the hostname and ipAddress in the request objects. If no hostId is specified, it will be set to the hostname.  It is an error to try and create host with the same hostId as another host.</p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_hosts(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiHostList body: The list of hosts to create
        :return: ApiHostList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_hosts_with_http_info(**kwargs)
        else:
            (data) = self.create_hosts_with_http_info(**kwargs)
            return data

    def create_hosts_with_http_info(self, **kwargs):
        """
        .
        <p>Create one or more hosts.</p> <p>You must specify at least the hostname and ipAddress in the request objects. If no hostId is specified, it will be set to the hostname.  It is an error to try and create host with the same hostId as another host.</p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_hosts_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiHostList body: The list of hosts to create
        :return: ApiHostList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_hosts" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiHostList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_all_hosts(self, **kwargs):
        """
        Delete all hosts in the system.
        Delete all hosts in the system
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_all_hosts(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiHostList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_all_hosts_with_http_info(**kwargs)
        else:
            (data) = self.delete_all_hosts_with_http_info(**kwargs)
            return data

    def delete_all_hosts_with_http_info(self, **kwargs):
        """
        Delete all hosts in the system.
        Delete all hosts in the system
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_all_hosts_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ApiHostList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_all_hosts" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiHostList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_host(self, host_id, **kwargs):
        """
        Delete a host from the system.
        Delete a host from the system
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_host(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host to remove (required)
        :return: ApiHost
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_host_with_http_info(host_id, **kwargs)
        else:
            (data) = self.delete_host_with_http_info(host_id, **kwargs)
            return data

    def delete_host_with_http_info(self, host_id, **kwargs):
        """
        Delete a host from the system.
        Delete a host from the system
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_host_with_http_info(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host to remove (required)
        :return: ApiHost
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['host_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params) or (params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `delete_host`")


        collection_formats = {}

        path_params = {}
        if 'host_id' in params:
            path_params['hostId'] = params['host_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts/{hostId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiHost',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_tags(self, hostname, **kwargs):
        """
        Remove the tags associated with the host.
        Remove the tags associated with the host. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_tags(hostname, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str hostname: Name of the host to remove tags from (required)
        :param list[ApiEntityTag] body: List of tags to remove from the host
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_tags_with_http_info(hostname, **kwargs)
        else:
            (data) = self.delete_tags_with_http_info(hostname, **kwargs)
            return data

    def delete_tags_with_http_info(self, hostname, **kwargs):
        """
        Remove the tags associated with the host.
        Remove the tags associated with the host. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_tags_with_http_info(hostname, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str hostname: Name of the host to remove tags from (required)
        :param list[ApiEntityTag] body: List of tags to remove from the host
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hostname', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hostname' is set
        if ('hostname' not in params) or (params['hostname'] is None):
            raise ValueError("Missing the required parameter `hostname` when calling `delete_tags`")


        collection_formats = {}

        path_params = {}
        if 'hostname' in params:
            path_params['hostname'] = params['hostname']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts/{hostname}/tags', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ApiEntityTag]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def enter_maintenance_mode(self, host_id, **kwargs):
        """
        Put the host into maintenance mode.
        Put the host into maintenance mode. This is a synchronous command. The result is known immediately upon return.  <p>Available since API v2.</p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enter_maintenance_mode(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.enter_maintenance_mode_with_http_info(host_id, **kwargs)
        else:
            (data) = self.enter_maintenance_mode_with_http_info(host_id, **kwargs)
            return data

    def enter_maintenance_mode_with_http_info(self, host_id, **kwargs):
        """
        Put the host into maintenance mode.
        Put the host into maintenance mode. This is a synchronous command. The result is known immediately upon return.  <p>Available since API v2.</p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enter_maintenance_mode_with_http_info(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['host_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enter_maintenance_mode" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params) or (params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `enter_maintenance_mode`")


        collection_formats = {}

        path_params = {}
        if 'host_id' in params:
            path_params['hostId'] = params['host_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts/{hostId}/commands/enterMaintenanceMode', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def exit_maintenance_mode(self, host_id, **kwargs):
        """
        Take the host out of maintenance mode.
        Take the host out of maintenance mode. This is a synchronous command. The result is known immediately upon return.  <p> Available since API v2. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.exit_maintenance_mode(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.exit_maintenance_mode_with_http_info(host_id, **kwargs)
        else:
            (data) = self.exit_maintenance_mode_with_http_info(host_id, **kwargs)
            return data

    def exit_maintenance_mode_with_http_info(self, host_id, **kwargs):
        """
        Take the host out of maintenance mode.
        Take the host out of maintenance mode. This is a synchronous command. The result is known immediately upon return.  <p> Available since API v2. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.exit_maintenance_mode_with_http_info(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['host_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exit_maintenance_mode" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params) or (params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `exit_maintenance_mode`")


        collection_formats = {}

        path_params = {}
        if 'host_id' in params:
            path_params['hostId'] = params['host_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts/{hostId}/commands/exitMaintenanceMode', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def generate_host_certs(self, host_id, **kwargs):
        """
        Generates (or regenerates) a key and certificate for this host if Auto-TLS is enabled.
        Generates (or regenerates) a key and certificate for this host if Auto-TLS is enabled.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.generate_host_certs(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host to generate a certificate for. (required)
        :param ApiGenerateHostCertsArguments body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.generate_host_certs_with_http_info(host_id, **kwargs)
        else:
            (data) = self.generate_host_certs_with_http_info(host_id, **kwargs)
            return data

    def generate_host_certs_with_http_info(self, host_id, **kwargs):
        """
        Generates (or regenerates) a key and certificate for this host if Auto-TLS is enabled.
        Generates (or regenerates) a key and certificate for this host if Auto-TLS is enabled.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.generate_host_certs_with_http_info(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host to generate a certificate for. (required)
        :param ApiGenerateHostCertsArguments body: 
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['host_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_host_certs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params) or (params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `generate_host_certs`")


        collection_formats = {}

        path_params = {}
        if 'host_id' in params:
            path_params['hostId'] = params['host_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts/{hostId}/commands/generateHostCerts', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_host_components(self, host_id, **kwargs):
        """
        Returns the list of Component details on the requested host.
        Returns the list of Component details on the requested host.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_host_components(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host. (required)
        :return: list[ApiComponentInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_host_components_with_http_info(host_id, **kwargs)
        else:
            (data) = self.get_host_components_with_http_info(host_id, **kwargs)
            return data

    def get_host_components_with_http_info(self, host_id, **kwargs):
        """
        Returns the list of Component details on the requested host.
        Returns the list of Component details on the requested host.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_host_components_with_http_info(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host. (required)
        :return: list[ApiComponentInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['host_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_host_components" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params) or (params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `get_host_components`")


        collection_formats = {}

        path_params = {}
        if 'host_id' in params:
            path_params['hostId'] = params['host_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts/{hostId}/components', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ApiComponentInfo]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_metrics(self, host_id, **kwargs):
        """
        Fetch metric readings for a host.
        Fetch metric readings for a host. <p> By default, this call will look up all metrics available for the host. If only specific metrics are desired, use the <i>metrics</i> parameter. <p> By default, the returned results correspond to a 5 minute window based on the provided end time (which defaults to the current server time). The <i>from</i> and <i>to</i> parameters can be used to control the window being queried. A maximum window of 3 hours is enforced. <p> When requesting a \"full\" view, aside from the extended properties of the returned metric data, the collection will also contain information about all metrics available for the role, even if no readings are available in the requested window. <p> Host metrics also include per-network interface and per-storage device metrics. Since collecting this data incurs in more overhead, query parameters can be used to choose which network interfaces and storage devices to query, or to these metrics altogether. <p> Storage metrics are collected at different levels; for example, per-disk and per-partition metrics are available. The \"storageIds\" parameter can be used to filter specific storage IDs. <p> In the returned data, the network interfaces and storage IDs can be identified by looking at the \"context\" property of the metric objects.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_metrics(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The host's ID. (required)
        :param str _from: Start of the period to query.
        :param list[str] ifs: Network interfaces to query for metrics (default = all).
        :param list[str] metrics: Filter for which metrics to query.
        :param bool query_nw: Whether to query for network interface metrics.
        :param bool query_storage: Whether to query for storage metrics.
        :param list[str] storage_ids: Storage context IDs to query for metrics (default = all).
        :param str to: End of the period to query.
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiMetricList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_metrics_with_http_info(host_id, **kwargs)
        else:
            (data) = self.get_metrics_with_http_info(host_id, **kwargs)
            return data

    def get_metrics_with_http_info(self, host_id, **kwargs):
        """
        Fetch metric readings for a host.
        Fetch metric readings for a host. <p> By default, this call will look up all metrics available for the host. If only specific metrics are desired, use the <i>metrics</i> parameter. <p> By default, the returned results correspond to a 5 minute window based on the provided end time (which defaults to the current server time). The <i>from</i> and <i>to</i> parameters can be used to control the window being queried. A maximum window of 3 hours is enforced. <p> When requesting a \"full\" view, aside from the extended properties of the returned metric data, the collection will also contain information about all metrics available for the role, even if no readings are available in the requested window. <p> Host metrics also include per-network interface and per-storage device metrics. Since collecting this data incurs in more overhead, query parameters can be used to choose which network interfaces and storage devices to query, or to these metrics altogether. <p> Storage metrics are collected at different levels; for example, per-disk and per-partition metrics are available. The \"storageIds\" parameter can be used to filter specific storage IDs. <p> In the returned data, the network interfaces and storage IDs can be identified by looking at the \"context\" property of the metric objects.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_metrics_with_http_info(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The host's ID. (required)
        :param str _from: Start of the period to query.
        :param list[str] ifs: Network interfaces to query for metrics (default = all).
        :param list[str] metrics: Filter for which metrics to query.
        :param bool query_nw: Whether to query for network interface metrics.
        :param bool query_storage: Whether to query for storage metrics.
        :param list[str] storage_ids: Storage context IDs to query for metrics (default = all).
        :param str to: End of the period to query.
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiMetricList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['host_id', '_from', 'ifs', 'metrics', 'query_nw', 'query_storage', 'storage_ids', 'to', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params) or (params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `get_metrics`")


        collection_formats = {}

        path_params = {}
        if 'host_id' in params:
            path_params['hostId'] = params['host_id']

        query_params = []
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'ifs' in params:
            query_params.append(('ifs', params['ifs']))
            collection_formats['ifs'] = 'multi'
        if 'metrics' in params:
            query_params.append(('metrics', params['metrics']))
            collection_formats['metrics'] = 'multi'
        if 'query_nw' in params:
            query_params.append(('queryNw', params['query_nw']))
        if 'query_storage' in params:
            query_params.append(('queryStorage', params['query_storage']))
        if 'storage_ids' in params:
            query_params.append(('storageIds', params['storage_ids']))
            collection_formats['storageIds'] = 'multi'
        if 'to' in params:
            query_params.append(('to', params['to']))
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts/{hostId}/metrics', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiMetricList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def migrate_roles(self, host_id, **kwargs):
        """
        Migrate roles to a different host.
        Migrate roles to a different host. <p> This command applies only to HDFS NameNode, JournalNode, and Failover Controller roles. In order to migrate these roles: <ul> <li>HDFS High Availability must be enabled, using quorum-based storage.</li> <li>HDFS must not be configured to use a federated nameservice.</li> </ul> <b>Migrating a NameNode or JournalNode role requires cluster downtime</b>. HDFS, along with all of its dependent services, will be stopped at the beginning of the migration process, and restarted at its conclusion. <p>If the active NameNode is selected for migration, a manual failover will be performed before the role is migrated. The role will remain in standby mode after the migration is complete. <p>When migrating a NameNode role, the co-located Failover Controller role must be migrated as well if automatic failover is enabled. The Failover Controller role name must be included in the list of role names to migrate specified in the arguments to this command (it will not be included implicitly). This command does not allow a Failover Controller role to be moved by itself, although it is possible to move a JournalNode independently. <p> Available since API v10.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.migrate_roles(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host on which the roles to migrate currently reside (required)
        :param ApiMigrateRolesArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.migrate_roles_with_http_info(host_id, **kwargs)
        else:
            (data) = self.migrate_roles_with_http_info(host_id, **kwargs)
            return data

    def migrate_roles_with_http_info(self, host_id, **kwargs):
        """
        Migrate roles to a different host.
        Migrate roles to a different host. <p> This command applies only to HDFS NameNode, JournalNode, and Failover Controller roles. In order to migrate these roles: <ul> <li>HDFS High Availability must be enabled, using quorum-based storage.</li> <li>HDFS must not be configured to use a federated nameservice.</li> </ul> <b>Migrating a NameNode or JournalNode role requires cluster downtime</b>. HDFS, along with all of its dependent services, will be stopped at the beginning of the migration process, and restarted at its conclusion. <p>If the active NameNode is selected for migration, a manual failover will be performed before the role is migrated. The role will remain in standby mode after the migration is complete. <p>When migrating a NameNode role, the co-located Failover Controller role must be migrated as well if automatic failover is enabled. The Failover Controller role name must be included in the list of role names to migrate specified in the arguments to this command (it will not be included implicitly). This command does not allow a Failover Controller role to be moved by itself, although it is possible to move a JournalNode independently. <p> Available since API v10.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.migrate_roles_with_http_info(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host on which the roles to migrate currently reside (required)
        :param ApiMigrateRolesArguments body: Arguments for the command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['host_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method migrate_roles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params) or (params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `migrate_roles`")


        collection_formats = {}

        path_params = {}
        if 'host_id' in params:
            path_params['hostId'] = params['host_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts/{hostId}/commands/migrateRoles', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_host(self, host_id, **kwargs):
        """
        Returns a specific Host in the system.
        Returns a specific Host in the system.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_host(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host to read. (required)
        :param str view: The view to materialize. Defaults to 'full'.
        :return: ApiHost
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_host_with_http_info(host_id, **kwargs)
        else:
            (data) = self.read_host_with_http_info(host_id, **kwargs)
            return data

    def read_host_with_http_info(self, host_id, **kwargs):
        """
        Returns a specific Host in the system.
        Returns a specific Host in the system.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_host_with_http_info(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host to read. (required)
        :param str view: The view to materialize. Defaults to 'full'.
        :return: ApiHost
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['host_id', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params) or (params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `read_host`")


        collection_formats = {}

        path_params = {}
        if 'host_id' in params:
            path_params['hostId'] = params['host_id']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts/{hostId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiHost',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_host_config(self, host_id, **kwargs):
        """
        Retrieves the configuration of a specific host.
        Retrieves the configuration of a specific host.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_host_config(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host. (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_host_config_with_http_info(host_id, **kwargs)
        else:
            (data) = self.read_host_config_with_http_info(host_id, **kwargs)
            return data

    def read_host_config_with_http_info(self, host_id, **kwargs):
        """
        Retrieves the configuration of a specific host.
        Retrieves the configuration of a specific host.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_host_config_with_http_info(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host. (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['host_id', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_host_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params) or (params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `read_host_config`")


        collection_formats = {}

        path_params = {}
        if 'host_id' in params:
            path_params['hostId'] = params['host_id']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts/{hostId}/config', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiConfigList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_hosts(self, **kwargs):
        """
        Returns hosts in the system filtered by optional host configuration parameters, if specified.
        Returns hosts in the system filtered by optional host configuration parameters, if specified.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_hosts(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_name: Optional host config name to filter hosts by. Available from v40.
        :param str config_value: host config value associated with config name. Available from v40.
        :param str view: The view to materialize
        :return: ApiHostList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_hosts_with_http_info(**kwargs)
        else:
            (data) = self.read_hosts_with_http_info(**kwargs)
            return data

    def read_hosts_with_http_info(self, **kwargs):
        """
        Returns hosts in the system filtered by optional host configuration parameters, if specified.
        Returns hosts in the system filtered by optional host configuration parameters, if specified.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_hosts_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str config_name: Optional host config name to filter hosts by. Available from v40.
        :param str config_value: host config value associated with config name. Available from v40.
        :param str view: The view to materialize
        :return: ApiHostList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_name', 'config_value', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_hosts" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'config_name' in params:
            query_params.append(('configName', params['config_name']))
        if 'config_value' in params:
            query_params.append(('configValue', params['config_value']))
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiHostList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_tags(self, hostname, **kwargs):
        """
        Returns the tags associated with this host.
        Returns the tags associated with this host. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_tags(hostname, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str hostname: The name of the host (required)
        :param int limit: Number of tags
        :param int offset: Index of the first tag to retrieve
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_tags_with_http_info(hostname, **kwargs)
        else:
            (data) = self.read_tags_with_http_info(hostname, **kwargs)
            return data

    def read_tags_with_http_info(self, hostname, **kwargs):
        """
        Returns the tags associated with this host.
        Returns the tags associated with this host. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_tags_with_http_info(hostname, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str hostname: The name of the host (required)
        :param int limit: Number of tags
        :param int offset: Index of the first tag to retrieve
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hostname', 'limit', 'offset']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hostname' is set
        if ('hostname' not in params) or (params['hostname'] is None):
            raise ValueError("Missing the required parameter `hostname` when calling `read_tags`")


        collection_formats = {}

        path_params = {}
        if 'hostname' in params:
            path_params['hostname'] = params['hostname']

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts/{hostname}/tags', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ApiEntityTag]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def reset_host_id(self, host_id, **kwargs):
        """
        Forces agent on specified host to switch to reporting a different host id.
        Forces agent on specified host to switch to reporting a different host id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reset_host_id(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host that should be affected. (required)
        :param str new_host_id: New ID the the host should report.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.reset_host_id_with_http_info(host_id, **kwargs)
        else:
            (data) = self.reset_host_id_with_http_info(host_id, **kwargs)
            return data

    def reset_host_id_with_http_info(self, host_id, **kwargs):
        """
        Forces agent on specified host to switch to reporting a different host id.
        Forces agent on specified host to switch to reporting a different host id.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reset_host_id_with_http_info(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host that should be affected. (required)
        :param str new_host_id: New ID the the host should report.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['host_id', 'new_host_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_host_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params) or (params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `reset_host_id`")


        collection_formats = {}

        path_params = {}
        if 'host_id' in params:
            path_params['hostId'] = params['host_id']

        query_params = []
        if 'new_host_id' in params:
            query_params.append(('newHostId', params['new_host_id']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts/{hostId}/commands/resetHostId', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_host(self, host_id, **kwargs):
        """
        .
        <p>Update an existing host in the system.</p> <p>Currently, only updating the rackId is supported.  All other fields of the host will be ignored.</p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_host(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The hostId to update (required)
        :param ApiHost body: The updated host object.
        :return: ApiHost
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_host_with_http_info(host_id, **kwargs)
        else:
            (data) = self.update_host_with_http_info(host_id, **kwargs)
            return data

    def update_host_with_http_info(self, host_id, **kwargs):
        """
        .
        <p>Update an existing host in the system.</p> <p>Currently, only updating the rackId is supported.  All other fields of the host will be ignored.</p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_host_with_http_info(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The hostId to update (required)
        :param ApiHost body: The updated host object.
        :return: ApiHost
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['host_id', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params) or (params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `update_host`")


        collection_formats = {}

        path_params = {}
        if 'host_id' in params:
            path_params['hostId'] = params['host_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts/{hostId}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiHost',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_host_config(self, host_id, **kwargs):
        """
        Updates the host configuration with the given values.
        Updates the host configuration with the given values. <p> If a value is set in the given configuration, it will be added to the host's configuration, replacing any existing entries. If a value is unset (its value is null), the existing configuration for the attribute will be erased, if any. <p> Attributes that are not listed in the input will maintain their current values in the configuration.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_host_config(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host. (required)
        :param str message: Optional message describing the changes.
        :param ApiConfigList body: Configuration changes.
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_host_config_with_http_info(host_id, **kwargs)
        else:
            (data) = self.update_host_config_with_http_info(host_id, **kwargs)
            return data

    def update_host_config_with_http_info(self, host_id, **kwargs):
        """
        Updates the host configuration with the given values.
        Updates the host configuration with the given values. <p> If a value is set in the given configuration, it will be added to the host's configuration, replacing any existing entries. If a value is unset (its value is null), the existing configuration for the attribute will be erased, if any. <p> Attributes that are not listed in the input will maintain their current values in the configuration.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_host_config_with_http_info(host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str host_id: The ID of the host. (required)
        :param str message: Optional message describing the changes.
        :param ApiConfigList body: Configuration changes.
        :return: ApiConfigList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['host_id', 'message', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_host_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params) or (params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `update_host_config`")


        collection_formats = {}

        path_params = {}
        if 'host_id' in params:
            path_params['hostId'] = params['host_id']

        query_params = []
        if 'message' in params:
            query_params.append(('message', params['message']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/hosts/{hostId}/config', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiConfigList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
