# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ClustersResourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def add_hosts(self, cluster_name, **kwargs):
        """
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_hosts(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param ApiHostRefList body: 
        :return: ApiHostRefList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_hosts_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.add_hosts_with_http_info(cluster_name, **kwargs)
            return data

    def add_hosts_with_http_info(self, cluster_name, **kwargs):
        """
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_hosts_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param ApiHostRefList body: 
        :return: ApiHostRefList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_hosts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `add_hosts`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/hosts', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiHostRefList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def add_tags(self, cluster_name, **kwargs):
        """
        Attach tags to the cluster.
        Attach tags to the cluster. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_tags(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: Name of the cluster (required)
        :param list[ApiEntityTag] body: list of tags to add
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_tags_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.add_tags_with_http_info(cluster_name, **kwargs)
            return data

    def add_tags_with_http_info(self, cluster_name, **kwargs):
        """
        Attach tags to the cluster.
        Attach tags to the cluster. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_tags_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: Name of the cluster (required)
        :param list[ApiEntityTag] body: list of tags to add
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `add_tags`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/tags', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ApiEntityTag]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def auto_assign_roles(self, cluster_name, **kwargs):
        """
        Automatically assign roles to hosts and create the roles for all the services in a cluster.
        Automatically assign roles to hosts and create the roles for all the services in a cluster. <p> Assignments are done based on services and hosts in the cluster, and hardware specifications. If no hosts are added to the cluster, an exception will be thrown preventing any role assignments. Existing roles will be taken into account and their assignments will be not be modified. <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.auto_assign_roles(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.auto_assign_roles_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.auto_assign_roles_with_http_info(cluster_name, **kwargs)
            return data

    def auto_assign_roles_with_http_info(self, cluster_name, **kwargs):
        """
        Automatically assign roles to hosts and create the roles for all the services in a cluster.
        Automatically assign roles to hosts and create the roles for all the services in a cluster. <p> Assignments are done based on services and hosts in the cluster, and hardware specifications. If no hosts are added to the cluster, an exception will be thrown preventing any role assignments. Existing roles will be taken into account and their assignments will be not be modified. <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.auto_assign_roles_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method auto_assign_roles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `auto_assign_roles`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/autoAssignRoles', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def auto_configure(self, cluster_name, **kwargs):
        """
        Automatically configures roles and services in a cluster.
        Automatically configures roles and services in a cluster. <p> Overwrites some existing configurations. Might create new role config groups. Only default role config groups must exist before calling this endpoint. Other role config groups must not exist. If they do, an exception will be thrown preventing any configuration. Ignores the Cloudera Management Service even if colocated with roles of this cluster. To avoid over-committing the heap on hosts, assign hosts to this cluster that are not being used by the Cloudera Management Service. <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.auto_configure(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.auto_configure_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.auto_configure_with_http_info(cluster_name, **kwargs)
            return data

    def auto_configure_with_http_info(self, cluster_name, **kwargs):
        """
        Automatically configures roles and services in a cluster.
        Automatically configures roles and services in a cluster. <p> Overwrites some existing configurations. Might create new role config groups. Only default role config groups must exist before calling this endpoint. Other role config groups must not exist. If they do, an exception will be thrown preventing any configuration. Ignores the Cloudera Management Service even if colocated with roles of this cluster. To avoid over-committing the heap on hosts, assign hosts to this cluster that are not being used by the Cloudera Management Service. <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.auto_configure_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method auto_configure" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `auto_configure`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/autoConfigure', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def configure_auto_tls_services_command(self, cluster_name, **kwargs):
        """
        Configures all services in a cluster to use Auto-TLS.
        Configures all services in a cluster to use Auto-TLS
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.configure_auto_tls_services_command(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.configure_auto_tls_services_command_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.configure_auto_tls_services_command_with_http_info(cluster_name, **kwargs)
            return data

    def configure_auto_tls_services_command_with_http_info(self, cluster_name, **kwargs):
        """
        Configures all services in a cluster to use Auto-TLS.
        Configures all services in a cluster to use Auto-TLS
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.configure_auto_tls_services_command_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method configure_auto_tls_services_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `configure_auto_tls_services_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/configureAutoTlsServices', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def configure_for_kerberos(self, cluster_name, **kwargs):
        """
        Command to configure the cluster to use Kerberos for authentication.
        Command to configure the cluster to use Kerberos for authentication.  This command will configure all relevant services on a cluster for Kerberos usage.  This command will trigger a GenerateCredentials command to create Kerberos keytabs for all roles in the cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.configure_for_kerberos(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param ApiConfigureForKerberosArguments body: Arguments for the configure for kerberos command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.configure_for_kerberos_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.configure_for_kerberos_with_http_info(cluster_name, **kwargs)
            return data

    def configure_for_kerberos_with_http_info(self, cluster_name, **kwargs):
        """
        Command to configure the cluster to use Kerberos for authentication.
        Command to configure the cluster to use Kerberos for authentication.  This command will configure all relevant services on a cluster for Kerberos usage.  This command will trigger a GenerateCredentials command to create Kerberos keytabs for all roles in the cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.configure_for_kerberos_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param ApiConfigureForKerberosArguments body: Arguments for the configure for kerberos command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method configure_for_kerberos" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `configure_for_kerberos`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/configureForKerberos', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_clusters(self, **kwargs):
        """
        Creates a collection of clusters.
        Creates a collection of clusters.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_clusters(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiClusterList body: List of clusters to created.
        :return: ApiClusterList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_clusters_with_http_info(**kwargs)
        else:
            (data) = self.create_clusters_with_http_info(**kwargs)
            return data

    def create_clusters_with_http_info(self, **kwargs):
        """
        Creates a collection of clusters.
        Creates a collection of clusters.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_clusters_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiClusterList body: List of clusters to created.
        :return: ApiClusterList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_clusters" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiClusterList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_cluster(self, cluster_name, **kwargs):
        """
        Deletes a cluster.
        Deletes a cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_cluster(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: Name of cluster to delete. (required)
        :return: ApiCluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_cluster_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.delete_cluster_with_http_info(cluster_name, **kwargs)
            return data

    def delete_cluster_with_http_info(self, cluster_name, **kwargs):
        """
        Deletes a cluster.
        Deletes a cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_cluster_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: Name of cluster to delete. (required)
        :return: ApiCluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `delete_cluster`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCluster',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_cluster_credentials_command(self, cluster_name, **kwargs):
        """
        Delete existing Kerberos credentials for the cluster.
        Delete existing Kerberos credentials for the cluster. <p> This command will affect all services that have been configured to use Kerberos, and have existing credentials.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_cluster_credentials_command(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: cluster name (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_cluster_credentials_command_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.delete_cluster_credentials_command_with_http_info(cluster_name, **kwargs)
            return data

    def delete_cluster_credentials_command_with_http_info(self, cluster_name, **kwargs):
        """
        Delete existing Kerberos credentials for the cluster.
        Delete existing Kerberos credentials for the cluster. <p> This command will affect all services that have been configured to use Kerberos, and have existing credentials.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_cluster_credentials_command_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: cluster name (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cluster_credentials_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `delete_cluster_credentials_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/deleteCredentials', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_tags(self, cluster_name, **kwargs):
        """
        Remove the tags associated with the cluster.
        Remove the tags associated with the cluster. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_tags(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: Name of the cluster to remove tags from (required)
        :param list[ApiEntityTag] body: 
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_tags_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.delete_tags_with_http_info(cluster_name, **kwargs)
            return data

    def delete_tags_with_http_info(self, cluster_name, **kwargs):
        """
        Remove the tags associated with the cluster.
        Remove the tags associated with the cluster. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_tags_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: Name of the cluster to remove tags from (required)
        :param list[ApiEntityTag] body: 
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `delete_tags`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/tags', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ApiEntityTag]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def deploy_client_config(self, cluster_name, **kwargs):
        """
        Deploy the cluster-wide client configuration.
        Deploy the cluster-wide client configuration.  <p>For each service in the cluster, deploy the service's client configuration to all the hosts that the service runs on.</p>  <p>Available since API v2.</p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deploy_client_config(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.deploy_client_config_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.deploy_client_config_with_http_info(cluster_name, **kwargs)
            return data

    def deploy_client_config_with_http_info(self, cluster_name, **kwargs):
        """
        Deploy the cluster-wide client configuration.
        Deploy the cluster-wide client configuration.  <p>For each service in the cluster, deploy the service's client configuration to all the hosts that the service runs on.</p>  <p>Available since API v2.</p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deploy_client_config_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deploy_client_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `deploy_client_config`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/deployClientConfig', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def deploy_client_configs_and_refresh(self, cluster_name, **kwargs):
        """
        Performs a command with the 2 steps - deploy cc - cluster refresh  This orchestration is needed for the staleness wizard, so it can invoke a single command at wizard finish.
        Performs a command with the 2 steps - deploy cc - cluster refresh  This orchestration is needed for the staleness wizard, so it can invoke a single command at wizard finish.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deploy_client_configs_and_refresh(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.deploy_client_configs_and_refresh_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.deploy_client_configs_and_refresh_with_http_info(cluster_name, **kwargs)
            return data

    def deploy_client_configs_and_refresh_with_http_info(self, cluster_name, **kwargs):
        """
        Performs a command with the 2 steps - deploy cc - cluster refresh  This orchestration is needed for the staleness wizard, so it can invoke a single command at wizard finish.
        Performs a command with the 2 steps - deploy cc - cluster refresh  This orchestration is needed for the staleness wizard, so it can invoke a single command at wizard finish.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deploy_client_configs_and_refresh_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deploy_client_configs_and_refresh" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `deploy_client_configs_and_refresh`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/deployClientConfigsAndRefresh', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def deploy_cluster_client_config(self, cluster_name, **kwargs):
        """
        Deploy the Cluster's Kerberos client configuration.
        Deploy the Cluster's Kerberos client configuration.  <p> Deploy krb5.conf to hosts in a cluster. Does not deploy to decommissioned hosts or hosts with active processes. </p>  <p> Available since API v7. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deploy_cluster_client_config(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :param ApiHostRefList body: Hosts in cluster to deploy to. If empty, will target all eligible hosts in the cluster.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.deploy_cluster_client_config_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.deploy_cluster_client_config_with_http_info(cluster_name, **kwargs)
            return data

    def deploy_cluster_client_config_with_http_info(self, cluster_name, **kwargs):
        """
        Deploy the Cluster's Kerberos client configuration.
        Deploy the Cluster's Kerberos client configuration.  <p> Deploy krb5.conf to hosts in a cluster. Does not deploy to decommissioned hosts or hosts with active processes. </p>  <p> Available since API v7. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deploy_cluster_client_config_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :param ApiHostRefList body: Hosts in cluster to deploy to. If empty, will target all eligible hosts in the cluster.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deploy_cluster_client_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `deploy_cluster_client_config`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/deployClusterClientConfig', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def disable_tls(self, cluster_name, **kwargs):
        """
        Disables TLS settings on a cluster.
        Disables TLS settings on a cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_tls(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.disable_tls_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.disable_tls_with_http_info(cluster_name, **kwargs)
            return data

    def disable_tls_with_http_info(self, cluster_name, **kwargs):
        """
        Disables TLS settings on a cluster.
        Disables TLS settings on a cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_tls_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_tls" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `disable_tls`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/disableTls', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def enter_maintenance_mode(self, cluster_name, **kwargs):
        """
        Put the cluster into maintenance mode.
        Put the cluster into maintenance mode. This is a synchronous command. The result is known immediately upon return.  <p>Available since API v2.</p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enter_maintenance_mode(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.enter_maintenance_mode_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.enter_maintenance_mode_with_http_info(cluster_name, **kwargs)
            return data

    def enter_maintenance_mode_with_http_info(self, cluster_name, **kwargs):
        """
        Put the cluster into maintenance mode.
        Put the cluster into maintenance mode. This is a synchronous command. The result is known immediately upon return.  <p>Available since API v2.</p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.enter_maintenance_mode_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enter_maintenance_mode" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `enter_maintenance_mode`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/enterMaintenanceMode', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def exit_maintenance_mode(self, cluster_name, **kwargs):
        """
        Take the cluster out of maintenance mode.
        Take the cluster out of maintenance mode. This is a synchronous command. The result is known immediately upon return.  <p>Available since API v2.</p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.exit_maintenance_mode(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.exit_maintenance_mode_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.exit_maintenance_mode_with_http_info(cluster_name, **kwargs)
            return data

    def exit_maintenance_mode_with_http_info(self, cluster_name, **kwargs):
        """
        Take the cluster out of maintenance mode.
        Take the cluster out of maintenance mode. This is a synchronous command. The result is known immediately upon return.  <p>Available since API v2.</p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.exit_maintenance_mode_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method exit_maintenance_mode" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `exit_maintenance_mode`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/exitMaintenanceMode', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def expire_logs(self, cluster_name, **kwargs):
        """
        Remove backup and disaster related log files in hdfs.
        Remove backup and disaster related log files in hdfs. <p> Available since API v31.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.expire_logs(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :param int days: logs more than these many days old are purged. -2 to use the existing setting
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.expire_logs_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.expire_logs_with_http_info(cluster_name, **kwargs)
            return data

    def expire_logs_with_http_info(self, cluster_name, **kwargs):
        """
        Remove backup and disaster related log files in hdfs.
        Remove backup and disaster related log files in hdfs. <p> Available since API v31.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.expire_logs_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :param int days: logs more than these many days old are purged. -2 to use the existing setting
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'days']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method expire_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `expire_logs`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []
        if 'days' in params:
            query_params.append(('days', params['days']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/expireLogs', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def export(self, cluster_name, **kwargs):
        """
        Export the cluster template for the given cluster.
        Export the cluster template for the given cluster. If cluster does not have host templates defined it will export host templates based on roles assignment.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.export(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: cluster name (required)
        :param bool export_auto_config: export configs set by the auto configuration
        :return: ApiClusterTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.export_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.export_with_http_info(cluster_name, **kwargs)
            return data

    def export_with_http_info(self, cluster_name, **kwargs):
        """
        Export the cluster template for the given cluster.
        Export the cluster template for the given cluster. If cluster does not have host templates defined it will export host templates based on roles assignment.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.export_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: cluster name (required)
        :param bool export_auto_config: export configs set by the auto configuration
        :return: ApiClusterTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'export_auto_config']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `export`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []
        if 'export_auto_config' in params:
            query_params.append(('exportAutoConfig', params['export_auto_config']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/export', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiClusterTemplate',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def first_run(self, cluster_name, **kwargs):
        """
        Prepare and start services in a cluster.
        Prepare and start services in a cluster.  <p> Perform all the steps needed to prepare each service in a cluster and start the services in order. </p>  <p> Available since API v7. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.first_run(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.first_run_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.first_run_with_http_info(cluster_name, **kwargs)
            return data

    def first_run_with_http_info(self, cluster_name, **kwargs):
        """
        Prepare and start services in a cluster.
        Prepare and start services in a cluster.  <p> Perform all the steps needed to prepare each service in a cluster and start the services in order. </p>  <p> Available since API v7. </p>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.first_run_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method first_run" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `first_run`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/firstRun', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_client_config(self, cluster_name, **kwargs):
        """
        Download a zip-compressed archive of the client configuration, of a specific cluster.
        Download a zip-compressed archive of the client configuration, of a specific cluster. Currently, this only includes Kerberos Client Configuration (krb5.conf). For client configuration of services, use the clientConfig endpoint of the services resource. This resource does not require any authentication.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_client_config(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The cluster name. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_client_config_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.get_client_config_with_http_info(cluster_name, **kwargs)
            return data

    def get_client_config_with_http_info(self, cluster_name, **kwargs):
        """
        Download a zip-compressed archive of the client configuration, of a specific cluster.
        Download a zip-compressed archive of the client configuration, of a specific cluster. Currently, this only includes Kerberos Client Configuration (krb5.conf). For client configuration of services, use the clientConfig endpoint of the services resource. This resource does not require any authentication.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_client_config_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The cluster name. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_client_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_client_config`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/octet-stream'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/clientConfig', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_kerberos_info(self, cluster_name, **kwargs):
        """
        Provides Cluster Kerberos information.
        Provides Cluster Kerberos information
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_kerberos_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The cluster name. (required)
        :return: ApiKerberosInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_kerberos_info_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.get_kerberos_info_with_http_info(cluster_name, **kwargs)
            return data

    def get_kerberos_info_with_http_info(self, cluster_name, **kwargs):
        """
        Provides Cluster Kerberos information.
        Provides Cluster Kerberos information
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_kerberos_info_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The cluster name. (required)
        :return: ApiKerberosInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_kerberos_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_kerberos_info`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/kerberosInfo', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiKerberosInfo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_ozone_s3_gateway_info(self, cluster_name, **kwargs):
        """
        Returns the REST url for the Ozone S3 Gateway, as well as the AWS credentials needed to access the S3 endpoint.
        Returns the REST url for the Ozone S3 Gateway, as well as the AWS credentials needed to access the S3 endpoint. Additionally, creates a bucket with the specified name under the volume s3v. If no Ozone is present, or Ozone is not running, returns success with an empty response.  Currently, we get the credentials for the Hive kerberos principal, and give ownership of the created bucket to the same. This is likely not a permanent solution. If the cluster is not kerberizied, we return dummy credentials.  Requires CDH 7.2.1+ or CDH 7.1.3+
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_ozone_s3_gateway_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :param str bucket_name: the name of the bucket to create
        :return: ApiOzoneS3GatewayInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_ozone_s3_gateway_info_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.get_ozone_s3_gateway_info_with_http_info(cluster_name, **kwargs)
            return data

    def get_ozone_s3_gateway_info_with_http_info(self, cluster_name, **kwargs):
        """
        Returns the REST url for the Ozone S3 Gateway, as well as the AWS credentials needed to access the S3 endpoint.
        Returns the REST url for the Ozone S3 Gateway, as well as the AWS credentials needed to access the S3 endpoint. Additionally, creates a bucket with the specified name under the volume s3v. If no Ozone is present, or Ozone is not running, returns success with an empty response.  Currently, we get the credentials for the Hive kerberos principal, and give ownership of the created bucket to the same. This is likely not a permanent solution. If the cluster is not kerberizied, we return dummy credentials.  Requires CDH 7.2.1+ or CDH 7.1.3+
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_ozone_s3_gateway_info_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :param str bucket_name: the name of the bucket to create
        :return: ApiOzoneS3GatewayInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'bucket_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ozone_s3_gateway_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_ozone_s3_gateway_info`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []
        if 'bucket_name' in params:
            query_params.append(('bucketName', params['bucket_name']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/getOzoneS3GatewayInfo', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiOzoneS3GatewayInfo',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_utilization_report(self, cluster_name, **kwargs):
        """
        Provides the resource utilization of the entire cluster as well as the resource utilization per tenant.
        Provides the resource utilization of the entire cluster as well as the resource utilization per tenant. Only available with Cloudera Manager Enterprise Edition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_utilization_report(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: cluster name (required)
        :param list[str] days_of_week: The days of the week for which the user wants to report utilization. Days is a list of number between 1 to 7, where 1 corresponds to Monday, and 7 corrensponds to Sunday. All 7 days are included if this is not specified.
        :param int end_hour_of_day: The end hour of a day for which the user wants to report utilization. The hour is a number between [0-23]. Default value is 23 if this is not specified.
        :param str _from: Start of the time range to report utilization in ISO 8601 format.
        :param int start_hour_of_day: The start hour of a day for which the user wants to report utilization. The hour is a number between [0-23]. Default value is 0 if this is not specified.
        :param str tenant_type: The type of the tenant (POOL or USER).
        :param str to: End of the the time range to report utilization in ISO 8601 format (defaults to now).
        :return: ApiClusterUtilization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_utilization_report_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.get_utilization_report_with_http_info(cluster_name, **kwargs)
            return data

    def get_utilization_report_with_http_info(self, cluster_name, **kwargs):
        """
        Provides the resource utilization of the entire cluster as well as the resource utilization per tenant.
        Provides the resource utilization of the entire cluster as well as the resource utilization per tenant. Only available with Cloudera Manager Enterprise Edition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_utilization_report_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: cluster name (required)
        :param list[str] days_of_week: The days of the week for which the user wants to report utilization. Days is a list of number between 1 to 7, where 1 corresponds to Monday, and 7 corrensponds to Sunday. All 7 days are included if this is not specified.
        :param int end_hour_of_day: The end hour of a day for which the user wants to report utilization. The hour is a number between [0-23]. Default value is 23 if this is not specified.
        :param str _from: Start of the time range to report utilization in ISO 8601 format.
        :param int start_hour_of_day: The start hour of a day for which the user wants to report utilization. The hour is a number between [0-23]. Default value is 0 if this is not specified.
        :param str tenant_type: The type of the tenant (POOL or USER).
        :param str to: End of the the time range to report utilization in ISO 8601 format (defaults to now).
        :return: ApiClusterUtilization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'days_of_week', 'end_hour_of_day', '_from', 'start_hour_of_day', 'tenant_type', 'to']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_utilization_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_utilization_report`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []
        if 'days_of_week' in params:
            query_params.append(('daysOfWeek', params['days_of_week']))
            collection_formats['daysOfWeek'] = 'multi'
        if 'end_hour_of_day' in params:
            query_params.append(('endHourOfDay', params['end_hour_of_day']))
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'start_hour_of_day' in params:
            query_params.append(('startHourOfDay', params['start_hour_of_day']))
        if 'tenant_type' in params:
            query_params.append(('tenantType', params['tenant_type']))
        if 'to' in params:
            query_params.append(('to', params['to']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/utilization', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiClusterUtilization',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def inspect_hosts_command(self, cluster_name, **kwargs):
        """
        Runs the host inspector on the configured hosts in the specified cluster.
        Runs the host inspector on the configured hosts in the specified cluster.  Available since V8.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.inspect_hosts_command(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.inspect_hosts_command_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.inspect_hosts_command_with_http_info(cluster_name, **kwargs)
            return data

    def inspect_hosts_command_with_http_info(self, cluster_name, **kwargs):
        """
        Runs the host inspector on the configured hosts in the specified cluster.
        Runs the host inspector on the configured hosts in the specified cluster.  Available since V8.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.inspect_hosts_command_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method inspect_hosts_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `inspect_hosts_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/inspectHosts', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def is_tls_enabled(self, cluster_name, **kwargs):
        """
        Returns whether a cluster has any TLS settings enabled.
        Returns whether a cluster has any TLS settings enabled. This only checks settings that would have been enabled by Auto-TLS.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.is_tls_enabled(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.is_tls_enabled_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.is_tls_enabled_with_http_info(cluster_name, **kwargs)
            return data

    def is_tls_enabled_with_http_info(self, cluster_name, **kwargs):
        """
        Returns whether a cluster has any TLS settings enabled.
        Returns whether a cluster has any TLS settings enabled. This only checks settings that would have been enabled by Auto-TLS.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.is_tls_enabled_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method is_tls_enabled" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `is_tls_enabled`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/isTlsEnabled', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='bool',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_active_commands(self, cluster_name, **kwargs):
        """
        List active cluster commands.
        List active cluster commands.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_active_commands(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiCommandList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_active_commands_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.list_active_commands_with_http_info(cluster_name, **kwargs)
            return data

    def list_active_commands_with_http_info(self, cluster_name, **kwargs):
        """
        List active cluster commands.
        List active cluster commands.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_active_commands_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiCommandList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_active_commands" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `list_active_commands`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommandList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_dfs_services(self, cluster_name, **kwargs):
        """
        List the services that can provide distributed file system (DFS) capabilities in this cluster.
        List the services that can provide distributed file system (DFS) capabilities in this cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_dfs_services(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: cluster name (required)
        :param str view: data view required for matching services
        :return: ApiServiceList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_dfs_services_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.list_dfs_services_with_http_info(cluster_name, **kwargs)
            return data

    def list_dfs_services_with_http_info(self, cluster_name, **kwargs):
        """
        List the services that can provide distributed file system (DFS) capabilities in this cluster.
        List the services that can provide distributed file system (DFS) capabilities in this cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_dfs_services_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: cluster name (required)
        :param str view: data view required for matching services
        :return: ApiServiceList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_dfs_services" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `list_dfs_services`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/dfsServices', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiServiceList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_hosts(self, cluster_name, **kwargs):
        """
        Returns hosts in the system filtered by optional host configuration parameters, if specified.
        Returns hosts in the system filtered by optional host configuration parameters, if specified.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_hosts(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: Name of the cluster (required)
        :param str config_name: optional host config name to filter hosts by. Available from v40.
        :param str config_value: host config value associated with config name. Available from v40.
        :param str view: The view to materialize
        :return: ApiHostList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_hosts_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.list_hosts_with_http_info(cluster_name, **kwargs)
            return data

    def list_hosts_with_http_info(self, cluster_name, **kwargs):
        """
        Returns hosts in the system filtered by optional host configuration parameters, if specified.
        Returns hosts in the system filtered by optional host configuration parameters, if specified.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_hosts_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: Name of the cluster (required)
        :param str config_name: optional host config name to filter hosts by. Available from v40.
        :param str config_value: host config value associated with config name. Available from v40.
        :param str view: The view to materialize
        :return: ApiHostList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'config_name', 'config_value', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_hosts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `list_hosts`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []
        if 'config_name' in params:
            query_params.append(('configName', params['config_name']))
        if 'config_value' in params:
            query_params.append(('configValue', params['config_value']))
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/hosts', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiHostList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_service_types(self, cluster_name, **kwargs):
        """
        List the supported service types for a cluster.
        List the supported service types for a cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_service_types(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The cluster. (required)
        :return: ApiServiceTypeList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_service_types_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.list_service_types_with_http_info(cluster_name, **kwargs)
            return data

    def list_service_types_with_http_info(self, cluster_name, **kwargs):
        """
        List the supported service types for a cluster.
        List the supported service types for a cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_service_types_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The cluster. (required)
        :return: ApiServiceTypeList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_service_types" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `list_service_types`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/serviceTypes', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiServiceTypeList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_upgrade_domains(self, cluster_name, **kwargs):
        """
        Returns the Upgrade Domains associated with the cluster and the host names that belong to each Upgrade Domain.
        Returns the Upgrade Domains associated with the cluster and the host names that belong to each Upgrade Domain. Hosts without an Upgrade Domain set will default to using the rack assignment of the host.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_upgrade_domains(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: ApiHdfsUpgradeDomainList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_upgrade_domains_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.list_upgrade_domains_with_http_info(cluster_name, **kwargs)
            return data

    def list_upgrade_domains_with_http_info(self, cluster_name, **kwargs):
        """
        Returns the Upgrade Domains associated with the cluster and the host names that belong to each Upgrade Domain.
        Returns the Upgrade Domains associated with the cluster and the host names that belong to each Upgrade Domain. Hosts without an Upgrade Domain set will default to using the rack assignment of the host.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_upgrade_domains_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: ApiHdfsUpgradeDomainList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_upgrade_domains" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `list_upgrade_domains`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/upgradeDomains', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiHdfsUpgradeDomainList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def perf_inspector_command(self, cluster_name, **kwargs):
        """
        Run cluster performance diagnostics test.
        Run cluster performance diagnostics test.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.perf_inspector_command(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param ApiClusterPerfInspectorArgs body: Optional arguments for the command. See ApiClusterPerfInspectorArgs.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.perf_inspector_command_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.perf_inspector_command_with_http_info(cluster_name, **kwargs)
            return data

    def perf_inspector_command_with_http_info(self, cluster_name, **kwargs):
        """
        Run cluster performance diagnostics test.
        Run cluster performance diagnostics test.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.perf_inspector_command_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param ApiClusterPerfInspectorArgs body: Optional arguments for the command. See ApiClusterPerfInspectorArgs.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method perf_inspector_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `perf_inspector_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/perfInspector', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def pools_refresh(self, cluster_name, **kwargs):
        """
        Updates all refreshable configuration files for services with Dynamic Resource Pools.
        Updates all refreshable configuration files for services with Dynamic Resource Pools. <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.pools_refresh(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.pools_refresh_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.pools_refresh_with_http_info(cluster_name, **kwargs)
            return data

    def pools_refresh_with_http_info(self, cluster_name, **kwargs):
        """
        Updates all refreshable configuration files for services with Dynamic Resource Pools.
        Updates all refreshable configuration files for services with Dynamic Resource Pools. <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.pools_refresh_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pools_refresh" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `pools_refresh`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/poolsRefresh', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def pre_upgrade_check_command(self, cluster_name, **kwargs):
        """
        Run cluster pre-upgrade check(s) when upgrading from specified version of CDH to the other.
        Run cluster pre-upgrade check(s) when upgrading from specified version of CDH to the other. <p> Allows the following upgrade checks: <ul> <li>Minor upgrades from any CDH 5 to any CDH 5</li> <li>Major upgrades from any CDH 5 to any CDH 6</li> <li>Minor upgrades from any CDH 6 to any CDH 6</li> <li>Maintenance upgrades or downgrades (a.b.x to a.b.y)</li> </ul>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.pre_upgrade_check_command(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param ApiCdhUpgradeArgs body: Arguments for the command. See ApiCdhUpgradeArgs.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.pre_upgrade_check_command_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.pre_upgrade_check_command_with_http_info(cluster_name, **kwargs)
            return data

    def pre_upgrade_check_command_with_http_info(self, cluster_name, **kwargs):
        """
        Run cluster pre-upgrade check(s) when upgrading from specified version of CDH to the other.
        Run cluster pre-upgrade check(s) when upgrading from specified version of CDH to the other. <p> Allows the following upgrade checks: <ul> <li>Minor upgrades from any CDH 5 to any CDH 5</li> <li>Major upgrades from any CDH 5 to any CDH 6</li> <li>Minor upgrades from any CDH 6 to any CDH 6</li> <li>Maintenance upgrades or downgrades (a.b.x to a.b.y)</li> </ul>
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.pre_upgrade_check_command_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param ApiCdhUpgradeArgs body: Arguments for the command. See ApiCdhUpgradeArgs.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pre_upgrade_check_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `pre_upgrade_check_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/preUpgradeCheck', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_cluster(self, cluster_name, **kwargs):
        """
        Reads information about a cluster.
        Reads information about a cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_cluster(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: Name of cluster to look up. (required)
        :return: ApiCluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_cluster_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.read_cluster_with_http_info(cluster_name, **kwargs)
            return data

    def read_cluster_with_http_info(self, cluster_name, **kwargs):
        """
        Reads information about a cluster.
        Reads information about a cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_cluster_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: Name of cluster to look up. (required)
        :return: ApiCluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `read_cluster`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCluster',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_clusters(self, **kwargs):
        """
        List all known clusters.
        List all known clusters.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_clusters(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_type: Type of cluster, either \"any\", \"base\" or \"compute\". Default is \"base\".
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiClusterList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_clusters_with_http_info(**kwargs)
        else:
            (data) = self.read_clusters_with_http_info(**kwargs)
            return data

    def read_clusters_with_http_info(self, **kwargs):
        """
        List all known clusters.
        List all known clusters.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_clusters_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_type: Type of cluster, either \"any\", \"base\" or \"compute\". Default is \"base\".
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiClusterList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_type', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_clusters" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'cluster_type' in params:
            query_params.append(('clusterType', params['cluster_type']))
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiClusterList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_tags(self, cluster_name, **kwargs):
        """
        Returns the tags associated with this cluster.
        Returns the tags associated with this cluster. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_tags(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :param int limit: Number of tags
        :param int offset: Index of the first tag to retrieve
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_tags_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.read_tags_with_http_info(cluster_name, **kwargs)
            return data

    def read_tags_with_http_info(self, cluster_name, **kwargs):
        """
        Returns the tags associated with this cluster.
        Returns the tags associated with this cluster. Tag names beginning with the prefix _cldr_ (case insensitive) are reserved for internal use by Cloudera.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_tags_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :param int limit: Number of tags
        :param int offset: Index of the first tag to retrieve
        :return: list[ApiEntityTag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'limit', 'offset']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `read_tags`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/tags', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='list[ApiEntityTag]',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def refresh(self, cluster_name, **kwargs):
        """
        Updates all refreshable configuration files in the cluster.
        Updates all refreshable configuration files in the cluster. Will not restart any roles. <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.refresh(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.refresh_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.refresh_with_http_info(cluster_name, **kwargs)
            return data

    def refresh_with_http_info(self, cluster_name, **kwargs):
        """
        Updates all refreshable configuration files in the cluster.
        Updates all refreshable configuration files in the cluster. Will not restart any roles. <p> Available since API v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.refresh_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method refresh" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `refresh`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/refresh', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def remove_all_hosts(self, cluster_name, **kwargs):
        """
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_all_hosts(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :return: ApiHostRefList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.remove_all_hosts_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.remove_all_hosts_with_http_info(cluster_name, **kwargs)
            return data

    def remove_all_hosts_with_http_info(self, cluster_name, **kwargs):
        """
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_all_hosts_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :return: ApiHostRefList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_all_hosts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `remove_all_hosts`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/hosts', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiHostRefList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def remove_host(self, cluster_name, host_id, **kwargs):
        """
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_host(cluster_name, host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str host_id:  (required)
        :return: ApiHostRef
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.remove_host_with_http_info(cluster_name, host_id, **kwargs)
        else:
            (data) = self.remove_host_with_http_info(cluster_name, host_id, **kwargs)
            return data

    def remove_host_with_http_info(self, cluster_name, host_id, **kwargs):
        """
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_host_with_http_info(cluster_name, host_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name:  (required)
        :param str host_id:  (required)
        :return: ApiHostRef
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'host_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `remove_host`")
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params) or (params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `remove_host`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'host_id' in params:
            path_params['hostId'] = params['host_id']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/hosts/{hostId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiHostRef',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def restart_command(self, cluster_name, **kwargs):
        """
        Restart all services in the cluster.
        Restart all services in the cluster. <p> Services are stopped then started in the appropriate order given their dependencies. The command can optionally restart only stale services and their dependencies as well as redeploy client configuration on all services in the cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.restart_command(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param ApiRestartClusterArgs body: arguments for the restart command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.restart_command_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.restart_command_with_http_info(cluster_name, **kwargs)
            return data

    def restart_command_with_http_info(self, cluster_name, **kwargs):
        """
        Restart all services in the cluster.
        Restart all services in the cluster. <p> Services are stopped then started in the appropriate order given their dependencies. The command can optionally restart only stale services and their dependencies as well as redeploy client configuration on all services in the cluster.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.restart_command_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param ApiRestartClusterArgs body: arguments for the restart command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method restart_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `restart_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/restart', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def rolling_restart(self, cluster_name, **kwargs):
        """
        Command to do a \"best-effort\" rolling restart of the given cluster, i.
        Command to do a \"best-effort\" rolling restart of the given cluster, i.e. it does plain restart of services that cannot be rolling restarted, followed by first rolling restarting non-slaves and then rolling restarting the slave roles of services that can be rolling restarted. The slave restarts are done host-by-host. <p> Available since API v4. Only available with Cloudera Manager Enterprise Edition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.rolling_restart(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param ApiRollingRestartClusterArgs body: Arguments for the rolling restart command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.rolling_restart_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.rolling_restart_with_http_info(cluster_name, **kwargs)
            return data

    def rolling_restart_with_http_info(self, cluster_name, **kwargs):
        """
        Command to do a \"best-effort\" rolling restart of the given cluster, i.
        Command to do a \"best-effort\" rolling restart of the given cluster, i.e. it does plain restart of services that cannot be rolling restarted, followed by first rolling restarting non-slaves and then rolling restarting the slave roles of services that can be rolling restarted. The slave restarts are done host-by-host. <p> Available since API v4. Only available with Cloudera Manager Enterprise Edition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.rolling_restart_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param ApiRollingRestartClusterArgs body: Arguments for the rolling restart command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rolling_restart" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `rolling_restart`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/rollingRestart', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def rolling_upgrade(self, cluster_name, **kwargs):
        """
        Command to do a rolling upgrade of specific services in the given cluster  This command does not handle any services that don't support rolling upgrades.
        Command to do a rolling upgrade of specific services in the given cluster  This command does not handle any services that don't support rolling upgrades. The command will throw an error and not start if upgrade of any such service is requested.  This command does not upgrade the full CDH Cluster. You should normally use the upgradeCDH Command for upgrading the cluster. This is primarily helpful if you need to need to recover from an upgrade failure or for advanced users to script an alternative to the upgradeCdhCommand.  This command expects the binaries to be available on hosts and activated. It does not change any binaries on the hosts.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.rolling_upgrade(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param ApiRollingUpgradeServicesArgs body: Arguments for the rolling upgrade command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.rolling_upgrade_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.rolling_upgrade_with_http_info(cluster_name, **kwargs)
            return data

    def rolling_upgrade_with_http_info(self, cluster_name, **kwargs):
        """
        Command to do a rolling upgrade of specific services in the given cluster  This command does not handle any services that don't support rolling upgrades.
        Command to do a rolling upgrade of specific services in the given cluster  This command does not handle any services that don't support rolling upgrades. The command will throw an error and not start if upgrade of any such service is requested.  This command does not upgrade the full CDH Cluster. You should normally use the upgradeCDH Command for upgrading the cluster. This is primarily helpful if you need to need to recover from an upgrade failure or for advanced users to script an alternative to the upgradeCdhCommand.  This command expects the binaries to be available on hosts and activated. It does not change any binaries on the hosts.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.rolling_upgrade_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param ApiRollingUpgradeServicesArgs body: Arguments for the rolling upgrade command.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rolling_upgrade" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `rolling_upgrade`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/rollingUpgrade', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def start_command(self, cluster_name, **kwargs):
        """
        Start all services in the cluster.
        Start all services in the cluster. <p> Services are started in the appropriate order given their dependencies.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.start_command(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.start_command_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.start_command_with_http_info(cluster_name, **kwargs)
            return data

    def start_command_with_http_info(self, cluster_name, **kwargs):
        """
        Start all services in the cluster.
        Start all services in the cluster. <p> Services are started in the appropriate order given their dependencies.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.start_command_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `start_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/start', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def stop_command(self, cluster_name, **kwargs):
        """
        Stop all services in the cluster.
        Stop all services in the cluster. <p> Services are stopped in the appropriate order given their dependencies.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.stop_command(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.stop_command_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.stop_command_with_http_info(cluster_name, **kwargs)
            return data

    def stop_command_with_http_info(self, cluster_name, **kwargs):
        """
        Stop all services in the cluster.
        Stop all services in the cluster. <p> Services are stopped in the appropriate order given their dependencies.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.stop_command_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stop_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `stop_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/stop', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_cluster(self, cluster_name, **kwargs):
        """
        Update an existing cluster.
        Update an existing cluster. <p> To update the CDH version, provide the new value in the \"fullVersion\" property. Setting a correct version that matches the actual installed software will ensure the correct version-specific features, such as services, roles, commands, and configurations. This need not be manually set for clusters using parcels. In general this action is only necessary after the CDH packages have been manually updated. Note that a downgrade may be rejected if it would render existing services or roles unusable. For major upgrade, the \"upgradeService\" cluster command should be used instead.</p> <p> To rename the cluster, provide the new name in the \"displayName\" property for API >= 6, or in the \"name\" property for API <=5. <p> Available since API v2.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_cluster(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param ApiCluster body: 
        :return: ApiCluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_cluster_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.update_cluster_with_http_info(cluster_name, **kwargs)
            return data

    def update_cluster_with_http_info(self, cluster_name, **kwargs):
        """
        Update an existing cluster.
        Update an existing cluster. <p> To update the CDH version, provide the new value in the \"fullVersion\" property. Setting a correct version that matches the actual installed software will ensure the correct version-specific features, such as services, roles, commands, and configurations. This need not be manually set for clusters using parcels. In general this action is only necessary after the CDH packages have been manually updated. Note that a downgrade may be rejected if it would render existing services or roles unusable. For major upgrade, the \"upgradeService\" cluster command should be used instead.</p> <p> To rename the cluster, provide the new name in the \"displayName\" property for API >= 6, or in the \"name\" property for API <=5. <p> Available since API v2.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_cluster_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param ApiCluster body: 
        :return: ApiCluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `update_cluster`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCluster',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def upgrade_cdh_command(self, cluster_name, **kwargs):
        """
        Perform CDH upgrade to the specified version.
        Perform CDH upgrade to the specified version. <p> Allows the following upgrades: <ul> <li>Major upgrades from any CDH 4 to any CDH 5</li> <li>Minor upgrades from any CDH 5 to any CDH 5</li> <li>Maintenance upgrades or downgrades (a.b.x to a.b.y)</li> </ul> <p> If using packages, CDH packages on all hosts of the cluster must be manually upgraded before this command is issued. <p> The command will upgrade the services and their configuration to the version available in the CDH5 distribution. <p> Unless rolling upgrade options are provided, the entire cluster will experience downtime. If rolling upgrade options are provided, command will do a \"best-effort\" rolling upgrade of the given cluster, i.e. it does plain upgrade of services that cannot be rolling upgraded, followed by first rolling upgrading non-slaves and then rolling restarting the slave roles of services that can be rolling restarted. The slave restarts are done host-by-host. <p> Available since v9. Rolling upgrade is only available with Cloudera Manager Enterprise Edition. A more limited upgrade variant available since v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upgrade_cdh_command(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param ApiCdhUpgradeArgs body: Arguments for the command. See ApiCdhUpgradeArgs.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.upgrade_cdh_command_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.upgrade_cdh_command_with_http_info(cluster_name, **kwargs)
            return data

    def upgrade_cdh_command_with_http_info(self, cluster_name, **kwargs):
        """
        Perform CDH upgrade to the specified version.
        Perform CDH upgrade to the specified version. <p> Allows the following upgrades: <ul> <li>Major upgrades from any CDH 4 to any CDH 5</li> <li>Minor upgrades from any CDH 5 to any CDH 5</li> <li>Maintenance upgrades or downgrades (a.b.x to a.b.y)</li> </ul> <p> If using packages, CDH packages on all hosts of the cluster must be manually upgraded before this command is issued. <p> The command will upgrade the services and their configuration to the version available in the CDH5 distribution. <p> Unless rolling upgrade options are provided, the entire cluster will experience downtime. If rolling upgrade options are provided, command will do a \"best-effort\" rolling upgrade of the given cluster, i.e. it does plain upgrade of services that cannot be rolling upgraded, followed by first rolling upgrading non-slaves and then rolling restarting the slave roles of services that can be rolling restarted. The slave restarts are done host-by-host. <p> Available since v9. Rolling upgrade is only available with Cloudera Manager Enterprise Edition. A more limited upgrade variant available since v6.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upgrade_cdh_command_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :param ApiCdhUpgradeArgs body: Arguments for the command. See ApiCdhUpgradeArgs.
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upgrade_cdh_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `upgrade_cdh_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/upgradeCdh', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def upgrade_services_command(self, cluster_name, **kwargs):
        """
        Upgrades the services in the cluster to the CDH5 version.
        Upgrades the services in the cluster to the CDH5 version. <p> This command requires that the CDH packages in the hosts used by the cluster be upgraded to CDH5 before this command is issued. Once issued, this command will stop all running services before proceeding. <p> If parcels are used instead of CDH system packages then the following steps need to happen in order: <ol> <li>Stop all services manually</li> <li>Activate parcel</li> <li>Run this upgrade command</li> </ol> The command will upgrade the services and their configuration to the version available in the CDH5 distribution.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upgrade_services_command(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.upgrade_services_command_with_http_info(cluster_name, **kwargs)
        else:
            (data) = self.upgrade_services_command_with_http_info(cluster_name, **kwargs)
            return data

    def upgrade_services_command_with_http_info(self, cluster_name, **kwargs):
        """
        Upgrades the services in the cluster to the CDH5 version.
        Upgrades the services in the cluster to the CDH5 version. <p> This command requires that the CDH packages in the hosts used by the cluster be upgraded to CDH5 before this command is issued. Once issued, this command will stop all running services before proceeding. <p> If parcels are used instead of CDH system packages then the following steps need to happen in order: <ol> <li>Stop all services manually</li> <li>Activate parcel</li> <li>Run this upgrade command</li> </ol> The command will upgrade the services and their configuration to the version available in the CDH5 distribution.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upgrade_services_command_with_http_info(cluster_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster. (required)
        :return: ApiCommand
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upgrade_services_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `upgrade_services_command`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/commands/upgradeServices', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiCommand',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
