# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class AuditsResourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def read_audits(self, **kwargs):
        """
        Fetch audit events from Cloudera Manager (CM) and CM managed services like HDFS, HBase, Impala, Hive, and Sentry.
        Fetch audit events from Cloudera Manager (CM) and CM managed services like HDFS, HBase, Impala, Hive, and Sentry. <p> By default, this call will fetch the first 100 audit events (sorted from most recent to oldest) corresponding to a 1 day window based on provided end time (which defaults to the  current CM server time). The <em>startTime</em> and <em>endTime</em> parameters can be used to control the window being queried. <p> Audit events for CM managed services are only retrieved if Cloudera Navigator server is running.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_audits(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str end_time: End of the period to query in ISO 8601 format (defaults to current time).
        :param int max_results: Maximum number of audits to return
        :param str query: The query to filter out audits in the system. It accepts querying the intersection of a list of constraints, joined together with semicolons (without spaces). For example: </p> <dl> <dt>command==listStatus</dt> <dd>looks for audits with listStatus command.</dd> <dt>command==listStatus;username!=foo</dt> <dd>looks for audits with listStatus command but excludes audits generated by foo username</dd> <dt>command==listStatus;source==*oozie*</dt> <dd>looks for audits with listStatus command and source that contains the string 'oozie'. </dd> </dl>  Following are valid selectors for the query (if applicable to the audit): <table> <tr> <th> Selector </th> <th> Description </th> <th> SCM </th> <th> HDFS </th> <th> HBase </th> <th> Hive </th> <th> Impala </th> <th> Sentry </th> </tr> <tr> <td> service </td> <td> Cloudera Manager Service </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> operation </td> <td> Operation name </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> username </td> <td> User name </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> impersonator</td> <td> Impersonator </td> <td> </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> ip_address </td> <td> IP Address </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> allowed </td> <td> Whether the request was allowed or denied </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> qualifier</td> <td> Column qualifier </td> <td> </td> <td> </td> <td> x </td> <td> </td> <td> </td> <td> </td> </tr> <tr> <td> source </td> <td> Source resource of the operation  </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> </td> </tr> <tr> <td> destination </td> <td> Destination resource of the operation </td> <td> </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> </td> </tr> <tr> <td> hostIpAddress </td> <td> Host IP Address </td> <td> x </td> <td> </td> <td> </td> <td> </td> <td> </td> <td> </td> </tr> <tr> <td> role </td> <td> Cloudera Manager Role </td> <td> x </td> <td> </td> <td> </td> <td> </td> <td> </td> <td> </td> </tr> <tr> <td> family </td> <td> Column family </td> <td> </td> <td> </td> <td> x </td> <td> </td> <td> </td> <td> </td> </tr> <tr> <td> database_name </td> <td> Database name </td> <td> </td> <td> </td> <td> </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> table_name </td> <td> Table name </td> <td> </td> <td> </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> object_type </td> <td> Type of object being handled </td> <td> </td> <td> </td> <td> </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> operation_text </td> <td> Command/query text </td> <td> </td> <td> </td> <td> </td> <td> x </td> <td> x </td> <td> x </td> </tr> </table> <p> The only supported operator is <em>\";\"</em> (Boolean AND). Boolean OR is not supported. <p> The supported comparators are <em>==</em> and <em>!=</em> Note that \"LIKE\" comparison is supported using the wild card syntax, for example <em>foo==*value*</em>. Asterisk is interpreted as a wild card character and must not be part of the value. (LIKE comparison queries are converted to standard SQL LIKE syntax, so any % (%25) character in a value that also contains a wild card will be interpreted as a wild card.) <p/> Available since API v8. A subset of these features is available since v4.
        :param int result_offset: Offset of audits to return
        :param str start_time: Start of the period to query in ISO 8601 format (defaults to 1 day ago relative to endTime).
        :return: ApiAuditList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_audits_with_http_info(**kwargs)
        else:
            (data) = self.read_audits_with_http_info(**kwargs)
            return data

    def read_audits_with_http_info(self, **kwargs):
        """
        Fetch audit events from Cloudera Manager (CM) and CM managed services like HDFS, HBase, Impala, Hive, and Sentry.
        Fetch audit events from Cloudera Manager (CM) and CM managed services like HDFS, HBase, Impala, Hive, and Sentry. <p> By default, this call will fetch the first 100 audit events (sorted from most recent to oldest) corresponding to a 1 day window based on provided end time (which defaults to the  current CM server time). The <em>startTime</em> and <em>endTime</em> parameters can be used to control the window being queried. <p> Audit events for CM managed services are only retrieved if Cloudera Navigator server is running.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_audits_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str end_time: End of the period to query in ISO 8601 format (defaults to current time).
        :param int max_results: Maximum number of audits to return
        :param str query: The query to filter out audits in the system. It accepts querying the intersection of a list of constraints, joined together with semicolons (without spaces). For example: </p> <dl> <dt>command==listStatus</dt> <dd>looks for audits with listStatus command.</dd> <dt>command==listStatus;username!=foo</dt> <dd>looks for audits with listStatus command but excludes audits generated by foo username</dd> <dt>command==listStatus;source==*oozie*</dt> <dd>looks for audits with listStatus command and source that contains the string 'oozie'. </dd> </dl>  Following are valid selectors for the query (if applicable to the audit): <table> <tr> <th> Selector </th> <th> Description </th> <th> SCM </th> <th> HDFS </th> <th> HBase </th> <th> Hive </th> <th> Impala </th> <th> Sentry </th> </tr> <tr> <td> service </td> <td> Cloudera Manager Service </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> operation </td> <td> Operation name </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> username </td> <td> User name </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> impersonator</td> <td> Impersonator </td> <td> </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> ip_address </td> <td> IP Address </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> allowed </td> <td> Whether the request was allowed or denied </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> qualifier</td> <td> Column qualifier </td> <td> </td> <td> </td> <td> x </td> <td> </td> <td> </td> <td> </td> </tr> <tr> <td> source </td> <td> Source resource of the operation  </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> </td> </tr> <tr> <td> destination </td> <td> Destination resource of the operation </td> <td> </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> <td> </td> </tr> <tr> <td> hostIpAddress </td> <td> Host IP Address </td> <td> x </td> <td> </td> <td> </td> <td> </td> <td> </td> <td> </td> </tr> <tr> <td> role </td> <td> Cloudera Manager Role </td> <td> x </td> <td> </td> <td> </td> <td> </td> <td> </td> <td> </td> </tr> <tr> <td> family </td> <td> Column family </td> <td> </td> <td> </td> <td> x </td> <td> </td> <td> </td> <td> </td> </tr> <tr> <td> database_name </td> <td> Database name </td> <td> </td> <td> </td> <td> </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> table_name </td> <td> Table name </td> <td> </td> <td> </td> <td> x </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> object_type </td> <td> Type of object being handled </td> <td> </td> <td> </td> <td> </td> <td> x </td> <td> x </td> <td> x </td> </tr> <tr> <td> operation_text </td> <td> Command/query text </td> <td> </td> <td> </td> <td> </td> <td> x </td> <td> x </td> <td> x </td> </tr> </table> <p> The only supported operator is <em>\";\"</em> (Boolean AND). Boolean OR is not supported. <p> The supported comparators are <em>==</em> and <em>!=</em> Note that \"LIKE\" comparison is supported using the wild card syntax, for example <em>foo==*value*</em>. Asterisk is interpreted as a wild card character and must not be part of the value. (LIKE comparison queries are converted to standard SQL LIKE syntax, so any % (%25) character in a value that also contains a wild card will be interpreted as a wild card.) <p/> Available since API v8. A subset of these features is available since v4.
        :param int result_offset: Offset of audits to return
        :param str start_time: Start of the period to query in ISO 8601 format (defaults to 1 day ago relative to endTime).
        :return: ApiAuditList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['end_time', 'max_results', 'query', 'result_offset', 'start_time']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_audits" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'end_time' in params:
            query_params.append(('endTime', params['end_time']))
        if 'max_results' in params:
            query_params.append(('maxResults', params['max_results']))
        if 'query' in params:
            query_params.append(('query', params['query']))
        if 'result_offset' in params:
            query_params.append(('resultOffset', params['result_offset']))
        if 'start_time' in params:
            query_params.append(('startTime', params['start_time']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/audits', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiAuditList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def stream_audits(self, **kwargs):
        """
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.stream_audits(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str end_time: 
        :param int max_results: 
        :param str query: 
        :param int result_offset: 
        :param str start_time: 
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.stream_audits_with_http_info(**kwargs)
        else:
            (data) = self.stream_audits_with_http_info(**kwargs)
            return data

    def stream_audits_with_http_info(self, **kwargs):
        """
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.stream_audits_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str end_time: 
        :param int max_results: 
        :param str query: 
        :param int result_offset: 
        :param str start_time: 
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['end_time', 'max_results', 'query', 'result_offset', 'start_time']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stream_audits" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'end_time' in params:
            query_params.append(('endTime', params['end_time']))
        if 'max_results' in params:
            query_params.append(('maxResults', params['max_results']))
        if 'query' in params:
            query_params.append(('query', params['query']))
        if 'result_offset' in params:
            query_params.append(('resultOffset', params['result_offset']))
        if 'start_time' in params:
            query_params.append(('startTime', params['start_time']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/audits/stream', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
