# coding: utf-8

"""
    Cloudera Manager API

    <h1>Cloudera Manager API v43</h1>       <p>Introduced in Cloudera Manager 7.2.6</p>       <p><a href=\"http://www.cloudera.com/documentation.html\">Cloudera Product Documentation</a></p>

    OpenAPI spec version: 7.2.6
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ActivitiesResourceApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_metrics(self, activity_id, cluster_name, service_name, **kwargs):
        """
        Fetch metric readings for a particular activity.
        Fetch metric readings for a particular activity. <p> By default, this call will look up all metrics available for the activity. If only specific metrics are desired, use the <i>metrics</i> parameter. <p> By default, the returned results correspond to a 5 minute window based on the provided end time (which defaults to the current server time). The <i>from</i> and <i>to</i> parameters can be used to control the window being queried. A maximum window of 3 hours is enforced. <p> When requesting a \"full\" view, aside from the extended properties of the returned metric data, the collection will also contain information about all metrics available for the activity, even if no readings are available in the requested window.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_metrics(activity_id, cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str activity_id: The name of the activity. (required)
        :param str cluster_name: The name of the cluster. (required)
        :param str service_name: The name of the service. (required)
        :param str _from: Start of the period to query.
        :param list[str] metrics: Filter for which metrics to query.
        :param str to: End of the period to query.
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiMetricList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_metrics_with_http_info(activity_id, cluster_name, service_name, **kwargs)
        else:
            (data) = self.get_metrics_with_http_info(activity_id, cluster_name, service_name, **kwargs)
            return data

    def get_metrics_with_http_info(self, activity_id, cluster_name, service_name, **kwargs):
        """
        Fetch metric readings for a particular activity.
        Fetch metric readings for a particular activity. <p> By default, this call will look up all metrics available for the activity. If only specific metrics are desired, use the <i>metrics</i> parameter. <p> By default, the returned results correspond to a 5 minute window based on the provided end time (which defaults to the current server time). The <i>from</i> and <i>to</i> parameters can be used to control the window being queried. A maximum window of 3 hours is enforced. <p> When requesting a \"full\" view, aside from the extended properties of the returned metric data, the collection will also contain information about all metrics available for the activity, even if no readings are available in the requested window.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_metrics_with_http_info(activity_id, cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str activity_id: The name of the activity. (required)
        :param str cluster_name: The name of the cluster. (required)
        :param str service_name: The name of the service. (required)
        :param str _from: Start of the period to query.
        :param list[str] metrics: Filter for which metrics to query.
        :param str to: End of the period to query.
        :param str view: The view of the data to materialize, either \"summary\" or \"full\".
        :return: ApiMetricList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_id', 'cluster_name', 'service_name', '_from', 'metrics', 'to', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_id' is set
        if ('activity_id' not in params) or (params['activity_id'] is None):
            raise ValueError("Missing the required parameter `activity_id` when calling `get_metrics`")
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_metrics`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `get_metrics`")


        collection_formats = {}

        path_params = {}
        if 'activity_id' in params:
            path_params['activityId'] = params['activity_id']
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'metrics' in params:
            query_params.append(('metrics', params['metrics']))
            collection_formats['metrics'] = 'multi'
        if 'to' in params:
            query_params.append(('to', params['to']))
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/activities/{activityId}/metrics', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiMetricList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_activities(self, cluster_name, service_name, **kwargs):
        """
        Read all activities in the system.
        Read all activities in the system
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_activities(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :param str service_name: The name of the service (required)
        :param int max_results: The maximum number of activities to return.
        :param str query: The query to perform to find activities in the system. By default, this call returns top level (i.e. root) activities that have currently started. <p> The query specifies the intersection of a list of constraints, joined together with semicolons (without spaces). For example: </p> <dl> <dt>status==started;parent==</dt> <dd>looks for running root activities. This is also the default query.</dd> <dt>status==failed;finishTime=gt=2012-04-01T20:30:00.000Z</dt> <dd>looks for failed activities after the given date time.</dd> <dt>name==Pi Estimator;startTime=gt=2012-04-01T20:30:00.000Z</dt> <dd>looks for activities started after the given date time, with the name of \"Pi Estimator\".</dd> <dt>startTime=lt=2012-01-02T00:00:00.000Z;finishTime=ge=2012-01-01T00:00:00.000Z</dt> <dd>looks for activities that are active on 2012 New Year's Day. Note that they may start before or finish after that day.</dd> <dt>status==failed;parent==000014-20120425161321-oozie-joe</dt> <dd>looks for failed child activities of the given parent activity id.</dd> <dt>status==started;metrics.cpu_user=gt=10</dt> <dd>looks for started activities that are using more than 10 cores per second.</dd> <dt>type==hive;metrics.user==bc;finishTime=gt=2012-04-01T20:30:00.000Z</dt> <dd>looks for all hive queries submitted by user bc after the given date time.</dd> </dl>  You may query any fields present in the ApiActivity object. You can also query by activity metric values using the <em>metrics.*</em> syntax. Values for date time fields should be ISO8601 timestamps. <p> The valid comparators are <em>==</em>, <em>!=</em>, <em>=lt=</em>, <em>=le=</em>, <em>=ge=</em>, and <em>=gt=</em>. They stand for \"==\", \"!=\", \"&lt;\", \"&lt;=\", \"&gt;=\", \"&gt;\" respectively.
        :param int result_offset: Specified the offset of activities to return.
        :param str view: The view of the activities to materialize
        :return: ApiActivityList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_activities_with_http_info(cluster_name, service_name, **kwargs)
        else:
            (data) = self.read_activities_with_http_info(cluster_name, service_name, **kwargs)
            return data

    def read_activities_with_http_info(self, cluster_name, service_name, **kwargs):
        """
        Read all activities in the system.
        Read all activities in the system
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_activities_with_http_info(cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cluster_name: The name of the cluster (required)
        :param str service_name: The name of the service (required)
        :param int max_results: The maximum number of activities to return.
        :param str query: The query to perform to find activities in the system. By default, this call returns top level (i.e. root) activities that have currently started. <p> The query specifies the intersection of a list of constraints, joined together with semicolons (without spaces). For example: </p> <dl> <dt>status==started;parent==</dt> <dd>looks for running root activities. This is also the default query.</dd> <dt>status==failed;finishTime=gt=2012-04-01T20:30:00.000Z</dt> <dd>looks for failed activities after the given date time.</dd> <dt>name==Pi Estimator;startTime=gt=2012-04-01T20:30:00.000Z</dt> <dd>looks for activities started after the given date time, with the name of \"Pi Estimator\".</dd> <dt>startTime=lt=2012-01-02T00:00:00.000Z;finishTime=ge=2012-01-01T00:00:00.000Z</dt> <dd>looks for activities that are active on 2012 New Year's Day. Note that they may start before or finish after that day.</dd> <dt>status==failed;parent==000014-20120425161321-oozie-joe</dt> <dd>looks for failed child activities of the given parent activity id.</dd> <dt>status==started;metrics.cpu_user=gt=10</dt> <dd>looks for started activities that are using more than 10 cores per second.</dd> <dt>type==hive;metrics.user==bc;finishTime=gt=2012-04-01T20:30:00.000Z</dt> <dd>looks for all hive queries submitted by user bc after the given date time.</dd> </dl>  You may query any fields present in the ApiActivity object. You can also query by activity metric values using the <em>metrics.*</em> syntax. Values for date time fields should be ISO8601 timestamps. <p> The valid comparators are <em>==</em>, <em>!=</em>, <em>=lt=</em>, <em>=le=</em>, <em>=ge=</em>, and <em>=gt=</em>. They stand for \"==\", \"!=\", \"&lt;\", \"&lt;=\", \"&gt;=\", \"&gt;\" respectively.
        :param int result_offset: Specified the offset of activities to return.
        :param str view: The view of the activities to materialize
        :return: ApiActivityList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_name', 'service_name', 'max_results', 'query', 'result_offset', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_activities" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `read_activities`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `read_activities`")


        collection_formats = {}

        path_params = {}
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'max_results' in params:
            query_params.append(('maxResults', params['max_results']))
        if 'query' in params:
            query_params.append(('query', params['query']))
        if 'result_offset' in params:
            query_params.append(('resultOffset', params['result_offset']))
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/activities', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiActivityList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_activity(self, activity_id, cluster_name, service_name, **kwargs):
        """
        Returns a specific activity in the system.
        Returns a specific activity in the system
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_activity(activity_id, cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str activity_id: The id of the activity to retrieve (required)
        :param str cluster_name: The name of the cluster (required)
        :param str service_name: The name of the service (required)
        :param str view: The view of the activity to materialize
        :return: ApiActivity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_activity_with_http_info(activity_id, cluster_name, service_name, **kwargs)
        else:
            (data) = self.read_activity_with_http_info(activity_id, cluster_name, service_name, **kwargs)
            return data

    def read_activity_with_http_info(self, activity_id, cluster_name, service_name, **kwargs):
        """
        Returns a specific activity in the system.
        Returns a specific activity in the system
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_activity_with_http_info(activity_id, cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str activity_id: The id of the activity to retrieve (required)
        :param str cluster_name: The name of the cluster (required)
        :param str service_name: The name of the service (required)
        :param str view: The view of the activity to materialize
        :return: ApiActivity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_id', 'cluster_name', 'service_name', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_activity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_id' is set
        if ('activity_id' not in params) or (params['activity_id'] is None):
            raise ValueError("Missing the required parameter `activity_id` when calling `read_activity`")
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `read_activity`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `read_activity`")


        collection_formats = {}

        path_params = {}
        if 'activity_id' in params:
            path_params['activityId'] = params['activity_id']
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/activities/{activityId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiActivity',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_child_activities(self, activity_id, cluster_name, service_name, **kwargs):
        """
        Returns the child activities.
        Returns the child activities
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_child_activities(activity_id, cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str activity_id: The id of the activity (required)
        :param str cluster_name: The name of the cluster (required)
        :param str service_name: The name of the service (required)
        :param int max_results: The maximum number of activities to return.
        :param int result_offset: Specified the offset of activities to return.
        :param str view: The view of the children to materialize
        :return: ApiActivityList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_child_activities_with_http_info(activity_id, cluster_name, service_name, **kwargs)
        else:
            (data) = self.read_child_activities_with_http_info(activity_id, cluster_name, service_name, **kwargs)
            return data

    def read_child_activities_with_http_info(self, activity_id, cluster_name, service_name, **kwargs):
        """
        Returns the child activities.
        Returns the child activities
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_child_activities_with_http_info(activity_id, cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str activity_id: The id of the activity (required)
        :param str cluster_name: The name of the cluster (required)
        :param str service_name: The name of the service (required)
        :param int max_results: The maximum number of activities to return.
        :param int result_offset: Specified the offset of activities to return.
        :param str view: The view of the children to materialize
        :return: ApiActivityList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_id', 'cluster_name', 'service_name', 'max_results', 'result_offset', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_child_activities" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_id' is set
        if ('activity_id' not in params) or (params['activity_id'] is None):
            raise ValueError("Missing the required parameter `activity_id` when calling `read_child_activities`")
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `read_child_activities`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `read_child_activities`")


        collection_formats = {}

        path_params = {}
        if 'activity_id' in params:
            path_params['activityId'] = params['activity_id']
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'max_results' in params:
            query_params.append(('maxResults', params['max_results']))
        if 'result_offset' in params:
            query_params.append(('resultOffset', params['result_offset']))
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/activities/{activityId}/children', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiActivityList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_similar_activities(self, activity_id, cluster_name, service_name, **kwargs):
        """
        Returns a list of similar activities.
        Returns a list of similar activities
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_similar_activities(activity_id, cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str activity_id: The id of the activity (required)
        :param str cluster_name: The name of the cluster (required)
        :param str service_name: The name of the service (required)
        :param str view: The view of the activities to materialize
        :return: ApiActivityList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_similar_activities_with_http_info(activity_id, cluster_name, service_name, **kwargs)
        else:
            (data) = self.read_similar_activities_with_http_info(activity_id, cluster_name, service_name, **kwargs)
            return data

    def read_similar_activities_with_http_info(self, activity_id, cluster_name, service_name, **kwargs):
        """
        Returns a list of similar activities.
        Returns a list of similar activities
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_similar_activities_with_http_info(activity_id, cluster_name, service_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str activity_id: The id of the activity (required)
        :param str cluster_name: The name of the cluster (required)
        :param str service_name: The name of the service (required)
        :param str view: The view of the activities to materialize
        :return: ApiActivityList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_id', 'cluster_name', 'service_name', 'view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_similar_activities" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_id' is set
        if ('activity_id' not in params) or (params['activity_id'] is None):
            raise ValueError("Missing the required parameter `activity_id` when calling `read_similar_activities`")
        # verify the required parameter 'cluster_name' is set
        if ('cluster_name' not in params) or (params['cluster_name'] is None):
            raise ValueError("Missing the required parameter `cluster_name` when calling `read_similar_activities`")
        # verify the required parameter 'service_name' is set
        if ('service_name' not in params) or (params['service_name'] is None):
            raise ValueError("Missing the required parameter `service_name` when calling `read_similar_activities`")


        collection_formats = {}

        path_params = {}
        if 'activity_id' in params:
            path_params['activityId'] = params['activity_id']
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']
        if 'service_name' in params:
            path_params['serviceName'] = params['service_name']

        query_params = []
        if 'view' in params:
            query_params.append(('view', params['view']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # Authentication setting
        auth_settings = ['basic']

        return self.api_client.call_api('/clusters/{clusterName}/services/{serviceName}/activities/{activityId}/similar', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ApiActivityList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
