# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetGlobalClusterResult',
    'AwaitableGetGlobalClusterResult',
    'get_global_cluster',
    'get_global_cluster_output',
]

@pulumi.output_type
class GetGlobalClusterResult:
    def __init__(__self__, deletion_protection=None):
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[bool]:
        """
        The deletion protection setting for the new global database. The global database can't be deleted when deletion protection is enabled.
        """
        return pulumi.get(self, "deletion_protection")


class AwaitableGetGlobalClusterResult(GetGlobalClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGlobalClusterResult(
            deletion_protection=self.deletion_protection)


def get_global_cluster(global_cluster_identifier: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGlobalClusterResult:
    """
    Resource Type definition for AWS::RDS::GlobalCluster


    :param str global_cluster_identifier: The cluster identifier of the new global database cluster. This parameter is stored as a lowercase string.
    """
    __args__ = dict()
    __args__['globalClusterIdentifier'] = global_cluster_identifier
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:rds:getGlobalCluster', __args__, opts=opts, typ=GetGlobalClusterResult).value

    return AwaitableGetGlobalClusterResult(
        deletion_protection=__ret__.deletion_protection)


@_utilities.lift_output_func(get_global_cluster)
def get_global_cluster_output(global_cluster_identifier: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGlobalClusterResult]:
    """
    Resource Type definition for AWS::RDS::GlobalCluster


    :param str global_cluster_identifier: The cluster identifier of the new global database cluster. This parameter is stored as a lowercase string.
    """
    ...
