/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.AutoValue_GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorageOptions;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@AutoValue
public abstract class GoogleCloudStorageFileSystemOptions {
    public static GoogleCloudStorageFileSystemOptions DEFAULT = GoogleCloudStorageFileSystemOptions.builder().build();

    public static Builder builder() {
        return new AutoValue_GoogleCloudStorageFileSystemOptions.Builder().setBucketDeleteEnabled(false).setCloudStorageOptions(GoogleCloudStorageOptions.DEFAULT).setCooperativeLockingEnabled(false).setEnsureNoConflictingItems(true).setMarkerFilePattern((String)null).setPerformanceCacheEnabled(false).setPerformanceCacheOptions(PerformanceCachingGoogleCloudStorageOptions.DEFAULT).setStatusParallelEnabled(true);
    }

    public abstract Builder toBuilder();

    public abstract boolean isPerformanceCacheEnabled();

    public abstract PerformanceCachingGoogleCloudStorageOptions getPerformanceCacheOptions();

    public abstract GoogleCloudStorageOptions getCloudStorageOptions();

    public abstract boolean isBucketDeleteEnabled();

    @Nullable
    public abstract Pattern getMarkerFilePattern();

    public abstract boolean isStatusParallelEnabled();

    public abstract boolean isCooperativeLockingEnabled();

    public abstract boolean isEnsureNoConflictingItems();

    public void throwIfNotValid() {
        this.getCloudStorageOptions().throwIfNotValid();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setPerformanceCacheEnabled(boolean var1);

        public abstract Builder setPerformanceCacheOptions(PerformanceCachingGoogleCloudStorageOptions var1);

        public abstract Builder setCloudStorageOptions(GoogleCloudStorageOptions var1);

        public abstract Builder setBucketDeleteEnabled(boolean var1);

        abstract Builder setMarkerFilePattern(Pattern var1);

        public Builder setMarkerFilePattern(String markerFilePattern) {
            return this.setMarkerFilePattern(markerFilePattern == null ? null : Pattern.compile("^(.+/)?" + markerFilePattern + "$"));
        }

        public abstract Builder setStatusParallelEnabled(boolean var1);

        public abstract Builder setCooperativeLockingEnabled(boolean var1);

        public abstract Builder setEnsureNoConflictingItems(boolean var1);

        public abstract GoogleCloudStorageFileSystemOptions build();
    }
}

