###############################################################################
# (c) Copyright 2021 CERN for the benefit of the LHCb Collaboration           #
#                                                                             #
# This software is distributed under the terms of the GNU General Public      #
# Licence version 3 (GPL Version 3), copied verbatim in the file "COPYING".   #
#                                                                             #
# In applying this licence, CERN does not waive the privileges and immunities #
# granted to it by virtue of its status as an Intergovernmental Organization  #
# or submit itself to any jurisdiction.                                       #
###############################################################################

tuple_names = {
    "Pi": ["DSt_PiMTuple", "DSt_PiPTuple"],
    "K": ["DSt_KPTuple", "DSt_KMTuple"],
    "Mu": ["Jpsi_MuPTuple", "Jpsi_MuMTuple"],
    "K_DsPhi": ["DsPhi_KPTuple", "DsPhi_KMTuple"],
    "K_DSt3Pi": ["DSt3Pi_KPTuple", "DSt3Pi_KMTuple"],
    "Pi_DSt3Pi": ["DSt3Pi_PiMTuple", "DSt3Pi_PiPTuple"],
    "K_Phi": ["Phi_KMTuple", "Phi_KPTuple"],
    "K_Omega": ["OmegaL_KPTuple", "OmegaL_KMTuple"],
    "K_DD": ["OmegaDDD_KPTuple", "OmegaDDD_KMTuple"],
    "Pi_KS": ["KSLL_PiPTuple", "KSLL_PiMTuple"],
    "Pi_DD": ["KSDD_PiPTuple", "KSDD_PiMTuple"],
    "P": [
        "Lam0LL_PTuple",
        "Lam0LL_PbarTuple",
        "Lam0LL_HPT_PTuple",
        "Lam0LL_HPT_PbarTuple",
        "Lam0LL_VHPT_PTuple",
        "Lam0LL_VHPT_PbarTuple",
    ],
    "P_DD": [
        "Lam0DD_PTuple",
        "Lam0DD_PbarTuple",
        "Lam0DD_HPT_PTuple",
        "Lam0DD_HPT_PbarTuple",
        "Lam0DD_VHPT_PTuple",
        "Lam0DD_VHPT_PbarTuple",
    ],
    "P_Sigmac0": ["Sigmac0_PbarTuple", "Sigmac0_PTuple"],
    "P_Sigmacpp": ["Sigmacpp_PbarTuple", "Sigmacpp_PTuple"],
    "P_B_Jpsi": ["B_Jpsi_PTuple", "B_Jpsi_PbarTuple"],
    "e_B_Jpsi": ["B_Jpsi_EPTuple", "B_Jpsi_EMTuple"],
    "Mu_B_Jpsi": ["B_Jpsi_MuPTuple", "B_Jpsi_MuMTuple"],
    "e": ["Jpsi_EPTuple", "Jpsi_EMTuple"],
    "P_LcfB": ["LbLcMu_PTuple", "LbLcMu_PbarTuple"],
    "P_IncLc": ["Lc_PTuple", "Lc_PbarTuple"],
    "Mu_nopt": ["Jpsinopt_MuPTuple", "Jpsinopt_MuMTuple"],
}

simple_samples = [
    "13b",
    "15",
    "17",
    "20",
    "20_MCTuneV2",
    "20_MCTunev3",
    "20r1",
    "20r1_MCTuneV2",
    "21",
    "21_MCTuneV4",
    "21r1",
    "21r1_MCTuneV4",
    "22",
    "23",
    "23Val",
    "23_MCTuneV1",
    "26",
    "5TeV",
    "Electron15",
    "Electron16",
    "Electron17",
    "Electron18",
]
