from ..stats import Stats


GAMECLASSDATA = {
    # To be Expanded Upon
    # "classname" : {
    #     "hit_dice" : "d12",
    #     "saving_throws" : Stats(CON = True),
    #     "skills" : [],
    #     "preferred_stats" : Stats(DEX = True),
    #     "subclasses" : []
    # },
    "Barbarian": {
        "hit_dice": "d12",
        "saving_throws": Stats(STR=True, CON=True),
        "skills": [
            "Animal Handling",
            "Athletics",
            "Intimidation",
            "Nature",
            "Perception",
            "Survival",
        ],
        "preferred_stats": Stats(STR=True, CON=True),
        "subclasses": ["Path of the Berserker", "Path of the Totem Warrior"],
    },
    "Rogue": {
        "hit_dice": "d8",
        "saving_throws": Stats(DEX=True, INT=True),
        "skills": [
            "Acrobatics",
            "Athletics",
            "Deception",
            "Insight",
            "Intimidation",
            "Investigation",
            "Perception",
            "Performance",
            "Persuasion",
            "Sleight of Hand",
            "Stealth",
        ],
        "preferred_stats": Stats(DEX=True, CHA=True),
        "subclasses": ["Thief", "Assassin", "Arcane Trickster"],
    },
    "Wizard": {
        "hit_dice": "d6",
        "saving_throws": Stats(INT=True, WIS=True),
        "skills": [
            "Arcana",
            "History",
            "Insight",
            "Investigation",
            "Medicine",
            "Religion",
        ],
        "preferred_stats": Stats(INT=True, CON=True),
        "subclasses": [
            "School of Abjuration",
            "School of Conjuration",
            "School of Divination",
            "School of Enchantment",
            "School of Evocation",
            "School of Illusion",
            "School of Necromancy",
            "School of Transmutation",
        ],
    },
    "Ranger": {
        "hit_dice": "d10",
        "saving_throws": Stats(STR=True, DEX=True),
        "skills": [
            "Animal Handling",
            "Athletics",
            "Insight",
            "Investigation",
            "Nature",
            "Perception",
            "Stealth",
            "and Survival",
        ],
        "preferred_stats": Stats(WIS=True, DEX=True),
        "subclasses": ["Hunter", "Beast Master"],
    },
    "Paladin": {
        "hit_dice": "d10",
        "saving_throws": Stats(CHA=True, WIS=True),
        "skills": [
            "Athletics",
            "Insight",
            "Intimidation",
            "Medicine",
            "Persuasion",
            "Religion",
        ],
        "preferred_stats": Stats(STR=True, CHA=True),
        "subclasses": ["Oath of Devotion", "Oath of the Ancients", "Oath of Vengeance"],
    },
    "Bard": {
        "hit_dice": "d8",
        "saving_throws": Stats(DEX=True, CHA=True),
        "skills": [
            "Acrobatics",
            "Animal Handling",
            "Arcana",
            "Athletics",
            "Deception",
            "History",
            "Insight",
            "Intimidation",
            "Investigation",
            "Investigation",
            "Medicine",
            "Nature",
            "Perception",
            "Persuasion",
            "Religion",
            "Sleight",
            "Stealth",
            "Survival",
        ],
        "preferred_stats": Stats(DEX=True, CHA=True),
        "subclasses": [
            "College of Lore",
            "College of Valor",
        ],
    },
    "Cleric": {
        "hit_dice": "d8",
        "saving_throws": Stats(WIS=True, CHA=True),
        "skills": ["History", "Insight", "Medicine", "Persuasion", "Religion"],
        "preferred_stats": Stats(WIS=True, CON=True),
        "subclasses": [
            "Knowledge Domain",
            "Life Domain",
            "Light Domain",
            "Nature Domain",
            "Tempest Domain",
            "Trickery Domain",
            "War Domain",
        ],
    },
}
