# Heroku Resource Provider

The Heroku Resource Provider lets you manage [Heroku](http://heroku.com) resources.

## Installing

This package is available for several languages/platforms:

### Node.js (JavaScript/TypeScript)

To use from JavaScript or TypeScript in Node.js, install using either `npm`:

```bash
npm install @pulumiverse/heroku
```

or `yarn`:

```bash
yarn add @pulumiverse/heroku
```

### Python

To use from Python, install using `pip`:

```bash
pip install pulumiverse_heroku
```

### Go

To use from Go, use `go get` to grab the latest version of the library:

```bash
go get github.com/pulumiverse/pulumi-heroku/sdk/go/...
```

### .NET

To use from .NET, install using `dotnet add package`:

```bash
dotnet add package Pulumiverse.Heroku
```

## Configuration

The following configuration points are available for the `heroku` provider:

- `heroku:apiKey` (environment: `HEROKU_API_KEY`) - the API key for `heroku`

## Reference

For detailed reference documentation, please visit [the Pulumi registry](https://www.pulumi.com/registry/packages/heroku/api-docs/).
