# -*- coding: utf-8 -*-
# (c) Copyright 2021 Sensirion AG, Switzerland

##############################################################################
##############################################################################
#                 _____         _    _ _______ _____ ____  _   _
#                / ____|   /\  | |  | |__   __|_   _/ __ \| \ | |
#               | |       /  \ | |  | |  | |    | || |  | |  \| |
#               | |      / /\ \| |  | |  | |    | || |  | | . ` |
#               | |____ / ____ \ |__| |  | |   _| || |__| | |\  |
#                \_____/_/    \_\____/   |_|  |_____\____/|_| \_|
#
#     THIS FILE IS AUTOMATICALLY GENERATED AND MUST NOT BE EDITED MANUALLY!
#
# Generator:    sensirion-i2c-interface-generator 0.5.1
# Product:      SVM41
# Version:      0.7.4
#
##############################################################################
##############################################################################

# flake8: noqa

from __future__ import absolute_import, division, print_function
from sensirion_i2c_driver import SensirionI2cCommand, CrcCalculator
from struct import pack, unpack

import logging
log = logging.getLogger(__name__)


class Svm41I2cCmdBase(SensirionI2cCommand):
    """
    SVM41 I²C base command.
    """
    def __init__(self, command, tx_data, rx_length, read_delay, timeout,
                 post_processing_time=0.0):
        """
        Constructs a new SVM41 I²C command.

        :param int/None command:
            The command ID to be sent to the device. None means that no
            command will be sent, i.e. only ``tx_data`` (if not None) will
            be sent. No CRC is added to these bytes since the command ID
            usually already contains a CRC.
        :param bytes-like/list/None tx_data:
            Bytes to be extended with CRCs and then sent to the I²C device.
            None means that no write header will be sent at all (if ``command``
            is None too). An empty list means to send the write header (even if
            ``command`` is None), but without data following it.
        :param int/None rx_length:
            Number of bytes to be read from the I²C device, including CRC
            bytes. None means that no read header is sent at all. Zero means
            to send the read header, but without reading any data.
        :param float read_delay:
            Delay (in Seconds) to be inserted between the end of the write
            operation and the beginning of the read operation. This is needed
            if the device needs some time to prepare the RX data, e.g. if it
            has to perform a measurement. Set to 0.0 to indicate that no delay
            is needed, i.e. the device does not need any processing time.
        :param float timeout:
            Timeout (in Seconds) to be used in case of clock stretching. If the
            device stretches the clock longer than this value, the transceive
            operation will be aborted with a timeout error. Set to 0.0 to
            indicate that the device will not stretch the clock for this
            command.
        :param float post_processing_time:
            Maximum time in seconds the device needs for post processing of
            this command until it is ready to receive the next command. For
            example after a device reset command, the device might need some
            time until it is ready again. Usually this is 0.0s, i.e. no post
            processing is needed.
        """
        super(Svm41I2cCmdBase, self).__init__(
            command=command,
            tx_data=tx_data,
            rx_length=rx_length,
            read_delay=read_delay,
            timeout=timeout,
            crc=CrcCalculator(8, 0x31, 0xFF, 0x00),
            command_bytes=2,
            post_processing_time=post_processing_time,
        )


class Svm41I2cCmdStartMeasurement(Svm41I2cCmdBase):
    """
    Start Measurement I²C Command

    Starts continuous measurement in polling mode.

    .. note:: This command is only available in idle mode.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm41I2cCmdStartMeasurement, self).__init__(
            command=0x0010,
            tx_data=None,
            rx_length=None,
            read_delay=0.0,
            timeout=0,
            post_processing_time=0.001,
        )


class Svm41I2cCmdStopMeasurement(Svm41I2cCmdBase):
    """
    Stop Measurement I²C Command

    Stops the measurement mode and returns to idle mode.

    .. note:: This command is only available in measurement mode.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm41I2cCmdStopMeasurement, self).__init__(
            command=0x0104,
            tx_data=None,
            rx_length=None,
            read_delay=0.0,
            timeout=0,
            post_processing_time=0.05,
        )


class Svm41I2cCmdReadMeasuredValuesAsIntegers(Svm41I2cCmdBase):
    """
    Read Measured Values As Integers I²C Command

    Returns the new measurement results as integers.

    .. note:: This command is only available in measurement mode. The firmware
              updates the measurement values every second. Polling data with a
              faster sampling rate will return the same values. The first
              measurement is available 1 second after the start measurement
              command is issued. Any readout prior to this will return zero
              initialized values.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm41I2cCmdReadMeasuredValuesAsIntegers, self).__init__(
            command=0x0405,
            tx_data=None,
            rx_length=12,
            read_delay=0.05,
            timeout=0,
            post_processing_time=0.0,
        )

    def interpret_response(self, data):
        """
        Validates the CRCs of the received data from the device and returns
        the interpreted data.

        :param bytes data:
            Received raw bytes from the read operation.
        :return:
            - humidity (int) -
              Compensated ambient humidity in % RH with a scaling factor of
              100.
            - temperature (int) -
              Compensated ambient temperature in degrees celsius with a scaling
              of 200.
            - voc_index (int) -
              VOC algorithm output with a scaling value of 10.
            - nox_index (int) -
              NOx algorithm output with a scaling value of 10.
        :rtype: tuple
        :raise ~sensirion_i2c_driver.errors.I2cChecksumError:
            If a received CRC was wrong.
        """
        # check and remove CRCs
        checked_data = Svm41I2cCmdBase.interpret_response(self, data)

        # convert raw received data into proper data types
        humidity = int(unpack(">h", checked_data[0:2])[0])  # int16
        temperature = int(unpack(">h", checked_data[2:4])[0])  # int16
        voc_index = int(unpack(">h", checked_data[4:6])[0])  # int16
        nox_index = int(unpack(">h", checked_data[6:8])[0])  # int16
        return humidity, \
            temperature, \
            voc_index, \
            nox_index


class Svm41I2cCmdReadMeasuredRawValues(Svm41I2cCmdBase):
    """
    Read Measured Raw Values I²C Command

    Returns the measured raw values.

    .. note:: This command is only available in measurement mode. The firmware
              updates the measurement values every second. Polling data with a
              faster sampling rate will return the same values. The first
              measurement is available 1 second after the start measurement
              command is issued. Any readout prior to this will return zero
              initialized values.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm41I2cCmdReadMeasuredRawValues, self).__init__(
            command=0x03D2,
            tx_data=None,
            rx_length=12,
            read_delay=0.05,
            timeout=0,
            post_processing_time=0.0,
        )

    def interpret_response(self, data):
        """
        Validates the CRCs of the received data from the device and returns
        the interpreted data.

        :param bytes data:
            Received raw bytes from the read operation.
        :return:
            - raw_humidity (int) -
              Uncompensated raw humidity in % RH as read from the SHT40 with a
              scaling factor of 100.
            - raw_temperature (int) -
              Uncompensated raw temperature in degrees celsius as read from the
              SHT40 with a scaling of 200.
            - raw_voc_ticks (int) -
              Raw VOC output ticks as read from the SGP sensor.
            - raw_nox_ticks (int) -
              Raw NOx output ticks as read from the SGP sensor.
        :rtype: tuple
        :raise ~sensirion_i2c_driver.errors.I2cChecksumError:
            If a received CRC was wrong.
        """
        # check and remove CRCs
        checked_data = Svm41I2cCmdBase.interpret_response(self, data)

        # convert raw received data into proper data types
        raw_humidity = int(unpack(">h", checked_data[0:2])[0])  # int16
        raw_temperature = int(unpack(">h", checked_data[2:4])[0])  # int16
        raw_voc_ticks = int(unpack(">H", checked_data[4:6])[0])  # uint16
        raw_nox_ticks = int(unpack(">H", checked_data[6:8])[0])  # uint16
        return raw_humidity, \
            raw_temperature, \
            raw_voc_ticks, \
            raw_nox_ticks


class Svm41I2cCmdGetTemperatureOffsetForRhtMeasurements(Svm41I2cCmdBase):
    """
    Get Temperature Offset For Rht Measurements I²C Command

    Gets the T-Offset for the temperature compensation of the RHT algorithm.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm41I2cCmdGetTemperatureOffsetForRhtMeasurements, self).__init__(
            command=0x6014,
            tx_data=None,
            rx_length=3,
            read_delay=0.001,
            timeout=0,
            post_processing_time=0.0,
        )

    def interpret_response(self, data):
        """
        Validates the CRCs of the received data from the device and returns
        the interpreted data.

        :param bytes data:
            Received raw bytes from the read operation.
        :return: Temperature offset in degrees celsius with a scaling of 200.
        :rtype: int
        :raise ~sensirion_i2c_driver.errors.I2cChecksumError:
            If a received CRC was wrong.
        """
        # check and remove CRCs
        checked_data = Svm41I2cCmdBase.interpret_response(self, data)

        # convert raw received data into proper data types
        t_offset = int(unpack(">h", checked_data[0:2])[0])  # int16
        return t_offset


class Svm41I2cCmdSetTemperatureOffsetForRhtMeasurements(Svm41I2cCmdBase):
    """
    Set Temperature Offset For Rht Measurements I²C Command

    Sets the T-Offset for the temperature compensation of the RHT algorithm.
    """

    def __init__(self, t_offset):
        """
        Constructor.

        :param int t_offset:
            Temperature offset in degrees celsius with a scaling of 200.
        """
        super(Svm41I2cCmdSetTemperatureOffsetForRhtMeasurements, self).__init__(
            command=0x6014,
            tx_data=b"".join([pack(">h", t_offset)]),
            rx_length=None,
            read_delay=0.0,
            timeout=0,
            post_processing_time=0.0,
        )


class Svm41I2cCmdGetVocAlgorithmTuningParameters(Svm41I2cCmdBase):
    """
    Get VOC Algorithm Tuning Parameters I²C Command

    Gets the currently set parameters for customizing the VOC algorithm
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm41I2cCmdGetVocAlgorithmTuningParameters, self).__init__(
            command=0x60D0,
            tx_data=None,
            rx_length=18,
            read_delay=0.05,
            timeout=0,
            post_processing_time=0.0,
        )

    def interpret_response(self, data):
        """
        Validates the CRCs of the received data from the device and returns
        the interpreted data.

        :param bytes data:
            Received raw bytes from the read operation.
        :return:
            - voc_index_offset (int) -
              VOC index representing typical (average) conditions.
            - learning_time_offset_hours (int) -
              Time constant to estimate the VOC algorithm offset from the
              history in hours. Past events will be forgotten after about twice
              the learning time.
            - learning_time_gain_hours (int) -
              Time constant to estimate the VOC algorithm gain from the history
              in hours. Past events will be forgotten after about twice the
              learning time.
            - gating_max_duration_minutes (int) -
              Maximum duration of gating in minutes (freeze of estimator during
              high VOC index signal). Zero disables the gating.
            - std_initial (int) -
              Initial estimate for standard deviation. Lower value boosts
              events during initial learning period, but may result in larger
              device-to-device variations.
            - gain_factor (int) -
              Factor to amplify or to attenuate the VOC Index output.
        :rtype: tuple
        :raise ~sensirion_i2c_driver.errors.I2cChecksumError:
            If a received CRC was wrong.
        """
        # check and remove CRCs
        checked_data = Svm41I2cCmdBase.interpret_response(self, data)

        # convert raw received data into proper data types
        voc_index_offset = int(unpack(">h", checked_data[0:2])[0])  # int16
        learning_time_offset_hours = int(unpack(">h", checked_data[2:4])[0])  # int16
        learning_time_gain_hours = int(unpack(">h", checked_data[4:6])[0])  # int16
        gating_max_duration_minutes = int(unpack(">h", checked_data[6:8])[0])  # int16
        std_initial = int(unpack(">h", checked_data[8:10])[0])  # int16
        gain_factor = int(unpack(">h", checked_data[10:12])[0])  # int16
        return voc_index_offset, \
            learning_time_offset_hours, \
            learning_time_gain_hours, \
            gating_max_duration_minutes, \
            std_initial, \
            gain_factor


class Svm41I2cCmdSetVocAlgorithmTuningParameters(Svm41I2cCmdBase):
    """
    Set VOC Algorithm Tuning Parameters I²C Command

    Sets the parameters to customize the VOC algorithm. This command is only
    available in idle mode.
    """

    def __init__(self, voc_index_offset, learning_time_offset_hours, learning_time_gain_hours, gating_max_duration_minutes, std_initial, gain_factor):
        """
        Constructor.

        :param int voc_index_offset:
            VOC index representing typical (average) conditions. Allowed values
            are in range 1..250. The default value is 100.
        :param int learning_time_offset_hours:
            Time constant to estimate the VOC algorithm offset from the history
            in hours. Past events will be forgotten after about twice the
            learning time. Allowed values are in range 1..1000. The default
            value is 12 hours.
        :param int learning_time_gain_hours:
            Time constant to estimate the VOC algorithm gain from the history
            in hours. Past events will be forgotten after about twice the
            learning time. Allowed values are in range 1..1000. The default
            value is 12 hours.
        :param int gating_max_duration_minutes:
            Maximum duration of gating in minutes (freeze of estimator during
            high VOC index signal). Set to zero to disable the gating. Allowed
            values are in range 0..3000. The default value is 180 minutes.
        :param int std_initial:
            Initial estimate for standard deviation. Lower value boosts events
            during initial learning period, but may result in larger
            device-to-device variations. Allowed values are in range 10..5000.
            The default value is 50.
        :param int gain_factor:
            Gain factor to amplify or to attenuate the VOC index output.
            Allowed values are in range 1..1000. The default value is 230.
        """
        super(Svm41I2cCmdSetVocAlgorithmTuningParameters, self).__init__(
            command=0x60D0,
            tx_data=b"".join([pack(">h", voc_index_offset),
                           pack(">h", learning_time_offset_hours),
                           pack(">h", learning_time_gain_hours),
                           pack(">h", gating_max_duration_minutes),
                           pack(">h", std_initial),
                           pack(">h", gain_factor)]),
            rx_length=None,
            read_delay=0.0,
            timeout=0,
            post_processing_time=0.05,
        )


class Svm41I2cCmdGetNoxAlgorithmTuningParameters(Svm41I2cCmdBase):
    """
    Get NOx Algorithm Tuning Parameters I²C Command

    Gets the currently set parameters for customizing the NOx algorithm
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm41I2cCmdGetNoxAlgorithmTuningParameters, self).__init__(
            command=0x60E1,
            tx_data=None,
            rx_length=18,
            read_delay=0.05,
            timeout=0,
            post_processing_time=0.0,
        )

    def interpret_response(self, data):
        """
        Validates the CRCs of the received data from the device and returns
        the interpreted data.

        :param bytes data:
            Received raw bytes from the read operation.
        :return:
            - nox_index_offset (int) -
              NOx index representing typical (average) conditions.
            - learning_time_offset_hours (int) -
              Time constant to estimate the NOx algorithm offset from the
              history in hours. Past events will be forgotten after about twice
              the learning time.
            - learning_time_gain_hours (int) -
              The time constant to estimate the NOx algorithm gain from the
              history has no impact for NOx. This parameter is still in place
              for consistency reasons with the VOC tuning parameters command.
              This getter will always return the default value.
            - gating_max_duration_minutes (int) -
              Maximum duration of gating in minutes (freeze of estimator during
              high NOx index signal). Zero disables the gating.
            - std_initial (int) -
              The initial estimate for standard deviation has no impact for
              NOx. This parameter is still in place for consistency reasons
              with the VOC tuning parameters command. This getter will always
              return the default value.
            - gain_factor (int) -
              Factor to amplify or to attenuate the NOx Index output.
        :rtype: tuple
        :raise ~sensirion_i2c_driver.errors.I2cChecksumError:
            If a received CRC was wrong.
        """
        # check and remove CRCs
        checked_data = Svm41I2cCmdBase.interpret_response(self, data)

        # convert raw received data into proper data types
        nox_index_offset = int(unpack(">h", checked_data[0:2])[0])  # int16
        learning_time_offset_hours = int(unpack(">h", checked_data[2:4])[0])  # int16
        learning_time_gain_hours = int(unpack(">h", checked_data[4:6])[0])  # int16
        gating_max_duration_minutes = int(unpack(">h", checked_data[6:8])[0])  # int16
        std_initial = int(unpack(">h", checked_data[8:10])[0])  # int16
        gain_factor = int(unpack(">h", checked_data[10:12])[0])  # int16
        return nox_index_offset, \
            learning_time_offset_hours, \
            learning_time_gain_hours, \
            gating_max_duration_minutes, \
            std_initial, \
            gain_factor


class Svm41I2cCmdSetNoxAlgorithmTuningParameters(Svm41I2cCmdBase):
    """
    Set NOx Algorithm Tuning Parameters I²C Command

    Sets the parameters to customize the NOx algorithm. This command is only
    available in idle mode.
    """

    def __init__(self, nox_index_offset, learning_time_offset_hours, learning_time_gain_hours, gating_max_duration_minutes, std_initial, gain_factor):
        """
        Constructor.

        :param int nox_index_offset:
            NOx index representing typical (average) conditions. Allowed values
            are in range 1..250. The default value is 1.
        :param int learning_time_offset_hours:
            Time constant to estimate the NOx algorithm offset from the history
            in hours. Past events will be forgotten after about twice the
            learning time. Allowed values are in range 1..1000. The default
            value is 12 hours.
        :param int learning_time_gain_hours:
            The time constant to estimate the NOx algorithm gain from the
            history has no impact for the NOx algorithm. This parameter is
            still in place for consistency reasons with the VOC tuning
            parameters command. This parameter must always be set to 12 hours.
        :param int gating_max_duration_minutes:
            Maximum duration of gating in minutes (freeze of estimator during
            high NOx index signal). Set to zero to disable the gating. Allowed
            values are in range 0..3000. The default value is 720 minutes.
        :param int std_initial:
            The initial estimate for standard deviation parameter has no impact
            for the NOx algorithm. This parameter is still in place for
            consistency reasons with the VOC tuning parameters command. This
            parameter must always be set to 50.
        :param int gain_factor:
            Gain factor to amplify or to attenuate the VOC index output.
            Allowed values are in range 1..1000. The default value is 230.
        """
        super(Svm41I2cCmdSetNoxAlgorithmTuningParameters, self).__init__(
            command=0x60E1,
            tx_data=b"".join([pack(">h", nox_index_offset),
                           pack(">h", learning_time_offset_hours),
                           pack(">h", learning_time_gain_hours),
                           pack(">h", gating_max_duration_minutes),
                           pack(">h", std_initial),
                           pack(">h", gain_factor)]),
            rx_length=None,
            read_delay=0.0,
            timeout=0,
            post_processing_time=0.05,
        )


class Svm41I2cCmdStoreNvData(Svm41I2cCmdBase):
    """
    Store Nv Data I²C Command

    Stores all algorithm parameters to the non-volatile memory.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm41I2cCmdStoreNvData, self).__init__(
            command=0x6002,
            tx_data=None,
            rx_length=None,
            read_delay=0.0,
            timeout=0,
            post_processing_time=0.5,
        )


class Svm41I2cCmdGetVocAlgorithmState(Svm41I2cCmdBase):
    """
    Get VOC Algorithm State I²C Command

    Gets the current VOC algorithm state.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm41I2cCmdGetVocAlgorithmState, self).__init__(
            command=0x6181,
            tx_data=None,
            rx_length=12,
            read_delay=0.05,
            timeout=0,
            post_processing_time=0.0,
        )

    def interpret_response(self, data):
        """
        Validates the CRCs of the received data from the device and returns
        the interpreted data.

        :param bytes data:
            Received raw bytes from the read operation.
        :return: Current VOC algorithm state.
        :rtype: bytes
        :raise ~sensirion_i2c_driver.errors.I2cChecksumError:
            If a received CRC was wrong.
        """
        # check and remove CRCs
        checked_data = Svm41I2cCmdBase.interpret_response(self, data)

        # convert raw received data into proper data types
        state = bytes(checked_data[0:8])  # bytearray<8>
        return state


class Svm41I2cCmdSetVocAlgorithmState(Svm41I2cCmdBase):
    """
    Set VOC Algorithm State I²C Command

    Sets the VOC algorithm state. This command is only available in idle mode.
    """

    def __init__(self, state):
        """
        Constructor.

        :param bytes state:
            Current VOC algorithm state.
        """
        super(Svm41I2cCmdSetVocAlgorithmState, self).__init__(
            command=0x6181,
            tx_data=b"".join([bytes(bytearray(state))]),
            rx_length=None,
            read_delay=0.0,
            timeout=0,
            post_processing_time=0.05,
        )


class Svm41I2cCmdGetVersion(Svm41I2cCmdBase):
    """
    Get Version I²C Command

    Gets the version information for the hardware, firmware and protocol.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm41I2cCmdGetVersion, self).__init__(
            command=0xD100,
            tx_data=None,
            rx_length=12,
            read_delay=0.001,
            timeout=0,
            post_processing_time=0.0,
        )

    def interpret_response(self, data):
        """
        Validates the CRCs of the received data from the device and returns
        the interpreted data.

        :param bytes data:
            Received raw bytes from the read operation.
        :return:
            - firmware_major (int) -
              Firmware major version number.
            - firmware_minor (int) -
              Firmware minor version number.
            - firmware_debug (bool) -
              Firmware debug state. If the debug state is set, the firmware is
              in development.
            - hardware_major (int) -
              Hardware major version number.
            - hardware_minor (int) -
              Hardware minor version number.
            - protocol_major (int) -
              Protocol major version number.
            - protocol_minor (int) -
              Protocol minor version number.
            - padding (int) -
              Padding byte, ignore this.
        :rtype: tuple
        :raise ~sensirion_i2c_driver.errors.I2cChecksumError:
            If a received CRC was wrong.
        """
        # check and remove CRCs
        checked_data = Svm41I2cCmdBase.interpret_response(self, data)

        # convert raw received data into proper data types
        firmware_major = int(unpack(">B", checked_data[0:1])[0])  # uint8
        firmware_minor = int(unpack(">B", checked_data[1:2])[0])  # uint8
        firmware_debug = bool(unpack(">?", checked_data[2:3])[0])  # bool
        hardware_major = int(unpack(">B", checked_data[3:4])[0])  # uint8
        hardware_minor = int(unpack(">B", checked_data[4:5])[0])  # uint8
        protocol_major = int(unpack(">B", checked_data[5:6])[0])  # uint8
        protocol_minor = int(unpack(">B", checked_data[6:7])[0])  # uint8
        padding = int(unpack(">B", checked_data[7:8])[0])  # uint8
        return firmware_major, \
            firmware_minor, \
            firmware_debug, \
            hardware_major, \
            hardware_minor, \
            protocol_major, \
            protocol_minor, \
            padding


class Svm41I2cCmdGetSerialNumber(Svm41I2cCmdBase):
    """
    Get Serial Number I²C Command

    Gets the serial number from the device.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm41I2cCmdGetSerialNumber, self).__init__(
            command=0xD033,
            tx_data=None,
            rx_length=39,
            read_delay=0.001,
            timeout=0,
            post_processing_time=0.0,
        )

    def interpret_response(self, data):
        """
        Validates the CRCs of the received data from the device and returns
        the interpreted data.

        :param bytes data:
            Received raw bytes from the read operation.
        :return: Ascii string containing the serial number. The string has the
                 null-termination character included.
        :rtype: str
        :raise ~sensirion_i2c_driver.errors.I2cChecksumError:
            If a received CRC was wrong.
        """
        # check and remove CRCs
        checked_data = Svm41I2cCmdBase.interpret_response(self, data)

        # convert raw received data into proper data types
        serial_number = str(checked_data[0:26].decode('utf-8').rstrip('\0'))  # string<26>
        return serial_number


class Svm41I2cCmdDeviceReset(Svm41I2cCmdBase):
    """
    Device Reset I²C Command

    Executs a reset on the device.

    .. note:: The device will reply before executing the reset.
    """

    def __init__(self):
        """
        Constructor.
        """
        super(Svm41I2cCmdDeviceReset, self).__init__(
            command=0xD304,
            tx_data=None,
            rx_length=None,
            read_delay=0.0,
            timeout=0,
            post_processing_time=0.1,
        )

