# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class PrismaModelsWorkflow(pydantic.BaseModel):
    """
    Represents a Workflow record
    """

    id: str
    name: str
    description: typing.Optional[str] = None
    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")
    steps: typing.Optional[typing.List[PrismaModelsWorkflowStep]] = None
    api_user_id: str = pydantic.Field(alias="apiUserId")
    api_user: typing.Optional[PrismaModelsApiUser] = pydantic.Field(alias="apiUser", default=None)
    workflow_configs: typing.Optional[typing.List[WorkflowConfig]] = pydantic.Field(
        alias="workflowConfigs", default=None
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}


from .prisma_models_api_user import PrismaModelsApiUser  # noqa: E402
from .prisma_models_workflow_step import PrismaModelsWorkflowStep  # noqa: E402
from .workflow_config import WorkflowConfig  # noqa: E402

PrismaModelsWorkflow.update_forward_refs()
