# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .datasource_status import DatasourceStatus
from .datasource_type import DatasourceType

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class PrismaModelsDatasource(pydantic.BaseModel):
    """
    Represents a Datasource record
    """

    id: str
    name: str
    content: typing.Optional[str] = None
    description: typing.Optional[str] = None
    url: typing.Optional[str] = None
    type: DatasourceType
    api_user_id: str = pydantic.Field(alias="apiUserId")
    api_user: typing.Optional[PrismaModelsApiUser] = pydantic.Field(alias="apiUser", default=None)
    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")
    metadata: typing.Optional[str] = None
    status: DatasourceStatus
    datasources: typing.Optional[typing.List[PrismaModelsAgentDatasource]] = None
    vector_db: typing.Optional[PrismaModelsVectorDb] = pydantic.Field(alias="vectorDb", default=None)
    vector_db_id: typing.Optional[str] = pydantic.Field(alias="vectorDbId", default=None)

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}


from .prisma_models_agent_datasource import PrismaModelsAgentDatasource  # noqa: E402
from .prisma_models_api_user import PrismaModelsApiUser  # noqa: E402
from .prisma_models_vector_db import PrismaModelsVectorDb  # noqa: E402

PrismaModelsDatasource.update_forward_refs()
