# This file was auto-generated by Fern from our API Definition.

import typing

import httpx

from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .environment import SuperagentEnvironment
from .resources.agent.client import AgentClient, AsyncAgentClient
from .resources.api_key.client import ApiKeyClient, AsyncApiKeyClient
from .resources.api_user.client import ApiUserClient, AsyncApiUserClient
from .resources.datasource.client import AsyncDatasourceClient, DatasourceClient
from .resources.llm.client import AsyncLlmClient, LlmClient
from .resources.tool.client import AsyncToolClient, ToolClient
from .resources.vector_database.client import AsyncVectorDatabaseClient, VectorDatabaseClient
from .resources.workflow.client import AsyncWorkflowClient, WorkflowClient
from .resources.workflow_config.client import AsyncWorkflowConfigClient, WorkflowConfigClient


class Superagent:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propogate to these functions.

    Parameters:
        - base_url: typing.Optional[str]. The base url to use for requests from the client.

        - environment: SuperagentEnvironment. The environment to use for requests from the client. from .environment import SuperagentEnvironment

                                              Defaults to SuperagentEnvironment.DEFAULT

        - token: typing.Optional[typing.Union[str, typing.Callable[[], str]]].

        - timeout: typing.Optional[float]. The timeout to be used, in seconds, for requests by default the timeout is 60 seconds.

        - httpx_client: typing.Optional[httpx.Client]. The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.
    ---
    from superagent.client import Superagent

    client = Superagent(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: SuperagentEnvironment = SuperagentEnvironment.DEFAULT,
        token: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = None,
        timeout: typing.Optional[float] = 60,
        httpx_client: typing.Optional[httpx.Client] = None
    ):
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx.Client(timeout=timeout) if httpx_client is None else httpx_client,
        )
        self.agent = AgentClient(client_wrapper=self._client_wrapper)
        self.llm = LlmClient(client_wrapper=self._client_wrapper)
        self.api_user = ApiUserClient(client_wrapper=self._client_wrapper)
        self.api_key = ApiKeyClient(client_wrapper=self._client_wrapper)
        self.datasource = DatasourceClient(client_wrapper=self._client_wrapper)
        self.tool = ToolClient(client_wrapper=self._client_wrapper)
        self.workflow = WorkflowClient(client_wrapper=self._client_wrapper)
        self.workflow_config = WorkflowConfigClient(client_wrapper=self._client_wrapper)
        self.vector_database = VectorDatabaseClient(client_wrapper=self._client_wrapper)


class AsyncSuperagent:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propogate to these functions.

    Parameters:
        - base_url: typing.Optional[str]. The base url to use for requests from the client.

        - environment: SuperagentEnvironment. The environment to use for requests from the client. from .environment import SuperagentEnvironment

                                              Defaults to SuperagentEnvironment.DEFAULT

        - token: typing.Optional[typing.Union[str, typing.Callable[[], str]]].

        - timeout: typing.Optional[float]. The timeout to be used, in seconds, for requests by default the timeout is 60 seconds.

        - httpx_client: typing.Optional[httpx.AsyncClient]. The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.
    ---
    from superagent.client import AsyncSuperagent

    client = AsyncSuperagent(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: SuperagentEnvironment = SuperagentEnvironment.DEFAULT,
        token: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = None,
        timeout: typing.Optional[float] = 60,
        httpx_client: typing.Optional[httpx.AsyncClient] = None
    ):
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx.AsyncClient(timeout=timeout) if httpx_client is None else httpx_client,
        )
        self.agent = AsyncAgentClient(client_wrapper=self._client_wrapper)
        self.llm = AsyncLlmClient(client_wrapper=self._client_wrapper)
        self.api_user = AsyncApiUserClient(client_wrapper=self._client_wrapper)
        self.api_key = AsyncApiKeyClient(client_wrapper=self._client_wrapper)
        self.datasource = AsyncDatasourceClient(client_wrapper=self._client_wrapper)
        self.tool = AsyncToolClient(client_wrapper=self._client_wrapper)
        self.workflow = AsyncWorkflowClient(client_wrapper=self._client_wrapper)
        self.workflow_config = AsyncWorkflowConfigClient(client_wrapper=self._client_wrapper)
        self.vector_database = AsyncVectorDatabaseClient(client_wrapper=self._client_wrapper)


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: SuperagentEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
