import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Allows for the creation and modification of a Snowflake User. https://docs.snowflake.com/en/user-guide/admin-user-management.html
 *
 * @schema CfnUserProps
 */
export interface CfnUserProps {
    /**
     * Identifier for the user; must be unique for your account.
     *
     * @schema CfnUserProps#Name
     */
    readonly name: string;
    /**
     * The password for the user
     *
     * @schema CfnUserProps#Password
     */
    readonly password: string;
    /**
     * Name that the user enters to log into the system. Login names for users must be unique across your entire account.
     *
     * @schema CfnUserProps#LoginName
     */
    readonly loginName?: string;
    /**
     * Name displayed for the user in the Snowflake web interface.
     *
     * @schema CfnUserProps#DisplayName
     */
    readonly displayName?: string;
    /**
     * First name of the user.
     *
     * @schema CfnUserProps#FirstName
     */
    readonly firstName?: string;
    /**
     * Middle name of the user.
     *
     * @schema CfnUserProps#MiddleName
     */
    readonly middleName?: string;
    /**
     * Last name of the user.
     *
     * @schema CfnUserProps#LastName
     */
    readonly lastName?: string;
    /**
     * Email address for the user.
     *
     * @schema CfnUserProps#Email
     */
    readonly email?: string;
    /**
     * Specifies whether the user is forced to change their password on next login (including their first/initial login) into the system.
     *
     * @schema CfnUserProps#MustChangePassword
     */
    readonly mustChangePassword?: boolean;
    /**
     * Specifies whether the user is disabled.
     *
     * @schema CfnUserProps#Disabled
     */
    readonly disabled?: boolean;
    /**
     * Specifies the number of days after which the user status is set to Expired and the user is no longer allowed to log in.
     *
     * @schema CfnUserProps#DaysToExpiry
     */
    readonly daysToExpiry?: number;
    /**
     * Specifies the number of minutes until the temporary lock on the user login is cleared.
     *
     * @schema CfnUserProps#MinsToUnlock
     */
    readonly minsToUnlock?: number;
    /**
     * Specifies the namespace (database only or database and schema) that is active by default for the user's session upon login.
     *
     * @schema CfnUserProps#DefaultWarehouse
     */
    readonly defaultWarehouse?: string;
    /**
     * Specifies the primary role that is active by default for the user's session upon login.
     *
     * @schema CfnUserProps#DefaultRole
     */
    readonly defaultRole?: string;
    /**
     * Specifies the number of minutes to temporarily bypass MFA for the user.
     *
     * @schema CfnUserProps#MinsToBypassMfa
     */
    readonly minsToBypassMfa?: number;
    /**
     * Specifies the user's RSA public key; used for key pair authentication.
     *
     * @schema CfnUserProps#RsaPublicKey
     */
    readonly rsaPublicKey?: string;
    /**
     * Specifies the user's second RSA public key; used to rotate the public and private keys for key pair authentication based on an expiration schedule set by your organization.
     *
     * @schema CfnUserProps#RsaPublicKey2
     */
    readonly rsaPublicKey2?: string;
    /**
     * Specifies a comment for the user.
     *
     * @schema CfnUserProps#Comment
     */
    readonly comment?: string;
}
/**
 * Converts an object of type 'CfnUserProps' to JSON representation.
 */
export declare function toJson_CfnUserProps(obj: CfnUserProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Snowflake::User::User`
 *
 * @cloudformationResource Snowflake::User::User
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-snowflake-resource-providers.git
 */
export declare class CfnUser extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Snowflake::User::User";
    /**
     * Resource props.
     */
    readonly props: CfnUserProps;
    /**
     * Create a new `Snowflake::User::User`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnUserProps);
}
