# Generated by Django 5.0 on 2023-12-28 03:24

import django.db.models.deletion
from django.db import migrations, models

import django_fast_iprestrict.models
import django_fast_iprestrict.validators


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Rule",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "position",
                    models.PositiveIntegerField(
                        blank=True,
                        default=django_fast_iprestrict.models.get_default_position,
                    ),
                ),
                ("name", models.CharField(max_length=50, unique=True)),
                (
                    "rule",
                    models.CharField(
                        max_length=50,
                        validators=[django_fast_iprestrict.validators.validate_network],
                    ),
                ),
                (
                    "action",
                    models.CharField(
                        choices=[("a", "allow"), ("b", "deny"), ("c", "disabled")],
                        default="a",
                        max_length=1,
                    ),
                ),
            ],
            options={
                "ordering": ("position",),
                "indexes": [
                    models.Index(
                        fields=["position"], name="django_fast_positio_d900cb_idx"
                    )
                ],
            },
        ),
        migrations.CreateModel(
            name="RulePath",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("path", models.TextField(max_length=4096)),
                ("is_regex", models.BooleanField(blank=True, default=False)),
                (
                    "rule",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="urls",
                        to="django_fast_iprestrict.rule",
                    ),
                ),
            ],
            options={
                "ordering": ("rule__position", "id"),
            },
        ),
    ]
