# Generated by Django 4.0.8 on 2022-12-29 15:20

from django.conf import settings
import django.contrib.auth.models
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('first_name', models.CharField(blank=True, max_length=150, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('metadata', models.JSONField(default=dict, editable=False)),
                ('name', models.CharField(max_length=2000)),
                ('homepage', models.URLField(blank=True)),
                ('photo', models.ImageField(blank=True, upload_to='user_photos')),
                ('title', models.CharField(blank=True, max_length=300)),
                ('description', models.TextField(blank=True, max_length=1000)),
                ('username', models.CharField(max_length=40, null=True, unique=True)),
                ('email', models.EmailField(max_length=254, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('created_by', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Slide',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('metadata', models.JSONField(default=dict, editable=False)),
                ('name', models.CharField(max_length=2000)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('article', models.TextField(blank=True, null=True)),
                ('image', models.ImageField(blank=True, upload_to='slides')),
                ('created_by', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Slides',
            },
        ),
        migrations.CreateModel(
            name='ResearchArtifact',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('metadata', models.JSONField(default=dict, editable=False)),
                ('name', models.CharField(max_length=2000)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('type', models.CharField(choices=[('article', 'Article'), ('book', 'Book'), ('booklet', 'Booklet'), ('conference', 'Conference'), ('inbook', 'Contribution to book'), ('incollection', 'Contribution to collection'), ('inproceedings', 'Contribution to conference or workshop'), ('manual', 'Technical documentation'), ('mastersthesis', 'Masters thesis'), ('misc', 'Miscellaneous'), ('phdthesis', 'PhD thesis'), ('proceedings', 'Conference or workshop proceedings'), ('techreport', 'Technical report'), ('unpublished', 'Unpublished')], default='article', max_length=100)),
                ('author', models.TextField(null=True)),
                ('year', models.PositiveIntegerField(null=True)),
                ('doi', models.CharField(max_length=1000, null=True)),
                ('pages', models.CharField(max_length=1000, null=True)),
                ('howpublished', models.CharField(max_length=1000, null=True)),
                ('chapter', models.CharField(max_length=1000, null=True)),
                ('organization', models.CharField(max_length=1000, null=True)),
                ('booktitle', models.CharField(max_length=1000, null=True)),
                ('school', models.CharField(max_length=1000, null=True)),
                ('institution', models.CharField(max_length=1000, null=True)),
                ('publisher', models.CharField(max_length=1000, null=True)),
                ('address', models.CharField(max_length=1000, null=True)),
                ('journal', models.CharField(max_length=1000, null=True)),
                ('volume', models.CharField(max_length=1000, null=True)),
                ('number', models.CharField(max_length=1000, null=True)),
                ('series', models.CharField(max_length=1000, null=True)),
                ('month', models.CharField(max_length=1000, null=True)),
                ('note', models.CharField(max_length=1000, null=True)),
                ('key', models.CharField(max_length=1000, null=True)),
                ('editor', models.CharField(max_length=1000, null=True)),
                ('edition', models.CharField(max_length=1000, null=True)),
                ('biburl', models.URLField(max_length=1000, null=True)),
                ('slides', models.FileField(null=True, upload_to='research/slides')),
                ('document', models.FileField(null=True, upload_to='research/documents')),
                ('appendix', models.FileField(null=True, upload_to='research/appendices')),
                ('image', models.ImageField(null=True, upload_to='research/images')),
                ('description', models.TextField(blank=True, null=True)),
                ('created_by', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-year', '-month'],
            },
        ),
        migrations.CreateModel(
            name='Query',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('metadata', models.JSONField(default=dict, editable=False)),
                ('name', models.CharField(max_length=2000)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('sparql', models.TextField()),
                ('created_by', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Queries',
            },
        ),
        migrations.CreateModel(
            name='PrimarySource',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('metadata', models.JSONField(default=dict, editable=False)),
                ('state', models.CharField(choices=[('PR', 'processing'), ('ER', 'error'), ('CO', 'complete')], default='PR', editable=False, max_length=2)),
                ('message', models.TextField(editable=False, null=True)),
                ('task_id', models.CharField(editable=False, max_length=200, null=True)),
                ('name', models.CharField(max_length=2000)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('created_by', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MachineLearningModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('metadata', models.JSONField(default=dict, editable=False)),
                ('state', models.CharField(choices=[('PR', 'processing'), ('ER', 'error'), ('CO', 'complete')], default='PR', editable=False, max_length=2)),
                ('message', models.TextField(editable=False, null=True)),
                ('task_id', models.CharField(editable=False, max_length=200, null=True)),
                ('name', models.CharField(max_length=2000)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('created_by', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Documentation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('metadata', models.JSONField(default=dict, editable=False)),
                ('name', models.CharField(max_length=2000)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('content', models.TextField(blank=True, null=True)),
                ('view_name', models.CharField(editable=False, max_length=200, null=True)),
                ('referent_id', models.PositiveIntegerField(blank=True, editable=False, null=True)),
                ('created_by', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
                ('referent_type', models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype')),
            ],
        ),
        migrations.CreateModel(
            name='Annotation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('metadata', models.JSONField(default=dict, editable=False)),
                ('state', models.CharField(choices=[('PR', 'processing'), ('ER', 'error'), ('CO', 'complete')], default='PR', editable=False, max_length=2)),
                ('message', models.TextField(editable=False, null=True)),
                ('task_id', models.CharField(editable=False, max_length=200, null=True)),
                ('name', models.CharField(max_length=2000)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('source_id', models.PositiveIntegerField(blank=True, editable=False, null=True)),
                ('created_by', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
                ('source_type', models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddIndex(
            model_name='documentation',
            index=models.Index(fields=['referent_type', 'referent_id'], name='ochre_docum_referen_61394f_idx'),
        ),
    ]
