# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['creole',
 'creole.emitter',
 'creole.html_tools',
 'creole.parser',
 'creole.rest_tools',
 'creole.shared',
 'creole.tests',
 'creole.tests.utils']

package_data = \
{'': ['*']}

install_requires = \
['docutils']

entry_points = \
{'console_scripts': ['creole2html = creole.cmdline:cli_creole2html',
                     'html2creole = creole.cmdline:cli_html2creole',
                     'html2rest = creole.cmdline:cli_html2rest',
                     'html2textile = creole.cmdline:cli_html2textile',
                     'publish = creole.publish:publish',
                     'update_rst_readme = '
                     'creole.setup_utils:update_creole_rst_readme']}

setup_kwargs = {
    'name': 'python-creole-atlassian',
    'version': '1.4.92',
    'description': 'python-creole is an open-source (GPL) markup converter in pure Python for: creole2html, html2creole, html2ReSt, html2textile',
    'long_description': '===================\nabout python-creole\n===================\n\npython-creole is a OpenSource (GPL) Python lib for converting markups.\npython-creole is pure python. No external libs needed.\n\nCompatible Python Versions (see `tox.ini <https://github.com/jedie/python-creole/blob/master/tox.ini>`_ or `.travis.yml <https://github.com/jedie/python-creole/blob/master/.travis.yml>`_):\n\n* 3.9, 3.8, 3.7, 3.6\n\n* PyPy3\n\nExisting converters:\n\n* creole -> html\n\n* html -> creole markup\n\n* reSt -> html (for clean html code)\n\n* html -> reStructuredText markup (only a subset of reSt supported)\n\n* html -> textile markup (not completed yet)\n\nThe creole2html part based on the creole markup parser and emitter from the MoinMoin project by Radomir Dopieralski and Thomas Waldmann.\n\n+-----------------------------------+\n| |Build Status on github|          |\n+-----------------------------------+\n| |Build Status on travis-ci.org|   |\n+-----------------------------------+\n| |Coverage Status on coveralls.io| |\n+-----------------------------------+\n| |Status on landscape.io|          |\n+-----------------------------------+\n| |PyPi version|                    |\n+-----------------------------------+\n\n.. |Build Status on github| image:: https://github.com/jedie/python-creole/workflows/test/badge.svg?branch=master\n.. |Build Status on travis-ci.org| image:: https://travis-ci.org/jedie/python-creole.svg\n.. _travis-ci.org/jedie/python-creole: https://travis-ci.org/jedie/python-creole/\n.. |Coverage Status on coveralls.io| image:: https://coveralls.io/repos/jedie/python-creole/badge.svg\n.. _coveralls.io/r/jedie/python-creole: https://coveralls.io/r/jedie/python-creole\n.. |Status on landscape.io| image:: https://landscape.io/github/jedie/python-creole/master/landscape.svg\n.. _landscape.io/github/jedie/python-creole/master: https://landscape.io/github/jedie/python-creole/master\n.. |PyPi version| image:: https://badge.fury.io/py/python-creole.svg\n.. _pypi.org/project/python-creole/: https://pypi.org/project/python-creole/\n\n=======\ninstall\n=======\n\nPython packages available on: `http://pypi.python.org/pypi/python-creole/ <http://pypi.python.org/pypi/python-creole/>`_\n\n::\n\n    ~$ pip install python-creole\n\nTo setup a virtualenv via Poetry, see ``unittests`` section below.\n\n------------\ndependencies\n------------\n\nFor the most parts (``creole2html`` and ``html2creole``) no external libraries are needed.\n\nFor all functionality (and running the unittests) these modules are needed:\n\n* `docutils <http://pypi.python.org/pypi/docutils/>`_ (for the ReStructuredText stuff)\n\n* `textile <http://pypi.python.org/pypi/textile/>`_ (for html2textile tests)\n\n=======\nexample\n=======\n\n-----------\ncreole2html\n-----------\n\nConvert creole markup to html code:\n\n::\n\n    >>> from creole import creole2html\n    >>> creole2html("This is **creole //markup//**")\n    u\'<p>This is <strong>creole <i>markup</i></strong></p>\\n\'\n\n-----------\nhtml2creole\n-----------\n\nConvert html code back into creole markup:\n\n::\n\n    >>> from creole import html2creole\n    >>> html2creole(u\'<p>This is <strong>creole <i>markup</i></strong></p>\\n\')\n    u\'This is **creole //markup//**\'\n\n---------\nrest2html\n---------\n\nConvert ReStructuredText into clean html code (needs `docutils`_):\n\n::\n\n    >>> from creole.rest2html.clean_writer import rest2html\n    >>> rest2html(u"A ReSt link to `PyLucid CMS <http://www.pylucid.org>`_ :)")\n    u\'<p>A ReSt link to <a href="http://www.pylucid.org">PyLucid CMS</a> :)</p>\\\\n\'\n\n(more information: `rest2html wiki page <https://github.com/jedie/python-creole/wiki/rest2html>`_)\n\n---------\nhtml2rest\n---------\n\nConvert html code into ReStructuredText markup:\n\n::\n\n    >>> from creole import html2rest\n    >>> html2rest(u\'<p>This is <strong>ReStructuredText</strong> <em>markup</em>!</p>\')\n    u\'This is **ReStructuredText** *markup*!\'\n\n------------\nhtml2textile\n------------\n\nConvert html code into textile markup\n\n::\n\n    >>> from creole import html2textile\n    >>> html2textile(u\'<p>This is <strong>textile <i>markup</i></strong>!</p>\')\n    u\'This is *textile __markup__*!\'\n\nSee also: `http://github.com/jedie/python-creole/blob/master/demo.py <http://github.com/jedie/python-creole/blob/master/demo.py>`_\n\n=====================\nImage size additional\n=====================\n\nYou can pass image width/height in image tags, e.g.:\n\n::\n\n    >>> from creole import creole2html\n    >>> creole_markup="""{{foobar.jpg|image title|90x160}}"""\n    >>> creole2html(creole_markup)\n    \'<p><img src="foobar.jpg" title="image title" alt="image title" width="90" height="160" /></p>\'\n\nThe third part (``90x160``) is not in creole standard, you can force a *strict* mode, e.g.:\n\n::\n\n    >>> creole2html(creole_markup, strict=True)\n    \'<p><img src="foobar.jpg" title="image title|90x160" alt="image title|90x160" /></p>\'\n\n================================\nSource code highlighting support\n================================\n\nYou can find a example macro which highlight source code thanks to the pygments\nlibrary. It is located here: `/creole/shared/example_macros.py <https://github.com/jedie/python-creole/blob/master/creole/shared/example_macros.py>`_.\nHere is how to use it:\n\n::\n\n    >>> from creole import creole2html\n    >>> from creole.shared.example_macros import code\n    >>> creole_markup="""<<code ext=".py">>#some code\\nprint(\'coucou\')\\n<</code>>"""\n    >>> creole2html(creole_markup, macros={\'code\': code})\n\n=====================\ncommandline interface\n=====================\n\nIf you have python-creole installed, you will get these simple CLI scripts:\n\n* creole2html\n\n* html2creole\n\n* html2rest\n\n* html2textile\n\nHere the ``--help`` output from ``html2creole``:\n\n::\n\n    $ html2creole --help\n    usage: html2creole [-h] [-v] [--encoding ENCODING] sourcefile destination\n    \n    python-creole is an open-source (GPL) markup converter in pure Python for:\n    creole2html, html2creole, html2ReSt, html2textile\n    \n    positional arguments:\n      sourcefile           source file to convert\n      destination          Output filename\n    \n    optional arguments:\n      -h, --help           show this help message and exit\n      -v, --version        show program\'s version number and exit\n      --encoding ENCODING  Codec for read/write file (default encoding: utf-8)\n\nExample to convert a html file into a creole file:\n\n::\n\n    $ html2creole foobar.html foobar.creole\n\n=============\ndocumentation\n=============\n\nWe store documentation/examples into the project wiki:\n\n* `https://github.com/jedie/python-creole/wiki <https://github.com/jedie/python-creole/wiki>`_\n\nHow to handle unknown html tags in html2creole:\n\n* `https://github.com/jedie/python-creole/wiki/Unknown-Html-Tags <https://github.com/jedie/python-creole/wiki/Unknown-Html-Tags>`_\n\nContributers should take a look at this page:\n\n* `https://github.com/jedie/python-creole/wiki/Developer-Info <https://github.com/jedie/python-creole/wiki/Developer-Info>`_\n\nCreole Markup Cheat Sheet can be found here: `http://www.wikicreole.org/wiki/CheatSheet <http://www.wikicreole.org/wiki/CheatSheet>`_\n\n|Creole Markup Cheat Sheet|\n\n.. |Creole Markup Cheat Sheet| image:: http://www.wikicreole.org/imageServlet?page=CheatSheet%2Fcreole_cheat_sheet.png&width=340\n\n---------\nunittests\n---------\n\n::\n\n    # clone repository (or use your fork):\n    ~$ git clone https://github.com/jedie/python-creole.git\n    ~$ cd python-creole\n    \n    # install or update poetry:\n    ~/python-creole$ make install-poetry\n    \n    # install python-creole via poetry:\n    ~/python-creole$ make install\n    \n    # Run pytest:\n    ~/python-creole$ make pytest\n    \n    # Run pytest via tox with all environments:\n    ~/python-creole$ make tox\n    \n    # Run pytest via tox with one Python version:\n    ~/python-creole$ make tox-py38\n    ~/python-creole$ make tox-py37\n    ~/python-creole$ make tox-py36\n\n------------\nmake targets\n------------\n\nTo see all make targets, just call ``make``:\n\n::\n\n    ~/python-creole$ make\n    help                 List all commands\n    install-poetry       install or update poetry\n    install              install python-creole via poetry\n    lint                 Run code formatters and linter\n    fix-code-style       Fix code formatting\n    tox-listenvs         List all tox test environments\n    tox                  Run pytest via tox with all environments\n    tox-py36             Run pytest via tox with *python v3.6*\n    tox-py37             Run pytest via tox with *python v3.7*\n    tox-py38             Run pytest via tox with *python v3.8*\n    tox-py39             Run pytest via tox with *python v3.9*\n    pytest               Run pytest\n    update-rst-readme    update README.rst from README.creole\n    publish              Release new version to PyPi\n\n--------------------\nUse creole in README\n--------------------\n\nWith python-creole you can convert a README on-the-fly from creole into ReStructuredText in setup.py\nHow to do this, read: `https://github.com/jedie/python-creole/wiki/Use-In-Setup <https://github.com/jedie/python-creole/wiki/Use-In-Setup>`_\n\nNote: In this case you must install **docutils**! See above.\n\n=======\nhistory\n=======\n\n* *dev* - `compare v1.4.9...master <https://github.com/jedie/python-creole/compare/v1.4.9...master>`_ \n\n    * TBC\n\n* v1.4.9 - 2020-11-4 - `compare v1.4.8...v1.4.9 <https://github.com/jedie/python-creole/compare/v1.4.8...v1.4.9>`_ \n\n    * Add missing classifier for Python 3.9 (`Contributed by jugmac00 <https://github.com/jedie/python-creole/pull/55>`_)\n\n    * Update readme test\n\n* v1.4.8 - 2020-10-17 - `compare v1.4.7...v1.4.8 <https://github.com/jedie/python-creole/compare/v1.4.7...v1.4.8>`_ \n\n    * Validate generated ``README.rst`` with `readme-renderer <https://pypi.org/project/readme-renderer/>`_\n\n* v1.4.7 - 2020-10-17 - `compare v1.4.6...v1.4.7 <https://github.com/jedie/python-creole/compare/v1.4.6...v1.4.7>`_ \n\n    * ``update_rst_readme()`` will touch ``README.rst`` if there are not change (timestamp will not changed in file)\n\n    * Run tests with Python 3.9, too.\n\n    * Some meta updates to project setup\n\n* v1.4.6 - 2020-02-13 - `compare v1.4.5...v1.4.6 <https://github.com/jedie/python-creole/compare/v1.4.5...v1.4.6>`_ \n\n    * less restricted dependency specification\n\n* v1.4.5 - 2020-02-13 - `compare v1.4.4...v1.4.5 <https://github.com/jedie/python-creole/compare/v1.4.4...v1.4.5>`_ \n\n    * new: ``creole.setup_utils.assert_rst_readme`` for project setup tests\n\n    * use `https://github.com/ymyzk/tox-gh-actions <https://github.com/ymyzk/tox-gh-actions>`_ on gitlab CI\n\n* v1.4.4 - 2020-02-07 - `compare v1.4.3...v1.4.4 <https://github.com/jedie/python-creole/compare/v1.4.3...v1.4.4>`_ \n\n    * Fix #44: Move ``poetry-publish`` to ``dev-dependencies`` and lower ``docutils`` requirement to |^0.15|\n\n    * some code style updated\n\n    * Always update README.rst before publish\n\n* v1.4.3 - 2020-02-01 - `compare v1.4.2...v1.4.3 <https://github.com/jedie/python-creole/compare/v1.4.2...v1.4.3>`_ \n\n    * Use new `poetry-publish <https://pypi.org/project/poetry-publish/>`_ for ``make publish``\n\n* v1.4.2 - 2020-02-01 - `compare v1.4.1...v1.4.2 <https://github.com/jedie/python-creole/compare/v1.4.1...v1.4.2>`_ \n\n    * Update CI configs on github and travis\n\n    * Update ``Makefile``: add ``make publish`` and ``make update-rst-readme``\n\n    * Add generated ``README.rst`` in repository to fix install problems about missing readme\n\n* v1.4.1 - 2020-01-19 - `compare v1.4.0...v1.4.1 <https://github.com/jedie/python-creole/compare/v1.4.0...v1.4.1>`_ \n\n    * Remove Python v2 support code\n\n    * `Fix "Undefined substitution referenced" error <https://github.com/jedie/python-creole/issues/26>`_ contributed by dforsi\n\n    * `Fix regression in tests for setup_utils <https://github.com/jedie/python-creole/pull/37>`_ contributed by jugmac00\n\n    * Fix code style with: autopep8\n\n    * sort imports with isort\n\n    * change old ``%-formatted`` and ``.format(...)`` strings into Python 3.6+\'s ``f-strings`` with flynt\n\n    * Activate linting in CI pipeline\n\n* v1.4.0 - 2020-01-19 - `compare v1.3.2...v1.4.0 <https://github.com/jedie/python-creole/compare/v1.3.2...v1.4.0>`_ \n\n    * modernize project:\n\n        * use poetry\n\n        * Add a ``Makefile``\n\n        * use pytest and tox\n\n        * remove Python v2 support\n\n        * Test with Python v3.6, v3.7 and v3.8\n\n* v1.3.2 - 2018-02-27 - `compare v1.3.1...v1.3.2 <https://github.com/jedie/python-creole/compare/v1.3.1...v1.3.2>`_ \n\n    * Adding optional img size to creole2html and html2creole contributed by `John Dupuy <https://github.com/JohnAD>`_\n\n    * run tests also with python 3.5 and 3.6\n\n* v1.3.1 - 2015-08-15 - `compare v1.3.0...v1.3.1 <https://github.com/jedie/python-creole/compare/v1.3.0...v1.3.1>`_ \n\n    * Bugfix for "Failed building wheel for python-creole"\n\n* v1.3.0 - 2015-06-02 - `compare v1.2.2...v1.3.0 <https://github.com/jedie/python-creole/compare/v1.2.2...v1.3.0>`_ \n\n    * Refactory internal file structure\n\n    * run unittests and doctests with nose\n\n    * Refactor CLI tests\n\n    * skip official support for Python 2.6\n\n    * small code cleanups and fixes.\n\n    * use **json.dumps()** instead of **repr()** in some cases\n\n* v1.2.2 - 2015-04-05 - `compare v1.2.1...v1.2.2 <https://github.com/jedie/python-creole/compare/v1.2.1...v1.2.2>`_ \n\n    * Bugfix textile unittests if url scheme is unknown\n\n    * migrate google-code Wiki to github and remove google-code links\n\n* v1.2.1 - 2014-09-14 - `compare v1.2.0...v1.2.1 <https://github.com/jedie/python-creole/compare/v1.2.0...v1.2.1>`_ \n\n    * Use origin PyPi code to check generated reStructuredText in setup.py\n\n    * Update unitest for textile v2.1.8\n\n* v1.2.0 - 2014-05-15 - `compare v1.1.1...v1.2.0 <https://github.com/jedie/python-creole/compare/v1.1.1...v1.2.0>`_ \n\n    * NEW: Add ``<<code>>`` example macro (Source code highlighting with pygments) - implemented by Julien Enselme\n\n    * NEW: Add ``<<toc>>`` macro to create a table of contents list\n\n    * Bugfix for: AttributeError: \'CreoleParser\' object has no attribute \'_escaped_char_repl\'\n\n    * Bugfix for: AttributeError: \'CreoleParser\' object has no attribute \'_escaped_url_repl\'\n\n    * API Change: Callable macros will raise a TypeError instead of create a DeprecationWarning (Was removed in v0.5)\n\n* v1.1.1 - 2013-11-08\n\n    * Bugfix: Setup script exited with error: can\'t copy \'README.creole\': doesn\'t exist or not a regular file\n\n* v1.1.0 - 2013-10-28\n\n    * NEW: Simple commandline interface added.\n\n* v1.0.7 - 2013-08-07\n\n    * Bugfix in \'clean reStructuredText html writer\' if docutils => v0.11 used.\n\n    * Bugfix for PyPy 2.1 usage\n\n* v1.0.6 - 2012-10-15\n\n    * Security fix in rest2html: Disable "file_insertion_enabled" and "raw_enabled" as default.\n\n* v1.0.5 - 2012-09-03\n\n    * made automatic protocol links more strict: Only whitespace before and at the end are allowed.\n\n    * Bugfix: Don\'t allow ``ftp:/broken`` (Only one slash) to be a link.\n\n* v1.0.4 - 2012-06-11\n\n    * html2rest: Handle double link/image substitution and raise better error messages\n\n    * Bugfix in unittests (include test README file in python package).  Thanks to Wen Heping for reporting this.\n\n* v1.0.3 - 2012-06-11\n\n    * Bugfix: ``AttributeError: \'module\' object has no attribute \'interesting_cdata\'`` from HTMLParser patch. Thanks to Wen Heping for reporting this.\n\n    * Fix a bug in get_long_description() ReSt test for Py3k and his unittests.\n\n    * Use Travis CI, too.\n\n* v1.0.2 - 2012-04-04\n\n    * Fix "`AttributeError: \'NoneType\' object has no attribute \'parent\' <https://github.com/jedie/python-creole/issues/6>`_" in html2creole.\n\n* v1.0.1 - 2011-11-16\n\n    * Fix "`TypeError: expected string or buffer <https://github.com/jedie/python-creole/issues/5>`_" in rest2html.\n\n    * `Bugfix in exception handling. <https://github.com/jedie/python-creole/commit/e8422f944709a5f8c2c6a8c8a58a84a92620f035>`_\n\n* v1.0.0 - 2011-10-20\n\n    * Change API: Replace \'parser_kwargs\' and \'emitter_kwargs\' with separate arguments. (More information on `API Wiki Page <https://github.com/jedie/python-creole/wiki/API>`_)\n\n* v0.9.2\n\n    * Turn zip_safe in setup.py on and change unittests API.\n\n* v0.9.1\n\n    * Many Bugfixes, tested with CPython 2.6, 2.7, 3.2 and PyPy v1.6\n\n* v0.9.0\n\n    * Add Python v3 support (like `http://python3porting.com/noconv.html <http://python3porting.com/noconv.html>`_ strategy)\n\n    * move unittests into creole/tests/\n\n    * Tested with Python 2.7.1, 3.2 and PyPy v1.6.1 15798ab8cf48 jit\n\n* v0.8.5\n\n    * Bugfix in html2creole: ignore links without href\n\n* v0.8.4\n\n    * Bugfix in html parser if list tag has attributes: `https://code.google.com/p/python-creole/issues/detail?id=19#c4 <https://code.google.com/p/python-creole/issues/detail?id=19#c4>`_\n\n* v0.8.3\n\n    * Better error message if given string is not unicode: `https://code.google.com/p/python-creole/issues/detail?id=19 <https://code.google.com/p/python-creole/issues/detail?id=19>`_\n\n* v0.8.2\n\n    * Bugfix in get_long_description() error handling (*local variable \'long_description_origin\' referenced before assignment*)\n\n* v0.8.1\n\n    * Bugfix for installation under python 2.5\n\n    * Note: `setup helper <https://github.com/jedie/python-creole/wiki/Use-In-Setup>`_ changed: rename ``GetLongDescription(...)`` to ``get_long_description(...)``\n\n* v0.8\n\n    * New GetLongDescription() helper for setup.py, see: `https://github.com/jedie/python-creole/wiki/Use-In-Setup`_\n\n* v0.7.3\n\n    * Bugfix in html2rest:\n\n        * table without ``<th>`` header\n\n        * new line after table\n\n        * create reference hyperlinks in table cells intead of embedded urls.\n\n        * Don\'t always use raise_unknown_node()\n\n    * Add child content to raise_unknown_node()\n\n* v0.7.2\n\n    * Activate ``----`` to ``<hr>`` in html2rest\n\n    * Update demo.py\n\n* v0.7.1\n\n    * Bugfix if docutils are not installed\n\n    * API change: rest2html is now here: ``from creole.rest2html.clean_writer import rest2html`` \n\n* v0.7.0\n\n    * **NEW**: Add a html2reStructuredText converter (only a subset of reSt supported)\n\n* v0.6.1\n\n    * Bugfix: separate lines with one space in "wiki style line breaks" mode\n\n* v0.6\n\n    * **NEW**: html2textile converter\n\n    * some **API changed**!\n\n* v0.5\n\n    * **API changed**:\n\n        * Html2CreoleEmitter optional argument \'unknown_emit\' takes now a callable for handle unknown html tags.\n\n        * No macros used as default in creole2html converting.\n\n        * We remove the support for callable macros. Only dict and modules are allowed.\n\n    * remove unknown html tags is default behaviour in html2creole converting.\n\n    * restructure and cleanup sourcecode files.\n\n* v0.4\n\n    * only emit children of empty tags like div and span (contributed by Eric O\'Connell)\n\n    * remove inter wiki links and doesn\'t check the protocol\n\n* v0.3.3\n\n    * Use <tt> when {{{ ... }}} is inline and not <pre>, see: `PyLucid Forum Thread <http://forum.pylucid.org/viewtopic.php?f=3&t=320>`_\n\n    * Bugfix in html2creole: insert newline before new list. TODO: apply to all block tags: `issues 16 <http://code.google.com/p/python-creole/issues/detail?id=16#c5>`_\n\n* v0.3.2\n\n    * Bugfix for spaces after Headline: `issues 15 <https://code.google.com/p/python-creole/issues/detail?id=15>`_\n\n* v0.3.1\n\n    * Make argument \'block_rules\' in Parser() optional\n\n* v0.3.0\n\n    * creole2html() has the optional parameter \'blog_line_breaks\' to switch from default blog to wiki line breaks\n\n* v0.2.8\n\n    * bugfix in setup.py\n\n* v0.2.7\n\n    * handle obsolete non-closed <br> tag\n\n* v0.2.6\n\n    * bugfix in setup.py\n\n    * Cleanup DocStrings\n\n    * add unittests\n\n* v0.2.5\n\n    * creole2html: Bugfix if "--", "//" etc. stands alone, see also: `issues 12 <http://code.google.com/p/python-creole/issues/detail?id=12>`_\n\n    * Note: bold, italic etc. can\'t cross line any more.\n\n* v0.2.4\n\n    * creole2html: ignore file extensions in image tag\n\n        * see also: `issues 7 <http://code.google.com/p/python-creole/issues/detail?id=7>`_\n\n* v0.2.3\n\n    * html2creole bugfix/enhanced: convert image tag without alt attribute:\n\n        * see also: `issues 6 <http://code.google.com/p/python-creole/issues/detail?id=6>`_\n\n        * Thanks Betz Stefan alias \'encbladexp\'\n\n* v0.2.2\n\n    * html2creole bugfix: convert ``<a href="/url/">Search & Destroy</a>``\n\n* v0.2.1\n\n    * html2creole bugfixes in:\n\n        * converting tables: ignore tbody tag and better handling p and a tags in td\n\n        * converting named entity\n\n* v0.2\n\n    * remove all django template tag stuff: `issues 3 <http://code.google.com/p/python-creole/issues/detail?id=3>`_\n\n    * html code always escaped\n\n* v0.1.1\n\n    * improve macros stuff, patch by Vitja Makarov: `issues 2 <http://code.google.com/p/python-creole/issues/detail?id=2>`_\n\n* v0.1.0\n\n    * first version cut out from `PyLucid CMS <http://www.pylucid.org>`_\n\n.. |^0.15| image:: ^0.15\n\nfirst source code was written 27.11.2008: `Forum thread (de) <http://www.python-forum.de/viewtopic.php?f=3&t=16742>`_\n\n-------------\nProject links\n-------------\n\n+--------+------------------------------------------------+\n| GitHub | `https://github.com/jedie/python-creole`_      |\n+--------+------------------------------------------------+\n| Wiki   | `https://github.com/jedie/python-creole/wiki`_ |\n+--------+------------------------------------------------+\n| PyPi   | `https://pypi.org/project/python-creole/`_     |\n+--------+------------------------------------------------+\n\n.. _https://github.com/jedie/python-creole: https://github.com/jedie/python-creole\n.. _https://pypi.org/project/python-creole/: https://pypi.org/project/python-creole/\n\n--------\ndonation\n--------\n\n* `paypal.me/JensDiemer <https://www.paypal.me/JensDiemer>`_\n\n* `Flattr This! <https://flattr.com/submit/auto?uid=jedie&url=https%3A%2F%2Fgithub.com%2Fjedie%2Fpython-creole%2F>`_\n\n* Send `Bitcoins <http://www.bitcoin.org/>`_ to `1823RZ5Md1Q2X5aSXRC5LRPcYdveCiVX6F <https://blockexplorer.com/address/1823RZ5Md1Q2X5aSXRC5LRPcYdveCiVX6F>`_\n\n------------\n\n``Note: this file is generated from README.creole 2020-11-04 08:46:39 with "python-creole"``',
    'author': 'Jens Diemer',
    'author_email': 'python-creole@jensdiemer.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/jedie/python-creole/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0.0',
}


setup(**setup_kwargs)
