"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class ResourceHandler {
    constructor(eks, event) {
        this.eks = eks;
        this.requestType = event.RequestType;
        this.requestId = event.RequestId;
        this.logicalResourceId = event.LogicalResourceId;
        this.physicalResourceId = event.PhysicalResourceId;
        this.event = event;
        const roleToAssume = event.ResourceProperties.AssumeRoleArn;
        if (!roleToAssume) {
            throw new Error('AssumeRoleArn must be provided');
        }
        eks.configureAssumeRole({
            RoleArn: roleToAssume,
            RoleSessionName: `AWSCDK.EKSCluster.${this.requestType}.${this.requestId}`,
        });
    }
    onEvent() {
        switch (this.requestType) {
            case 'Create': return this.onCreate();
            case 'Update': return this.onUpdate();
            case 'Delete': return this.onDelete();
        }
        throw new Error(`Invalid request type ${this.requestType}`);
    }
    isComplete() {
        switch (this.requestType) {
            case 'Create': return this.isCreateComplete();
            case 'Update': return this.isUpdateComplete();
            case 'Delete': return this.isDeleteComplete();
        }
        throw new Error(`Invalid request type ${this.requestType}`);
    }
    log(x) {
        // tslint:disable-next-line: no-console
        console.log(JSON.stringify(x, undefined, 2));
    }
}
exports.ResourceHandler = ResourceHandler;
//# sourceMappingURL=data:application/json;base64,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