# -*- coding: utf-8 -*-
import os
from io import open
from setuptools import setup
from setuptools import find_packages

here = os.path.abspath(os.path.dirname(__file__))

with open(os.path.join(here, "README.md"), "r", encoding="utf-8") as fobj:
    long_description = fobj.read()

requires = [
    "django",
]

setup(
    name="django-fullname-localization",
    version="0.1.0",
    description="Add localization support for user's fullname.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    author="zencore",
    author_email="dobetter@zencore.cn",
    license="MIT",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3 :: Only",
    ],
    keywords=["django admin extentions", "django fullname localization"],
    install_requires=requires,
    packages=find_packages(".", exclude=["django_fullname_localization_example", "django_fullname_localization_example.migrations", "django_fullname_localization_demo"]),
    py_modules=["django_fullname_localization"],
    zip_safe=False,
    include_package_data=True,
)