"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-4663
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.hyperflex_health_check_script_info import HyperflexHealthCheckScriptInfo
    globals()['HyperflexHealthCheckScriptInfo'] = HyperflexHealthCheckScriptInfo


class HyperflexHealthCheckDefinitionAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'HYPERFLEX.HEALTHCHECKDEFINITION': "hyperflex.HealthCheckDefinition",
        },
        ('object_type',): {
            'HYPERFLEX.HEALTHCHECKDEFINITION': "hyperflex.HealthCheckDefinition",
        },
        ('script_execution_mode',): {
            'ON_DEMAND': "ON_DEMAND",
            'SCHEDULED': "SCHEDULED",
        },
        ('supported_hypervisor_type',): {
            'ALL': "All",
            'ESXI': "ESXi",
            'EMPTY': "",
            'IWE': "IWE",
            'HYPERV': "HyperV",
        },
        ('target_execution_type',): {
            'LEADER_NODE': "EXECUTE_ON_LEADER_NODE",
            'ALL_NODES': "EXECUTE_ON_ALL_NODES",
            'ALL_NODES_AND_AGGREGATE': "EXECUTE_ON_ALL_NODES_AND_AGGREGATE",
        },
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'category': (str,),  # noqa: E501
            'common_causes': (str,),  # noqa: E501
            'configuration': (str,),  # noqa: E501
            'default_health_check_script_info': (HyperflexHealthCheckScriptInfo,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'health_check_script_infos': ([HyperflexHealthCheckScriptInfo], none_type,),  # noqa: E501
            'health_impact': (str,),  # noqa: E501
            'internal_name': (str,),  # noqa: E501
            'minimum_hyper_flex_version': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'reference': (str,),  # noqa: E501
            'resolution': (str,),  # noqa: E501
            'script_execution_mode': (str,),  # noqa: E501
            'script_execution_on_compute_nodes': (bool,),  # noqa: E501
            'supported_hypervisor_type': (str,),  # noqa: E501
            'target_execution_type': (str,),  # noqa: E501
            'timeout': (int,),  # noqa: E501
            'unsupported_hyper_flex_versions': ([str], none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'category': 'Category',  # noqa: E501
        'common_causes': 'CommonCauses',  # noqa: E501
        'configuration': 'Configuration',  # noqa: E501
        'default_health_check_script_info': 'DefaultHealthCheckScriptInfo',  # noqa: E501
        'description': 'Description',  # noqa: E501
        'health_check_script_infos': 'HealthCheckScriptInfos',  # noqa: E501
        'health_impact': 'HealthImpact',  # noqa: E501
        'internal_name': 'InternalName',  # noqa: E501
        'minimum_hyper_flex_version': 'MinimumHyperFlexVersion',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'reference': 'Reference',  # noqa: E501
        'resolution': 'Resolution',  # noqa: E501
        'script_execution_mode': 'ScriptExecutionMode',  # noqa: E501
        'script_execution_on_compute_nodes': 'ScriptExecutionOnComputeNodes',  # noqa: E501
        'supported_hypervisor_type': 'SupportedHypervisorType',  # noqa: E501
        'target_execution_type': 'TargetExecutionType',  # noqa: E501
        'timeout': 'Timeout',  # noqa: E501
        'unsupported_hyper_flex_versions': 'UnsupportedHyperFlexVersions',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """HyperflexHealthCheckDefinitionAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "hyperflex.HealthCheckDefinition", must be one of ["hyperflex.HealthCheckDefinition", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "hyperflex.HealthCheckDefinition", must be one of ["hyperflex.HealthCheckDefinition", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            category (str): Category that the health check belongs to.. [optional]  # noqa: E501
            common_causes (str): Static information detailing the common causes for the health check failure.. [optional]  # noqa: E501
            configuration (str): Execution configuration fo the health check script.. [optional]  # noqa: E501
            default_health_check_script_info (HyperflexHealthCheckScriptInfo): [optional]  # noqa: E501
            description (str): Description of the health check definition.. [optional]  # noqa: E501
            health_check_script_infos ([HyperflexHealthCheckScriptInfo], none_type): [optional]  # noqa: E501
            health_impact (str): Static information detailing the health impact of the health check failure.. [optional]  # noqa: E501
            internal_name (str): Internal name of the health check definition.. [optional]  # noqa: E501
            minimum_hyper_flex_version (str): Minimum HyperFlex version that the check is supported on. Defaults to version 3.0.1.. [optional] if omitted the server will use the default value of "3.0"  # noqa: E501
            name (str): Name of the health check definition.. [optional]  # noqa: E501
            reference (str): Static information containing additional reference for the health check.. [optional]  # noqa: E501
            resolution (str): Static information detailing the possible remediation actions that can be taken to remedy the health check failure.. [optional]  # noqa: E501
            script_execution_mode (str): Execution mode of the health script on the HyperFlex cluster. * `ON_DEMAND` - Execute the health check on-demand. * `SCHEDULED` - Execute the health check on a scheduled interval.. [optional] if omitted the server will use the default value of "ON_DEMAND"  # noqa: E501
            script_execution_on_compute_nodes (bool): Indicates if the script needs to be executed on HyperFlex compute nodes. | Typically, scripts are only executed on the storage Nodes.. [optional]  # noqa: E501
            supported_hypervisor_type (str): Hypervisor type that the Health Check is supported on (All, if it is hypervisor agnostic). * `All` - The Health Check is hypervisor-agnostic. * `ESXi` - The Health Check is supported only on Vmware ESXi hypervisor of any version. * `` - The Health Check is supported only on Cisco HyperFlexAp platform. * `IWE` - The Health Check is supported only on Cisco IWE platform. * `HyperV` - The Health Check is supported only on Microsoft HyperV hypervisor.. [optional] if omitted the server will use the default value of "All"  # noqa: E501
            target_execution_type (str): Indicates whether the health check is executed only on the leader node, or on all nodes in the HyperFlex cluster. * `EXECUTE_ON_LEADER_NODE` - Execute the health check script only on the HyperFlex cluster's leader node. * `EXECUTE_ON_ALL_NODES` - Execute health check on all nodes and aggregate the results. * `EXECUTE_ON_ALL_NODES_AND_AGGREGATE` - Execute the health check on all Nodes and perform custom aggregation.. [optional] if omitted the server will use the default value of "EXECUTE_ON_LEADER_NODE"  # noqa: E501
            timeout (int): Health check script execution timeout.. [optional]  # noqa: E501
            unsupported_hyper_flex_versions ([str], none_type): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "hyperflex.HealthCheckDefinition")
        object_type = kwargs.get('object_type', "hyperflex.HealthCheckDefinition")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
