"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-4663
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.equipment_locator_led_relationship import EquipmentLocatorLedRelationship
    from intersight.model.hyperflex_node_relationship import HyperflexNodeRelationship
    globals()['EquipmentLocatorLedRelationship'] = EquipmentLocatorLedRelationship
    globals()['HyperflexNodeRelationship'] = HyperflexNodeRelationship


class HyperflexDriveAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'HYPERFLEX.DRIVE': "hyperflex.Drive",
        },
        ('object_type',): {
            'HYPERFLEX.DRIVE': "hyperflex.Drive",
        },
        ('disk_use_state',): {
            'UNKNOWN': "UNKNOWN",
            'USED': "USED",
            'NOTUSED': "NOTUSED",
            'EMPTY': "EMPTY",
        },
        ('protocol',): {
            'UNKNOWN': "Unknown",
            'SAS': "SAS",
            'NVME': "NVMe",
            'SATA': "SATA",
        },
        ('status',): {
            'UNKNOWN': "UNKNOWN",
            'CLAIMED': "CLAIMED",
            'AVAILABLE': "AVAILABLE",
            'IGNORED': "IGNORED",
            'BLACKLISTED': "BLACKLISTED",
            'SECUREERASED': "SECUREERASED",
        },
        ('type',): {
            'UNKNOWN': "Unknown",
            'SSD': "SSD",
            'HDD': "HDD",
            'NVRAM': "NVRAM",
            'SATA': "SATA",
            'BSAS': "BSAS",
            'FC': "FC",
            'FSAS': "FSAS",
            'LUN': "LUN",
            'MSATA': "MSATA",
            'SAS': "SAS",
            'VMDISK': "VMDISK",
        },
        ('usage',): {
            'UNKNOWN': "UNKNOWN",
            'PERSISTENCE': "PERSISTENCE",
            'SYSTEM': "SYSTEM",
            'CACHING': "CACHING",
        },
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'capacity': (int,),  # noqa: E501
            'disk_use_state': (str,),  # noqa: E501
            'host_name': (str,),  # noqa: E501
            'host_uuid': (str,),  # noqa: E501
            'model_number': (str,),  # noqa: E501
            'node_uuid': (str,),  # noqa: E501
            'path': (str,),  # noqa: E501
            'protocol': (str,),  # noqa: E501
            'serial_number': (str,),  # noqa: E501
            'slot_number': (str,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'type': (str,),  # noqa: E501
            'usage': (str,),  # noqa: E501
            'used_capacity': (int,),  # noqa: E501
            'uuid': (str,),  # noqa: E501
            'version': (str,),  # noqa: E501
            'locator_led': (EquipmentLocatorLedRelationship,),  # noqa: E501
            'node': (HyperflexNodeRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'capacity': 'Capacity',  # noqa: E501
        'disk_use_state': 'DiskUseState',  # noqa: E501
        'host_name': 'HostName',  # noqa: E501
        'host_uuid': 'HostUuid',  # noqa: E501
        'model_number': 'ModelNumber',  # noqa: E501
        'node_uuid': 'NodeUuid',  # noqa: E501
        'path': 'Path',  # noqa: E501
        'protocol': 'Protocol',  # noqa: E501
        'serial_number': 'SerialNumber',  # noqa: E501
        'slot_number': 'SlotNumber',  # noqa: E501
        'status': 'Status',  # noqa: E501
        'type': 'Type',  # noqa: E501
        'usage': 'Usage',  # noqa: E501
        'used_capacity': 'UsedCapacity',  # noqa: E501
        'uuid': 'Uuid',  # noqa: E501
        'version': 'Version',  # noqa: E501
        'locator_led': 'LocatorLed',  # noqa: E501
        'node': 'Node',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """HyperflexDriveAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "hyperflex.Drive", must be one of ["hyperflex.Drive", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "hyperflex.Drive", must be one of ["hyperflex.Drive", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            capacity (int): Provisioned capacity of the drive in bytes.. [optional]  # noqa: E501
            disk_use_state (str): Disk inventory state. Should be one of values defined in enum. * `UNKNOWN` - The use state of the disk is unknown. * `USED` - The use state of the disk is used. * `NOTUSED` - The use state of the disk is unused. * `EMPTY` - The use state of the disk is empty.. [optional] if omitted the server will use the default value of "UNKNOWN"  # noqa: E501
            host_name (str): Host Name.. [optional]  # noqa: E501
            host_uuid (str): The unique identifier of the drive's host.. [optional]  # noqa: E501
            model_number (str): The model number of the disk or SSD.. [optional]  # noqa: E501
            node_uuid (str): The unique identifier of the Hyperflex Node to which the disk is attached.. [optional]  # noqa: E501
            path (str): Device path for the drive.. [optional]  # noqa: E501
            protocol (str): Disk Protocol - SATA, NVME, SAS. * `Unknown` - Disk protocol is unknown. * `SAS` - Serial Attached SCSI protocol (SAS) used in disk. * `NVMe` - Non-volatile memory express (NVMe) protocol used in disk. * `SATA` - Serial Advanced Technology Attachment (SATA) used in disk.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            serial_number (str): Serial number of the Hyperflex drive.. [optional]  # noqa: E501
            slot_number (str): The SCSI slot number of the drive.. [optional]  # noqa: E501
            status (str): Disk inventory state as determined by storfs inventory module. Should be one of values defined in enum. * `UNKNOWN` - The state of the disk is unknown. * `CLAIMED` - The state of the disk is claimed by storfs and has a valid storfs format. * `AVAILABLE` - The disk is available but not claimed by storfs. * `IGNORED` - The disk ash been ignored by storfs. * `BLACKLISTED` - The disk has been blacklisted by storfs. * `SECUREERASED` - The disk has been secure erased.. [optional] if omitted the server will use the default value of "UNKNOWN"  # noqa: E501
            type (str): Type of disk - UNKNOWN, HDD, SSD. * `Unknown` - Default unknown disk type. * `SSD` - Storage disk with Solid state disk. * `HDD` - Storage disk with Hard disk drive. * `NVRAM` - Storage disk with Non-volatile random-access memory type. * `SATA` - Disk drive implementation with Serial Advanced Technology Attachment (SATA). * `BSAS` - Bridged SAS-SATA disks with added hardware to enable them to be plugged into a SAS-connected storage shelf. * `FC` - Storage disk with Fiber Channel. * `FSAS` - Near Line SAS. NL-SAS drives are enterprise SATA drives with a SAS interface, head, media, androtational speed of traditional enterprise-class SATA drives with the fully capable SAS interfacetypical for classic SAS drives. * `LUN` - Logical Unit Number refers to a logical disk. * `MSATA` - SATA disk in multi-disk carrier storage shelf. * `SAS` - Storage disk with serial attached SCSI. * `VMDISK` - Virtual machine Data Disk.. [optional] if omitted the server will use the default value of "Unknown"  # noqa: E501
            usage (str): Specifies what the disk is used for. Should be one of values defined in enum. * `UNKNOWN` - The usage of the disk is unknown. * `PERSISTENCE` - The usage of the disk is for generic data storage. * `SYSTEM` - The usage of the disk is related to system storage. * `CACHING` - The usage of the disk is for caching.. [optional] if omitted the server will use the default value of "UNKNOWN"  # noqa: E501
            used_capacity (int): Used Capacity of the drive in Bytes.. [optional]  # noqa: E501
            uuid (str): The unique identifier of the Hyperflex drive.. [optional]  # noqa: E501
            version (str): The firmware version of the Hyperflex drive.. [optional]  # noqa: E501
            locator_led (EquipmentLocatorLedRelationship): [optional]  # noqa: E501
            node (HyperflexNodeRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "hyperflex.Drive")
        object_type = kwargs.get('object_type', "hyperflex.Drive")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
