"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-4663
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.bulk_export_relationship import BulkExportRelationship
    from intersight.model.bulk_exported_item_relationship import BulkExportedItemRelationship
    from intersight.model.mo_mo_ref import MoMoRef
    globals()['BulkExportRelationship'] = BulkExportRelationship
    globals()['BulkExportedItemRelationship'] = BulkExportedItemRelationship
    globals()['MoMoRef'] = MoMoRef


class BulkExportedItemAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'BULK.EXPORTEDITEM': "bulk.ExportedItem",
        },
        ('object_type',): {
            'BULK.EXPORTEDITEM': "bulk.ExportedItem",
        },
        ('status',): {
            'EMPTY': "",
            'VALIDATIONINPROGRESS': "ValidationInProgress",
            'VALID': "Valid",
            'INVALID': "InValid",
            'INPROGRESS': "InProgress",
            'SUCCESS': "Success",
            'FAILED': "Failed",
            'ROLLBACKINITIATED': "RollBackInitiated",
            'ROLLBACKFAILED': "RollBackFailed",
            'ROLLBACKCOMPLETED': "RollbackCompleted",
            'ROLLBACKABORTED': "RollbackAborted",
            'OPERATIONTIMEDOUT': "OperationTimedOut",
            'OPERATIONCANCELLED': "OperationCancelled",
            'CANCELINPROGRESS': "CancelInProgress",
        },
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'export_tags': (bool,),  # noqa: E501
            'file_name': (str,),  # noqa: E501
            'item': (MoMoRef,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'service_name': (str,),  # noqa: E501
            'service_version': (str,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'status_message': (str,),  # noqa: E501
            'export': (BulkExportRelationship,),  # noqa: E501
            'parent_item': (BulkExportedItemRelationship,),  # noqa: E501
            'related_items': ([BulkExportedItemRelationship], none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'export_tags': 'ExportTags',  # noqa: E501
        'file_name': 'FileName',  # noqa: E501
        'item': 'Item',  # noqa: E501
        'name': 'Name',  # noqa: E501
        'service_name': 'ServiceName',  # noqa: E501
        'service_version': 'ServiceVersion',  # noqa: E501
        'status': 'Status',  # noqa: E501
        'status_message': 'StatusMessage',  # noqa: E501
        'export': 'Export',  # noqa: E501
        'parent_item': 'ParentItem',  # noqa: E501
        'related_items': 'RelatedItems',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """BulkExportedItemAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "bulk.ExportedItem", must be one of ["bulk.ExportedItem", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "bulk.ExportedItem", must be one of ["bulk.ExportedItem", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            export_tags (bool): Specifies whether tags must be exported for item MO.. [optional] if omitted the server will use the default value of False  # noqa: E501
            file_name (str): Name of the file corresponding to item MO.. [optional]  # noqa: E501
            item (MoMoRef): [optional]  # noqa: E501
            name (str): MO item identity (the moref corresponding to item) expressed as a string.. [optional]  # noqa: E501
            service_name (str): Name of the service that owns the item MO.. [optional]  # noqa: E501
            service_version (str): Version of the service that owns the item MO.. [optional]  # noqa: E501
            status (str): Status of the item's export operation. * `` - The operation has not started. * `ValidationInProgress` - The validation operation is in progress. * `Valid` - The content to be imported is valid. * `InValid` - The content to be imported is not valid and the status message will have the reason. * `InProgress` - The operation is in progress. * `Success` - The operation has succeeded. * `Failed` - The operation has failed. * `RollBackInitiated` - The rollback has been inititiated for import failure. * `RollBackFailed` - The rollback has failed for import failure. * `RollbackCompleted` - The rollback has completed for import failure. * `RollbackAborted` - The rollback has been aborted for import failure. * `OperationTimedOut` - The operation has timed out. * `OperationCancelled` - The operation has been cancelled. * `CancelInProgress` - The operation is being cancelled.. [optional] if omitted the server will use the default value of ""  # noqa: E501
            status_message (str): Progress or error message for the MO's export operation.. [optional]  # noqa: E501
            export (BulkExportRelationship): [optional]  # noqa: E501
            parent_item (BulkExportedItemRelationship): [optional]  # noqa: E501
            related_items ([BulkExportedItemRelationship], none_type): An array of relationships to bulkExportedItem resources.. [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "bulk.ExportedItem")
        object_type = kwargs.get('object_type', "bulk.ExportedItem")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
