"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-4663
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.asset_api_key_credential import AssetApiKeyCredential
    from intersight.model.asset_client_certificate_credential import AssetClientCertificateCredential
    from intersight.model.asset_no_authentication_credential import AssetNoAuthenticationCredential
    from intersight.model.asset_oauth_bearer_token_credential import AssetOauthBearerTokenCredential
    from intersight.model.asset_oauth_client_id_secret_credential import AssetOauthClientIdSecretCredential
    from intersight.model.asset_private_key_credential import AssetPrivateKeyCredential
    from intersight.model.asset_username_password_credential import AssetUsernamePasswordCredential
    from intersight.model.mo_base_complex_type import MoBaseComplexType
    globals()['AssetApiKeyCredential'] = AssetApiKeyCredential
    globals()['AssetClientCertificateCredential'] = AssetClientCertificateCredential
    globals()['AssetNoAuthenticationCredential'] = AssetNoAuthenticationCredential
    globals()['AssetOauthBearerTokenCredential'] = AssetOauthBearerTokenCredential
    globals()['AssetOauthClientIdSecretCredential'] = AssetOauthClientIdSecretCredential
    globals()['AssetPrivateKeyCredential'] = AssetPrivateKeyCredential
    globals()['AssetUsernamePasswordCredential'] = AssetUsernamePasswordCredential
    globals()['MoBaseComplexType'] = MoBaseComplexType


class AssetCredential(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'ACCESS.ADDRESSTYPE': "access.AddressType",
            'ADAPTER.ADAPTERCONFIG': "adapter.AdapterConfig",
            'ADAPTER.DCEINTERFACESETTINGS': "adapter.DceInterfaceSettings",
            'ADAPTER.ETHSETTINGS': "adapter.EthSettings",
            'ADAPTER.FCSETTINGS': "adapter.FcSettings",
            'ADAPTER.PORTCHANNELSETTINGS': "adapter.PortChannelSettings",
            'APPLIANCE.APISTATUS': "appliance.ApiStatus",
            'APPLIANCE.CERTRENEWALPHASE': "appliance.CertRenewalPhase",
            'APPLIANCE.KEYVALUEPAIR': "appliance.KeyValuePair",
            'APPLIANCE.STATUSCHECK': "appliance.StatusCheck",
            'ASSET.ADDRESSINFORMATION': "asset.AddressInformation",
            'ASSET.APIKEYCREDENTIAL': "asset.ApiKeyCredential",
            'ASSET.CLIENTCERTIFICATECREDENTIAL': "asset.ClientCertificateCredential",
            'ASSET.CLOUDCONNECTION': "asset.CloudConnection",
            'ASSET.CONNECTIONCONTROLMESSAGE': "asset.ConnectionControlMessage",
            'ASSET.CONTRACTINFORMATION': "asset.ContractInformation",
            'ASSET.CUSTOMERINFORMATION': "asset.CustomerInformation",
            'ASSET.DEPLOYMENTDEVICEINFORMATION': "asset.DeploymentDeviceInformation",
            'ASSET.DEVICEINFORMATION': "asset.DeviceInformation",
            'ASSET.DEVICESTATISTICS': "asset.DeviceStatistics",
            'ASSET.DEVICETRANSACTION': "asset.DeviceTransaction",
            'ASSET.GLOBALULTIMATE': "asset.GlobalUltimate",
            'ASSET.HTTPCONNECTION': "asset.HttpConnection",
            'ASSET.INTERSIGHTDEVICECONNECTORCONNECTION': "asset.IntersightDeviceConnectorConnection",
            'ASSET.METERINGTYPE': "asset.MeteringType",
            'ASSET.NOAUTHENTICATIONCREDENTIAL': "asset.NoAuthenticationCredential",
            'ASSET.OAUTHBEARERTOKENCREDENTIAL': "asset.OauthBearerTokenCredential",
            'ASSET.OAUTHCLIENTIDSECRETCREDENTIAL': "asset.OauthClientIdSecretCredential",
            'ASSET.ORCHESTRATIONHITACHIVIRTUALSTORAGEPLATFORMOPTIONS': "asset.OrchestrationHitachiVirtualStoragePlatformOptions",
            'ASSET.ORCHESTRATIONSERVICE': "asset.OrchestrationService",
            'ASSET.PARENTCONNECTIONSIGNATURE': "asset.ParentConnectionSignature",
            'ASSET.PRIVATEKEYCREDENTIAL': "asset.PrivateKeyCredential",
            'ASSET.PRODUCTINFORMATION': "asset.ProductInformation",
            'ASSET.SSHCONNECTION': "asset.SshConnection",
            'ASSET.SUDIINFO': "asset.SudiInfo",
            'ASSET.TARGETKEY': "asset.TargetKey",
            'ASSET.TARGETSIGNATURE': "asset.TargetSignature",
            'ASSET.TARGETSTATUSDETAILS': "asset.TargetStatusDetails",
            'ASSET.TERRAFORMINTEGRATIONSERVICE': "asset.TerraformIntegrationService",
            'ASSET.TERRAFORMINTEGRATIONTERRAFORMAGENTOPTIONS': "asset.TerraformIntegrationTerraformAgentOptions",
            'ASSET.TERRAFORMINTEGRATIONTERRAFORMCLOUDOPTIONS': "asset.TerraformIntegrationTerraformCloudOptions",
            'ASSET.USERNAMEPASSWORDCREDENTIAL': "asset.UsernamePasswordCredential",
            'ASSET.VIRTUALIZATIONAMAZONWEBSERVICEOPTIONS': "asset.VirtualizationAmazonWebServiceOptions",
            'ASSET.VIRTUALIZATIONSERVICE': "asset.VirtualizationService",
            'ASSET.VMHOST': "asset.VmHost",
            'ASSET.WORKLOADOPTIMIZERAMAZONWEBSERVICESBILLINGOPTIONS': "asset.WorkloadOptimizerAmazonWebServicesBillingOptions",
            'ASSET.WORKLOADOPTIMIZERHYPERVOPTIONS': "asset.WorkloadOptimizerHypervOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZUREAPPLICATIONINSIGHTSOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureApplicationInsightsOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZUREENTERPRISEAGREEMENTOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureEnterpriseAgreementOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZURESERVICEPRINCIPALOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureServicePrincipalOptions",
            'ASSET.WORKLOADOPTIMIZEROPENSTACKOPTIONS': "asset.WorkloadOptimizerOpenStackOptions",
            'ASSET.WORKLOADOPTIMIZERREDHATOPENSTACKOPTIONS': "asset.WorkloadOptimizerRedHatOpenStackOptions",
            'ASSET.WORKLOADOPTIMIZERSERVICE': "asset.WorkloadOptimizerService",
            'ASSET.WORKLOADOPTIMIZERVMWAREVCENTEROPTIONS': "asset.WorkloadOptimizerVmwareVcenterOptions",
            'BOOT.BOOTLOADER': "boot.Bootloader",
            'BOOT.ISCSI': "boot.Iscsi",
            'BOOT.LOCALCDD': "boot.LocalCdd",
            'BOOT.LOCALDISK': "boot.LocalDisk",
            'BOOT.NVME': "boot.Nvme",
            'BOOT.PCHSTORAGE': "boot.PchStorage",
            'BOOT.PXE': "boot.Pxe",
            'BOOT.SAN': "boot.San",
            'BOOT.SDCARD': "boot.SdCard",
            'BOOT.UEFISHELL': "boot.UefiShell",
            'BOOT.USB': "boot.Usb",
            'BOOT.VIRTUALMEDIA': "boot.VirtualMedia",
            'BULK.HTTPHEADER': "bulk.HttpHeader",
            'BULK.RESTRESULT': "bulk.RestResult",
            'BULK.RESTSUBREQUEST': "bulk.RestSubRequest",
            'CAPABILITY.PORTRANGE': "capability.PortRange",
            'CAPABILITY.SWITCHNETWORKLIMITS': "capability.SwitchNetworkLimits",
            'CAPABILITY.SWITCHSTORAGELIMITS': "capability.SwitchStorageLimits",
            'CAPABILITY.SWITCHSYSTEMLIMITS': "capability.SwitchSystemLimits",
            'CAPABILITY.SWITCHINGMODECAPABILITY': "capability.SwitchingModeCapability",
            'CERTIFICATEMANAGEMENT.IMC': "certificatemanagement.Imc",
            'CLOUD.AVAILABILITYZONE': "cloud.AvailabilityZone",
            'CLOUD.BILLINGUNIT': "cloud.BillingUnit",
            'CLOUD.CLOUDREGION': "cloud.CloudRegion",
            'CLOUD.CLOUDTAG': "cloud.CloudTag",
            'CLOUD.CUSTOMATTRIBUTES': "cloud.CustomAttributes",
            'CLOUD.IMAGEREFERENCE': "cloud.ImageReference",
            'CLOUD.INSTANCETYPE': "cloud.InstanceType",
            'CLOUD.NETWORKACCESSCONFIG': "cloud.NetworkAccessConfig",
            'CLOUD.NETWORKADDRESS': "cloud.NetworkAddress",
            'CLOUD.NETWORKINSTANCEATTACHMENT': "cloud.NetworkInstanceAttachment",
            'CLOUD.NETWORKINTERFACEATTACHMENT': "cloud.NetworkInterfaceAttachment",
            'CLOUD.SECURITYGROUPRULE': "cloud.SecurityGroupRule",
            'CLOUD.TFCWORKSPACEVARIABLES': "cloud.TfcWorkspaceVariables",
            'CLOUD.VOLUMEATTACHMENT': "cloud.VolumeAttachment",
            'CLOUD.VOLUMEINSTANCEATTACHMENT': "cloud.VolumeInstanceAttachment",
            'CLOUD.VOLUMEIOPSINFO': "cloud.VolumeIopsInfo",
            'CLOUD.VOLUMETYPE': "cloud.VolumeType",
            'CMRF.CMRF': "cmrf.CmRf",
            'COMM.IPV4ADDRESSBLOCK': "comm.IpV4AddressBlock",
            'COMM.IPV4INTERFACE': "comm.IpV4Interface",
            'COMM.IPV6INTERFACE': "comm.IpV6Interface",
            'COMPUTE.ALARMSUMMARY': "compute.AlarmSummary",
            'COMPUTE.IPADDRESS': "compute.IpAddress",
            'COMPUTE.PERSISTENTMEMORYMODULE': "compute.PersistentMemoryModule",
            'COMPUTE.PERSISTENTMEMORYOPERATION': "compute.PersistentMemoryOperation",
            'COMPUTE.SERVERCONFIG': "compute.ServerConfig",
            'COMPUTE.STORAGECONTROLLEROPERATION': "compute.StorageControllerOperation",
            'COMPUTE.STORAGEPHYSICALDRIVE': "compute.StoragePhysicalDrive",
            'COMPUTE.STORAGEPHYSICALDRIVEOPERATION': "compute.StoragePhysicalDriveOperation",
            'COMPUTE.STORAGEVIRTUALDRIVE': "compute.StorageVirtualDrive",
            'COMPUTE.STORAGEVIRTUALDRIVEOPERATION': "compute.StorageVirtualDriveOperation",
            'COND.ALARMSUMMARY': "cond.AlarmSummary",
            'CONNECTOR.CLOSESTREAMMESSAGE': "connector.CloseStreamMessage",
            'CONNECTOR.COMMANDCONTROLMESSAGE': "connector.CommandControlMessage",
            'CONNECTOR.COMMANDTERMINALSTREAM': "connector.CommandTerminalStream",
            'CONNECTOR.EXPECTPROMPT': "connector.ExpectPrompt",
            'CONNECTOR.FETCHSTREAMMESSAGE': "connector.FetchStreamMessage",
            'CONNECTOR.FILECHECKSUM': "connector.FileChecksum",
            'CONNECTOR.FILEMESSAGE': "connector.FileMessage",
            'CONNECTOR.HTTPREQUEST': "connector.HttpRequest",
            'CONNECTOR.SSHCONFIG': "connector.SshConfig",
            'CONNECTOR.SSHMESSAGE': "connector.SshMessage",
            'CONNECTOR.STARTSTREAM': "connector.StartStream",
            'CONNECTOR.STARTSTREAMFROMDEVICE': "connector.StartStreamFromDevice",
            'CONNECTOR.STREAMACKNOWLEDGE': "connector.StreamAcknowledge",
            'CONNECTOR.STREAMINPUT': "connector.StreamInput",
            'CONNECTOR.STREAMKEEPALIVE': "connector.StreamKeepalive",
            'CONNECTOR.TARGETCHANGEMESSAGE': "connector.TargetChangeMessage",
            'CONNECTOR.URL': "connector.Url",
            'CONNECTOR.XMLAPIMESSAGE': "connector.XmlApiMessage",
            'CONNECTORPACK.CONNECTORPACKUPDATE': "connectorpack.ConnectorPackUpdate",
            'CONTENT.COMPLEXTYPE': "content.ComplexType",
            'CONTENT.PARAMETER': "content.Parameter",
            'CONTENT.TEXTPARAMETER': "content.TextParameter",
            'CRD.CUSTOMRESOURCECONFIGPROPERTY': "crd.CustomResourceConfigProperty",
            'EQUIPMENT.IOCARDIDENTITY': "equipment.IoCardIdentity",
            'FABRIC.LLDPSETTINGS': "fabric.LldpSettings",
            'FABRIC.MACAGINGSETTINGS': "fabric.MacAgingSettings",
            'FABRIC.PORTIDENTIFIER': "fabric.PortIdentifier",
            'FABRIC.QOSCLASS': "fabric.QosClass",
            'FABRIC.UDLDGLOBALSETTINGS': "fabric.UdldGlobalSettings",
            'FABRIC.UDLDSETTINGS': "fabric.UdldSettings",
            'FABRIC.VLANSETTINGS': "fabric.VlanSettings",
            'FCPOOL.BLOCK': "fcpool.Block",
            'FEEDBACK.FEEDBACKDATA': "feedback.FeedbackData",
            'FIRMWARE.CHASSISUPGRADEIMPACT': "firmware.ChassisUpgradeImpact",
            'FIRMWARE.CIFSSERVER': "firmware.CifsServer",
            'FIRMWARE.COMPONENTIMPACT': "firmware.ComponentImpact",
            'FIRMWARE.COMPONENTMETA': "firmware.ComponentMeta",
            'FIRMWARE.DIRECTDOWNLOAD': "firmware.DirectDownload",
            'FIRMWARE.FABRICUPGRADEIMPACT': "firmware.FabricUpgradeImpact",
            'FIRMWARE.FIRMWAREINVENTORY': "firmware.FirmwareInventory",
            'FIRMWARE.HTTPSERVER': "firmware.HttpServer",
            'FIRMWARE.NETWORKSHARE': "firmware.NetworkShare",
            'FIRMWARE.NFSSERVER': "firmware.NfsServer",
            'FIRMWARE.SERVERUPGRADEIMPACT': "firmware.ServerUpgradeImpact",
            'FORECAST.MODEL': "forecast.Model",
            'HCL.CONSTRAINT': "hcl.Constraint",
            'HCL.FIRMWARE': "hcl.Firmware",
            'HCL.HARDWARECOMPATIBILITYPROFILE': "hcl.HardwareCompatibilityProfile",
            'HCL.PRODUCT': "hcl.Product",
            'HYPERFLEX.ALARMSUMMARY': "hyperflex.AlarmSummary",
            'HYPERFLEX.APPSETTINGCONSTRAINT': "hyperflex.AppSettingConstraint",
            'HYPERFLEX.BONDSTATE': "hyperflex.BondState",
            'HYPERFLEX.DATASTOREINFO': "hyperflex.DatastoreInfo",
            'HYPERFLEX.DISKSTATUS': "hyperflex.DiskStatus",
            'HYPERFLEX.ENTITYREFERENCE': "hyperflex.EntityReference",
            'HYPERFLEX.ERRORSTACK': "hyperflex.ErrorStack",
            'HYPERFLEX.FEATURELIMITENTRY': "hyperflex.FeatureLimitEntry",
            'HYPERFLEX.FILEPATH': "hyperflex.FilePath",
            'HYPERFLEX.HEALTHCHECKSCRIPTINFO': "hyperflex.HealthCheckScriptInfo",
            'HYPERFLEX.HXHOSTMOUNTSTATUSDT': "hyperflex.HxHostMountStatusDt",
            'HYPERFLEX.HXLICENSEAUTHORIZATIONDETAILSDT': "hyperflex.HxLicenseAuthorizationDetailsDt",
            'HYPERFLEX.HXLINKDT': "hyperflex.HxLinkDt",
            'HYPERFLEX.HXNETWORKADDRESSDT': "hyperflex.HxNetworkAddressDt",
            'HYPERFLEX.HXPLATFORMDATASTORECONFIGDT': "hyperflex.HxPlatformDatastoreConfigDt",
            'HYPERFLEX.HXREGISTRATIONDETAILSDT': "hyperflex.HxRegistrationDetailsDt",
            'HYPERFLEX.HXRESILIENCYINFODT': "hyperflex.HxResiliencyInfoDt",
            'HYPERFLEX.HXSITEDT': "hyperflex.HxSiteDt",
            'HYPERFLEX.HXUUIDDT': "hyperflex.HxUuIdDt",
            'HYPERFLEX.HXZONEINFODT': "hyperflex.HxZoneInfoDt",
            'HYPERFLEX.HXZONERESILIENCYINFODT': "hyperflex.HxZoneResiliencyInfoDt",
            'HYPERFLEX.IPADDRRANGE': "hyperflex.IpAddrRange",
            'HYPERFLEX.LOGICALAVAILABILITYZONE': "hyperflex.LogicalAvailabilityZone",
            'HYPERFLEX.MACADDRPREFIXRANGE': "hyperflex.MacAddrPrefixRange",
            'HYPERFLEX.MAPCLUSTERIDTOPROTECTIONINFO': "hyperflex.MapClusterIdToProtectionInfo",
            'HYPERFLEX.MAPCLUSTERIDTOSTSNAPSHOTPOINT': "hyperflex.MapClusterIdToStSnapshotPoint",
            'HYPERFLEX.MAPUUIDTOTRACKEDDISK': "hyperflex.MapUuidToTrackedDisk",
            'HYPERFLEX.NAMEDVLAN': "hyperflex.NamedVlan",
            'HYPERFLEX.NAMEDVSAN': "hyperflex.NamedVsan",
            'HYPERFLEX.NETWORKPORT': "hyperflex.NetworkPort",
            'HYPERFLEX.PORTTYPETOPORTNUMBERMAP': "hyperflex.PortTypeToPortNumberMap",
            'HYPERFLEX.PROTECTIONINFO': "hyperflex.ProtectionInfo",
            'HYPERFLEX.REPLICATIONCLUSTERREFERENCETOSCHEDULE': "hyperflex.ReplicationClusterReferenceToSchedule",
            'HYPERFLEX.REPLICATIONPEERINFO': "hyperflex.ReplicationPeerInfo",
            'HYPERFLEX.REPLICATIONPLATDATASTORE': "hyperflex.ReplicationPlatDatastore",
            'HYPERFLEX.REPLICATIONPLATDATASTOREPAIR': "hyperflex.ReplicationPlatDatastorePair",
            'HYPERFLEX.REPLICATIONSCHEDULE': "hyperflex.ReplicationSchedule",
            'HYPERFLEX.REPLICATIONSTATUS': "hyperflex.ReplicationStatus",
            'HYPERFLEX.RPOSTATUS': "hyperflex.RpoStatus",
            'HYPERFLEX.SERVERFIRMWAREVERSIONINFO': "hyperflex.ServerFirmwareVersionInfo",
            'HYPERFLEX.SERVERMODELENTRY': "hyperflex.ServerModelEntry",
            'HYPERFLEX.SNAPSHOTFILES': "hyperflex.SnapshotFiles",
            'HYPERFLEX.SNAPSHOTINFOBRIEF': "hyperflex.SnapshotInfoBrief",
            'HYPERFLEX.SNAPSHOTPOINT': "hyperflex.SnapshotPoint",
            'HYPERFLEX.SNAPSHOTSTATUS': "hyperflex.SnapshotStatus",
            'HYPERFLEX.STPLATFORMCLUSTERHEALINGINFO': "hyperflex.StPlatformClusterHealingInfo",
            'HYPERFLEX.STPLATFORMCLUSTERRESILIENCYINFO': "hyperflex.StPlatformClusterResiliencyInfo",
            'HYPERFLEX.SUMMARY': "hyperflex.Summary",
            'HYPERFLEX.TRACKEDDISK': "hyperflex.TrackedDisk",
            'HYPERFLEX.TRACKEDFILE': "hyperflex.TrackedFile",
            'HYPERFLEX.VDISKCONFIG': "hyperflex.VdiskConfig",
            'HYPERFLEX.VIRTUALMACHINE': "hyperflex.VirtualMachine",
            'HYPERFLEX.VIRTUALMACHINERUNTIMEINFO': "hyperflex.VirtualMachineRuntimeInfo",
            'HYPERFLEX.VMDISK': "hyperflex.VmDisk",
            'HYPERFLEX.VMINTERFACE': "hyperflex.VmInterface",
            'HYPERFLEX.VMPROTECTIONSPACEUSAGE': "hyperflex.VmProtectionSpaceUsage",
            'HYPERFLEX.WWXNPREFIXRANGE': "hyperflex.WwxnPrefixRange",
            'I18N.MESSAGE': "i18n.Message",
            'I18N.MESSAGEPARAM': "i18n.MessageParam",
            'IAAS.LICENSEKEYSINFO': "iaas.LicenseKeysInfo",
            'IAAS.LICENSEUTILIZATIONINFO': "iaas.LicenseUtilizationInfo",
            'IAAS.WORKFLOWSTEPS': "iaas.WorkflowSteps",
            'IAM.ACCOUNTPERMISSIONS': "iam.AccountPermissions",
            'IAM.CLIENTMETA': "iam.ClientMeta",
            'IAM.ENDPOINTPASSWORDPROPERTIES': "iam.EndPointPasswordProperties",
            'IAM.FEATUREDEFINITION': "iam.FeatureDefinition",
            'IAM.GROUPPERMISSIONTOROLES': "iam.GroupPermissionToRoles",
            'IAM.LDAPBASEPROPERTIES': "iam.LdapBaseProperties",
            'IAM.LDAPDNSPARAMETERS': "iam.LdapDnsParameters",
            'IAM.PERMISSIONREFERENCE': "iam.PermissionReference",
            'IAM.PERMISSIONTOROLES': "iam.PermissionToRoles",
            'IAM.RULE': "iam.Rule",
            'IAM.SAMLSPCONNECTION': "iam.SamlSpConnection",
            'IAM.SSOSESSIONATTRIBUTES': "iam.SsoSessionAttributes",
            'IMCCONNECTOR.WEBUIMESSAGE': "imcconnector.WebUiMessage",
            'INFRA.HARDWAREINFO': "infra.HardwareInfo",
            'INFRA.METADATA': "infra.MetaData",
            'INVENTORY.INVENTORYMO': "inventory.InventoryMo",
            'INVENTORY.UEMINFO': "inventory.UemInfo",
            'IPPOOL.IPV4BLOCK': "ippool.IpV4Block",
            'IPPOOL.IPV4CONFIG': "ippool.IpV4Config",
            'IPPOOL.IPV6BLOCK': "ippool.IpV6Block",
            'IPPOOL.IPV6CONFIG': "ippool.IpV6Config",
            'IQNPOOL.IQNSUFFIXBLOCK': "iqnpool.IqnSuffixBlock",
            'KUBERNETES.ACTIONINFO': "kubernetes.ActionInfo",
            'KUBERNETES.ADDON': "kubernetes.Addon",
            'KUBERNETES.ADDONCONFIGURATION': "kubernetes.AddonConfiguration",
            'KUBERNETES.BAREMETALNETWORKINFO': "kubernetes.BaremetalNetworkInfo",
            'KUBERNETES.CALICOCONFIG': "kubernetes.CalicoConfig",
            'KUBERNETES.CLUSTERCERTIFICATECONFIGURATION': "kubernetes.ClusterCertificateConfiguration",
            'KUBERNETES.CLUSTERMANAGEMENTCONFIG': "kubernetes.ClusterManagementConfig",
            'KUBERNETES.CONFIGURATION': "kubernetes.Configuration",
            'KUBERNETES.DAEMONSETSTATUS': "kubernetes.DaemonSetStatus",
            'KUBERNETES.DEPLOYMENTSTATUS': "kubernetes.DeploymentStatus",
            'KUBERNETES.ESSENTIALADDON': "kubernetes.EssentialAddon",
            'KUBERNETES.ESXIVIRTUALMACHINEINFRACONFIG': "kubernetes.EsxiVirtualMachineInfraConfig",
            'KUBERNETES.ETHERNET': "kubernetes.Ethernet",
            'KUBERNETES.ETHERNETMATCHER': "kubernetes.EthernetMatcher",
            'KUBERNETES.HYPERFLEXAPVIRTUALMACHINEINFRACONFIG': "kubernetes.HyperFlexApVirtualMachineInfraConfig",
            'KUBERNETES.INGRESSSTATUS': "kubernetes.IngressStatus",
            'KUBERNETES.KEYVALUE': "kubernetes.KeyValue",
            'KUBERNETES.LOADBALANCER': "kubernetes.LoadBalancer",
            'KUBERNETES.NODEADDRESS': "kubernetes.NodeAddress",
            'KUBERNETES.NODEGROUPLABEL': "kubernetes.NodeGroupLabel",
            'KUBERNETES.NODEGROUPTAINT': "kubernetes.NodeGroupTaint",
            'KUBERNETES.NODEINFO': "kubernetes.NodeInfo",
            'KUBERNETES.NODESPEC': "kubernetes.NodeSpec",
            'KUBERNETES.NODESTATUS': "kubernetes.NodeStatus",
            'KUBERNETES.OBJECTMETA': "kubernetes.ObjectMeta",
            'KUBERNETES.OVSBOND': "kubernetes.OvsBond",
            'KUBERNETES.PODSTATUS': "kubernetes.PodStatus",
            'KUBERNETES.PROXYCONFIG': "kubernetes.ProxyConfig",
            'KUBERNETES.SERVICESTATUS': "kubernetes.ServiceStatus",
            'KUBERNETES.STATEFULSETSTATUS': "kubernetes.StatefulSetStatus",
            'KUBERNETES.TAINT': "kubernetes.Taint",
            'MACPOOL.BLOCK': "macpool.Block",
            'MEMORY.PERSISTENTMEMORYGOAL': "memory.PersistentMemoryGoal",
            'MEMORY.PERSISTENTMEMORYLOCALSECURITY': "memory.PersistentMemoryLocalSecurity",
            'MEMORY.PERSISTENTMEMORYLOGICALNAMESPACE': "memory.PersistentMemoryLogicalNamespace",
            'META.ACCESSPRIVILEGE': "meta.AccessPrivilege",
            'META.DISPLAYNAMEDEFINITION': "meta.DisplayNameDefinition",
            'META.IDENTITYDEFINITION': "meta.IdentityDefinition",
            'META.PROPDEFINITION': "meta.PropDefinition",
            'META.RELATIONSHIPDEFINITION': "meta.RelationshipDefinition",
            'MO.MOREF': "mo.MoRef",
            'MO.TAG': "mo.Tag",
            'MO.VERSIONCONTEXT': "mo.VersionContext",
            'NIAAPI.DETAIL': "niaapi.Detail",
            'NIAAPI.NEWRELEASEDETAIL': "niaapi.NewReleaseDetail",
            'NIAAPI.REVISIONINFO': "niaapi.RevisionInfo",
            'NIAAPI.SOFTWAREREGEX': "niaapi.SoftwareRegex",
            'NIAAPI.VERSIONREGEXPLATFORM': "niaapi.VersionRegexPlatform",
            'NIATELEMETRY.BOOTFLASHDETAILS': "niatelemetry.BootflashDetails",
            'NIATELEMETRY.DISKINFO': "niatelemetry.Diskinfo",
            'NIATELEMETRY.INTERFACE': "niatelemetry.Interface",
            'NIATELEMETRY.INTERFACEELEMENT': "niatelemetry.InterfaceElement",
            'NIATELEMETRY.LOGICALLINK': "niatelemetry.LogicalLink",
            'NIATELEMETRY.NVEPACKETCOUNTERS': "niatelemetry.NvePacketCounters",
            'NIATELEMETRY.NVEVNI': "niatelemetry.NveVni",
            'NIATELEMETRY.NXOSBGPMVPN': "niatelemetry.NxosBgpMvpn",
            'NIATELEMETRY.NXOSVTP': "niatelemetry.NxosVtp",
            'NIATELEMETRY.SMARTLICENSE': "niatelemetry.SmartLicense",
            'NOTIFICATION.ALARMMOCONDITION': "notification.AlarmMoCondition",
            'NOTIFICATION.SENDEMAIL': "notification.SendEmail",
            'NTP.AUTHNTPSERVER': "ntp.AuthNtpServer",
            'ONPREM.IMAGEPACKAGE': "onprem.ImagePackage",
            'ONPREM.SCHEDULE': "onprem.Schedule",
            'ONPREM.UPGRADENOTE': "onprem.UpgradeNote",
            'ONPREM.UPGRADEPHASE': "onprem.UpgradePhase",
            'OPRS.KVPAIR': "oprs.Kvpair",
            'OS.ANSWERS': "os.Answers",
            'OS.GLOBALCONFIG': "os.GlobalConfig",
            'OS.IPV4CONFIGURATION': "os.Ipv4Configuration",
            'OS.IPV6CONFIGURATION': "os.Ipv6Configuration",
            'OS.PHYSICALDISK': "os.PhysicalDisk",
            'OS.PHYSICALDISKRESPONSE': "os.PhysicalDiskResponse",
            'OS.PLACEHOLDER': "os.PlaceHolder",
            'OS.SERVERCONFIG': "os.ServerConfig",
            'OS.VALIDATIONINFORMATION': "os.ValidationInformation",
            'OS.VIRTUALDRIVE': "os.VirtualDrive",
            'OS.VIRTUALDRIVERESPONSE': "os.VirtualDriveResponse",
            'OS.WINDOWSPARAMETERS': "os.WindowsParameters",
            'PKIX.DISTINGUISHEDNAME': "pkix.DistinguishedName",
            'PKIX.ECDSAKEYSPEC': "pkix.EcdsaKeySpec",
            'PKIX.EDDSAKEYSPEC': "pkix.EddsaKeySpec",
            'PKIX.RSAALGORITHM': "pkix.RsaAlgorithm",
            'PKIX.SUBJECTALTERNATENAME': "pkix.SubjectAlternateName",
            'POLICY.ACTIONQUALIFIER': "policy.ActionQualifier",
            'POLICY.CONFIGCHANGE': "policy.ConfigChange",
            'POLICY.CONFIGCHANGECONTEXT': "policy.ConfigChangeContext",
            'POLICY.CONFIGCONTEXT': "policy.ConfigContext",
            'POLICY.CONFIGRESULTCONTEXT': "policy.ConfigResultContext",
            'POLICY.QUALIFIER': "policy.Qualifier",
            'POLICYINVENTORY.JOBINFO': "policyinventory.JobInfo",
            'RECOVERY.BACKUPSCHEDULE': "recovery.BackupSchedule",
            'RESOURCE.PERTYPECOMBINEDSELECTOR': "resource.PerTypeCombinedSelector",
            'RESOURCE.SELECTOR': "resource.Selector",
            'RESOURCE.SOURCETOPERMISSIONRESOURCES': "resource.SourceToPermissionResources",
            'RESOURCE.SOURCETOPERMISSIONRESOURCESHOLDER': "resource.SourceToPermissionResourcesHolder",
            'RESOURCEPOOL.SERVERLEASEPARAMETERS': "resourcepool.ServerLeaseParameters",
            'RESOURCEPOOL.SERVERPOOLPARAMETERS': "resourcepool.ServerPoolParameters",
            'SDCARD.DIAGNOSTICS': "sdcard.Diagnostics",
            'SDCARD.DRIVERS': "sdcard.Drivers",
            'SDCARD.HOSTUPGRADEUTILITY': "sdcard.HostUpgradeUtility",
            'SDCARD.OPERATINGSYSTEM': "sdcard.OperatingSystem",
            'SDCARD.PARTITION': "sdcard.Partition",
            'SDCARD.SERVERCONFIGURATIONUTILITY': "sdcard.ServerConfigurationUtility",
            'SDCARD.USERPARTITION': "sdcard.UserPartition",
            'SDWAN.NETWORKCONFIGURATIONTYPE': "sdwan.NetworkConfigurationType",
            'SDWAN.TEMPLATEINPUTSTYPE': "sdwan.TemplateInputsType",
            'SERVER.PENDINGWORKFLOWTRIGGER': "server.PendingWorkflowTrigger",
            'SNMP.TRAP': "snmp.Trap",
            'SNMP.USER': "snmp.User",
            'SOFTWAREREPOSITORY.APPLIANCEUPLOAD': "softwarerepository.ApplianceUpload",
            'SOFTWAREREPOSITORY.CIFSSERVER': "softwarerepository.CifsServer",
            'SOFTWAREREPOSITORY.CONSTRAINTMODELS': "softwarerepository.ConstraintModels",
            'SOFTWAREREPOSITORY.HTTPSERVER': "softwarerepository.HttpServer",
            'SOFTWAREREPOSITORY.IMPORTRESULT': "softwarerepository.ImportResult",
            'SOFTWAREREPOSITORY.LOCALMACHINE': "softwarerepository.LocalMachine",
            'SOFTWAREREPOSITORY.NFSSERVER': "softwarerepository.NfsServer",
            'STORAGE.AUTOMATICDRIVEGROUP': "storage.AutomaticDriveGroup",
            'STORAGE.HITACHIARRAYUTILIZATION': "storage.HitachiArrayUtilization",
            'STORAGE.HITACHICAPACITY': "storage.HitachiCapacity",
            'STORAGE.HITACHIINITIATOR': "storage.HitachiInitiator",
            'STORAGE.INITIATOR': "storage.Initiator",
            'STORAGE.KEYSETTING': "storage.KeySetting",
            'STORAGE.LOCALKEYSETTING': "storage.LocalKeySetting",
            'STORAGE.M2VIRTUALDRIVECONFIG': "storage.M2VirtualDriveConfig",
            'STORAGE.MANUALDRIVEGROUP': "storage.ManualDriveGroup",
            'STORAGE.NETAPPEXPORTPOLICYRULE': "storage.NetAppExportPolicyRule",
            'STORAGE.NETAPPSTORAGEUTILIZATION': "storage.NetAppStorageUtilization",
            'STORAGE.PUREARRAYUTILIZATION': "storage.PureArrayUtilization",
            'STORAGE.PUREDISKUTILIZATION': "storage.PureDiskUtilization",
            'STORAGE.PUREHOSTUTILIZATION': "storage.PureHostUtilization",
            'STORAGE.PUREREPLICATIONBLACKOUT': "storage.PureReplicationBlackout",
            'STORAGE.PUREVOLUMEUTILIZATION': "storage.PureVolumeUtilization",
            'STORAGE.R0DRIVE': "storage.R0Drive",
            'STORAGE.REMOTEKEYSETTING': "storage.RemoteKeySetting",
            'STORAGE.SPANDRIVES': "storage.SpanDrives",
            'STORAGE.STORAGECONTAINERHOSTMOUNTSTATUS': "storage.StorageContainerHostMountStatus",
            'STORAGE.STORAGECONTAINERUTILIZATION': "storage.StorageContainerUtilization",
            'STORAGE.VIRTUALDRIVECONFIGURATION': "storage.VirtualDriveConfiguration",
            'STORAGE.VIRTUALDRIVEPOLICY': "storage.VirtualDrivePolicy",
            'STORAGE.VOLUMEUTILIZATION': "storage.VolumeUtilization",
            'SYSLOG.LOCALFILELOGGINGCLIENT': "syslog.LocalFileLoggingClient",
            'SYSLOG.REMOTELOGGINGCLIENT': "syslog.RemoteLoggingClient",
            'TAM.ACTION': "tam.Action",
            'TAM.APIDATASOURCE': "tam.ApiDataSource",
            'TAM.IDENTIFIERS': "tam.Identifiers",
            'TAM.PSIRTSEVERITY': "tam.PsirtSeverity",
            'TAM.QUERYENTRY': "tam.QueryEntry",
            'TAM.S3DATASOURCE': "tam.S3DataSource",
            'TAM.SECURITYADVISORYDETAILS': "tam.SecurityAdvisoryDetails",
            'TAM.TEXTFSMTEMPLATEDATASOURCE': "tam.TextFsmTemplateDataSource",
            'TECHSUPPORTMANAGEMENT.APPLIANCEPARAM': "techsupportmanagement.ApplianceParam",
            'TECHSUPPORTMANAGEMENT.NIAPARAM': "techsupportmanagement.NiaParam",
            'TECHSUPPORTMANAGEMENT.PLATFORMPARAM': "techsupportmanagement.PlatformParam",
            'TEMPLATE.TRANSFORMATIONSTAGE': "template.TransformationStage",
            'TERRAFORM.CLOUDRESOURCE': "terraform.CloudResource",
            'TERRAFORM.RUNSTATE': "terraform.Runstate",
            'UCSD.CONNECTORPACK': "ucsd.ConnectorPack",
            'UCSD.UCSDRESTOREPARAMETERS': "ucsd.UcsdRestoreParameters",
            'UCSDCONNECTOR.RESTCLIENTMESSAGE': "ucsdconnector.RestClientMessage",
            'UUIDPOOL.UUIDBLOCK': "uuidpool.UuidBlock",
            'VIRTUALIZATION.ACTIONINFO': "virtualization.ActionInfo",
            'VIRTUALIZATION.CLOUDINITCONFIG': "virtualization.CloudInitConfig",
            'VIRTUALIZATION.COMPUTECAPACITY': "virtualization.ComputeCapacity",
            'VIRTUALIZATION.CPUALLOCATION': "virtualization.CpuAllocation",
            'VIRTUALIZATION.CPUINFO': "virtualization.CpuInfo",
            'VIRTUALIZATION.ESXICLONECUSTOMSPEC': "virtualization.EsxiCloneCustomSpec",
            'VIRTUALIZATION.ESXIOVACUSTOMSPEC': "virtualization.EsxiOvaCustomSpec",
            'VIRTUALIZATION.ESXIVMCOMPUTECONFIGURATION': "virtualization.EsxiVmComputeConfiguration",
            'VIRTUALIZATION.ESXIVMCONFIGURATION': "virtualization.EsxiVmConfiguration",
            'VIRTUALIZATION.ESXIVMNETWORKCONFIGURATION': "virtualization.EsxiVmNetworkConfiguration",
            'VIRTUALIZATION.ESXIVMSTORAGECONFIGURATION': "virtualization.EsxiVmStorageConfiguration",
            'VIRTUALIZATION.GUESTINFO': "virtualization.GuestInfo",
            'VIRTUALIZATION.HXAPVMCONFIGURATION': "virtualization.HxapVmConfiguration",
            'VIRTUALIZATION.MEMORYALLOCATION': "virtualization.MemoryAllocation",
            'VIRTUALIZATION.MEMORYCAPACITY': "virtualization.MemoryCapacity",
            'VIRTUALIZATION.NETWORKINTERFACE': "virtualization.NetworkInterface",
            'VIRTUALIZATION.PRODUCTINFO': "virtualization.ProductInfo",
            'VIRTUALIZATION.STORAGECAPACITY': "virtualization.StorageCapacity",
            'VIRTUALIZATION.VIRTUALDISKCONFIG': "virtualization.VirtualDiskConfig",
            'VIRTUALIZATION.VIRTUALMACHINEDISK': "virtualization.VirtualMachineDisk",
            'VIRTUALIZATION.VMESXIDISK': "virtualization.VmEsxiDisk",
            'VIRTUALIZATION.VMWAREREMOTEDISPLAYINFO': "virtualization.VmwareRemoteDisplayInfo",
            'VIRTUALIZATION.VMWARERESOURCECONSUMPTION': "virtualization.VmwareResourceConsumption",
            'VIRTUALIZATION.VMWARESHARESINFO': "virtualization.VmwareSharesInfo",
            'VIRTUALIZATION.VMWARETEAMINGANDFAILOVER': "virtualization.VmwareTeamingAndFailover",
            'VIRTUALIZATION.VMWAREVLANRANGE': "virtualization.VmwareVlanRange",
            'VIRTUALIZATION.VMWAREVMCPUSHAREINFO': "virtualization.VmwareVmCpuShareInfo",
            'VIRTUALIZATION.VMWAREVMCPUSOCKETINFO': "virtualization.VmwareVmCpuSocketInfo",
            'VIRTUALIZATION.VMWAREVMDISKCOMMITINFO': "virtualization.VmwareVmDiskCommitInfo",
            'VIRTUALIZATION.VMWAREVMMEMORYSHAREINFO': "virtualization.VmwareVmMemoryShareInfo",
            'VMEDIA.MAPPING': "vmedia.Mapping",
            'VNIC.ARFSSETTINGS': "vnic.ArfsSettings",
            'VNIC.CDN': "vnic.Cdn",
            'VNIC.COMPLETIONQUEUESETTINGS': "vnic.CompletionQueueSettings",
            'VNIC.ETHINTERRUPTSETTINGS': "vnic.EthInterruptSettings",
            'VNIC.ETHRXQUEUESETTINGS': "vnic.EthRxQueueSettings",
            'VNIC.ETHTXQUEUESETTINGS': "vnic.EthTxQueueSettings",
            'VNIC.FCERRORRECOVERYSETTINGS': "vnic.FcErrorRecoverySettings",
            'VNIC.FCINTERRUPTSETTINGS': "vnic.FcInterruptSettings",
            'VNIC.FCQUEUESETTINGS': "vnic.FcQueueSettings",
            'VNIC.FLOGISETTINGS': "vnic.FlogiSettings",
            'VNIC.ISCSIAUTHPROFILE': "vnic.IscsiAuthProfile",
            'VNIC.LUN': "vnic.Lun",
            'VNIC.NVGRESETTINGS': "vnic.NvgreSettings",
            'VNIC.PLACEMENTSETTINGS': "vnic.PlacementSettings",
            'VNIC.PLOGISETTINGS': "vnic.PlogiSettings",
            'VNIC.ROCESETTINGS': "vnic.RoceSettings",
            'VNIC.RSSHASHSETTINGS': "vnic.RssHashSettings",
            'VNIC.SCSIQUEUESETTINGS': "vnic.ScsiQueueSettings",
            'VNIC.TCPOFFLOADSETTINGS': "vnic.TcpOffloadSettings",
            'VNIC.USNICSETTINGS': "vnic.UsnicSettings",
            'VNIC.VIFSTATUS': "vnic.VifStatus",
            'VNIC.VLANSETTINGS': "vnic.VlanSettings",
            'VNIC.VMQSETTINGS': "vnic.VmqSettings",
            'VNIC.VSANSETTINGS': "vnic.VsanSettings",
            'VNIC.VXLANSETTINGS': "vnic.VxlanSettings",
            'WORKFLOW.ARRAYDATATYPE': "workflow.ArrayDataType",
            'WORKFLOW.ASSOCIATEDROLES': "workflow.AssociatedRoles",
            'WORKFLOW.CLICOMMAND': "workflow.CliCommand",
            'WORKFLOW.COMMENTS': "workflow.Comments",
            'WORKFLOW.CONSTRAINTS': "workflow.Constraints",
            'WORKFLOW.CUSTOMARRAYITEM': "workflow.CustomArrayItem",
            'WORKFLOW.CUSTOMDATAPROPERTY': "workflow.CustomDataProperty",
            'WORKFLOW.CUSTOMDATATYPE': "workflow.CustomDataType",
            'WORKFLOW.CUSTOMDATATYPEPROPERTIES': "workflow.CustomDataTypeProperties",
            'WORKFLOW.DECISIONCASE': "workflow.DecisionCase",
            'WORKFLOW.DECISIONTASK': "workflow.DecisionTask",
            'WORKFLOW.DEFAULTVALUE': "workflow.DefaultValue",
            'WORKFLOW.DISPLAYMETA': "workflow.DisplayMeta",
            'WORKFLOW.DYNAMICWORKFLOWACTIONTASKLIST': "workflow.DynamicWorkflowActionTaskList",
            'WORKFLOW.ENUMENTRY': "workflow.EnumEntry",
            'WORKFLOW.EXPECTPROMPT': "workflow.ExpectPrompt",
            'WORKFLOW.FAILUREENDTASK': "workflow.FailureEndTask",
            'WORKFLOW.FILEDOWNLOADOP': "workflow.FileDownloadOp",
            'WORKFLOW.FILEOPERATIONS': "workflow.FileOperations",
            'WORKFLOW.FILETEMPLATEOP': "workflow.FileTemplateOp",
            'WORKFLOW.FILETRANSFER': "workflow.FileTransfer",
            'WORKFLOW.FORKTASK': "workflow.ForkTask",
            'WORKFLOW.INITIATORCONTEXT': "workflow.InitiatorContext",
            'WORKFLOW.INTERNALPROPERTIES': "workflow.InternalProperties",
            'WORKFLOW.JOINTASK': "workflow.JoinTask",
            'WORKFLOW.LOOPTASK': "workflow.LoopTask",
            'WORKFLOW.MESSAGE': "workflow.Message",
            'WORKFLOW.MOREFERENCEARRAYITEM': "workflow.MoReferenceArrayItem",
            'WORKFLOW.MOREFERENCEDATATYPE': "workflow.MoReferenceDataType",
            'WORKFLOW.MOREFERENCEPROPERTY': "workflow.MoReferenceProperty",
            'WORKFLOW.PARAMETERSET': "workflow.ParameterSet",
            'WORKFLOW.PRIMITIVEARRAYITEM': "workflow.PrimitiveArrayItem",
            'WORKFLOW.PRIMITIVEDATAPROPERTY': "workflow.PrimitiveDataProperty",
            'WORKFLOW.PRIMITIVEDATATYPE': "workflow.PrimitiveDataType",
            'WORKFLOW.PROPERTIES': "workflow.Properties",
            'WORKFLOW.RESULTHANDLER': "workflow.ResultHandler",
            'WORKFLOW.ROLLBACKTASK': "workflow.RollbackTask",
            'WORKFLOW.ROLLBACKWORKFLOWTASK': "workflow.RollbackWorkflowTask",
            'WORKFLOW.SELECTORPROPERTY': "workflow.SelectorProperty",
            'WORKFLOW.SSHCMD': "workflow.SshCmd",
            'WORKFLOW.SSHCONFIG': "workflow.SshConfig",
            'WORKFLOW.SSHSESSION': "workflow.SshSession",
            'WORKFLOW.STARTTASK': "workflow.StartTask",
            'WORKFLOW.SUBWORKFLOWTASK': "workflow.SubWorkflowTask",
            'WORKFLOW.SUCCESSENDTASK': "workflow.SuccessEndTask",
            'WORKFLOW.TARGETCONTEXT': "workflow.TargetContext",
            'WORKFLOW.TARGETDATATYPE': "workflow.TargetDataType",
            'WORKFLOW.TARGETPROPERTY': "workflow.TargetProperty",
            'WORKFLOW.TASKCONSTRAINTS': "workflow.TaskConstraints",
            'WORKFLOW.TASKRETRYINFO': "workflow.TaskRetryInfo",
            'WORKFLOW.UIINPUTFILTER': "workflow.UiInputFilter",
            'WORKFLOW.VALIDATIONERROR': "workflow.ValidationError",
            'WORKFLOW.VALIDATIONINFORMATION': "workflow.ValidationInformation",
            'WORKFLOW.WAITTASK': "workflow.WaitTask",
            'WORKFLOW.WAITTASKPROMPT': "workflow.WaitTaskPrompt",
            'WORKFLOW.WEBAPI': "workflow.WebApi",
            'WORKFLOW.WORKERTASK': "workflow.WorkerTask",
            'WORKFLOW.WORKFLOWCTX': "workflow.WorkflowCtx",
            'WORKFLOW.WORKFLOWENGINEPROPERTIES': "workflow.WorkflowEngineProperties",
            'WORKFLOW.WORKFLOWINFOPROPERTIES': "workflow.WorkflowInfoProperties",
            'WORKFLOW.WORKFLOWPROPERTIES': "workflow.WorkflowProperties",
            'WORKFLOW.XMLAPI': "workflow.XmlApi",
            'X509.CERTIFICATE': "x509.Certificate",
        },
        ('object_type',): {
            'ACCESS.ADDRESSTYPE': "access.AddressType",
            'ADAPTER.ADAPTERCONFIG': "adapter.AdapterConfig",
            'ADAPTER.DCEINTERFACESETTINGS': "adapter.DceInterfaceSettings",
            'ADAPTER.ETHSETTINGS': "adapter.EthSettings",
            'ADAPTER.FCSETTINGS': "adapter.FcSettings",
            'ADAPTER.PORTCHANNELSETTINGS': "adapter.PortChannelSettings",
            'APPLIANCE.APISTATUS': "appliance.ApiStatus",
            'APPLIANCE.CERTRENEWALPHASE': "appliance.CertRenewalPhase",
            'APPLIANCE.KEYVALUEPAIR': "appliance.KeyValuePair",
            'APPLIANCE.STATUSCHECK': "appliance.StatusCheck",
            'ASSET.ADDRESSINFORMATION': "asset.AddressInformation",
            'ASSET.APIKEYCREDENTIAL': "asset.ApiKeyCredential",
            'ASSET.CLIENTCERTIFICATECREDENTIAL': "asset.ClientCertificateCredential",
            'ASSET.CLOUDCONNECTION': "asset.CloudConnection",
            'ASSET.CONNECTIONCONTROLMESSAGE': "asset.ConnectionControlMessage",
            'ASSET.CONTRACTINFORMATION': "asset.ContractInformation",
            'ASSET.CUSTOMERINFORMATION': "asset.CustomerInformation",
            'ASSET.DEPLOYMENTDEVICEINFORMATION': "asset.DeploymentDeviceInformation",
            'ASSET.DEVICEINFORMATION': "asset.DeviceInformation",
            'ASSET.DEVICESTATISTICS': "asset.DeviceStatistics",
            'ASSET.DEVICETRANSACTION': "asset.DeviceTransaction",
            'ASSET.GLOBALULTIMATE': "asset.GlobalUltimate",
            'ASSET.HTTPCONNECTION': "asset.HttpConnection",
            'ASSET.INTERSIGHTDEVICECONNECTORCONNECTION': "asset.IntersightDeviceConnectorConnection",
            'ASSET.METERINGTYPE': "asset.MeteringType",
            'ASSET.NOAUTHENTICATIONCREDENTIAL': "asset.NoAuthenticationCredential",
            'ASSET.OAUTHBEARERTOKENCREDENTIAL': "asset.OauthBearerTokenCredential",
            'ASSET.OAUTHCLIENTIDSECRETCREDENTIAL': "asset.OauthClientIdSecretCredential",
            'ASSET.ORCHESTRATIONHITACHIVIRTUALSTORAGEPLATFORMOPTIONS': "asset.OrchestrationHitachiVirtualStoragePlatformOptions",
            'ASSET.ORCHESTRATIONSERVICE': "asset.OrchestrationService",
            'ASSET.PARENTCONNECTIONSIGNATURE': "asset.ParentConnectionSignature",
            'ASSET.PRIVATEKEYCREDENTIAL': "asset.PrivateKeyCredential",
            'ASSET.PRODUCTINFORMATION': "asset.ProductInformation",
            'ASSET.SSHCONNECTION': "asset.SshConnection",
            'ASSET.SUDIINFO': "asset.SudiInfo",
            'ASSET.TARGETKEY': "asset.TargetKey",
            'ASSET.TARGETSIGNATURE': "asset.TargetSignature",
            'ASSET.TARGETSTATUSDETAILS': "asset.TargetStatusDetails",
            'ASSET.TERRAFORMINTEGRATIONSERVICE': "asset.TerraformIntegrationService",
            'ASSET.TERRAFORMINTEGRATIONTERRAFORMAGENTOPTIONS': "asset.TerraformIntegrationTerraformAgentOptions",
            'ASSET.TERRAFORMINTEGRATIONTERRAFORMCLOUDOPTIONS': "asset.TerraformIntegrationTerraformCloudOptions",
            'ASSET.USERNAMEPASSWORDCREDENTIAL': "asset.UsernamePasswordCredential",
            'ASSET.VIRTUALIZATIONAMAZONWEBSERVICEOPTIONS': "asset.VirtualizationAmazonWebServiceOptions",
            'ASSET.VIRTUALIZATIONSERVICE': "asset.VirtualizationService",
            'ASSET.VMHOST': "asset.VmHost",
            'ASSET.WORKLOADOPTIMIZERAMAZONWEBSERVICESBILLINGOPTIONS': "asset.WorkloadOptimizerAmazonWebServicesBillingOptions",
            'ASSET.WORKLOADOPTIMIZERHYPERVOPTIONS': "asset.WorkloadOptimizerHypervOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZUREAPPLICATIONINSIGHTSOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureApplicationInsightsOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZUREENTERPRISEAGREEMENTOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureEnterpriseAgreementOptions",
            'ASSET.WORKLOADOPTIMIZERMICROSOFTAZURESERVICEPRINCIPALOPTIONS': "asset.WorkloadOptimizerMicrosoftAzureServicePrincipalOptions",
            'ASSET.WORKLOADOPTIMIZEROPENSTACKOPTIONS': "asset.WorkloadOptimizerOpenStackOptions",
            'ASSET.WORKLOADOPTIMIZERREDHATOPENSTACKOPTIONS': "asset.WorkloadOptimizerRedHatOpenStackOptions",
            'ASSET.WORKLOADOPTIMIZERSERVICE': "asset.WorkloadOptimizerService",
            'ASSET.WORKLOADOPTIMIZERVMWAREVCENTEROPTIONS': "asset.WorkloadOptimizerVmwareVcenterOptions",
            'BOOT.BOOTLOADER': "boot.Bootloader",
            'BOOT.ISCSI': "boot.Iscsi",
            'BOOT.LOCALCDD': "boot.LocalCdd",
            'BOOT.LOCALDISK': "boot.LocalDisk",
            'BOOT.NVME': "boot.Nvme",
            'BOOT.PCHSTORAGE': "boot.PchStorage",
            'BOOT.PXE': "boot.Pxe",
            'BOOT.SAN': "boot.San",
            'BOOT.SDCARD': "boot.SdCard",
            'BOOT.UEFISHELL': "boot.UefiShell",
            'BOOT.USB': "boot.Usb",
            'BOOT.VIRTUALMEDIA': "boot.VirtualMedia",
            'BULK.HTTPHEADER': "bulk.HttpHeader",
            'BULK.RESTRESULT': "bulk.RestResult",
            'BULK.RESTSUBREQUEST': "bulk.RestSubRequest",
            'CAPABILITY.PORTRANGE': "capability.PortRange",
            'CAPABILITY.SWITCHNETWORKLIMITS': "capability.SwitchNetworkLimits",
            'CAPABILITY.SWITCHSTORAGELIMITS': "capability.SwitchStorageLimits",
            'CAPABILITY.SWITCHSYSTEMLIMITS': "capability.SwitchSystemLimits",
            'CAPABILITY.SWITCHINGMODECAPABILITY': "capability.SwitchingModeCapability",
            'CERTIFICATEMANAGEMENT.IMC': "certificatemanagement.Imc",
            'CLOUD.AVAILABILITYZONE': "cloud.AvailabilityZone",
            'CLOUD.BILLINGUNIT': "cloud.BillingUnit",
            'CLOUD.CLOUDREGION': "cloud.CloudRegion",
            'CLOUD.CLOUDTAG': "cloud.CloudTag",
            'CLOUD.CUSTOMATTRIBUTES': "cloud.CustomAttributes",
            'CLOUD.IMAGEREFERENCE': "cloud.ImageReference",
            'CLOUD.INSTANCETYPE': "cloud.InstanceType",
            'CLOUD.NETWORKACCESSCONFIG': "cloud.NetworkAccessConfig",
            'CLOUD.NETWORKADDRESS': "cloud.NetworkAddress",
            'CLOUD.NETWORKINSTANCEATTACHMENT': "cloud.NetworkInstanceAttachment",
            'CLOUD.NETWORKINTERFACEATTACHMENT': "cloud.NetworkInterfaceAttachment",
            'CLOUD.SECURITYGROUPRULE': "cloud.SecurityGroupRule",
            'CLOUD.TFCWORKSPACEVARIABLES': "cloud.TfcWorkspaceVariables",
            'CLOUD.VOLUMEATTACHMENT': "cloud.VolumeAttachment",
            'CLOUD.VOLUMEINSTANCEATTACHMENT': "cloud.VolumeInstanceAttachment",
            'CLOUD.VOLUMEIOPSINFO': "cloud.VolumeIopsInfo",
            'CLOUD.VOLUMETYPE': "cloud.VolumeType",
            'CMRF.CMRF': "cmrf.CmRf",
            'COMM.IPV4ADDRESSBLOCK': "comm.IpV4AddressBlock",
            'COMM.IPV4INTERFACE': "comm.IpV4Interface",
            'COMM.IPV6INTERFACE': "comm.IpV6Interface",
            'COMPUTE.ALARMSUMMARY': "compute.AlarmSummary",
            'COMPUTE.IPADDRESS': "compute.IpAddress",
            'COMPUTE.PERSISTENTMEMORYMODULE': "compute.PersistentMemoryModule",
            'COMPUTE.PERSISTENTMEMORYOPERATION': "compute.PersistentMemoryOperation",
            'COMPUTE.SERVERCONFIG': "compute.ServerConfig",
            'COMPUTE.STORAGECONTROLLEROPERATION': "compute.StorageControllerOperation",
            'COMPUTE.STORAGEPHYSICALDRIVE': "compute.StoragePhysicalDrive",
            'COMPUTE.STORAGEPHYSICALDRIVEOPERATION': "compute.StoragePhysicalDriveOperation",
            'COMPUTE.STORAGEVIRTUALDRIVE': "compute.StorageVirtualDrive",
            'COMPUTE.STORAGEVIRTUALDRIVEOPERATION': "compute.StorageVirtualDriveOperation",
            'COND.ALARMSUMMARY': "cond.AlarmSummary",
            'CONNECTOR.CLOSESTREAMMESSAGE': "connector.CloseStreamMessage",
            'CONNECTOR.COMMANDCONTROLMESSAGE': "connector.CommandControlMessage",
            'CONNECTOR.COMMANDTERMINALSTREAM': "connector.CommandTerminalStream",
            'CONNECTOR.EXPECTPROMPT': "connector.ExpectPrompt",
            'CONNECTOR.FETCHSTREAMMESSAGE': "connector.FetchStreamMessage",
            'CONNECTOR.FILECHECKSUM': "connector.FileChecksum",
            'CONNECTOR.FILEMESSAGE': "connector.FileMessage",
            'CONNECTOR.HTTPREQUEST': "connector.HttpRequest",
            'CONNECTOR.SSHCONFIG': "connector.SshConfig",
            'CONNECTOR.SSHMESSAGE': "connector.SshMessage",
            'CONNECTOR.STARTSTREAM': "connector.StartStream",
            'CONNECTOR.STARTSTREAMFROMDEVICE': "connector.StartStreamFromDevice",
            'CONNECTOR.STREAMACKNOWLEDGE': "connector.StreamAcknowledge",
            'CONNECTOR.STREAMINPUT': "connector.StreamInput",
            'CONNECTOR.STREAMKEEPALIVE': "connector.StreamKeepalive",
            'CONNECTOR.TARGETCHANGEMESSAGE': "connector.TargetChangeMessage",
            'CONNECTOR.URL': "connector.Url",
            'CONNECTOR.XMLAPIMESSAGE': "connector.XmlApiMessage",
            'CONNECTORPACK.CONNECTORPACKUPDATE': "connectorpack.ConnectorPackUpdate",
            'CONTENT.COMPLEXTYPE': "content.ComplexType",
            'CONTENT.PARAMETER': "content.Parameter",
            'CONTENT.TEXTPARAMETER': "content.TextParameter",
            'CRD.CUSTOMRESOURCECONFIGPROPERTY': "crd.CustomResourceConfigProperty",
            'EQUIPMENT.IOCARDIDENTITY': "equipment.IoCardIdentity",
            'FABRIC.LLDPSETTINGS': "fabric.LldpSettings",
            'FABRIC.MACAGINGSETTINGS': "fabric.MacAgingSettings",
            'FABRIC.PORTIDENTIFIER': "fabric.PortIdentifier",
            'FABRIC.QOSCLASS': "fabric.QosClass",
            'FABRIC.UDLDGLOBALSETTINGS': "fabric.UdldGlobalSettings",
            'FABRIC.UDLDSETTINGS': "fabric.UdldSettings",
            'FABRIC.VLANSETTINGS': "fabric.VlanSettings",
            'FCPOOL.BLOCK': "fcpool.Block",
            'FEEDBACK.FEEDBACKDATA': "feedback.FeedbackData",
            'FIRMWARE.CHASSISUPGRADEIMPACT': "firmware.ChassisUpgradeImpact",
            'FIRMWARE.CIFSSERVER': "firmware.CifsServer",
            'FIRMWARE.COMPONENTIMPACT': "firmware.ComponentImpact",
            'FIRMWARE.COMPONENTMETA': "firmware.ComponentMeta",
            'FIRMWARE.DIRECTDOWNLOAD': "firmware.DirectDownload",
            'FIRMWARE.FABRICUPGRADEIMPACT': "firmware.FabricUpgradeImpact",
            'FIRMWARE.FIRMWAREINVENTORY': "firmware.FirmwareInventory",
            'FIRMWARE.HTTPSERVER': "firmware.HttpServer",
            'FIRMWARE.NETWORKSHARE': "firmware.NetworkShare",
            'FIRMWARE.NFSSERVER': "firmware.NfsServer",
            'FIRMWARE.SERVERUPGRADEIMPACT': "firmware.ServerUpgradeImpact",
            'FORECAST.MODEL': "forecast.Model",
            'HCL.CONSTRAINT': "hcl.Constraint",
            'HCL.FIRMWARE': "hcl.Firmware",
            'HCL.HARDWARECOMPATIBILITYPROFILE': "hcl.HardwareCompatibilityProfile",
            'HCL.PRODUCT': "hcl.Product",
            'HYPERFLEX.ALARMSUMMARY': "hyperflex.AlarmSummary",
            'HYPERFLEX.APPSETTINGCONSTRAINT': "hyperflex.AppSettingConstraint",
            'HYPERFLEX.BONDSTATE': "hyperflex.BondState",
            'HYPERFLEX.DATASTOREINFO': "hyperflex.DatastoreInfo",
            'HYPERFLEX.DISKSTATUS': "hyperflex.DiskStatus",
            'HYPERFLEX.ENTITYREFERENCE': "hyperflex.EntityReference",
            'HYPERFLEX.ERRORSTACK': "hyperflex.ErrorStack",
            'HYPERFLEX.FEATURELIMITENTRY': "hyperflex.FeatureLimitEntry",
            'HYPERFLEX.FILEPATH': "hyperflex.FilePath",
            'HYPERFLEX.HEALTHCHECKSCRIPTINFO': "hyperflex.HealthCheckScriptInfo",
            'HYPERFLEX.HXHOSTMOUNTSTATUSDT': "hyperflex.HxHostMountStatusDt",
            'HYPERFLEX.HXLICENSEAUTHORIZATIONDETAILSDT': "hyperflex.HxLicenseAuthorizationDetailsDt",
            'HYPERFLEX.HXLINKDT': "hyperflex.HxLinkDt",
            'HYPERFLEX.HXNETWORKADDRESSDT': "hyperflex.HxNetworkAddressDt",
            'HYPERFLEX.HXPLATFORMDATASTORECONFIGDT': "hyperflex.HxPlatformDatastoreConfigDt",
            'HYPERFLEX.HXREGISTRATIONDETAILSDT': "hyperflex.HxRegistrationDetailsDt",
            'HYPERFLEX.HXRESILIENCYINFODT': "hyperflex.HxResiliencyInfoDt",
            'HYPERFLEX.HXSITEDT': "hyperflex.HxSiteDt",
            'HYPERFLEX.HXUUIDDT': "hyperflex.HxUuIdDt",
            'HYPERFLEX.HXZONEINFODT': "hyperflex.HxZoneInfoDt",
            'HYPERFLEX.HXZONERESILIENCYINFODT': "hyperflex.HxZoneResiliencyInfoDt",
            'HYPERFLEX.IPADDRRANGE': "hyperflex.IpAddrRange",
            'HYPERFLEX.LOGICALAVAILABILITYZONE': "hyperflex.LogicalAvailabilityZone",
            'HYPERFLEX.MACADDRPREFIXRANGE': "hyperflex.MacAddrPrefixRange",
            'HYPERFLEX.MAPCLUSTERIDTOPROTECTIONINFO': "hyperflex.MapClusterIdToProtectionInfo",
            'HYPERFLEX.MAPCLUSTERIDTOSTSNAPSHOTPOINT': "hyperflex.MapClusterIdToStSnapshotPoint",
            'HYPERFLEX.MAPUUIDTOTRACKEDDISK': "hyperflex.MapUuidToTrackedDisk",
            'HYPERFLEX.NAMEDVLAN': "hyperflex.NamedVlan",
            'HYPERFLEX.NAMEDVSAN': "hyperflex.NamedVsan",
            'HYPERFLEX.NETWORKPORT': "hyperflex.NetworkPort",
            'HYPERFLEX.PORTTYPETOPORTNUMBERMAP': "hyperflex.PortTypeToPortNumberMap",
            'HYPERFLEX.PROTECTIONINFO': "hyperflex.ProtectionInfo",
            'HYPERFLEX.REPLICATIONCLUSTERREFERENCETOSCHEDULE': "hyperflex.ReplicationClusterReferenceToSchedule",
            'HYPERFLEX.REPLICATIONPEERINFO': "hyperflex.ReplicationPeerInfo",
            'HYPERFLEX.REPLICATIONPLATDATASTORE': "hyperflex.ReplicationPlatDatastore",
            'HYPERFLEX.REPLICATIONPLATDATASTOREPAIR': "hyperflex.ReplicationPlatDatastorePair",
            'HYPERFLEX.REPLICATIONSCHEDULE': "hyperflex.ReplicationSchedule",
            'HYPERFLEX.REPLICATIONSTATUS': "hyperflex.ReplicationStatus",
            'HYPERFLEX.RPOSTATUS': "hyperflex.RpoStatus",
            'HYPERFLEX.SERVERFIRMWAREVERSIONINFO': "hyperflex.ServerFirmwareVersionInfo",
            'HYPERFLEX.SERVERMODELENTRY': "hyperflex.ServerModelEntry",
            'HYPERFLEX.SNAPSHOTFILES': "hyperflex.SnapshotFiles",
            'HYPERFLEX.SNAPSHOTINFOBRIEF': "hyperflex.SnapshotInfoBrief",
            'HYPERFLEX.SNAPSHOTPOINT': "hyperflex.SnapshotPoint",
            'HYPERFLEX.SNAPSHOTSTATUS': "hyperflex.SnapshotStatus",
            'HYPERFLEX.STPLATFORMCLUSTERHEALINGINFO': "hyperflex.StPlatformClusterHealingInfo",
            'HYPERFLEX.STPLATFORMCLUSTERRESILIENCYINFO': "hyperflex.StPlatformClusterResiliencyInfo",
            'HYPERFLEX.SUMMARY': "hyperflex.Summary",
            'HYPERFLEX.TRACKEDDISK': "hyperflex.TrackedDisk",
            'HYPERFLEX.TRACKEDFILE': "hyperflex.TrackedFile",
            'HYPERFLEX.VDISKCONFIG': "hyperflex.VdiskConfig",
            'HYPERFLEX.VIRTUALMACHINE': "hyperflex.VirtualMachine",
            'HYPERFLEX.VIRTUALMACHINERUNTIMEINFO': "hyperflex.VirtualMachineRuntimeInfo",
            'HYPERFLEX.VMDISK': "hyperflex.VmDisk",
            'HYPERFLEX.VMINTERFACE': "hyperflex.VmInterface",
            'HYPERFLEX.VMPROTECTIONSPACEUSAGE': "hyperflex.VmProtectionSpaceUsage",
            'HYPERFLEX.WWXNPREFIXRANGE': "hyperflex.WwxnPrefixRange",
            'I18N.MESSAGE': "i18n.Message",
            'I18N.MESSAGEPARAM': "i18n.MessageParam",
            'IAAS.LICENSEKEYSINFO': "iaas.LicenseKeysInfo",
            'IAAS.LICENSEUTILIZATIONINFO': "iaas.LicenseUtilizationInfo",
            'IAAS.WORKFLOWSTEPS': "iaas.WorkflowSteps",
            'IAM.ACCOUNTPERMISSIONS': "iam.AccountPermissions",
            'IAM.CLIENTMETA': "iam.ClientMeta",
            'IAM.ENDPOINTPASSWORDPROPERTIES': "iam.EndPointPasswordProperties",
            'IAM.FEATUREDEFINITION': "iam.FeatureDefinition",
            'IAM.GROUPPERMISSIONTOROLES': "iam.GroupPermissionToRoles",
            'IAM.LDAPBASEPROPERTIES': "iam.LdapBaseProperties",
            'IAM.LDAPDNSPARAMETERS': "iam.LdapDnsParameters",
            'IAM.PERMISSIONREFERENCE': "iam.PermissionReference",
            'IAM.PERMISSIONTOROLES': "iam.PermissionToRoles",
            'IAM.RULE': "iam.Rule",
            'IAM.SAMLSPCONNECTION': "iam.SamlSpConnection",
            'IAM.SSOSESSIONATTRIBUTES': "iam.SsoSessionAttributes",
            'IMCCONNECTOR.WEBUIMESSAGE': "imcconnector.WebUiMessage",
            'INFRA.HARDWAREINFO': "infra.HardwareInfo",
            'INFRA.METADATA': "infra.MetaData",
            'INVENTORY.INVENTORYMO': "inventory.InventoryMo",
            'INVENTORY.UEMINFO': "inventory.UemInfo",
            'IPPOOL.IPV4BLOCK': "ippool.IpV4Block",
            'IPPOOL.IPV4CONFIG': "ippool.IpV4Config",
            'IPPOOL.IPV6BLOCK': "ippool.IpV6Block",
            'IPPOOL.IPV6CONFIG': "ippool.IpV6Config",
            'IQNPOOL.IQNSUFFIXBLOCK': "iqnpool.IqnSuffixBlock",
            'KUBERNETES.ACTIONINFO': "kubernetes.ActionInfo",
            'KUBERNETES.ADDON': "kubernetes.Addon",
            'KUBERNETES.ADDONCONFIGURATION': "kubernetes.AddonConfiguration",
            'KUBERNETES.BAREMETALNETWORKINFO': "kubernetes.BaremetalNetworkInfo",
            'KUBERNETES.CALICOCONFIG': "kubernetes.CalicoConfig",
            'KUBERNETES.CLUSTERCERTIFICATECONFIGURATION': "kubernetes.ClusterCertificateConfiguration",
            'KUBERNETES.CLUSTERMANAGEMENTCONFIG': "kubernetes.ClusterManagementConfig",
            'KUBERNETES.CONFIGURATION': "kubernetes.Configuration",
            'KUBERNETES.DAEMONSETSTATUS': "kubernetes.DaemonSetStatus",
            'KUBERNETES.DEPLOYMENTSTATUS': "kubernetes.DeploymentStatus",
            'KUBERNETES.ESSENTIALADDON': "kubernetes.EssentialAddon",
            'KUBERNETES.ESXIVIRTUALMACHINEINFRACONFIG': "kubernetes.EsxiVirtualMachineInfraConfig",
            'KUBERNETES.ETHERNET': "kubernetes.Ethernet",
            'KUBERNETES.ETHERNETMATCHER': "kubernetes.EthernetMatcher",
            'KUBERNETES.HYPERFLEXAPVIRTUALMACHINEINFRACONFIG': "kubernetes.HyperFlexApVirtualMachineInfraConfig",
            'KUBERNETES.INGRESSSTATUS': "kubernetes.IngressStatus",
            'KUBERNETES.KEYVALUE': "kubernetes.KeyValue",
            'KUBERNETES.LOADBALANCER': "kubernetes.LoadBalancer",
            'KUBERNETES.NODEADDRESS': "kubernetes.NodeAddress",
            'KUBERNETES.NODEGROUPLABEL': "kubernetes.NodeGroupLabel",
            'KUBERNETES.NODEGROUPTAINT': "kubernetes.NodeGroupTaint",
            'KUBERNETES.NODEINFO': "kubernetes.NodeInfo",
            'KUBERNETES.NODESPEC': "kubernetes.NodeSpec",
            'KUBERNETES.NODESTATUS': "kubernetes.NodeStatus",
            'KUBERNETES.OBJECTMETA': "kubernetes.ObjectMeta",
            'KUBERNETES.OVSBOND': "kubernetes.OvsBond",
            'KUBERNETES.PODSTATUS': "kubernetes.PodStatus",
            'KUBERNETES.PROXYCONFIG': "kubernetes.ProxyConfig",
            'KUBERNETES.SERVICESTATUS': "kubernetes.ServiceStatus",
            'KUBERNETES.STATEFULSETSTATUS': "kubernetes.StatefulSetStatus",
            'KUBERNETES.TAINT': "kubernetes.Taint",
            'MACPOOL.BLOCK': "macpool.Block",
            'MEMORY.PERSISTENTMEMORYGOAL': "memory.PersistentMemoryGoal",
            'MEMORY.PERSISTENTMEMORYLOCALSECURITY': "memory.PersistentMemoryLocalSecurity",
            'MEMORY.PERSISTENTMEMORYLOGICALNAMESPACE': "memory.PersistentMemoryLogicalNamespace",
            'META.ACCESSPRIVILEGE': "meta.AccessPrivilege",
            'META.DISPLAYNAMEDEFINITION': "meta.DisplayNameDefinition",
            'META.IDENTITYDEFINITION': "meta.IdentityDefinition",
            'META.PROPDEFINITION': "meta.PropDefinition",
            'META.RELATIONSHIPDEFINITION': "meta.RelationshipDefinition",
            'MO.MOREF': "mo.MoRef",
            'MO.TAG': "mo.Tag",
            'MO.VERSIONCONTEXT': "mo.VersionContext",
            'NIAAPI.DETAIL': "niaapi.Detail",
            'NIAAPI.NEWRELEASEDETAIL': "niaapi.NewReleaseDetail",
            'NIAAPI.REVISIONINFO': "niaapi.RevisionInfo",
            'NIAAPI.SOFTWAREREGEX': "niaapi.SoftwareRegex",
            'NIAAPI.VERSIONREGEXPLATFORM': "niaapi.VersionRegexPlatform",
            'NIATELEMETRY.BOOTFLASHDETAILS': "niatelemetry.BootflashDetails",
            'NIATELEMETRY.DISKINFO': "niatelemetry.Diskinfo",
            'NIATELEMETRY.INTERFACE': "niatelemetry.Interface",
            'NIATELEMETRY.INTERFACEELEMENT': "niatelemetry.InterfaceElement",
            'NIATELEMETRY.LOGICALLINK': "niatelemetry.LogicalLink",
            'NIATELEMETRY.NVEPACKETCOUNTERS': "niatelemetry.NvePacketCounters",
            'NIATELEMETRY.NVEVNI': "niatelemetry.NveVni",
            'NIATELEMETRY.NXOSBGPMVPN': "niatelemetry.NxosBgpMvpn",
            'NIATELEMETRY.NXOSVTP': "niatelemetry.NxosVtp",
            'NIATELEMETRY.SMARTLICENSE': "niatelemetry.SmartLicense",
            'NOTIFICATION.ALARMMOCONDITION': "notification.AlarmMoCondition",
            'NOTIFICATION.SENDEMAIL': "notification.SendEmail",
            'NTP.AUTHNTPSERVER': "ntp.AuthNtpServer",
            'ONPREM.IMAGEPACKAGE': "onprem.ImagePackage",
            'ONPREM.SCHEDULE': "onprem.Schedule",
            'ONPREM.UPGRADENOTE': "onprem.UpgradeNote",
            'ONPREM.UPGRADEPHASE': "onprem.UpgradePhase",
            'OPRS.KVPAIR': "oprs.Kvpair",
            'OS.ANSWERS': "os.Answers",
            'OS.GLOBALCONFIG': "os.GlobalConfig",
            'OS.IPV4CONFIGURATION': "os.Ipv4Configuration",
            'OS.IPV6CONFIGURATION': "os.Ipv6Configuration",
            'OS.PHYSICALDISK': "os.PhysicalDisk",
            'OS.PHYSICALDISKRESPONSE': "os.PhysicalDiskResponse",
            'OS.PLACEHOLDER': "os.PlaceHolder",
            'OS.SERVERCONFIG': "os.ServerConfig",
            'OS.VALIDATIONINFORMATION': "os.ValidationInformation",
            'OS.VIRTUALDRIVE': "os.VirtualDrive",
            'OS.VIRTUALDRIVERESPONSE': "os.VirtualDriveResponse",
            'OS.WINDOWSPARAMETERS': "os.WindowsParameters",
            'PKIX.DISTINGUISHEDNAME': "pkix.DistinguishedName",
            'PKIX.ECDSAKEYSPEC': "pkix.EcdsaKeySpec",
            'PKIX.EDDSAKEYSPEC': "pkix.EddsaKeySpec",
            'PKIX.RSAALGORITHM': "pkix.RsaAlgorithm",
            'PKIX.SUBJECTALTERNATENAME': "pkix.SubjectAlternateName",
            'POLICY.ACTIONQUALIFIER': "policy.ActionQualifier",
            'POLICY.CONFIGCHANGE': "policy.ConfigChange",
            'POLICY.CONFIGCHANGECONTEXT': "policy.ConfigChangeContext",
            'POLICY.CONFIGCONTEXT': "policy.ConfigContext",
            'POLICY.CONFIGRESULTCONTEXT': "policy.ConfigResultContext",
            'POLICY.QUALIFIER': "policy.Qualifier",
            'POLICYINVENTORY.JOBINFO': "policyinventory.JobInfo",
            'RECOVERY.BACKUPSCHEDULE': "recovery.BackupSchedule",
            'RESOURCE.PERTYPECOMBINEDSELECTOR': "resource.PerTypeCombinedSelector",
            'RESOURCE.SELECTOR': "resource.Selector",
            'RESOURCE.SOURCETOPERMISSIONRESOURCES': "resource.SourceToPermissionResources",
            'RESOURCE.SOURCETOPERMISSIONRESOURCESHOLDER': "resource.SourceToPermissionResourcesHolder",
            'RESOURCEPOOL.SERVERLEASEPARAMETERS': "resourcepool.ServerLeaseParameters",
            'RESOURCEPOOL.SERVERPOOLPARAMETERS': "resourcepool.ServerPoolParameters",
            'SDCARD.DIAGNOSTICS': "sdcard.Diagnostics",
            'SDCARD.DRIVERS': "sdcard.Drivers",
            'SDCARD.HOSTUPGRADEUTILITY': "sdcard.HostUpgradeUtility",
            'SDCARD.OPERATINGSYSTEM': "sdcard.OperatingSystem",
            'SDCARD.PARTITION': "sdcard.Partition",
            'SDCARD.SERVERCONFIGURATIONUTILITY': "sdcard.ServerConfigurationUtility",
            'SDCARD.USERPARTITION': "sdcard.UserPartition",
            'SDWAN.NETWORKCONFIGURATIONTYPE': "sdwan.NetworkConfigurationType",
            'SDWAN.TEMPLATEINPUTSTYPE': "sdwan.TemplateInputsType",
            'SERVER.PENDINGWORKFLOWTRIGGER': "server.PendingWorkflowTrigger",
            'SNMP.TRAP': "snmp.Trap",
            'SNMP.USER': "snmp.User",
            'SOFTWAREREPOSITORY.APPLIANCEUPLOAD': "softwarerepository.ApplianceUpload",
            'SOFTWAREREPOSITORY.CIFSSERVER': "softwarerepository.CifsServer",
            'SOFTWAREREPOSITORY.CONSTRAINTMODELS': "softwarerepository.ConstraintModels",
            'SOFTWAREREPOSITORY.HTTPSERVER': "softwarerepository.HttpServer",
            'SOFTWAREREPOSITORY.IMPORTRESULT': "softwarerepository.ImportResult",
            'SOFTWAREREPOSITORY.LOCALMACHINE': "softwarerepository.LocalMachine",
            'SOFTWAREREPOSITORY.NFSSERVER': "softwarerepository.NfsServer",
            'STORAGE.AUTOMATICDRIVEGROUP': "storage.AutomaticDriveGroup",
            'STORAGE.HITACHIARRAYUTILIZATION': "storage.HitachiArrayUtilization",
            'STORAGE.HITACHICAPACITY': "storage.HitachiCapacity",
            'STORAGE.HITACHIINITIATOR': "storage.HitachiInitiator",
            'STORAGE.INITIATOR': "storage.Initiator",
            'STORAGE.KEYSETTING': "storage.KeySetting",
            'STORAGE.LOCALKEYSETTING': "storage.LocalKeySetting",
            'STORAGE.M2VIRTUALDRIVECONFIG': "storage.M2VirtualDriveConfig",
            'STORAGE.MANUALDRIVEGROUP': "storage.ManualDriveGroup",
            'STORAGE.NETAPPEXPORTPOLICYRULE': "storage.NetAppExportPolicyRule",
            'STORAGE.NETAPPSTORAGEUTILIZATION': "storage.NetAppStorageUtilization",
            'STORAGE.PUREARRAYUTILIZATION': "storage.PureArrayUtilization",
            'STORAGE.PUREDISKUTILIZATION': "storage.PureDiskUtilization",
            'STORAGE.PUREHOSTUTILIZATION': "storage.PureHostUtilization",
            'STORAGE.PUREREPLICATIONBLACKOUT': "storage.PureReplicationBlackout",
            'STORAGE.PUREVOLUMEUTILIZATION': "storage.PureVolumeUtilization",
            'STORAGE.R0DRIVE': "storage.R0Drive",
            'STORAGE.REMOTEKEYSETTING': "storage.RemoteKeySetting",
            'STORAGE.SPANDRIVES': "storage.SpanDrives",
            'STORAGE.STORAGECONTAINERHOSTMOUNTSTATUS': "storage.StorageContainerHostMountStatus",
            'STORAGE.STORAGECONTAINERUTILIZATION': "storage.StorageContainerUtilization",
            'STORAGE.VIRTUALDRIVECONFIGURATION': "storage.VirtualDriveConfiguration",
            'STORAGE.VIRTUALDRIVEPOLICY': "storage.VirtualDrivePolicy",
            'STORAGE.VOLUMEUTILIZATION': "storage.VolumeUtilization",
            'SYSLOG.LOCALFILELOGGINGCLIENT': "syslog.LocalFileLoggingClient",
            'SYSLOG.REMOTELOGGINGCLIENT': "syslog.RemoteLoggingClient",
            'TAM.ACTION': "tam.Action",
            'TAM.APIDATASOURCE': "tam.ApiDataSource",
            'TAM.IDENTIFIERS': "tam.Identifiers",
            'TAM.PSIRTSEVERITY': "tam.PsirtSeverity",
            'TAM.QUERYENTRY': "tam.QueryEntry",
            'TAM.S3DATASOURCE': "tam.S3DataSource",
            'TAM.SECURITYADVISORYDETAILS': "tam.SecurityAdvisoryDetails",
            'TAM.TEXTFSMTEMPLATEDATASOURCE': "tam.TextFsmTemplateDataSource",
            'TECHSUPPORTMANAGEMENT.APPLIANCEPARAM': "techsupportmanagement.ApplianceParam",
            'TECHSUPPORTMANAGEMENT.NIAPARAM': "techsupportmanagement.NiaParam",
            'TECHSUPPORTMANAGEMENT.PLATFORMPARAM': "techsupportmanagement.PlatformParam",
            'TEMPLATE.TRANSFORMATIONSTAGE': "template.TransformationStage",
            'TERRAFORM.CLOUDRESOURCE': "terraform.CloudResource",
            'TERRAFORM.RUNSTATE': "terraform.Runstate",
            'UCSD.CONNECTORPACK': "ucsd.ConnectorPack",
            'UCSD.UCSDRESTOREPARAMETERS': "ucsd.UcsdRestoreParameters",
            'UCSDCONNECTOR.RESTCLIENTMESSAGE': "ucsdconnector.RestClientMessage",
            'UUIDPOOL.UUIDBLOCK': "uuidpool.UuidBlock",
            'VIRTUALIZATION.ACTIONINFO': "virtualization.ActionInfo",
            'VIRTUALIZATION.CLOUDINITCONFIG': "virtualization.CloudInitConfig",
            'VIRTUALIZATION.COMPUTECAPACITY': "virtualization.ComputeCapacity",
            'VIRTUALIZATION.CPUALLOCATION': "virtualization.CpuAllocation",
            'VIRTUALIZATION.CPUINFO': "virtualization.CpuInfo",
            'VIRTUALIZATION.ESXICLONECUSTOMSPEC': "virtualization.EsxiCloneCustomSpec",
            'VIRTUALIZATION.ESXIOVACUSTOMSPEC': "virtualization.EsxiOvaCustomSpec",
            'VIRTUALIZATION.ESXIVMCOMPUTECONFIGURATION': "virtualization.EsxiVmComputeConfiguration",
            'VIRTUALIZATION.ESXIVMCONFIGURATION': "virtualization.EsxiVmConfiguration",
            'VIRTUALIZATION.ESXIVMNETWORKCONFIGURATION': "virtualization.EsxiVmNetworkConfiguration",
            'VIRTUALIZATION.ESXIVMSTORAGECONFIGURATION': "virtualization.EsxiVmStorageConfiguration",
            'VIRTUALIZATION.GUESTINFO': "virtualization.GuestInfo",
            'VIRTUALIZATION.HXAPVMCONFIGURATION': "virtualization.HxapVmConfiguration",
            'VIRTUALIZATION.MEMORYALLOCATION': "virtualization.MemoryAllocation",
            'VIRTUALIZATION.MEMORYCAPACITY': "virtualization.MemoryCapacity",
            'VIRTUALIZATION.NETWORKINTERFACE': "virtualization.NetworkInterface",
            'VIRTUALIZATION.PRODUCTINFO': "virtualization.ProductInfo",
            'VIRTUALIZATION.STORAGECAPACITY': "virtualization.StorageCapacity",
            'VIRTUALIZATION.VIRTUALDISKCONFIG': "virtualization.VirtualDiskConfig",
            'VIRTUALIZATION.VIRTUALMACHINEDISK': "virtualization.VirtualMachineDisk",
            'VIRTUALIZATION.VMESXIDISK': "virtualization.VmEsxiDisk",
            'VIRTUALIZATION.VMWAREREMOTEDISPLAYINFO': "virtualization.VmwareRemoteDisplayInfo",
            'VIRTUALIZATION.VMWARERESOURCECONSUMPTION': "virtualization.VmwareResourceConsumption",
            'VIRTUALIZATION.VMWARESHARESINFO': "virtualization.VmwareSharesInfo",
            'VIRTUALIZATION.VMWARETEAMINGANDFAILOVER': "virtualization.VmwareTeamingAndFailover",
            'VIRTUALIZATION.VMWAREVLANRANGE': "virtualization.VmwareVlanRange",
            'VIRTUALIZATION.VMWAREVMCPUSHAREINFO': "virtualization.VmwareVmCpuShareInfo",
            'VIRTUALIZATION.VMWAREVMCPUSOCKETINFO': "virtualization.VmwareVmCpuSocketInfo",
            'VIRTUALIZATION.VMWAREVMDISKCOMMITINFO': "virtualization.VmwareVmDiskCommitInfo",
            'VIRTUALIZATION.VMWAREVMMEMORYSHAREINFO': "virtualization.VmwareVmMemoryShareInfo",
            'VMEDIA.MAPPING': "vmedia.Mapping",
            'VNIC.ARFSSETTINGS': "vnic.ArfsSettings",
            'VNIC.CDN': "vnic.Cdn",
            'VNIC.COMPLETIONQUEUESETTINGS': "vnic.CompletionQueueSettings",
            'VNIC.ETHINTERRUPTSETTINGS': "vnic.EthInterruptSettings",
            'VNIC.ETHRXQUEUESETTINGS': "vnic.EthRxQueueSettings",
            'VNIC.ETHTXQUEUESETTINGS': "vnic.EthTxQueueSettings",
            'VNIC.FCERRORRECOVERYSETTINGS': "vnic.FcErrorRecoverySettings",
            'VNIC.FCINTERRUPTSETTINGS': "vnic.FcInterruptSettings",
            'VNIC.FCQUEUESETTINGS': "vnic.FcQueueSettings",
            'VNIC.FLOGISETTINGS': "vnic.FlogiSettings",
            'VNIC.ISCSIAUTHPROFILE': "vnic.IscsiAuthProfile",
            'VNIC.LUN': "vnic.Lun",
            'VNIC.NVGRESETTINGS': "vnic.NvgreSettings",
            'VNIC.PLACEMENTSETTINGS': "vnic.PlacementSettings",
            'VNIC.PLOGISETTINGS': "vnic.PlogiSettings",
            'VNIC.ROCESETTINGS': "vnic.RoceSettings",
            'VNIC.RSSHASHSETTINGS': "vnic.RssHashSettings",
            'VNIC.SCSIQUEUESETTINGS': "vnic.ScsiQueueSettings",
            'VNIC.TCPOFFLOADSETTINGS': "vnic.TcpOffloadSettings",
            'VNIC.USNICSETTINGS': "vnic.UsnicSettings",
            'VNIC.VIFSTATUS': "vnic.VifStatus",
            'VNIC.VLANSETTINGS': "vnic.VlanSettings",
            'VNIC.VMQSETTINGS': "vnic.VmqSettings",
            'VNIC.VSANSETTINGS': "vnic.VsanSettings",
            'VNIC.VXLANSETTINGS': "vnic.VxlanSettings",
            'WORKFLOW.ARRAYDATATYPE': "workflow.ArrayDataType",
            'WORKFLOW.ASSOCIATEDROLES': "workflow.AssociatedRoles",
            'WORKFLOW.CLICOMMAND': "workflow.CliCommand",
            'WORKFLOW.COMMENTS': "workflow.Comments",
            'WORKFLOW.CONSTRAINTS': "workflow.Constraints",
            'WORKFLOW.CUSTOMARRAYITEM': "workflow.CustomArrayItem",
            'WORKFLOW.CUSTOMDATAPROPERTY': "workflow.CustomDataProperty",
            'WORKFLOW.CUSTOMDATATYPE': "workflow.CustomDataType",
            'WORKFLOW.CUSTOMDATATYPEPROPERTIES': "workflow.CustomDataTypeProperties",
            'WORKFLOW.DECISIONCASE': "workflow.DecisionCase",
            'WORKFLOW.DECISIONTASK': "workflow.DecisionTask",
            'WORKFLOW.DEFAULTVALUE': "workflow.DefaultValue",
            'WORKFLOW.DISPLAYMETA': "workflow.DisplayMeta",
            'WORKFLOW.DYNAMICWORKFLOWACTIONTASKLIST': "workflow.DynamicWorkflowActionTaskList",
            'WORKFLOW.ENUMENTRY': "workflow.EnumEntry",
            'WORKFLOW.EXPECTPROMPT': "workflow.ExpectPrompt",
            'WORKFLOW.FAILUREENDTASK': "workflow.FailureEndTask",
            'WORKFLOW.FILEDOWNLOADOP': "workflow.FileDownloadOp",
            'WORKFLOW.FILEOPERATIONS': "workflow.FileOperations",
            'WORKFLOW.FILETEMPLATEOP': "workflow.FileTemplateOp",
            'WORKFLOW.FILETRANSFER': "workflow.FileTransfer",
            'WORKFLOW.FORKTASK': "workflow.ForkTask",
            'WORKFLOW.INITIATORCONTEXT': "workflow.InitiatorContext",
            'WORKFLOW.INTERNALPROPERTIES': "workflow.InternalProperties",
            'WORKFLOW.JOINTASK': "workflow.JoinTask",
            'WORKFLOW.LOOPTASK': "workflow.LoopTask",
            'WORKFLOW.MESSAGE': "workflow.Message",
            'WORKFLOW.MOREFERENCEARRAYITEM': "workflow.MoReferenceArrayItem",
            'WORKFLOW.MOREFERENCEDATATYPE': "workflow.MoReferenceDataType",
            'WORKFLOW.MOREFERENCEPROPERTY': "workflow.MoReferenceProperty",
            'WORKFLOW.PARAMETERSET': "workflow.ParameterSet",
            'WORKFLOW.PRIMITIVEARRAYITEM': "workflow.PrimitiveArrayItem",
            'WORKFLOW.PRIMITIVEDATAPROPERTY': "workflow.PrimitiveDataProperty",
            'WORKFLOW.PRIMITIVEDATATYPE': "workflow.PrimitiveDataType",
            'WORKFLOW.PROPERTIES': "workflow.Properties",
            'WORKFLOW.RESULTHANDLER': "workflow.ResultHandler",
            'WORKFLOW.ROLLBACKTASK': "workflow.RollbackTask",
            'WORKFLOW.ROLLBACKWORKFLOWTASK': "workflow.RollbackWorkflowTask",
            'WORKFLOW.SELECTORPROPERTY': "workflow.SelectorProperty",
            'WORKFLOW.SSHCMD': "workflow.SshCmd",
            'WORKFLOW.SSHCONFIG': "workflow.SshConfig",
            'WORKFLOW.SSHSESSION': "workflow.SshSession",
            'WORKFLOW.STARTTASK': "workflow.StartTask",
            'WORKFLOW.SUBWORKFLOWTASK': "workflow.SubWorkflowTask",
            'WORKFLOW.SUCCESSENDTASK': "workflow.SuccessEndTask",
            'WORKFLOW.TARGETCONTEXT': "workflow.TargetContext",
            'WORKFLOW.TARGETDATATYPE': "workflow.TargetDataType",
            'WORKFLOW.TARGETPROPERTY': "workflow.TargetProperty",
            'WORKFLOW.TASKCONSTRAINTS': "workflow.TaskConstraints",
            'WORKFLOW.TASKRETRYINFO': "workflow.TaskRetryInfo",
            'WORKFLOW.UIINPUTFILTER': "workflow.UiInputFilter",
            'WORKFLOW.VALIDATIONERROR': "workflow.ValidationError",
            'WORKFLOW.VALIDATIONINFORMATION': "workflow.ValidationInformation",
            'WORKFLOW.WAITTASK': "workflow.WaitTask",
            'WORKFLOW.WAITTASKPROMPT': "workflow.WaitTaskPrompt",
            'WORKFLOW.WEBAPI': "workflow.WebApi",
            'WORKFLOW.WORKERTASK': "workflow.WorkerTask",
            'WORKFLOW.WORKFLOWCTX': "workflow.WorkflowCtx",
            'WORKFLOW.WORKFLOWENGINEPROPERTIES': "workflow.WorkflowEngineProperties",
            'WORKFLOW.WORKFLOWINFOPROPERTIES': "workflow.WorkflowInfoProperties",
            'WORKFLOW.WORKFLOWPROPERTIES': "workflow.WorkflowProperties",
            'WORKFLOW.XMLAPI': "workflow.XmlApi",
            'X509.CERTIFICATE': "x509.Certificate",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = True

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'asset.ApiKeyCredential': AssetApiKeyCredential,
            'asset.ClientCertificateCredential': AssetClientCertificateCredential,
            'asset.NoAuthenticationCredential': AssetNoAuthenticationCredential,
            'asset.OauthBearerTokenCredential': AssetOauthBearerTokenCredential,
            'asset.OauthClientIdSecretCredential': AssetOauthClientIdSecretCredential,
            'asset.PrivateKeyCredential': AssetPrivateKeyCredential,
            'asset.UsernamePasswordCredential': AssetUsernamePasswordCredential,
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
    }

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, class_id, object_type, *args, **kwargs):  # noqa: E501
        """AssetCredential - a model defined in OpenAPI

        Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'class_id': class_id,
            'object_type': object_type,
        }
        model_args = {}
        model_args.update(required_args)
        model_args.update(kwargs)
        composed_info = validate_get_composed_info(
            constant_args, model_args, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        unused_args = composed_info[3]

        for var_name, var_value in required_args.items():
            setattr(self, var_name, var_value)
        for var_name, var_value in kwargs.items():
            if var_name in unused_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        not self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error beause the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              MoBaseComplexType,
          ],
          'oneOf': [
          ],
        }
