# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.6

import enum
import datetime
import sys
import types
import typing

import winsdk._winrt as _winrt
import winsdk.windows.foundation
import winsdk.windows.foundation.collections
import winsdk.windows.foundation.numerics
import winsdk.windows.storage.streams
import winsdk.windows.ui

class Print3DTaskCompletion(enum.IntEnum):
    ABANDONED = 0
    CANCELED = 1
    FAILED = 2
    SLICING = 3
    SUBMITTED = 4

class Print3DTaskDetail(enum.IntEnum):
    UNKNOWN = 0
    MODEL_EXCEEDS_PRINT_BED = 1
    UPLOAD_FAILED = 2
    INVALID_MATERIAL_SELECTION = 3
    INVALID_MODEL = 4
    MODEL_NOT_MANIFOLD = 5
    INVALID_PRINT_TICKET = 6

class Printing3DBufferFormat(enum.IntEnum):
    UNKNOWN = 0
    R32_G32_B32_A32_FLOAT = 2
    R32_G32_B32_A32_UINT = 3
    R32_G32_B32_FLOAT = 6
    R32_G32_B32_UINT = 7
    PRINTING3_D_DOUBLE = 500
    PRINTING3_D_UINT = 501

class Printing3DMeshVerificationMode(enum.IntEnum):
    FIND_FIRST_ERROR = 0
    FIND_ALL_ERRORS = 1

class Printing3DModelUnit(enum.IntEnum):
    METER = 0
    MICRON = 1
    MILLIMETER = 2
    CENTIMETER = 3
    INCH = 4
    FOOT = 5

class Printing3DObjectType(enum.IntEnum):
    MODEL = 0
    SUPPORT = 1
    OTHERS = 2

class Printing3DPackageCompression(enum.IntEnum):
    LOW = 0
    MEDIUM = 1
    HIGH = 2

class Printing3DTextureEdgeBehavior(enum.IntEnum):
    NONE = 0
    WRAP = 1
    MIRROR = 2
    CLAMP = 3

Self = typing.TypeVar('Self')

class Printing3DBufferDescription:
    format: Printing3DBufferFormat
    stride: _winrt.UInt32
    def __new__(cls: typing.Type[Printing3DBufferDescription], format: Printing3DBufferFormat, stride: _winrt.UInt32) -> Printing3DBufferDescription: ...

class Print3DManager(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> Print3DManager: ...
    @staticmethod
    def get_for_current_view() -> typing.Optional[Print3DManager]: ...
    @staticmethod
    def show_print_u_i_async() -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    def add_task_requested(self, event_handler: winsdk.windows.foundation.TypedEventHandler[Print3DManager, Print3DTaskRequestedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_task_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class Print3DTask(_winrt.Object):
    source: typing.Optional[Printing3D3MFPackage]
    @staticmethod
    def _from(obj: _winrt.Object) -> Print3DTask: ...
    def add_completed(self, event_handler: winsdk.windows.foundation.TypedEventHandler[Print3DTask, Print3DTaskCompletedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_completed(self, event_cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_source_changed(self, event_handler: winsdk.windows.foundation.TypedEventHandler[Print3DTask, Print3DTaskSourceChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_source_changed(self, event_cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_submitting(self, event_handler: winsdk.windows.foundation.TypedEventHandler[Print3DTask, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_submitting(self, event_cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class Print3DTaskCompletedEventArgs(_winrt.Object):
    completion: Print3DTaskCompletion
    extended_status: Print3DTaskDetail
    @staticmethod
    def _from(obj: _winrt.Object) -> Print3DTaskCompletedEventArgs: ...

class Print3DTaskRequest(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> Print3DTaskRequest: ...
    def create_task(self, title: str, printer_id: str, handler: typing.Optional[Print3DTaskSourceRequestedHandler]) -> typing.Optional[Print3DTask]: ...

class Print3DTaskRequestedEventArgs(_winrt.Object):
    request: typing.Optional[Print3DTaskRequest]
    @staticmethod
    def _from(obj: _winrt.Object) -> Print3DTaskRequestedEventArgs: ...

class Print3DTaskSourceChangedEventArgs(_winrt.Object):
    source: typing.Optional[Printing3D3MFPackage]
    @staticmethod
    def _from(obj: _winrt.Object) -> Print3DTaskSourceChangedEventArgs: ...

class Print3DTaskSourceRequestedArgs(_winrt.Object):
    @staticmethod
    def _from(obj: _winrt.Object) -> Print3DTaskSourceRequestedArgs: ...
    def set_source(self, source: typing.Optional[Printing3D3MFPackage]) -> None: ...

class Printing3D3MFPackage(_winrt.Object):
    thumbnail: typing.Optional[Printing3DTextureResource]
    print_ticket: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream]
    model_part: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream]
    textures: typing.Optional[winsdk.windows.foundation.collections.IVector[Printing3DTextureResource]]
    compression: Printing3DPackageCompression
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3D3MFPackage: ...
    def __new__(cls: typing.Type[Printing3D3MFPackage]) -> Printing3D3MFPackage:...
    @staticmethod
    def load_async(value: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream]) -> winsdk.windows.foundation.IAsyncOperation[Printing3D3MFPackage]: ...
    def load_model_from_package_async(self, value: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream]) -> winsdk.windows.foundation.IAsyncOperation[Printing3DModel]: ...
    def save_async(self) -> winsdk.windows.foundation.IAsyncOperation[winsdk.windows.storage.streams.IRandomAccessStream]: ...
    def save_model_to_package_async(self, value: typing.Optional[Printing3DModel]) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...

class Printing3DBaseMaterial(_winrt.Object):
    name: str
    color: typing.Optional[Printing3DColorMaterial]
    abs: str
    pla: str
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DBaseMaterial: ...
    def __new__(cls: typing.Type[Printing3DBaseMaterial]) -> Printing3DBaseMaterial:...

class Printing3DBaseMaterialGroup(_winrt.Object):
    bases: typing.Optional[winsdk.windows.foundation.collections.IVector[Printing3DBaseMaterial]]
    material_group_id: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DBaseMaterialGroup: ...
    def __new__(cls: typing.Type[Printing3DBaseMaterialGroup], material_group_id: _winrt.UInt32) -> Printing3DBaseMaterialGroup:...

class Printing3DColorMaterial(_winrt.Object):
    value: _winrt.UInt32
    color: winsdk.windows.ui.Color
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DColorMaterial: ...
    def __new__(cls: typing.Type[Printing3DColorMaterial]) -> Printing3DColorMaterial:...

class Printing3DColorMaterialGroup(_winrt.Object):
    colors: typing.Optional[winsdk.windows.foundation.collections.IVector[Printing3DColorMaterial]]
    material_group_id: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DColorMaterialGroup: ...
    def __new__(cls: typing.Type[Printing3DColorMaterialGroup], material_group_id: _winrt.UInt32) -> Printing3DColorMaterialGroup:...

class Printing3DComponent(_winrt.Object):
    type: Printing3DObjectType
    thumbnail: typing.Optional[Printing3DTextureResource]
    part_number: str
    name: str
    mesh: typing.Optional[Printing3DMesh]
    components: typing.Optional[winsdk.windows.foundation.collections.IVector[Printing3DComponentWithMatrix]]
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DComponent: ...
    def __new__(cls: typing.Type[Printing3DComponent]) -> Printing3DComponent:...

class Printing3DComponentWithMatrix(_winrt.Object):
    matrix: winsdk.windows.foundation.numerics.Matrix4x4
    component: typing.Optional[Printing3DComponent]
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DComponentWithMatrix: ...
    def __new__(cls: typing.Type[Printing3DComponentWithMatrix]) -> Printing3DComponentWithMatrix:...

class Printing3DCompositeMaterial(_winrt.Object):
    values: typing.Optional[winsdk.windows.foundation.collections.IVector[_winrt.Double]]
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DCompositeMaterial: ...
    def __new__(cls: typing.Type[Printing3DCompositeMaterial]) -> Printing3DCompositeMaterial:...

class Printing3DCompositeMaterialGroup(_winrt.Object):
    composites: typing.Optional[winsdk.windows.foundation.collections.IVector[Printing3DCompositeMaterial]]
    material_group_id: _winrt.UInt32
    material_indices: typing.Optional[winsdk.windows.foundation.collections.IVector[_winrt.UInt32]]
    base_material_group: typing.Optional[Printing3DBaseMaterialGroup]
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DCompositeMaterialGroup: ...
    def __new__(cls: typing.Type[Printing3DCompositeMaterialGroup], material_group_id: _winrt.UInt32) -> Printing3DCompositeMaterialGroup:...

class Printing3DFaceReductionOptions(_winrt.Object):
    target_triangle_count: _winrt.UInt32
    max_reduction_area: _winrt.Double
    max_edge_length: _winrt.Double
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DFaceReductionOptions: ...
    def __new__(cls: typing.Type[Printing3DFaceReductionOptions]) -> Printing3DFaceReductionOptions:...

class Printing3DMaterial(_winrt.Object):
    base_groups: typing.Optional[winsdk.windows.foundation.collections.IVector[Printing3DBaseMaterialGroup]]
    color_groups: typing.Optional[winsdk.windows.foundation.collections.IVector[Printing3DColorMaterialGroup]]
    composite_groups: typing.Optional[winsdk.windows.foundation.collections.IVector[Printing3DCompositeMaterialGroup]]
    multiple_property_groups: typing.Optional[winsdk.windows.foundation.collections.IVector[Printing3DMultiplePropertyMaterialGroup]]
    texture2_coord_groups: typing.Optional[winsdk.windows.foundation.collections.IVector[Printing3DTexture2CoordMaterialGroup]]
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DMaterial: ...
    def __new__(cls: typing.Type[Printing3DMaterial]) -> Printing3DMaterial:...

class Printing3DMesh(_winrt.Object):
    vertex_positions_description: Printing3DBufferDescription
    vertex_normals_description: Printing3DBufferDescription
    vertex_count: _winrt.UInt32
    triangle_material_indices_description: Printing3DBufferDescription
    triangle_indices_description: Printing3DBufferDescription
    index_count: _winrt.UInt32
    buffer_description_set: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    buffer_set: typing.Optional[winsdk.windows.foundation.collections.IPropertySet]
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DMesh: ...
    def __new__(cls: typing.Type[Printing3DMesh]) -> Printing3DMesh:...
    def create_triangle_indices(self, value: _winrt.UInt32) -> None: ...
    def create_triangle_material_indices(self, value: _winrt.UInt32) -> None: ...
    def create_vertex_normals(self, value: _winrt.UInt32) -> None: ...
    def create_vertex_positions(self, value: _winrt.UInt32) -> None: ...
    def get_triangle_indices(self) -> typing.Optional[winsdk.windows.storage.streams.IBuffer]: ...
    def get_triangle_material_indices(self) -> typing.Optional[winsdk.windows.storage.streams.IBuffer]: ...
    def get_vertex_normals(self) -> typing.Optional[winsdk.windows.storage.streams.IBuffer]: ...
    def get_vertex_positions(self) -> typing.Optional[winsdk.windows.storage.streams.IBuffer]: ...
    def verify_async(self, value: Printing3DMeshVerificationMode) -> winsdk.windows.foundation.IAsyncOperation[Printing3DMeshVerificationResult]: ...

class Printing3DMeshVerificationResult(_winrt.Object):
    is_valid: _winrt.Boolean
    nonmanifold_triangles: typing.Optional[winsdk.windows.foundation.collections.IVectorView[_winrt.UInt32]]
    reversed_normal_triangles: typing.Optional[winsdk.windows.foundation.collections.IVectorView[_winrt.UInt32]]
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DMeshVerificationResult: ...

class Printing3DModel(_winrt.Object):
    version: str
    unit: Printing3DModelUnit
    material: typing.Optional[Printing3DMaterial]
    build: typing.Optional[Printing3DComponent]
    components: typing.Optional[winsdk.windows.foundation.collections.IVector[Printing3DComponent]]
    meshes: typing.Optional[winsdk.windows.foundation.collections.IVector[Printing3DMesh]]
    metadata: typing.Optional[winsdk.windows.foundation.collections.IMap[str, str]]
    required_extensions: typing.Optional[winsdk.windows.foundation.collections.IVector[str]]
    textures: typing.Optional[winsdk.windows.foundation.collections.IVector[Printing3DModelTexture]]
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DModel: ...
    def __new__(cls: typing.Type[Printing3DModel]) -> Printing3DModel:...
    def clone(self) -> typing.Optional[Printing3DModel]: ...
    def repair_async(self) -> typing.Optional[winsdk.windows.foundation.IAsyncAction]: ...
    def repair_with_progress_async(self) -> winsdk.windows.foundation.IAsyncOperationWithProgress[_winrt.Boolean, _winrt.Double]: ...
    @typing.overload
    def try_partial_repair_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_partial_repair_async(self, max_wait_time: datetime.timedelta) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    @typing.overload
    def try_reduce_faces_async(self) -> winsdk.windows.foundation.IAsyncOperationWithProgress[_winrt.Boolean, _winrt.Double]: ...
    @typing.overload
    def try_reduce_faces_async(self, printing3_d_face_reduction_options: typing.Optional[Printing3DFaceReductionOptions]) -> winsdk.windows.foundation.IAsyncOperationWithProgress[_winrt.Boolean, _winrt.Double]: ...
    @typing.overload
    def try_reduce_faces_async(self, printing3_d_face_reduction_options: typing.Optional[Printing3DFaceReductionOptions], max_wait: datetime.timedelta) -> winsdk.windows.foundation.IAsyncOperationWithProgress[_winrt.Boolean, _winrt.Double]: ...

class Printing3DModelTexture(_winrt.Object):
    tile_style_v: Printing3DTextureEdgeBehavior
    tile_style_u: Printing3DTextureEdgeBehavior
    texture_resource: typing.Optional[Printing3DTextureResource]
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DModelTexture: ...
    def __new__(cls: typing.Type[Printing3DModelTexture]) -> Printing3DModelTexture:...

class Printing3DMultiplePropertyMaterial(_winrt.Object):
    material_indices: typing.Optional[winsdk.windows.foundation.collections.IVector[_winrt.UInt32]]
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DMultiplePropertyMaterial: ...
    def __new__(cls: typing.Type[Printing3DMultiplePropertyMaterial]) -> Printing3DMultiplePropertyMaterial:...

class Printing3DMultiplePropertyMaterialGroup(_winrt.Object):
    material_group_id: _winrt.UInt32
    material_group_indices: typing.Optional[winsdk.windows.foundation.collections.IVector[_winrt.UInt32]]
    multiple_properties: typing.Optional[winsdk.windows.foundation.collections.IVector[Printing3DMultiplePropertyMaterial]]
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DMultiplePropertyMaterialGroup: ...
    def __new__(cls: typing.Type[Printing3DMultiplePropertyMaterialGroup], material_group_id: _winrt.UInt32) -> Printing3DMultiplePropertyMaterialGroup:...

class Printing3DTexture2CoordMaterial(_winrt.Object):
    v: _winrt.Double
    u: _winrt.Double
    texture: typing.Optional[Printing3DModelTexture]
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DTexture2CoordMaterial: ...
    def __new__(cls: typing.Type[Printing3DTexture2CoordMaterial]) -> Printing3DTexture2CoordMaterial:...

class Printing3DTexture2CoordMaterialGroup(_winrt.Object):
    material_group_id: _winrt.UInt32
    texture2_coords: typing.Optional[winsdk.windows.foundation.collections.IVector[Printing3DTexture2CoordMaterial]]
    texture: typing.Optional[Printing3DModelTexture]
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DTexture2CoordMaterialGroup: ...
    def __new__(cls: typing.Type[Printing3DTexture2CoordMaterialGroup], material_group_id: _winrt.UInt32) -> Printing3DTexture2CoordMaterialGroup:...

class Printing3DTextureResource(_winrt.Object):
    texture_data: typing.Optional[winsdk.windows.storage.streams.IRandomAccessStreamWithContentType]
    name: str
    @staticmethod
    def _from(obj: _winrt.Object) -> Printing3DTextureResource: ...
    def __new__(cls: typing.Type[Printing3DTextureResource]) -> Printing3DTextureResource:...

Print3DTaskSourceRequestedHandler = typing.Callable[[typing.Optional[Print3DTaskSourceRequestedArgs]], None]

