# MIT License
# Copyright (c) 2022 Vladyslav49

from sqlite3 import (
    register_adapter,
    register_converter,
    sqlite_version,
    sqlite_version_info,
    Row
)

from .core import connect, Connection, Cursor
from .pool import create_pool, Pool
from .factory import Record
from .transaction import Transaction
from .exceptions import (
    Warning,
    Error,
    DatabaseError,
    DataError,
    IntegrityError,
    InterfaceError,
    InternalError,
    NotSupportedError,
    OperationalError,
    ProgrammingError,
    TransactionError,
    PoolError
)

try:
    import uvloop
except ImportError:
    pass
else:
    uvloop.install()

__author__ = 'Vladyslav49'
__license__ = 'MIT'

__all__ = [
    'register_adapter',
    'register_converter',
    'sqlite_version',
    'sqlite_version_info',
    'Row',
    'connect',
    'Connection',
    'Cursor',
    'create_pool',
    'Pool',
    'Record',
    'Transaction',
    'Warning',
    'Error',
    'DatabaseError',
    'DataError',
    'IntegrityError',
    'InterfaceError',
    'InternalError',
    'NotSupportedError',
    'OperationalError',
    'ProgrammingError',
    'TransactionError',
    'PoolError'
]
