import abc
from abc import ABC, abstractmethod
from cezzis_kafka.kafka_consumer_settings import KafkaConsumerSettings as KafkaConsumerSettings
from confluent_kafka import Consumer, Message

class IKafkaMessageProcessor(ABC, metaclass=abc.ABCMeta):
    @staticmethod
    @abstractmethod
    def CreateNew(kafka_settings: KafkaConsumerSettings) -> IKafkaMessageProcessor: ...
    @abstractmethod
    def kafka_settings(self) -> KafkaConsumerSettings: ...
    @abstractmethod
    def consumer_creating(self) -> None: ...
    @abstractmethod
    def consumer_created(self, consumer: Consumer | None) -> None: ...
    @abstractmethod
    def message_received(self, msg: Message) -> None: ...
    @abstractmethod
    def message_error_received(self, msg: Message) -> None: ...
    @abstractmethod
    def consumer_subscribed(self) -> None: ...
    @abstractmethod
    def consumer_stopping(self) -> None: ...
    @abstractmethod
    def message_partition_reached(self, msg: Message) -> None: ...
